/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.net.httpCommon;

import com.elluminate.net.NetDebug;
import com.elluminate.net.ProxyAuthData;
import com.elluminate.net.ProxyAuthDataStore;
import com.elluminate.net.httpCommon.AuthenticateHandler;
import com.elluminate.net.httpCommon.HttpHeaderParser;
import com.elluminate.net.httpCommon.NetHttpRequest;
import com.elluminate.net.httpCommon.NetHttpResponse;
import com.elluminate.net.httpCommon.NtlmGenericMsgProvider;
import com.elluminate.net.httpCommon.NtlmMsgProvider;
import com.elluminate.net.httpCommon.NtlmNativeMsgProvider;
import com.elluminate.net.httpCommon.ProxyAuthDomain;
import com.elluminate.net.httpCommon.ProxyAuthScheme;
import com.elluminate.net.httpCommon.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.log.LogSupport;
import java.io.IOException;
import java.util.HashMap;

public class NtlmProxyAuthScheme
implements ProxyAuthScheme {
    private static final int FAILED = 0;
    private static final int TYPE1SENT = 1;
    private static final int TYPE2RECV = 2;
    private static final int TYPE3SENT = 3;
    private static final int AUTHENTICATED = 4;
    private static I18n i18n = I18n.create(NtlmProxyAuthScheme.class);
    private int stage = 0;
    private ProxyAuthData authData = null;
    private String nextMsg = null;
    private NtlmMsgProvider provider = null;
    private String defaultDomain = System.getProperty("http.auth.ntlm.domain");

    public NtlmProxyAuthScheme() {
        if (this.defaultDomain == null) {
            this.defaultDomain = "";
        }
    }

    @Override
    public boolean setArgs(HashMap args) {
        block6: {
            try {
                this.provider = new NtlmNativeMsgProvider();
                if (NetDebug.NTLM.show()) {
                    LogSupport.message(this, "setArgs", "Using native NTLM support...");
                }
            }
            catch (Throwable t) {
                try {
                    this.provider = new NtlmGenericMsgProvider();
                    if (NetDebug.NTLM.show()) {
                        LogSupport.message(this, "setArgs", "Using generic NTLM support...");
                    }
                }
                catch (Throwable t2) {
                    this.provider = null;
                    if (!NetDebug.NTLM.show()) break block6;
                    LogSupport.message(this, "setArgs", "No NTLM support available...");
                }
            }
        }
        return this.provider != null;
    }

    @Override
    public int getStrength() {
        return 25;
    }

    @Override
    public boolean checkResponse(NetHttpResponse resp) throws IOException {
        int code = resp.getCode();
        if (NetDebug.NTLM.show()) {
            LogSupport.message(this, "checkResponse", "STAGE=" + this.stage);
        }
        switch (this.stage) {
            case 1: {
                this.processType2(resp);
                this.stage = 2;
                break;
            }
            case 3: {
                if (resp.getCodeType() == 200) {
                    this.stage = 4;
                    break;
                }
                if (code == 407) {
                    this.provider.reset();
                    if (this.authData != null) {
                        ProxyAuthDataStore.voidAuthData(this.authData);
                        this.authData = null;
                    }
                    this.stage = 0;
                    break;
                }
                throw new IOException(i18n.getString(StringsProperties.NTLMPROXYAUTHSCHEME_REFUSED, new Integer(code), resp.getMessage()));
            }
            case 4: {
                break;
            }
            default: {
                throw new IOException("Invalid authentication state.");
            }
        }
        return this.stage != 4;
    }

    @Override
    public void authenticate(NetHttpRequest req) throws IOException {
        if (NetDebug.NTLM.show()) {
            LogSupport.message(this, "authenticate", "STAGE=" + this.stage);
        }
        switch (this.stage) {
            case 0: {
                this.sendType1(req);
                this.stage = 1;
                break;
            }
            case 2: {
                this.sendType3(req);
                this.stage = 3;
                break;
            }
            case 4: {
                break;
            }
            default: {
                throw new IOException("Invalid authentication state.");
            }
        }
    }

    @Override
    public boolean disconnectRequired() {
        return this.stage == 0;
    }

    private void sendType1(NetHttpRequest req) throws IOException {
        if (this.provider.needCredentials()) {
            if (this.authData == null) {
                this.authData = ProxyAuthDataStore.getAuthData("NTLM", new ProxyAuthDomain(this.defaultDomain));
            }
            if (this.authData == null) {
                throw new IOException("Cancelled by user.");
            }
            this.provider.setCredentials(this.authData);
        }
        req.setHeader("Proxy-Authorization", "NTLM " + this.provider.getType1());
    }

    private void processType2(NetHttpResponse resp) throws IOException {
        this.nextMsg = null;
        HttpHeaderParser.parseAuth(resp, new AuthenticateHandler(){

            @Override
            public boolean scheme(String name, HashMap args) {
                if (name.equalsIgnoreCase("ntlm") && args.containsKey("")) {
                    NtlmProxyAuthScheme.this.nextMsg = (String)args.get("");
                    return false;
                }
                return true;
            }
        });
        if (this.nextMsg == null) {
            throw new IOException("Missing ntlm type2 response from server.");
        }
        this.nextMsg = this.provider.getType3(this.nextMsg);
    }

    private void sendType3(NetHttpRequest req) throws IOException {
        if (this.nextMsg == null) {
            throw new IOException("Processing Type3 NTLM response without processing Type2");
        }
        req.setHeader("Proxy-Authorization", "NTLM " + this.nextMsg);
    }
}

