/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.net.httpCommon;

import com.elluminate.net.AsyncEndpoint;
import com.elluminate.net.AsyncIOListener;
import com.elluminate.net.AsyncIORequest;
import com.elluminate.net.httpCommon.HttpRequestRecvListener;
import com.elluminate.net.httpCommon.HttpRequestSendListener;
import com.elluminate.util.log.LogSupport;
import com.elluminate.util.net.HttpRequest;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;

public class AsyncHttpRequest
extends HttpRequest
implements AsyncIOListener {
    private static final int BUFFER_SIZE = 256;
    protected AsyncEndpoint endpoint;
    protected HttpRequestSendListener sendListener;
    protected HttpRequestRecvListener recvListener;
    private byte[] buffer = null;
    private StringBuffer lineBuf = null;
    private boolean crSeen = false;
    private String lastHeader = null;

    public void init(AsyncEndpoint ep, boolean debug, HttpRequestRecvListener lst) {
        this.clear();
        this.debug = debug;
        this.recvListener = lst;
        this.uri = null;
        this.endpoint = ep;
        this.lastHeader = null;
        this.getLine();
    }

    public void send(AsyncEndpoint ep, HttpRequestSendListener lst) {
        byte[] buf;
        if (!this.writable) {
            throw new IllegalStateException("Attempt to send a write-protected request.");
        }
        this.writable = false;
        this.sendListener = lst;
        this.endpoint = ep;
        String reqStr = this.toString();
        if (this.debug) {
            StringTokenizer lines = new StringTokenizer(reqStr, "\n");
            while (lines.hasMoreTokens()) {
                String token = lines.nextToken();
                LogSupport.message(this, "send", token);
            }
        }
        try {
            buf = reqStr.getBytes("ASCII7");
        }
        catch (UnsupportedEncodingException uex) {
            buf = reqStr.getBytes();
        }
        try {
            if (ep.beginWriteFully(buf, this)) {
                this.sendDone();
            }
        }
        catch (IOException iox) {
            this.sendFail(iox);
        }
    }

    protected void getLine() {
        this.crSeen = false;
        if (this.buffer == null) {
            this.buffer = new byte[256];
            this.lineBuf = new StringBuffer();
        }
        try {
            int nRead;
            while (this.processBytes(nRead = this.endpoint.beginRead(this.buffer, 0, this.buffer.length, this))) {
            }
        }
        catch (IOException iox) {
            this.recvFail(iox);
        }
    }

    private boolean processBytes(int len) {
        int off = 0;
        if (len <= 0) {
            return false;
        }
        while (len > 0) {
            char c = (char)(this.buffer[off] & 0x7F);
            ++off;
            --len;
            if (c == '\n') {
                String line = this.lineBuf.toString();
                this.lineBuf.setLength(0);
                if (len > 0) {
                    this.endpoint.unread(this.buffer, off, len);
                }
                this.processLine(line);
                return false;
            }
            if (c == '\r') {
                this.crSeen = true;
                continue;
            }
            if (this.crSeen) {
                this.lineBuf.append('\r');
                this.crSeen = false;
            }
            this.lineBuf.append(c);
        }
        return true;
    }

    protected void processLine(String line) {
        try {
            if (line.length() == 0) {
                this.evaluateHeaders();
                this.recvDone();
            } else if (this.uri == null) {
                this.parseHttpLine(line);
                this.getLine();
            } else {
                this.lastHeader = this.parseHeaderLine(line, this.lastHeader, this.debug);
                this.getLine();
            }
        }
        catch (IOException iox) {
            this.recvFail(iox);
        }
    }

    @Override
    public void readComplete(AsyncIORequest req) {
        try {
            int nRead = req.finishRequest();
            while (this.processBytes(nRead)) {
                nRead = this.endpoint.beginRead(this.buffer, 0, this.buffer.length, this);
            }
        }
        catch (IOException iox) {
            this.recvFail(iox);
        }
    }

    @Override
    public void writeComplete(AsyncIORequest req) {
        try {
            req.finishRequest();
            this.sendDone();
        }
        catch (IOException iox) {
            this.sendFail(iox);
        }
    }

    @Override
    public void closeComplete(AsyncIORequest req) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void connectComplete(AsyncIORequest req) {
        throw new UnsupportedOperationException();
    }

    protected void recvFail(IOException iox) {
        HttpRequestRecvListener l = this.recvListener;
        this.recvListener = null;
        this.endpoint = null;
        if (l != null) {
            l.requestRecvFailed(this, iox);
        }
    }

    protected void recvDone() {
        HttpRequestRecvListener l = this.recvListener;
        this.recvListener = null;
        this.endpoint = null;
        if (l != null) {
            l.requestReceived(this);
        }
    }

    protected void sendFail(IOException iox) {
        HttpRequestSendListener l = this.sendListener;
        this.sendListener = null;
        this.endpoint = null;
        if (l != null) {
            l.requestSendFailed(this, iox);
        }
    }

    protected void sendDone() {
        HttpRequestSendListener l = this.sendListener;
        this.sendListener = null;
        this.endpoint = null;
        if (l != null) {
            l.requestSent(this);
        }
    }
}

