/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.net.http;

import com.elluminate.net.AsyncConnectionListener;
import com.elluminate.net.AsyncEndpoint;
import com.elluminate.net.AsyncIOAdapter;
import com.elluminate.net.AsyncIORequest;
import com.elluminate.net.NetDebug;
import com.elluminate.net.http.AsyncHttpConnection;
import com.elluminate.net.http.AsyncHttpSession;
import com.elluminate.net.http.AsyncHttpSessionListener;
import com.elluminate.net.httpCommon.AsyncHttpRequest;
import com.elluminate.net.httpCommon.AsyncHttpResponse;
import com.elluminate.net.httpCommon.HttpRequestRecvListener;
import com.elluminate.net.httpCommon.HttpResponseSendListener;
import com.elluminate.net.httpCommon.NetHttpRequest;
import com.elluminate.net.httpCommon.NetHttpResponse;
import com.elluminate.util.crypto.DiffieHellman;
import com.elluminate.util.log.LogSupport;
import java.io.IOException;

public class AsyncHttpServerConnection
extends AsyncHttpConnection
implements HttpRequestRecvListener {
    private static final String ERROR_HDR = "<html>\n  <head>\n  </head>\n  <body>\n";
    private static final String ERROR_TRL = "\n  </body>\n</html>\n";
    public static final int IDLE_TIMEOUT = 5000;
    private static final byte[] EMPTY_BUFFER = new byte[0];
    private Object lock = new Object();
    private AsyncConnectionListener listener;
    private NetHttpRequest req = new NetHttpRequest();
    private byte[] buffer = new byte[256];
    private AsyncHttpSession session = null;
    private Detachable attached = null;
    private String context = null;
    private Responder responder;
    private Processor[] processors;

    public AsyncHttpServerConnection(AsyncEndpoint ep, AsyncConnectionListener lst) {
        super(ep);
        this.listener = lst;
        this.context = ep.getInetAddress().getHostAddress() + ":" + ep.getPort();
        this.responder = new Responder(this.endpoint, this.req);
        this.req.setContext(this.context);
        this.processors = new Processor[NetHttpRequest.REQUESTS.length];
        this.processors[0] = new PingProcessor();
        this.processors[1] = new InitProcessor();
        this.processors[2] = new JoinProcessor();
        this.processors[3] = new ReadProcessor();
        this.processors[4] = new WriteProcessor();
        this.processors[5] = new DataProcessor();
        this.processors[6] = new CloseProcessor();
        this.init();
    }

    @Override
    protected void init() {
        try {
            this.endpoint.setTimeout(5000);
            this.endpoint.setLinger(5);
            this.req.init(this.endpoint, this);
        }
        catch (IOException iox) {
            this.endpoint.beginClose(null);
        }
    }

    @Override
    public void requestReceived(AsyncHttpRequest rq) {
        Processor proc = null;
        if (this.req.getMethod() != 0) {
            this.responder.sendError(400, "Invalid method for HTTP tunnel request.", "Invalid method for HTTP tunnel request.");
            return;
        }
        try {
            proc = this.processors[this.req.getRequest()];
        }
        catch (ArrayIndexOutOfBoundsException oobx) {
            LogSupport.error(this, "requestReceived", "Unknown HTTP request " + this.req.toString());
            this.responder.sendError(404, "Not found", "Not found");
            return;
        }
        if (proc != null) {
            proc.process(this.req);
        }
    }

    @Override
    public void requestRecvFailed(AsyncHttpRequest rq, IOException iox) {
        this.abort("requestRecvFailed", "http request read failed", iox);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach() {
        Detachable d = null;
        Object object = this.lock;
        synchronized (object) {
            d = this.attached;
            this.attached = null;
        }
        if (d == null) {
            throw new IllegalStateException("detach when not attached");
        }
        d.detach();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attach(Detachable d) {
        Object object = this.lock;
        synchronized (object) {
            if (this.attached != null) {
                throw new IllegalStateException("attach when already attached");
            }
            this.attached = d;
        }
    }

    public AsyncEndpoint getEndpoint() {
        return this.endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            AsyncEndpoint ep = this.endpoint;
            this.endpoint = null;
            if (ep != null) {
                ep.beginClose(null);
            }
            this.session = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abort(String method, String msg, IOException iox) {
        AsyncHttpSession s;
        if (NetDebug.HTTP.show()) {
            LogSupport.error(this, method, this.endpoint.getInetAddress() + "/" + this.endpoint.getPort() + ": " + msg + " - " + iox);
        }
        Object object = this.lock;
        synchronized (object) {
            s = this.session;
            this.session = null;
        }
        this.close();
        if (s != null) {
            s.close();
        }
    }

    abstract class AuthProcessor
    extends Processor {
        AuthProcessor() {
        }

        @Override
        public void process(NetHttpRequest req) {
            byte[] key = new byte[DiffieHellman.getKeyLength()];
            this.request = req;
            AsyncHttpServerConnection.this.session = AsyncHttpSession.findInstance(req.getSession());
            if (AsyncHttpServerConnection.this.session == null) {
                AsyncHttpServerConnection.this.responder.sendError(404, "Unknown session", "Unknown session");
                return;
            }
            try {
                if (AsyncHttpServerConnection.this.endpoint.beginReadFully(key, this)) {
                    this.processKey(key);
                }
            }
            catch (IOException iox) {
                AsyncHttpServerConnection.this.session = null;
                AsyncHttpServerConnection.this.close();
            }
        }

        private void processKey(byte[] key) {
            if (AsyncHttpServerConnection.this.session.authenticate(this.request, key)) {
                this.execute();
            } else {
                AsyncHttpServerConnection.this.responder.sendError(401, "Authentication failed.", "Authentication failed.");
            }
        }

        protected abstract void execute();

        @Override
        public void readComplete(AsyncIORequest req) {
            try {
                req.finishRequest();
                this.processKey(req.getBuffer());
            }
            catch (IOException iox) {
                AsyncHttpServerConnection.this.session = null;
                AsyncHttpServerConnection.this.close();
            }
        }
    }

    class CloseProcessor
    extends AuthProcessor {
        CloseProcessor() {
        }

        @Override
        protected void execute() {
            AsyncHttpServerConnection.this.session.close();
            AsyncHttpServerConnection.this.session = null;
            AsyncHttpServerConnection.this.responder.sendResponse(200, "OK", EMPTY_BUFFER, false);
        }
    }

    class DataProcessor
    extends AuthProcessor
    implements Detachable,
    HttpResponseSendListener {
        boolean responseSent = false;

        DataProcessor() {
        }

        @Override
        protected void execute() {
            int n = this.request.getLength() - DiffieHellman.getKeyLength();
            if (n > 0) {
                this.responseSent = false;
                AsyncHttpServerConnection.this.attach(this);
                AsyncHttpServerConnection.this.session.writeAttach(AsyncHttpServerConnection.this, this.request.getLength() - DiffieHellman.getKeyLength());
            } else {
                n = AsyncHttpServerConnection.this.session.bytesAvailable();
                this.responseSent = true;
                AsyncHttpServerConnection.this.responder.sendResponse(200, "OK", AsyncHttpServerConnection.this.session.bytesAvailable(), false, this);
            }
        }

        @Override
        public void responseSent(AsyncHttpResponse resp) {
            if (resp.getLength() > 0) {
                AsyncHttpServerConnection.this.attach(this);
                AsyncHttpServerConnection.this.session.readAttach(AsyncHttpServerConnection.this, resp.getLength());
            } else {
                AsyncHttpServerConnection.this.responder.responseComplete();
            }
        }

        @Override
        public void responseSendFailed(AsyncHttpResponse resp, IOException iox) {
            AsyncHttpServerConnection.this.abort("responseSendFailed", "Error sending READ response", iox);
        }

        @Override
        public void detach() {
            if (this.responseSent) {
                AsyncHttpServerConnection.this.responder.responseComplete();
            } else {
                this.responseSent = true;
                AsyncHttpServerConnection.this.responder.sendResponse(200, "OK", AsyncHttpServerConnection.this.session.bytesAvailable(), false, this);
            }
        }
    }

    static interface Detachable {
        public void detach();
    }

    class InitProcessor
    extends Processor
    implements AsyncHttpSessionListener,
    HttpResponseSendListener {
        private static final byte P_SENT_NONE = 0;
        private static final byte P_SENDING_SESSION_ID = 1;
        private static final byte P_SENT_SESSION_ID = 2;
        private static final byte P_SENDING_DH_RESPONSE = 3;
        private static final byte P_SENT_DH_RESPONSE = 4;
        private static final byte P_SENDING_MODE = 5;
        private static final byte P_SENT_MODE = 6;
        private volatile byte progress;
        private byte[] dhRaw;
        private byte[] dhResp;
        private int mode;

        InitProcessor() {
            this.progress = 0;
            this.dhRaw = new byte[DiffieHellman.getChallengeLength()];
            this.dhResp = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(NetHttpRequest req) {
            Object object = AsyncHttpServerConnection.this.lock;
            synchronized (object) {
                this.request = req;
                AsyncHttpServerConnection.this.session = null;
                this.dhResp = null;
                this.mode = 0;
                this.progress = 0;
            }
            if (req.getLength() != DiffieHellman.getChallengeLength()) {
                AsyncHttpServerConnection.this.responder.sendError(400, "Invalid validation token", null);
                return;
            }
            try {
                if (AsyncHttpServerConnection.this.endpoint.beginReadFully(this.dhRaw, this)) {
                    this.processDH();
                }
            }
            catch (IOException iox) {
                AsyncHttpServerConnection.this.abort("process", "error reading validation token", iox);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void responseSent(AsyncHttpResponse r) {
            block5: {
                byte[] sidRaw = AsyncHttpServerConnection.this.responder.encodeInt(AsyncHttpServerConnection.this.session.getID());
                try {
                    this.progress = 1;
                    if (!AsyncHttpServerConnection.this.endpoint.beginWriteFully(sidRaw, this)) break block5;
                    InitProcessor initProcessor = this;
                    synchronized (initProcessor) {
                        this.progress = (byte)2;
                        this.sendDHResponse();
                    }
                }
                catch (IOException iox) {
                    AsyncHttpServerConnection.this.abort("responseSent", "error writing HTTP protocol negotiation parameters", iox);
                }
            }
        }

        @Override
        public void responseSendFailed(AsyncHttpResponse resp, IOException iox) {
        }

        @Override
        public void readComplete(AsyncIORequest ioReq) {
            try {
                ioReq.finishRequest();
                this.processDH();
            }
            catch (IOException iox) {
                AsyncHttpServerConnection.this.abort("readComplete", "error reading INIT validation token", iox);
            }
        }

        @Override
        public void writeComplete(AsyncIORequest ioReq) {
            try {
                ioReq.finishRequest();
            }
            catch (IOException iox) {
                AsyncHttpServerConnection.this.abort("writeComplete", "error writing HTTP protocol negotiation parameters", iox);
            }
            switch (this.progress) {
                case 1: {
                    this.progress = (byte)2;
                    this.sendDHResponse();
                    break;
                }
                case 3: {
                    this.progress = (byte)4;
                    this.sendMode();
                    break;
                }
                case 5: {
                    this.progress = (byte)6;
                    AsyncHttpServerConnection.this.session.setSessionListener(null);
                    AsyncHttpServerConnection.this.session = null;
                    AsyncHttpServerConnection.this.responder.responseComplete();
                }
            }
        }

        private void processDH() {
            String dhStr = new String(this.dhRaw);
            AsyncHttpServerConnection.this.session = AsyncHttpSession.getInstance(AsyncHttpServerConnection.this.endpoint, AsyncHttpServerConnection.this.listener);
            AsyncHttpServerConnection.this.session.setSessionListener(this);
            AsyncHttpServerConnection.this.session.setResponse(dhStr);
            AsyncHttpServerConnection.this.responder.sendResponse(200, "OK", 8 + DiffieHellman.getChallengeLength(), false, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setDHResponse(String response) {
            Object object = AsyncHttpServerConnection.this.lock;
            synchronized (object) {
                this.dhResp = response.getBytes();
            }
            this.sendDHResponse();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendDHResponse() {
            Object object = AsyncHttpServerConnection.this.lock;
            synchronized (object) {
                if (this.dhResp != null && this.progress == 2) {
                    try {
                        this.progress = (byte)3;
                        if (AsyncHttpServerConnection.this.endpoint.beginWriteFully(this.dhResp, this)) {
                            this.progress = (byte)4;
                            this.sendMode();
                        }
                    }
                    catch (IOException iox) {
                        AsyncHttpServerConnection.this.abort("writeComplete", "error writing HTTP protocol negotiation parameters", iox);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setMode(int mode) {
            Object object = AsyncHttpServerConnection.this.lock;
            synchronized (object) {
                this.mode = mode;
            }
            this.sendMode();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendMode() {
            Object object = AsyncHttpServerConnection.this.lock;
            synchronized (object) {
                if (this.mode != 0 && this.progress == 4) {
                    try {
                        this.progress = (byte)5;
                        byte[] modeBuf = AsyncHttpServerConnection.this.responder.encodeInt(this.mode);
                        if (AsyncHttpServerConnection.this.endpoint.beginWriteFully(modeBuf, this)) {
                            this.progress = (byte)6;
                            AsyncHttpServerConnection.this.responder.responseComplete();
                        }
                    }
                    catch (IOException iox) {
                        AsyncHttpServerConnection.this.abort("sendMode", "error writing HTTP protocol negotiation parameters", iox);
                    }
                }
            }
        }
    }

    class JoinProcessor
    extends Processor {
        JoinProcessor() {
        }

        @Override
        public void process(NetHttpRequest req) {
            byte[] key = new byte[DiffieHellman.getKeyLength()];
            this.request = req;
            AsyncHttpServerConnection.this.session = AsyncHttpSession.findInstance(req.getSession());
            if (AsyncHttpServerConnection.this.session == null) {
                AsyncHttpServerConnection.this.responder.sendError(404, "Unknown session", "Unknown session");
                return;
            }
            AsyncHttpServerConnection.this.session.receivedJoin();
            try {
                if (AsyncHttpServerConnection.this.endpoint.beginReadFully(key, this)) {
                    this.processKey(key);
                }
            }
            catch (IOException iox) {
                AsyncHttpServerConnection.this.session.joinFailed(iox);
                AsyncHttpServerConnection.this.close();
            }
        }

        private void processKey(byte[] key) {
            if (AsyncHttpServerConnection.this.session.authenticate(this.request, key)) {
                AsyncHttpServerConnection.this.responder.sendResponse(200, "OK", AsyncHttpServerConnection.this.responder.encodeInt(AsyncHttpServerConnection.this.session.getID()), false);
            } else {
                AsyncHttpServerConnection.this.responder.sendError(401, "Authentication failed.", "Authentication failed.");
            }
        }

        @Override
        public void readComplete(AsyncIORequest rq) {
            try {
                rq.finishRequest();
                this.processKey(rq.getBuffer());
            }
            catch (IOException iox) {
                AsyncHttpServerConnection.this.session.joinFailed(iox);
                AsyncHttpServerConnection.this.close();
                return;
            }
        }
    }

    class PingProcessor
    extends Processor {
        private byte[] OK;

        PingProcessor() {
            this.OK = "OK\r\n".getBytes();
        }

        @Override
        public void process(NetHttpRequest req) {
            if (this.drain(req.getLength())) {
                AsyncHttpServerConnection.this.responder.sendResponse(200, "OK", this.OK, false);
            }
        }

        @Override
        public void drainDone() {
            AsyncHttpServerConnection.this.responder.sendResponse(200, "OK", this.OK, false);
        }
    }

    abstract class Processor
    extends AsyncIOAdapter {
        protected int skip = 0;
        protected NetHttpRequest request = null;

        Processor() {
        }

        public abstract void process(NetHttpRequest var1);

        protected boolean drain(int nBytes) {
            boolean wouldBlock = false;
            this.skip = nBytes;
            try {
                while (this.skip > 0 && !wouldBlock) {
                    int n = Math.min(AsyncHttpServerConnection.this.buffer.length, this.skip);
                    int nRead = AsyncHttpServerConnection.this.endpoint.beginRead(AsyncHttpServerConnection.this.buffer, 4, n, this);
                    if (nRead > 0) {
                        this.skip -= nRead;
                        continue;
                    }
                    wouldBlock = true;
                }
            }
            catch (IOException iox) {
                AsyncHttpServerConnection.this.abort("drain", "http request content read failed", iox);
            }
            return this.skip == 0;
        }

        @Override
        public void readComplete(AsyncIORequest ioReq) {
            try {
                int n = ioReq.finishRequest();
                if (this.skip > 0) {
                    if (this.drain(this.skip - n)) {
                        this.drainDone();
                    }
                } else {
                    this.readDone(ioReq.getBuffer(), ioReq.getOffset(), n);
                }
            }
            catch (IOException iox) {
                AsyncHttpServerConnection.this.abort("readComplete", "error reading requet body", iox);
            }
        }

        public void readDone(byte[] buf, int off, int len) {
            throw new UnsupportedOperationException("readDone not overridden");
        }

        public void drainDone() {
            throw new UnsupportedOperationException("drainDone not overridden");
        }
    }

    class ReadProcessor
    extends AuthProcessor
    implements Detachable,
    HttpResponseSendListener {
        ReadProcessor() {
        }

        @Override
        protected void execute() {
            AsyncHttpServerConnection.this.responder.sendResponse(200, "OK", 65536, false, this);
        }

        @Override
        public void responseSent(AsyncHttpResponse resp) {
            AsyncHttpServerConnection.this.attach(this);
            AsyncHttpServerConnection.this.session.readAttach(AsyncHttpServerConnection.this, 65536);
        }

        @Override
        public void responseSendFailed(AsyncHttpResponse resp, IOException iox) {
            AsyncHttpServerConnection.this.abort("responseSendFailed", "Error sending READ response", iox);
        }

        @Override
        public void detach() {
            AsyncHttpServerConnection.this.responder.responseComplete();
        }
    }

    class Responder
    extends AsyncIOAdapter
    implements HttpResponseSendListener {
        private boolean doClose = false;
        private NetHttpRequest request;
        private NetHttpResponse response = new NetHttpResponse();
        private byte[] buffer = null;
        private int bufLen = 0;
        private AsyncEndpoint endpoint;

        public Responder(AsyncEndpoint ep, NetHttpRequest req) {
            this.endpoint = ep;
            this.request = req;
            this.response.setContext(AsyncHttpServerConnection.this.context);
        }

        public void sendError(int code, String msg, String content) {
            byte[] body = (AsyncHttpServerConnection.ERROR_HDR + content + AsyncHttpServerConnection.ERROR_TRL).getBytes();
            this.sendResponse(code, msg, body, true);
        }

        public void sendResponse(int code, String msg, byte[] body, boolean close) {
            this.buffer = body;
            this.bufLen = body == null ? 0 : body.length;
            this.response.init(code, msg, this.bufLen, close, AsyncHttpServerConnection.this.req.getHttpVersion());
            this.doClose = close;
            this.response.send(this.endpoint, this);
        }

        public void sendResponse(int code, String msg, int len, boolean close, HttpResponseSendListener lst) {
            this.buffer = null;
            this.bufLen = -1;
            this.response.init(code, msg, len, close, AsyncHttpServerConnection.this.req.getHttpVersion());
            this.doClose = close;
            this.response.send(this.endpoint, lst);
        }

        public void responseComplete() {
            if (this.doClose) {
                AsyncHttpServerConnection.this.close();
            } else {
                AsyncHttpServerConnection.this.session = null;
                this.request.init(this.endpoint, AsyncHttpServerConnection.this);
            }
        }

        @Override
        public void responseSendFailed(AsyncHttpResponse resp, IOException iox) {
            AsyncHttpServerConnection.this.abort("responseSendFailed", "Error sending HTTP response " + resp, iox);
        }

        @Override
        public void responseSent(AsyncHttpResponse resp) {
            if (this.bufLen > 0) {
                try {
                    if (this.endpoint.beginWriteFully(this.buffer, 0, this.bufLen, this)) {
                        this.responseComplete();
                    }
                }
                catch (IOException iox) {
                    AsyncHttpServerConnection.this.abort("responseSent", "Error writing HTTP response body", iox);
                }
            } else if (this.bufLen == 0) {
                this.responseComplete();
            }
        }

        @Override
        public void writeComplete(AsyncIORequest req) {
            try {
                req.finishRequest();
                this.responseComplete();
            }
            catch (IOException iox) {
                AsyncHttpServerConnection.this.abort("writeComplete", "Error writing HTTP response bode", iox);
            }
        }

        public byte[] encodeInt(int n) {
            byte[] encoded = new byte[]{(byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
            return encoded;
        }
    }

    class WriteProcessor
    extends AuthProcessor
    implements Detachable {
        WriteProcessor() {
        }

        @Override
        protected void execute() {
            AsyncHttpServerConnection.this.attach(this);
            AsyncHttpServerConnection.this.session.writeAttach(AsyncHttpServerConnection.this, this.request.getLength() - DiffieHellman.getKeyLength());
        }

        @Override
        public void detach() {
            AsyncHttpServerConnection.this.responder.sendResponse(204, "OK", EMPTY_BUFFER, false);
        }
    }
}

