/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.net;

import com.elluminate.net.AbstractAsyncEndpoint;
import com.elluminate.net.AsyncEndpoint;
import com.elluminate.net.AsyncIOListener;
import com.elluminate.net.AsyncIORequestImpl;
import com.elluminate.net.Endpoint;
import com.elluminate.net.EndpointCaller;
import com.elluminate.util.MTPriorityQueue;
import com.elluminate.util.QueuedProcessor;
import com.elluminate.util.log.LogSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.SocketException;

public class ThreadedAsyncEndpoint
extends AbstractAsyncEndpoint {
    QueueProcessor processor = new QueueProcessor();
    Endpoint ep;
    InputStream istr;
    OutputStream ostr;
    MTPriorityQueue outputQueue = new MTPriorityQueue("AsyncIO Output", this.processor);
    MTPriorityQueue inputQueue = new MTPriorityQueue("AsyncIO Input", this.processor);
    boolean secure = false;

    ThreadedAsyncEndpoint() {
    }

    ThreadedAsyncEndpoint(Endpoint ep) throws IOException {
        this.ep = ep;
        this.istr = ep.getInputStream();
        this.ostr = ep.getOutputStream();
        this.state.set(3);
    }

    @Override
    public InetAddress getInetAddress() {
        return this.ep.getInetAddress();
    }

    @Override
    public int getPort() {
        return this.ep.getPort();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.ep.getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        return this.ep.getLocalPort();
    }

    @Override
    public int getLinger() throws SocketException {
        return this.ep.getSoLinger();
    }

    @Override
    public void setLinger(int linger) throws SocketException {
        this.ep.setSoLinger(linger > 0, linger);
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return this.ep.getTcpNoDelay();
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
        this.ep.setTcpNoDelay(on);
    }

    @Override
    protected void setTimeoutHook() {
        if (this.ep == null) {
            return;
        }
        try {
            this.ep.setSoTimeout(this.getTimeout());
        }
        catch (Throwable t) {
            LogSupport.exception(this, "setTimeoutHook", t, true);
        }
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    @Override
    public void beginConnect(InetAddress addr, int port, AsyncIOListener lst) {
        this.setCalled(addr, port);
        AsyncIORequestImpl req = AsyncIORequestImpl.getConnectReq((AsyncEndpoint)this, addr, port, this.handler, lst);
        if (!this.state.compareAndSet(0, 1)) {
            req.fail(new ConnectException("AsyncEndpoint is not disconnected"));
        } else {
            req.execute();
        }
        req.dispose();
    }

    void beginTunnel(String host, int port, String proxy, int proxyPort, String method, String options, AsyncIOListener lst) {
        AsyncIORequestImpl req = AsyncIORequestImpl.getConnectReq((AsyncEndpoint)this, host, port, this.handler, lst);
        if (!this.state.compareAndSet(0, 1)) {
            req.fail(new ConnectException("AsyncEndpoint is not disconnected"));
        } else {
            try {
                this.ep = EndpointCaller.tunnel(host, port, proxy, proxyPort, method, options);
                req.dispatch();
            }
            catch (IOException iox) {
                req.fail(iox);
            }
        }
        req.dispose();
    }

    @Override
    public int beginWrite(byte[] buf, int off, int len, AsyncIOListener lst) throws IOException {
        if (this.state.get() != 3) {
            throw new ConnectException("AsyncEndpoint is not connected");
        }
        AsyncIORequestImpl req = AsyncIORequestImpl.getWriteReq(this, buf, off, len, this.handler, lst);
        this.outputQueue.process(req);
        return 0;
    }

    @Override
    protected int beginReadImpl(byte[] buf, int off, int len, AsyncIOListener lst) throws IOException {
        if (this.state.get() != 3) {
            throw new ConnectException("AsyncEndpoint is not connected");
        }
        AsyncIORequestImpl req = AsyncIORequestImpl.getReadReq(this, buf, off, len, this.getTimeout(), this.handler, lst);
        this.inputQueue.process(req);
        return 0;
    }

    @Override
    public void beginClose(AsyncIOListener lst) {
        if (this.state.compareAndSet(3, 4)) {
            AsyncIORequestImpl req = AsyncIORequestImpl.getCloseReq(this, this.handler, lst);
            req.fail(new ConnectException("AsyncEndpoint is not connected"));
            req.dispose();
        } else {
            super.beginClose(lst);
        }
    }

    @Override
    protected int actualWrite(AsyncIORequestImpl req, byte[] buf, int off, int len) throws IOException {
        this.ostr.write(buf, off, len);
        return len;
    }

    @Override
    protected int actualRead(AsyncIORequestImpl req, byte[] buf, int off, int len) throws IOException {
        long deadline = req.getTimeout();
        int timeout = 0;
        if (deadline > 0L && (timeout = (int)(deadline - System.currentTimeMillis())) < 0) {
            timeout = 1;
        }
        this.ep.setSoTimeout(timeout);
        return this.istr.read(buf, off, len);
    }

    @Override
    protected boolean actualConnect(AsyncIORequestImpl req, InetAddress addr, int port) throws IOException {
        try {
            this.ep = EndpointCaller.direct(addr, port);
            this.istr = this.ep.getInputStream();
            this.ostr = this.ep.getOutputStream();
            this.state.set(3);
            return true;
        }
        catch (IOException iox) {
            this.ep = null;
            this.istr = null;
            this.ostr = null;
            this.state.set(0);
            throw iox;
        }
    }

    @Override
    protected boolean actualClose(AsyncIORequestImpl req) throws IOException {
        this.ep.closeForce();
        this.ep = null;
        this.istr = null;
        this.ostr = null;
        this.outputQueue.setEnabled(false);
        this.inputQueue.setEnabled(false);
        this.outputQueue.process(this.ep);
        this.outputQueue.stop(true);
        this.inputQueue.stop(false);
        this.state.set(0);
        return true;
    }

    class QueueProcessor
    implements QueuedProcessor {
        QueueProcessor() {
        }

        @Override
        public void discard(Object o) {
            AsyncIORequestImpl req = (AsyncIORequestImpl)o;
            req.dispose();
        }

        @Override
        public void idle() {
        }

        @Override
        public void process(Object o, Object context) {
            block2: {
                try {
                    AsyncIORequestImpl req = (AsyncIORequestImpl)o;
                    this.execute(req);
                }
                catch (ClassCastException ccx) {
                    if (!(o instanceof Endpoint)) break block2;
                    Endpoint ep = (Endpoint)o;
                    ep.closeForce();
                }
            }
        }

        void execute(AsyncIORequestImpl req) {
            req.execute();
        }
    }
}

