/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.net;

import com.elluminate.net.AbstractEndpoint;
import com.elluminate.net.Endpoint;
import com.elluminate.net.ProxySocket;
import com.elluminate.net.SocketUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;

public class ProxyEndpoint
extends AbstractEndpoint
implements Endpoint {
    private Socket real = null;
    protected Object lock = new Object();
    private boolean closed = false;
    private boolean fullDuplex = true;
    private InetAddress proxyAddr = null;
    private int proxyPort = 0;
    private InputStream istr = null;
    private static boolean isConnectedAvailable = true;
    private static Method isConnectedMethod = null;
    private static Class[] emptySig = new Class[0];
    private static Object[] emptyArgs = new Object[0];

    public ProxyEndpoint(Socket actual) {
        this.real = actual;
    }

    @Override
    public InetAddress getInetAddress() {
        return this.real.getInetAddress();
    }

    @Override
    public int getPort() {
        return this.real.getPort();
    }

    @Override
    public InetAddress getProxyAddress() {
        return this.proxyAddr;
    }

    @Override
    public int getProxyPort() {
        return this.proxyPort;
    }

    protected void setProxy(InetAddress addr, int port) {
        this.proxyAddr = addr;
        this.proxyPort = port;
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.real.getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        return this.real.getLocalPort();
    }

    @Override
    public synchronized InputStream getInputStream() throws IOException {
        if (this.istr == null) {
            this.istr = this.real.getInputStream();
            this.istr = new PushbackInputStream(this.istr, 64);
        }
        return this.istr;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.real.getOutputStream();
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
        this.real.setTcpNoDelay(on);
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return this.real.getTcpNoDelay();
    }

    @Override
    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.real.setSoLinger(on, linger);
    }

    @Override
    public int getSoLinger() throws SocketException {
        return this.real.getSoLinger();
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        this.real.setSoTimeout(timeout);
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return this.real.getSoTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed()) {
                return;
            }
            this.real.close();
            this.closed = true;
        }
    }

    @Override
    public void closeForce() {
        try {
            this.close();
        }
        catch (IOException ex) {
            this.closed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed() {
        Object object = this.lock;
        synchronized (object) {
            return this.closed;
        }
    }

    @Override
    public boolean isConnected() {
        Object ic;
        if (!isConnectedAvailable) {
            return !this.isClosed();
        }
        if (isConnectedMethod == null) {
            try {
                ic = Socket.class.getMethod("isConnected", emptySig);
                isConnectedMethod = ic;
            }
            catch (NoSuchMethodException ex) {
                isConnectedAvailable = false;
                return !this.isClosed();
            }
        }
        try {
            ic = (Boolean)isConnectedMethod.invoke((Object)this.real, emptyArgs);
            return (Boolean)ic;
        }
        catch (Exception ex) {
            isConnectedMethod = null;
            isConnectedAvailable = false;
            return !this.isClosed();
        }
    }

    @Override
    public boolean isFullDuplex() {
        return this.fullDuplex;
    }

    public void setFullDuplex(boolean full) {
        this.fullDuplex = full;
    }

    @Override
    public void setSendBufferSize(int size) throws SocketException {
        SocketUtil.setSendBufferSize(this.real, size);
    }

    @Override
    public int getSendBufferSize() throws SocketException {
        return SocketUtil.getSendBufferSize(this.real);
    }

    @Override
    public void setRecvBufferSize(int size) throws SocketException {
        SocketUtil.setRecvBufferSize(this.real, size);
    }

    @Override
    public int getRecvBufferSize() throws SocketException {
        return SocketUtil.getRecvBufferSize(this.real);
    }

    protected void setSocket(Socket actual) {
        this.real = actual;
        this.istr = null;
    }

    @Override
    public Socket getSocket() {
        return ProxySocket.getInstance(this);
    }

    @Override
    protected Socket getRealSocket() {
        return this.real;
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.real.getLocalPort() + "<=>" + this.real.getInetAddress() + ":" + this.real.getPort();
    }
}

