/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.net;

import com.elluminate.net.ProxyAuthContext;
import com.elluminate.net.ProxyAuthData;
import com.elluminate.net.ProxyAuthDataProvider;
import com.elluminate.net.ProxyAuthRealm;
import com.elluminate.net.StringsProperties;
import com.elluminate.util.I18n;
import java.io.IOException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.HashMap;

public class ProxyAuthDataStore {
    private static ProxyAuthDataProvider provider = null;
    private static HashMap<String, ProxyAuthData> map = new HashMap();
    private static HashMap<String, WaitInfo> pending = new HashMap();
    private static I18n i18n = I18n.create(ProxyAuthDataStore.class);

    private ProxyAuthDataStore() {
    }

    public static void setProvider(ProxyAuthDataProvider src) {
        Authenticator.setDefault(new LocalAuthenticator());
        provider = src;
    }

    public static ProxyAuthDataProvider getProvider() {
        return provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProxyAuthData getAuthData(String scheme, ProxyAuthContext context) throws IOException {
        ProxyAuthData data = null;
        WaitInfo info = null;
        boolean query = false;
        String key = null;
        Object object = map;
        synchronized (object) {
            data = new ProxyAuthData(scheme, context);
            key = data.getKey();
            if (map.containsKey(key)) {
                return map.get(key);
            }
            if (pending.containsKey(key)) {
                info = pending.get(key);
                query = false;
            } else {
                info = new WaitInfo();
                pending.put(key, info);
                query = true;
            }
        }
        if (provider == null) {
            throw new IOException(i18n.getString(StringsProperties.PROXYAUTHDATASTORE_NOPROVIDER));
        }
        if (query) {
            boolean ok = provider.getProxyAuthData(data);
            if (ok) {
                info.data = data;
            }
            Object object2 = map;
            synchronized (object2) {
                if (info.getData() != null) {
                    map.put(key, info.getData());
                }
                pending.remove(key);
            }
            object2 = info;
            synchronized (object2) {
                info.done = true;
                info.notifyAll();
            }
        }
        object = info;
        synchronized (object) {
            while (!info.isDone()) {
                try {
                    info.wait();
                }
                catch (InterruptedException ex) {
                    throw new IOException(i18n.getString(StringsProperties.PROXYAUTHDATASTORE_INTERRUPTED));
                }
            }
        }
        if (info.data == null) {
            throw new IOException(i18n.getString(StringsProperties.PROXYAUTHDATASTORE_CANCELLED));
        }
        return (ProxyAuthData)info.data.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void voidAuthData(ProxyAuthData data) {
        HashMap<String, ProxyAuthData> hashMap = map;
        synchronized (hashMap) {
            ProxyAuthData curr = map.get(data.getKey());
            if (curr != null && curr.equals(data)) {
                map.remove(data.getKey());
            }
        }
    }

    static class LocalAuthenticator
    extends Authenticator {
        LocalAuthenticator() {
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            ProxyAuthData data;
            String scheme = this.getRequestingScheme();
            String realm = this.getRequestingPrompt();
            try {
                data = ProxyAuthDataStore.getAuthData(scheme, new ProxyAuthRealm(realm));
                if (data == null) {
                    return null;
                }
            }
            catch (IOException iox) {
                return null;
            }
            return new PasswordAuthentication(data.getUser(), data.getPass().toCharArray());
        }
    }

    static class WaitInfo {
        private boolean done = false;
        private ProxyAuthData data = null;

        public boolean isDone() {
            return this.done;
        }

        void setDone(boolean isDone) {
            this.done = isDone;
        }

        public ProxyAuthData getData() {
            return this.data;
        }
    }
}

