/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.net;

import com.elluminate.net.Endpoint;
import com.elluminate.net.EndpointException;
import com.elluminate.net.EndpointTunnelImpl;
import com.elluminate.net.ProxyAuthDataProvider;
import com.elluminate.net.ProxyAuthDataStore;
import com.elluminate.net.direct.DirectEndpoint;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Locale;
import java.util.StringTokenizer;

public class EndpointCaller {
    private static HashMap<String, HashMap> defaultOptions = new HashMap();
    private static final byte STATE_NAME = 1;
    private static final byte STATE_EQUALS = 2;
    private static final byte STATE_VALUE = 3;
    private static final byte STATE_SEP = 4;

    private EndpointCaller() {
    }

    public static Endpoint direct(String host, int port) throws IOException {
        return new DirectEndpoint(host, port);
    }

    public static Endpoint direct(InetAddress addr, int port) throws IOException {
        return new DirectEndpoint(addr, port);
    }

    public static Endpoint direct(String host, int port, InetAddress localAddr, int localPort) throws IOException {
        return new DirectEndpoint(host, port, localAddr, localPort);
    }

    public static Endpoint direct(InetAddress addr, int port, InetAddress localAddr, int localPort) throws IOException {
        return new DirectEndpoint(addr, port, localAddr, localPort);
    }

    public static Endpoint tunnel(String host, int port, String proxyHost, int proxyPort, String method) throws EndpointException, IOException, UnknownHostException {
        return EndpointCaller.tunnel(host, port, proxyHost, proxyPort, method, null);
    }

    public static Endpoint tunnel(String host, int port, String proxyHost, int proxyPort, String method, String options) throws EndpointException, IOException, UnknownHostException {
        EndpointTunnelImpl impl = EndpointCaller.getTunnelImpl(method);
        if (impl == null) {
            throw new EndpointException("Unknown tunnelling method '" + method + "'");
        }
        HashMap opts = EndpointCaller.getOptions(method, options);
        return impl.getInstance(host, port, proxyHost, proxyPort, opts);
    }

    public static boolean isTunnelMethodAvailable(String method) {
        return EndpointCaller.getTunnelImpl(method) != null;
    }

    private static EndpointTunnelImpl getTunnelImpl(String method) {
        method = method.substring(0, 1).toUpperCase(Locale.ENGLISH) + method.substring(1).toLowerCase(Locale.ENGLISH);
        String className = "com.elluminate.net." + method.toLowerCase(Locale.ENGLISH) + "." + method + "TunnelImpl";
        EndpointTunnelImpl impl = null;
        try {
            Class<?> cls = Class.forName(className);
            impl = (EndpointTunnelImpl)cls.newInstance();
        }
        catch (Exception ex) {
            return null;
        }
        return impl;
    }

    private static HashMap getOptions(String method, String options) {
        if (options == null) {
            return defaultOptions.get(method.toLowerCase(Locale.ENGLISH));
        }
        return EndpointCaller.parseOptions(options);
    }

    static HashMap parseOptions(String options) {
        StringTokenizer parser = new StringTokenizer(options, ",=", true);
        HashMap<String, String> map = new HashMap<String, String>();
        String name = null;
        int state = 1;
        while (parser.hasMoreTokens()) {
            String token = parser.nextToken();
            boolean isComma = token.equals(",");
            boolean isEquals = token.equals("=");
            boolean isDelim = isComma || isEquals;
            switch (state) {
                case 1: {
                    if (isDelim) {
                        throw new IllegalArgumentException(options);
                    }
                    name = token.trim();
                    state = 2;
                    break;
                }
                case 2: {
                    if (!isEquals) {
                        throw new IllegalArgumentException(options);
                    }
                    state = 3;
                    break;
                }
                case 3: {
                    if (isDelim) {
                        throw new IllegalArgumentException(options);
                    }
                    map.put(name, token);
                    name = null;
                    state = 4;
                    break;
                }
                case 4: {
                    if (!isComma) {
                        throw new IllegalArgumentException(options);
                    }
                    state = 1;
                }
            }
        }
        if (state != 4) {
            throw new IllegalArgumentException(options);
        }
        return map;
    }

    public static void setDefaultOptions(String method, String options) {
        HashMap opts = EndpointCaller.parseOptions(options);
        defaultOptions.put(method.toLowerCase(Locale.ENGLISH), opts);
    }

    public static void setProxyAuthDataSource(ProxyAuthDataProvider src) {
        ProxyAuthDataStore.setProvider(src);
    }
}

