/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.net;

import com.elluminate.net.AsyncEndpoint;
import com.elluminate.net.AsyncEndpointSecurity;
import com.elluminate.net.AsyncTunnelImpl;
import com.elluminate.net.EndpointCaller;
import com.elluminate.net.NetDebug;
import com.elluminate.net.ProxyAuthDataProvider;
import com.elluminate.net.ProxyAuthDataStore;
import com.elluminate.net.ThreadedAsyncEndpoint;
import com.elluminate.platform.Platform;
import java.util.HashMap;
import java.util.Locale;

public class AsyncEndpointCaller {
    private static HashMap methods = new HashMap();
    private static HashMap defaultOptions = new HashMap();
    private static Class asyncEndpointClass;
    private static boolean is14;

    public static AsyncEndpoint getDirect() {
        return AsyncEndpointCaller.getEndpoint();
    }

    public static AsyncEndpoint getTunnel(String method, String proxyHost, int proxyPort) {
        return AsyncEndpointCaller.getTunnel(method, null, proxyHost, proxyPort);
    }

    public static AsyncEndpoint getTunnel(String method, String options, String proxyHost, int proxyPort) {
        AsyncTunnelImpl impl = AsyncEndpointCaller.getTunnelImpl(method);
        return impl.getEndpoint(proxyHost, proxyPort, AsyncEndpointCaller.getOptions(method, options));
    }

    public static boolean isTunnelMethodAvailable(String method) {
        return AsyncEndpointCaller.getTunnelImpl(method) != null;
    }

    private static AsyncTunnelImpl getTunnelImpl(String method) {
        if (methods.containsKey(method)) {
            return (AsyncTunnelImpl)methods.get(method);
        }
        method = method.substring(0, 1).toUpperCase(Locale.ENGLISH) + method.substring(1).toLowerCase(Locale.ENGLISH);
        String className = "com.elluminate.net." + method.toLowerCase(Locale.ENGLISH) + "." + method + "AsyncTunnelImpl";
        AsyncTunnelImpl impl = null;
        try {
            Class<?> cls = Class.forName(className);
            impl = (AsyncTunnelImpl)cls.newInstance();
        }
        catch (Exception ex) {
            impl = null;
        }
        methods.put(method, impl);
        return impl;
    }

    private static HashMap getOptions(String method, String options) {
        if (options == null) {
            return (HashMap)defaultOptions.get(method.toLowerCase(Locale.ENGLISH));
        }
        return EndpointCaller.parseOptions(options);
    }

    public static void setDefaultOptions(String method, String options) {
        HashMap opts = EndpointCaller.parseOptions(options);
        defaultOptions.put(method.toLowerCase(Locale.ENGLISH), opts);
    }

    public static void setProxyAuthDataSource(ProxyAuthDataProvider src) {
        ProxyAuthDataStore.setProvider(src);
    }

    private static AsyncEndpoint getEndpoint() {
        if (is14 && AsyncEndpointSecurity.isEnabled()) {
            return new ThreadedAsyncEndpoint();
        }
        try {
            return (AsyncEndpoint)asyncEndpointClass.newInstance();
        }
        catch (Throwable t) {
            return new ThreadedAsyncEndpoint();
        }
    }

    static {
        is14 = Platform.checkJavaVersion("1.4*");
        try {
            if (NetDebug.ASYNC_NO_NIO.isEnabled()) {
                throw new RuntimeException("NIO Async IO disabled");
            }
            Class<?> c = Class.forName("com.elluminate.net.nio.SelectorAsyncEndpoint");
            c.newInstance();
            asyncEndpointClass = c;
        }
        catch (Throwable t) {
            if (NetDebug.ASYNC_NO_THREAD.isEnabled()) {
                throw new RuntimeException("Thread Async IO disabled");
            }
            asyncEndpointClass = ThreadedAsyncEndpoint.class;
        }
    }
}

