/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.video.module.windows;

import com.elluminate.groupware.video.module.VideoBean;
import com.elluminate.groupware.video.module.VideoSupport;
import com.elluminate.util.Preferences;
import com.elluminate.util.log.LogSupport;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;

public class WinVideo
implements VideoSupport {
    private static final String LIB_NAME = "WinVideo";

    private static native void nativeClose();

    private static native void nativeConnect(String var0);

    private static native void nativeDisconnect();

    private static native String[] nativeEnumerate();

    private static native String nativeGetVersion();

    private static native boolean nativeHavePropsDialog();

    private static native void nativeOpen(int var0, int var1, int var2);

    private static native void nativeRead(int[] var0);

    private static native void nativeSetDebug(boolean var0);

    private static native void nativeSetVideoWindow(long var0);

    private static native void nativeShowPropsDialog(int var0, int var1, int var2, int var3);

    @Override
    public void close() {
        WinVideo.nativeClose();
    }

    @Override
    public void connect(String sourceDesc) {
        WinVideo.nativeConnect(sourceDesc);
    }

    @Override
    public void disconnect() {
        WinVideo.nativeDisconnect();
    }

    @Override
    public String[] enumerate() {
        String[] sourceEnumSet = WinVideo.nativeEnumerate();
        String[] filteredEnumSet = new String[sourceEnumSet.length];
        int enumSetIndex = 0;
        for (int i = 0; i < sourceEnumSet.length; ++i) {
            if (this.isPseudoWdmDevice(sourceEnumSet[i]) || sourceEnumSet[i] == null) continue;
            filteredEnumSet[enumSetIndex] = sourceEnumSet[i];
            ++enumSetIndex;
        }
        String[] outputEnumSet = new String[enumSetIndex];
        for (int i = 0; i < enumSetIndex; ++i) {
            outputEnumSet[i] = filteredEnumSet[i];
        }
        return outputEnumSet;
    }

    private boolean isPseudoWdmDevice(String deviceDesc) {
        int i;
        String[] pseudoDevicesList = new String[]{"Microsoft WDM Image Capture"};
        if (deviceDesc == null) {
            return false;
        }
        for (i = 0; i < pseudoDevicesList.length && !deviceDesc.regionMatches(0, pseudoDevicesList[i], 0, pseudoDevicesList[i].length()); ++i) {
        }
        return i < pseudoDevicesList.length;
    }

    @Override
    public String getDisplayName(String sourceDesc) {
        return sourceDesc;
    }

    @Override
    public boolean havePropsDialog() {
        return WinVideo.nativeHavePropsDialog();
    }

    @Override
    public void open(int frameWidth, int frameHeight, int maxFrameRate) {
        WinVideo.nativeOpen(frameWidth, frameHeight, maxFrameRate);
    }

    @Override
    public void read(int[] pixels) {
        WinVideo.nativeRead(pixels);
    }

    @Override
    public void loadPreferences(String prefix, Preferences preferences) {
    }

    @Override
    public void savePreferences(String prefix, Preferences preferences) {
    }

    @Override
    public void setBean(VideoBean bean) {
        try {
            Long handle = bean.getVWHandle();
            if (handle != null) {
                WinVideo.nativeSetVideoWindow(handle);
            }
        }
        catch (Throwable t) {
            LogSupport.exception((Object)this, (String)"setBean", (Throwable)t, (boolean)false);
        }
    }

    @Override
    public void setDebug(boolean enable) {
        WinVideo.nativeSetDebug(enable);
    }

    @Override
    public void showPropsDialog(Component videoPane) {
        Point pos = videoPane.getLocationOnScreen();
        Dimension size = videoPane.getSize();
        WinVideo.nativeShowPropsDialog(pos.x, pos.y, size.width, size.height);
    }

    static {
        System.loadLibrary(LIB_NAME);
        LogSupport.message((String)("Loaded native library WinVideo, version " + WinVideo.nativeGetVersion()));
    }
}

