/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.video.module.macos;

import com.elluminate.groupware.video.VideoDebug;
import com.elluminate.groupware.video.module.VideoBean;
import com.elluminate.groupware.video.module.VideoSupport;
import com.elluminate.util.Preferences;
import com.elluminate.util.log.LogSupport;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class MacVideo
implements VideoSupport {
    private long lastFrameTime = 0L;
    private VideoBean vBean = null;
    private int cameraPtr;

    public MacVideo() {
        this.initNative();
    }

    @Override
    public void close() {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("Called from Swing event thread.");
        }
        if (VideoDebug.NATIVE.show()) {
            LogSupport.message((Object)this, (String)"close", (String)"closing current device");
        }
        this.closeNative();
    }

    @Override
    public void connect(String sourceDesc) {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("Called from Swing event thread.");
        }
        if (VideoDebug.NATIVE.show()) {
            LogSupport.message((Object)this, (String)"connect", (String)sourceDesc);
        }
        this.connectNative(sourceDesc);
    }

    @Override
    public void disconnect() {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("Called from Swing event thread.");
        }
        if (VideoDebug.NATIVE.show()) {
            LogSupport.message((Object)this, (String)"disconnect", (String)"disconnecting current device");
        }
        this.disconnectNative();
    }

    @Override
    public String[] enumerate() {
        ArrayList devices = new ArrayList(8);
        if (SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("Called from Swing event thread.");
        }
        if (VideoDebug.NATIVE.show()) {
            LogSupport.message((Object)this, (String)"enumerate", (String)"Enumerating devices.");
        }
        this.enumerateNative(devices);
        String[] result = new String[devices.size()];
        return devices.toArray(result);
    }

    @Override
    public String getDisplayName(String sourceDesc) {
        return sourceDesc;
    }

    @Override
    public void open(int frameWidth, int frameHeight, int maxFrameRate) {
        if (frameWidth < 1) {
            throw new IllegalArgumentException("Bad frame width: " + frameWidth);
        }
        if (frameHeight < 1) {
            throw new IllegalArgumentException("Bad frame height: " + frameHeight);
        }
        if (maxFrameRate < 1) {
            throw new IllegalArgumentException("Bad frame rate: " + maxFrameRate);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("Called from Swing event thread.");
        }
        if (VideoDebug.NATIVE.show()) {
            LogSupport.message((Object)this, (String)"open", (String)(frameWidth + " x " + frameHeight + " @ " + maxFrameRate + " / sec"));
        }
        this.openNative(frameWidth, frameHeight, maxFrameRate);
        int period = 1000 / maxFrameRate;
        this.lastFrameTime = System.currentTimeMillis() - (long)period;
    }

    @Override
    public void read(int[] pixels) {
        int result;
        if (SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("Called from Swing event thread.");
        }
        while ((result = this.readNative(pixels)) != 0) {
            if (result < 0) {
                throw new RuntimeException("Unexpected error return: " + result);
            }
            if (result <= 0) continue;
            long now = System.currentTimeMillis();
            if (now > this.lastFrameTime + 2500L) {
                LogSupport.message((Object)this, (String)"read", (String)("No camera data received in " + (double)(now - this.lastFrameTime) / 1000.0 + " seconds, aborting."));
                throw new RuntimeException("Video delivery has stalled");
            }
            try {
                Thread.sleep(result);
            }
            catch (InterruptedException t) {
                Thread.currentThread().interrupt();
                return;
            }
        }
        this.lastFrameTime = System.currentTimeMillis();
    }

    @Override
    public void loadPreferences(String prefix, Preferences preferences) {
    }

    @Override
    public void savePreferences(String prefix, Preferences preferences) {
    }

    @Override
    public void setBean(VideoBean bean) {
        this.vBean = bean;
    }

    @Override
    public void setDebug(boolean enable) {
        this.setDebugNative(enable);
    }

    @Override
    public boolean havePropsDialog() {
        return true;
    }

    @Override
    public void showPropsDialog(Component videoPane) {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("Called from Swing event thread.");
        }
        if (VideoDebug.NATIVE.show()) {
            LogSupport.message((Object)this, (String)"showPropsDialog", (String)"Showing video properties dialog");
        }
        this.showPropsNative();
    }

    private static native int getVersionNative();

    private native void initNative();

    private native void closeNative();

    private native void connectNative(String var1);

    private native void disconnectNative();

    private native void enumerateNative(ArrayList var1);

    private native void openNative(int var1, int var2, int var3);

    private native int readNative(int[] var1);

    private native void setDebugNative(boolean var1);

    private native void showPropsNative();

    static {
        System.loadLibrary("MacVideo");
        int libVersion = 0;
        try {
            libVersion = MacVideo.getVersionNative();
        }
        catch (Throwable t) {
            libVersion = 65536;
        }
        LogSupport.message((String)("Loaded native library MacVideo, version: " + (libVersion >> 16) + "." + (libVersion >> 8 & 0xFF) + "." + (libVersion & 0xFF)));
    }
}

