/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.video.module;

import com.elluminate.classroom.client.messaging.ModulePublisherInfo;
import com.elluminate.engine.ConferencingEngine;
import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.ActionFeatureEvent;
import com.elluminate.framework.feature.ActionFeatureListener;
import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.ComponentFeature;
import com.elluminate.framework.feature.ComponentProvider;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.framework.feature.FeaturePathSupport;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.imps.Imps;
import com.elluminate.framework.session.CRSession;
import com.elluminate.groupware.ChairProtocol;
import com.elluminate.groupware.imps.PlaybackTimeAPI;
import com.elluminate.groupware.imps.PlaybackTimeListener;
import com.elluminate.groupware.imps.PreferencesDialogAPI;
import com.elluminate.groupware.module.AbstractClientModule;
import com.elluminate.groupware.module.PermissionFeatureFactory;
import com.elluminate.groupware.video.module.PreviewVideoCmd;
import com.elluminate.groupware.video.module.SetMaximumCamerasCmd;
import com.elluminate.groupware.video.module.StopVideoCmd;
import com.elluminate.groupware.video.module.StringsProperties;
import com.elluminate.groupware.video.module.TransmitVideoCmd;
import com.elluminate.groupware.video.module.VideoBean;
import com.elluminate.groupware.video.module.VideoCameraSettingsPrefsPanel;
import com.elluminate.groupware.video.module.VideoPublisher;
import com.elluminate.gui.component.PreferencesPanelOwner;
import com.elluminate.jinx.Client;
import com.elluminate.jinx.ClientEvent;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.ClientListener;
import com.elluminate.jinx.ConnectionEvent;
import com.elluminate.jinx.ConnectionListener;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.util.I18n;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.VersionManager;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.awt.Component;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;

@Singleton
public class VideoModule
extends AbstractClientModule
implements ConnectionListener,
PropertyChangeListener,
PreferencesPanelOwner,
ModulePublisherInfo,
PlaybackTimeListener {
    private static final String MODULE_NAME = "Video";
    private static final String FEATURE_BASE_PATH = "/video";
    private static final I18n i18n = I18n.create(VideoModule.class);
    private final ImageIcon VideoIcon;
    private VideoBean bean = null;
    private Client client = null;
    private ClientList clients = null;
    private boolean connected = false;
    private Preferences preferences;
    private ChairProtocol chairProtocol;
    private ClientProvider clientProvider;
    private Provider<VideoBean> beanProvider;
    private VideoPublisher msgPublisher;
    private Icon icon = null;
    private FeaturePathSupport pathSupport;
    private FeatureBroker broker = null;
    private Provider<VideoCameraSettingsPrefsPanel> videoCameraSettingsPrefsPanelProvider = null;
    private ComponentFeature videoPaneFeature;
    private BooleanFeature videoDisplayedFeature;
    private BooleanFeature transmitStartStopVideoFeature;
    private BooleanFeature previewStartStopVideoFeature;
    private ActionFeature videoCameraSettingsFeature;
    private ActionFeature maxFilmersFeature;
    private BooleanFeature videoFollowsModeratorFocusFeature;
    private BooleanFeature videoFollowsSpeakerFeature;
    private ActionFeature publishToWhiteboardFeature;
    private CRSession session;
    private PermissionFeatureFactory permissionFeatureFactory;
    private ConferencingEngine confEngine;
    private Provider<TransmitVideoCmd> transmitVideoCmd;
    private Provider<SetMaximumCamerasCmd> setMaximumCamerasCmd;
    private Provider<PreviewVideoCmd> previewVideoCmd;
    private Provider<StopVideoCmd> stopVideoCmd;
    private Imps imps;
    private final ComponentProvider videoPaneProvider = new VideoPaneProvider();

    public VideoModule() {
        this.VideoIcon = i18n.getIcon("VideoModule.videoIcon");
        this.registerIcon(this.VideoIcon);
    }

    @Inject
    public void initVideoPublisher(VideoPublisher msgPublisher) {
        this.msgPublisher = msgPublisher;
    }

    @Inject
    public void initPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    @Inject
    protected void initVideoBeanProvider(Provider<VideoBean> beanProvider) {
        this.beanProvider = beanProvider;
    }

    @Inject
    protected void initClientProvider(ClientProvider clientProvider) {
        this.clientProvider = clientProvider;
    }

    @Inject
    public void initChairProtocol(ChairProtocol chairProtocol) {
        this.chairProtocol = chairProtocol;
    }

    @Inject
    protected void initVersionManager(VersionManager versionManager) {
        versionManager.registerComponent((Object)this);
    }

    @Inject
    public void initPathSupport(FeaturePathSupport pathSupport) {
        this.pathSupport = pathSupport;
    }

    @Inject
    protected void initFeatureBroker(FeatureBroker broker) {
        this.broker = broker;
    }

    @Inject
    protected void initVideoCameraSettingsPrefsPanelProvider(Provider<VideoCameraSettingsPrefsPanel> videoCameraSettingsPrefsPanelProvider) {
        this.videoCameraSettingsPrefsPanelProvider = videoCameraSettingsPrefsPanelProvider;
    }

    @Inject
    protected void initPermissionFeatureFactory(PermissionFeatureFactory permissionFeatureFactory) {
        this.permissionFeatureFactory = permissionFeatureFactory;
    }

    @Inject
    protected void initSession(CRSession session) {
        this.session = session;
    }

    @Inject
    public void initConferencingEngine(ConferencingEngine ce) {
        this.confEngine = ce;
    }

    @Inject
    public void initSetMaximumCamerasCmd(Provider<SetMaximumCamerasCmd> cp) {
        this.setMaximumCamerasCmd = cp;
    }

    @Inject
    public void initStopSharingCmd(Provider<StopVideoCmd> cp) {
        this.stopVideoCmd = cp;
    }

    @Inject
    public void initTransmitVideoCmd(Provider<TransmitVideoCmd> cp) {
        this.transmitVideoCmd = cp;
    }

    @Inject
    public void initPreviewVideoCmd(Provider<PreviewVideoCmd> cp) {
        this.previewVideoCmd = cp;
    }

    @Inject
    protected void initImps(Imps imps) {
        this.imps = imps;
    }

    public String getNameOfModule() {
        return MODULE_NAME;
    }

    public String getTitle() {
        return i18n.getString((PropertiesEnum)StringsProperties.VIDEOMODULE_NAME);
    }

    public String getDisplayNameOfModule() {
        return i18n.getString((PropertiesEnum)StringsProperties.VIDEOMODULE_MODULETITLE);
    }

    public Icon getModuleIcon() {
        return i18n.getIcon((PropertiesEnum)StringsProperties.VIDEOMODULE_ICON);
    }

    protected void registerIcon(Icon icon) {
        this.icon = icon;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getPrefix() {
        return this.getClass().getName();
    }

    public Class<?>[] getCommandClasses() {
        return new Class[]{PreviewVideoCmd.class, StopVideoCmd.class, TransmitVideoCmd.class, SetMaximumCamerasCmd.class};
    }

    public boolean isNonLinear() {
        return this.bean != null && this.bean.isMuted();
    }

    public void setSeeking(boolean seeking) {
        if (this.bean != null) {
            this.bean.setSeeking(seeking);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String pName = e.getPropertyName();
        if (pName.equals("chair")) {
            this.updateFeatures();
        }
    }

    public void setLinearity(PlaybackTimeListener.Linearity linearity) {
        if (this.bean != null) {
            switch (linearity) {
                case REALTIME: {
                    this.bean.setMuted(false);
                    this.bean.setSeeking(false);
                    break;
                }
                case FAST_FORWARD: {
                    this.bean.setMuted(true);
                    this.bean.setSeeking(false);
                    break;
                }
                case SEEKING: {
                    this.bean.setMuted(false);
                    this.bean.setSeeking(true);
                }
            }
        }
    }

    public void resetSession() {
    }

    public void start() {
        this.bean = (VideoBean)this.beanProvider.get();
        this.bean.setModule(this);
        this.confEngine.registerCommand(this.transmitVideoCmd);
        this.confEngine.registerCommand(this.setMaximumCamerasCmd);
        this.confEngine.registerCommand(this.previewVideoCmd);
        this.confEngine.registerCommand(this.stopVideoCmd);
    }

    public void attach() {
        this.client = this.clientProvider.get();
        this.bean.setClient(this.client);
        this.clients = this.client.getClientList();
        this.client.addConnectionListener((ConnectionListener)this);
        this.clients.addPropertyChangeListener("chair", (PropertyChangeListener)this);
        this.clients.addClientListener(new ClientListener(){

            public void onRemoveClient(ClientEvent e) {
            }

            public void onAddClient(ClientEvent e) {
                VideoModule.this.handleAddClient(e);
            }
        });
        this.bean.videoInit();
        this.bean.loadPreferences(this.getPrefix(), this.preferences);
        this.bean.installPreferenceListeners();
        PlaybackTimeAPI playbackTimeApi = (PlaybackTimeAPI)this.imps.findBest(PlaybackTimeAPI.class);
        if (playbackTimeApi != null) {
            playbackTimeApi.addPlaybackTimeListener((PlaybackTimeListener)this);
        }
    }

    public void connectionStatusChanged(ConnectionEvent e) {
        this.connected = e.getAction() == 2;
        this.updateFeatures();
    }

    private void handleAddClient(ClientEvent e) {
        if (e.isMe()) {
            this.clients.getMyClient().addPropertyChangeListener("videoFloor", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    Boolean newValue;
                    Boolean oldValue = (Boolean)evt.getOldValue();
                    if (oldValue != (newValue = (Boolean)evt.getNewValue()) && newValue != null) {
                        if (newValue.booleanValue()) {
                            VideoModule.this.msgPublisher.sendVideoEnabledMessage();
                        } else {
                            VideoModule.this.msgPublisher.sendVideoDisabledMessage();
                        }
                    }
                }
            });
        }
    }

    public void setupUI() {
        this.createFeatures();
        this.updateFeatures();
        this.bean.applyPreferences(this.getPrefix(), this.preferences);
    }

    public void cleanupUI() {
        this.revokeFeatures();
    }

    public void detach() {
        PlaybackTimeAPI playbackTimeApi = (PlaybackTimeAPI)this.imps.findBest(PlaybackTimeAPI.class);
        if (playbackTimeApi != null) {
            playbackTimeApi.removePlaybackTimeListener((PlaybackTimeListener)this);
        }
        this.bean.removePreferenceListeners();
        this.bean.savePreferences(this.getPrefix(), this.preferences);
        this.bean.videoDeinit();
    }

    public void stop() {
    }

    private void createFeatures() {
        String VideoPaneTitle = i18n.getString((PropertiesEnum)StringsProperties.VIDEOMODULE_MODULETITLE);
        this.videoPaneFeature = this.broker.createComponentFeature((Object)this, this.pathSupport.composePath(FEATURE_BASE_PATH, "videoPane"), this.videoPaneProvider, VideoPaneTitle, null);
        this.videoPaneFeature.setEnabled(false);
        String TransmitStartText = i18n.getString((PropertiesEnum)StringsProperties.VIDEOMODULE_TRANSMITSTARTTEXT);
        String TransmitStartTip = i18n.getString((PropertiesEnum)StringsProperties.VIDEOMODULE_TRANSMITSTARTTIP);
        String TransmitStopText = i18n.getString((PropertiesEnum)StringsProperties.VIDEOMODULE_TRANSMITSTOPTEXT);
        Image TransmitStopIcon = i18n.getImage((PropertiesEnum)StringsProperties.VIDEOMODULE_TRANSMITSTOPICON);
        this.transmitStartStopVideoFeature = this.broker.createBooleanFeature((Object)this, this.pathSupport.composePath(FEATURE_BASE_PATH, "transmitStartStop"), true, false, TransmitStartText, TransmitStartTip);
        this.transmitStartStopVideoFeature.setTrueText(TransmitStopText);
        this.transmitStartStopVideoFeature.setFalseText(TransmitStartText);
        this.transmitStartStopVideoFeature.setTrueIcon(TransmitStopIcon);
        this.transmitStartStopVideoFeature.setFalseIcon(null);
        this.transmitStartStopVideoFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent ev) {
                boolean transmitting = (Boolean)VideoModule.this.transmitStartStopVideoFeature.getValue();
                if (transmitting != VideoModule.this.bean.isTransmitting()) {
                    VideoModule.this.bean.setTransmitting(transmitting);
                    VideoModule.this.broker.setFeaturePublished((Feature)VideoModule.this.previewStartStopVideoFeature, !transmitting);
                }
            }
        });
        String PreviewStartText = i18n.getString((PropertiesEnum)StringsProperties.VIDEOMODULE_PREVIEWSTARTTEXT);
        String PreviewStartTip = i18n.getString((PropertiesEnum)StringsProperties.VIDEOMODULE_PREVIEWSTARTTIP);
        String PreviewStopText = i18n.getString((PropertiesEnum)StringsProperties.VIDEOMODULE_PREVIEWSTOPTEXT);
        this.previewStartStopVideoFeature = this.broker.createBooleanFeature((Object)this, this.pathSupport.composePath(FEATURE_BASE_PATH, "previewStartStop"), true, false, PreviewStartText, PreviewStartTip);
        this.previewStartStopVideoFeature.setTrueText(PreviewStopText);
        this.previewStartStopVideoFeature.setFalseText(PreviewStartText);
        this.previewStartStopVideoFeature.setTrueIcon(i18n.getImage((PropertiesEnum)StringsProperties.VIDEOMODULE_PREVIEWSTOPICON));
        this.previewStartStopVideoFeature.setFalseIcon(i18n.getImage((PropertiesEnum)StringsProperties.VIDEOMODULE_PREVIEWSTARTICON));
        this.previewStartStopVideoFeature.setRolloverTrueIcon(i18n.getImage((PropertiesEnum)StringsProperties.VIDEOMODULE_PREVIEWSTOPICON));
        this.previewStartStopVideoFeature.setRolloverFalseIcon(i18n.getImage((PropertiesEnum)StringsProperties.VIDEOMODULE_PREVIEWROLLOVERICON));
        this.previewStartStopVideoFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent ev) {
                boolean previewing = (Boolean)VideoModule.this.previewStartStopVideoFeature.getValue();
                if (previewing != VideoModule.this.bean.isPreviewing()) {
                    VideoModule.this.bean.setPreviewing(previewing);
                }
            }
        });
        this.videoDisplayedFeature = this.broker.createBooleanFeature((Object)this, this.pathSupport.composePath(FEATURE_BASE_PATH, "notifyVideoPaneVisible"), true, false, null, null);
        this.videoDisplayedFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent ev) {
                boolean videoDisplayed = (Boolean)ev.getNewValue();
                if (VideoModule.this.bean != null) {
                    if (videoDisplayed) {
                        VideoModule.this.bean.setContentVisible(true);
                    } else {
                        VideoModule.this.bean.setContentVisible(false);
                    }
                }
            }
        });
        String PrefVideoCameraSettingsPrefsTitle = i18n.getString((PropertiesEnum)StringsProperties.VIDEOCAMERASETTINGSPREFS_TITLE);
        final ComponentFeature videoCameraSettingsPrefsPanel = this.broker.createComponentFeature((Object)this, this.pathSupport.composePath(FEATURE_BASE_PATH, "prefs/videoCameraSettingsPrefsPanel"), new ComponentProvider(){

            public Component get(ComponentFeature feature) {
                return (Component)VideoModule.this.videoCameraSettingsPrefsPanelProvider.get();
            }
        }, PrefVideoCameraSettingsPrefsTitle, null);
        this.broker.addFeature((Feature)videoCameraSettingsPrefsPanel);
        String PrefVideoCameraSettingsOptionsMenuTitle = i18n.getString((PropertiesEnum)StringsProperties.VIDEOBEAN_VIDEOCAMERASETTINGSOPTIONSMENUTITLE);
        this.videoCameraSettingsFeature = this.broker.createActionFeature((Object)this, this.pathSupport.composePath(FEATURE_BASE_PATH, "options/videoCameraSettingsMenuItem"), PrefVideoCameraSettingsOptionsMenuTitle, null);
        this.videoCameraSettingsFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                PreferencesDialogAPI preferencesDialogAPI;
                if (VideoModule.this.imps != null && (preferencesDialogAPI = (PreferencesDialogAPI)VideoModule.this.imps.findBest(PreferencesDialogAPI.class)) != null) {
                    preferencesDialogAPI.showFeaturePreferencesPanelByPath(videoCameraSettingsPrefsPanel.getPath());
                }
            }
        });
        String MenuMaxFilmersText = i18n.getString((PropertiesEnum)StringsProperties.VIDEOMODULE_VIDEOMENUSETMAXFILMERSITEM);
        this.maxFilmersFeature = this.broker.createActionFeature((Object)this, this.pathSupport.composePath(FEATURE_BASE_PATH, "options/maxFilmers"), MenuMaxFilmersText, null);
        this.maxFilmersFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                if (VideoModule.this.bean != null) {
                    VideoModule.this.bean.showMaxFilmersDialog();
                }
            }
        });
        String VideoFollowsModeratorFocusText = i18n.getString((PropertiesEnum)StringsProperties.VIDEOBEAN_FOLLOWSMODERATORFOCUSTITLE);
        String VideoDoesNotFollowModeratorFocusText = i18n.getString((PropertiesEnum)StringsProperties.VIDEOBEAN_FOLLOWSMODERATORFOCUSTITLE);
        this.videoFollowsModeratorFocusFeature = this.broker.createBooleanFeature((Object)this, this.pathSupport.composePath(FEATURE_BASE_PATH, "options/videoFollowsModeratorFocus"), true, false, VideoFollowsModeratorFocusText, null);
        this.videoFollowsModeratorFocusFeature.setTrueText(VideoDoesNotFollowModeratorFocusText);
        this.videoFollowsModeratorFocusFeature.setFalseText(VideoFollowsModeratorFocusText);
        this.videoFollowsModeratorFocusFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent ev) {
                boolean videoFollowsModeratorFocus = (Boolean)VideoModule.this.videoFollowsModeratorFocusFeature.getValue();
                if (videoFollowsModeratorFocus != VideoModule.this.bean.isVideoFollowingModerator()) {
                    VideoModule.this.bean.setFollowModerator(videoFollowsModeratorFocus);
                }
            }
        });
        String VideoFollowsSpeakerText = i18n.getString((PropertiesEnum)StringsProperties.VIDEOBEAN_FOLLOWSSPEAKERTITLE);
        String VideoDoesNotFollowSpeakerText = i18n.getString((PropertiesEnum)StringsProperties.VIDEOBEAN_FOLLOWSSPEAKERTITLE);
        this.videoFollowsSpeakerFeature = this.broker.createBooleanFeature((Object)this, this.pathSupport.composePath(FEATURE_BASE_PATH, "options/videoFollowsSpeaker"), true, true, VideoFollowsSpeakerText, null);
        this.videoFollowsSpeakerFeature.setTrueText(VideoDoesNotFollowSpeakerText);
        this.videoFollowsSpeakerFeature.setFalseText(VideoFollowsSpeakerText);
        this.videoFollowsSpeakerFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent ev) {
                boolean videoFollowsSpeaker = (Boolean)VideoModule.this.videoFollowsSpeakerFeature.getValue();
                if (videoFollowsSpeaker != VideoModule.this.bean.isVideoFollowingSpeaker()) {
                    VideoModule.this.bean.setFollowSpeaker(videoFollowsSpeaker);
                }
            }
        });
        this.videoFollowsSpeakerFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent ev) {
                boolean videoFollowsSpeaker = (Boolean)VideoModule.this.videoFollowsSpeakerFeature.getValue();
                if (videoFollowsSpeaker && ((Boolean)VideoModule.this.videoFollowsModeratorFocusFeature.getValue()).booleanValue()) {
                    VideoModule.this.videoFollowsModeratorFocusFeature.setValue((Object)false);
                }
            }
        });
        this.videoFollowsModeratorFocusFeature.addValueChangeListener(new MetaDataListener(){
            private boolean previousFollowSpeaker;

            public void metaDataChanged(MetaDataEvent ev) {
                boolean followsModerator = (Boolean)VideoModule.this.videoFollowsModeratorFocusFeature.getValue();
                if (followsModerator) {
                    this.previousFollowSpeaker = (Boolean)VideoModule.this.videoFollowsSpeakerFeature.getValue();
                    VideoModule.this.videoFollowsSpeakerFeature.setValue((Object)false);
                    VideoModule.this.videoFollowsSpeakerFeature.setEnabled(VideoModule.this.chairProtocol.fetchChair(VideoModule.this.clients).isMe());
                } else {
                    VideoModule.this.videoFollowsSpeakerFeature.setEnabled(true);
                    VideoModule.this.videoFollowsSpeakerFeature.setValue((Object)this.previousFollowSpeaker);
                }
            }
        });
        String publishToWhiteboardFeatureText = i18n.getString((PropertiesEnum)StringsProperties.VIDEOBEAN_PUBLISHTOWHITEBOARDTITLE);
        this.publishToWhiteboardFeature = this.broker.createActionFeature((Object)this, this.pathSupport.composePath(FEATURE_BASE_PATH, "options/publishToWhiteboard"), publishToWhiteboardFeatureText, null);
        this.publishToWhiteboardFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                if (VideoModule.this.bean != null) {
                    VideoModule.this.bean.publishToWhiteboard();
                }
            }
        });
        BooleanFeature bf = this.permissionFeatureFactory.createPermissionFeature((Object)this, "VideoPermission", "/video/videoPermission", i18n.getString((PropertiesEnum)StringsProperties.VIDEOMODULE_VICCOLUMNTITLE), MODULE_NAME, i18n);
        bf.setAccessibleName(i18n.getString((PropertiesEnum)StringsProperties.VIDEOMODULE_VICCOLUMNTITLE_ACCESSIBLENAME));
        this.session.registerAnnotation("VideoActivityAnnotation", (Object)0);
        this.session.registerAnnotation("VideoLagAnnotation", (Object)0);
    }

    private void updateFeatures() {
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                boolean canModerate = VideoModule.this.connected && VideoModule.this.bean.isChair();
                VideoModule.this.broker.setFeaturePublished((Feature)VideoModule.this.videoPaneFeature, true);
                VideoModule.this.videoDisplayedFeature.setEnabled(true);
                VideoModule.this.broker.setFeaturePublished((Feature)VideoModule.this.videoDisplayedFeature, true);
                VideoModule.this.transmitStartStopVideoFeature.setEnabled(VideoModule.this.bean.transmitStartStopEnabled());
                VideoModule.this.broker.setFeaturePublished((Feature)VideoModule.this.transmitStartStopVideoFeature, true);
                VideoModule.this.previewStartStopVideoFeature.setEnabled(VideoModule.this.bean.previewStartStopEnabled());
                VideoModule.this.broker.setFeaturePublished((Feature)VideoModule.this.previewStartStopVideoFeature, !VideoModule.this.bean.isTransmitting());
                VideoModule.this.videoCameraSettingsFeature.setEnabled(true);
                VideoModule.this.broker.setFeaturePublished((Feature)VideoModule.this.videoCameraSettingsFeature, true);
                VideoModule.this.maxFilmersFeature.setEnabled(canModerate);
                VideoModule.this.broker.setFeaturePublished((Feature)VideoModule.this.maxFilmersFeature, true);
                VideoModule.this.videoFollowsModeratorFocusFeature.setEnabled(canModerate);
                VideoModule.this.broker.setFeaturePublished((Feature)VideoModule.this.videoFollowsModeratorFocusFeature, true);
                VideoModule.this.videoFollowsSpeakerFeature.setEnabled(canModerate || (Boolean)VideoModule.this.videoFollowsModeratorFocusFeature.getValue() == false);
                VideoModule.this.broker.setFeaturePublished((Feature)VideoModule.this.videoFollowsSpeakerFeature, true);
                VideoModule.this.publishToWhiteboardFeature.setEnabled(VideoModule.this.bean.publishToWhiteboardEnabled());
                VideoModule.this.broker.setFeaturePublished((Feature)VideoModule.this.publishToWhiteboardFeature, true);
            }
        });
    }

    private void revokeFeatures() {
        this.broker.setFeaturePublished((Feature)this.videoPaneFeature, false);
        this.broker.setFeaturePublished((Feature)this.videoDisplayedFeature, false);
        this.broker.setFeaturePublished((Feature)this.transmitStartStopVideoFeature, false);
        this.broker.setFeaturePublished((Feature)this.previewStartStopVideoFeature, false);
        this.broker.setFeaturePublished((Feature)this.videoCameraSettingsFeature, false);
        this.broker.setFeaturePublished((Feature)this.maxFilmersFeature, false);
        this.broker.setFeaturePublished((Feature)this.videoFollowsModeratorFocusFeature, false);
        this.broker.setFeaturePublished((Feature)this.videoFollowsSpeakerFeature, false);
        this.broker.setFeaturePublished((Feature)this.publishToWhiteboardFeature, false);
    }

    public void setActiveViewCount(int activeViewCount) {
        this.videoPaneFeature.setEnabled(activeViewCount > 0);
    }

    public void setPublishToWhiteboardEnabled(boolean enabled) {
        this.publishToWhiteboardFeature.setEnabled(enabled);
    }

    public void setTransmitEnabled(boolean enabled) {
        this.transmitStartStopVideoFeature.setEnabled(enabled);
    }

    public void setPreviewEnabled(boolean enabled) {
        this.previewStartStopVideoFeature.setEnabled(enabled);
    }

    public void setVideoFollowsModeratorFocusEnabled(boolean enabled) {
        this.videoFollowsModeratorFocusFeature.setEnabled(enabled);
    }

    public void setVideoFollowsSpeakerEnabled(boolean enabled) {
        this.videoFollowsSpeakerFeature.setEnabled(enabled);
    }

    public void setTransmit(boolean transmit) {
        this.transmitStartStopVideoFeature.setValue((Object)transmit);
    }

    public void setPreview(boolean preview) {
        this.previewStartStopVideoFeature.setValue((Object)preview);
    }

    public void setVideoFollowsModeratorFocus(boolean videoFollowsModeratorFocus) {
        if ((Boolean)this.videoFollowsModeratorFocusFeature.getValue() != videoFollowsModeratorFocus) {
            this.videoFollowsModeratorFocusFeature.setValue((Object)videoFollowsModeratorFocus);
        }
    }

    public void setVideoFollowsSpeaker(boolean videoFollowsSpeaker) {
        this.videoFollowsSpeakerFeature.setValue((Object)videoFollowsSpeaker);
    }

    public void setPreviewVisible(boolean previewPublished) {
        this.broker.setFeaturePublished((Feature)this.previewStartStopVideoFeature, previewPublished);
    }

    public void setAdvancedEnabled(boolean enabled) {
    }

    public void setMaximumQualityPublished(boolean published) {
    }

    public void setMaximumQualityEnabled(boolean enabled) {
    }

    public void setMaximumQuality(String quality) {
    }

    public void setSelectCameraEnabled(boolean enabled) {
    }

    public VideoBean getBean() {
        return this.bean;
    }

    private class VideoPaneProvider
    implements ComponentProvider {
        private VideoPaneProvider() {
        }

        public Component get(ComponentFeature feature) {
            return VideoModule.this.bean;
        }
    }
}

