/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.video.module;

import com.elluminate.engine.CommandContextException;
import com.elluminate.engine.CommandExecutionException;
import com.elluminate.engine.CommandParameterException;
import com.elluminate.engine.command.AbstractCommand;
import com.elluminate.engine.command.SetMaximumCamerasCommand;
import com.elluminate.groupware.video.module.StringsProperties;
import com.elluminate.groupware.video.module.VideoBean;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Provider;

public class SetMaximumCamerasCmd
extends AbstractCommand
implements SetMaximumCamerasCommand {
    private int maximumCameraCount = 1;
    private I18n i18n = I18n.create((Object)((Object)this));
    private Provider<VideoBean> beanProvider;

    @Inject
    public void initVideoBeanProvider(Provider<VideoBean> bp) {
        this.beanProvider = bp;
    }

    public void setCameraCount(int cameraCount) {
        this.maximumCameraCount = cameraCount;
    }

    public void doexecute() throws CommandExecutionException {
        this.validateIsOnlineAndIsChair();
        if (this.maximumCameraCount < 1 || this.maximumCameraCount > 6) {
            throw new CommandParameterException("Invalid maximum cameras: " + this.maximumCameraCount, this.i18n.getString((PropertiesEnum)StringsProperties.SETMAXIMUMCAMERASCMD_BADPARAMCAMERACOUNTINVALID, new Object[]{this.maximumCameraCount}));
        }
        VideoBean bean = (VideoBean)this.beanProvider.get();
        if (!bean.setMaximumCamerasCmd(this.maximumCameraCount)) {
            throw new CommandContextException("Cannot set maximum cameras to " + this.maximumCameraCount, this.i18n.getString((PropertiesEnum)StringsProperties.SETMAXIMUMCAMERASCMD_BADRESULTERROROCCURRED, new Object[]{this.maximumCameraCount}));
        }
    }
}

