/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.video.module;

import com.elluminate.groupware.video.module.ReceiveListener;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.util.MTPriorityQueue;
import com.elluminate.util.QueuedProcessor;
import com.elluminate.util.QueuedProcessorAdapter;
import com.elluminate.util.log.LogSupport;
import java.util.TooManyListenersException;

public class ReceiveQueue {
    private ReceiveListener listener = null;
    private MTPriorityQueue queue = new MTPriorityQueue("Video receive queue", (QueuedProcessor)new QueuedProcessorAdapter(){

        public void process(Object object, Object context) {
            ReceiveQueue.this.queueLength--;
            if (ReceiveQueue.this.queueLength < 0) {
                ReceiveQueue.this.queueLength = 0;
            }
            ReceiveQueue.this.doProcess(object);
        }
    });
    private int queueLength = 0;
    private int queueCount = 0;
    private int queueMax = 0;
    private long queueSum = 0L;

    public ReceiveQueue() {
        this.queue.setThreadPriority(5);
    }

    public void abort() {
        this.queue.stop(false);
        this.queueLength = 0;
    }

    public void addReceiveListener(ReceiveListener rl) throws TooManyListenersException {
        if (this.listener != null) {
            throw new TooManyListenersException("Too many receive queue listeners.");
        }
        this.listener = rl;
    }

    private void doProcess(Object event) {
        try {
            ChannelDataEvent cde = (ChannelDataEvent)event;
            if (this.listener == null) {
                LogSupport.error((Object)this, (String)"doProcess", (String)"No listener.");
            } else {
                try {
                    this.listener.onReceive(cde);
                }
                catch (Throwable t) {
                    LogSupport.exception((Object)this, (String)"doProcess", (Throwable)t, (boolean)true);
                }
            }
            cde.dispose();
        }
        catch (Throwable t) {
            LogSupport.exception((Object)this, (String)"doProcess", (Throwable)t, (boolean)true);
        }
    }

    public int getQueueLength() {
        return this.queueLength;
    }

    public void queueEvent(ChannelDataEvent cde) {
        this.queueSum += (long)this.queueLength;
        ++this.queueCount;
        ++this.queueLength;
        if (this.queueLength > this.queueMax) {
            this.queueMax = this.queueLength;
        }
        this.queue.process(cde.clone());
    }

    public void removeReceiveListener(ReceiveListener rl) {
        if (this.listener == rl) {
            this.listener = null;
        }
    }

    public String toString() {
        return "Receive Queue Stats: Queuings: " + this.queueCount + ", Peak Depth: " + this.queueMax + ", Ave: " + this.queueSum / (long)this.queueCount;
    }
}

