/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.module.contentcapture.mrfclient;

import com.elluminate.contentcapture.ContentCaptureIOPacketUtils;
import com.elluminate.groupware.module.contentcapture.mrfclient.BufferListener;
import com.elluminate.groupware.module.contentcapture.mrfclient.Feed;
import com.elluminate.mediastream.MRFAudioControl;
import com.elluminate.mediastream.MRFAudioData;
import com.elluminate.mediastream.MRFClient;
import com.elluminate.mediastream.MRFConditionFeed;
import com.elluminate.mediastream.MRFDuplicateTiles;
import com.elluminate.mediastream.MRFFeed;
import com.elluminate.mediastream.MRFGroup;
import com.elluminate.mediastream.MRFImageControl;
import com.elluminate.mediastream.MRFImageData;
import com.elluminate.mediastream.MRFIndexMark;
import com.elluminate.mediastream.MRFModule;
import com.elluminate.mediastream.MRFPacket;
import com.elluminate.mediastream.MRFRecordingControl;
import com.elluminate.mediastream.MRFSessionName;
import com.elluminate.mediastream.MRFShow;
import com.elluminate.mediastream.MRFTextData;
import com.elluminate.mediastream.MRFile;
import java.awt.Dimension;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Set;

public class MRFTranscriber
implements BufferListener {
    public static final boolean DEBUG_IO = false;
    public static final int DEFAULT_BANDWIDTH = 56000;
    private static final int READ_BUFFER_SIZE = 131072;
    private BufferListener bufferListener = null;
    private LinkedList deferQueue = new LinkedList();
    private String[] feeds;
    private HashMap feedIndexMap = new HashMap();
    private HashMap feedNameMap = new HashMap();
    private Dimension forcedOutputSize = new Dimension(0, 0);
    private String host;
    private HashMap moduleNameMap = new HashMap();
    private MRFile mrFile = null;
    private DataOutputStream mrOutStr = null;
    private int port;
    private String path;
    private ByteBuffer readBuffer = ByteBuffer.allocate(131072);
    private boolean running = false;
    private SocketChannel socketChannel;
    private Selector selector;
    private int sequence = 0;

    public MRFTranscriber(String host, String port, String path, String sessionName, long date, String[] feeds, int width, int height) throws Exception {
        this.host = host;
        this.port = Integer.parseInt(port);
        this.path = path;
        this.feeds = feeds;
        this.forcedOutputSize.setSize(width, height);
        this.mrFile = new MRFile(new File(path), sessionName, date, width, height);
        this.selector = Selector.open();
    }

    public void addBufferListener(BufferListener bl) {
        this.bufferListener = bl;
    }

    private void addFeed(String feedName, byte feedType, short feedIndex, byte[] iconBytes, byte panelMode, short moduleIndex, SelectionKey key) throws IOException {
        Feed feed = new Feed(feedName, feedType, feedIndex, iconBytes, panelMode);
        if (this.feeds != null && this.feeds.length > 0) {
            for (int i = 0; i < this.feeds.length; ++i) {
                if (!this.feeds[i].equals(MRFFeed.getFeedsName((String)feedName.toLowerCase(Locale.ENGLISH)))) continue;
                this.subscribeToFeed(true, feed, feedIndex, moduleIndex, feedType, key);
                break;
            }
        } else {
            this.subscribeToFeed(true, feed, feedIndex, moduleIndex, feedType, key);
        }
    }

    private void addModule(String moduleName, short moduleIndex, SelectionKey key) throws IOException {
        this.moduleNameMap.put(moduleName, moduleIndex);
        MRFModule mrfModule = new MRFModule(moduleName);
        if (this.mrFile != null) {
            this.mrFile.writePacket((MRFPacket)mrfModule);
        }
    }

    private void fireBufferListener(ByteBuffer buffer, SelectionKey key) {
        if (this.bufferListener != null) {
            do {
                buffer.mark();
            } while (this.bufferListener.onBuffer(buffer, key));
        } else {
            buffer.clear();
        }
    }

    @Override
    public boolean onBuffer(ByteBuffer buffer, SelectionKey key) {
        if (buffer.remaining() < 3) {
            buffer.reset();
            return false;
        }
        int packetLength = buffer.getShort() - 2;
        if (buffer.remaining() < packetLength) {
            buffer.reset();
            return false;
        }
        byte[] packet = new byte[packetLength];
        buffer.get(packet);
        byte command = packet[0];
        try {
            switch (command) {
                case 0: {
                    this.processAddFeed(packet, key);
                    break;
                }
                case 28: {
                    this.processAddModule(packet, key);
                    break;
                }
                case 23: {
                    this.processAddParticipant(packet, key);
                    break;
                }
                case 9: {
                    this.processAudioDataPacket(packet, key);
                    break;
                }
                case 21: {
                    this.processAudioGrantPacket(packet, key);
                    break;
                }
                case 22: {
                    this.processAudioRevokePacket(packet, key);
                    break;
                }
                case 25: {
                    this.processCreateGroupPacket(packet, key);
                    break;
                }
                case 26: {
                    this.processDeleteGroupPacket(packet, key);
                    break;
                }
                case 14: {
                    this.processDuplicateTiles(packet, key);
                    break;
                }
                case 8: {
                    this.processImageDataPacket(packet, key);
                    break;
                }
                case 31: {
                    this.processIndexMark(packet, key);
                    break;
                }
                case 1: {
                    this.processRemoveFeed(packet, key);
                    break;
                }
                case 24: {
                    this.processRemoveParticipantPacket(packet, key);
                    break;
                }
                case 27: {
                    this.processRenameGroupPacket(packet, key);
                    break;
                }
                case 4: {
                    int ackNumber = ContentCaptureIOPacketUtils.getAckNumber((byte[])packet);
                    this.writeKey(ContentCaptureIOPacketUtils.encodeAcknowledgeAck((int)ackNumber), key);
                    break;
                }
                case 13: {
                    this.processRequestRepaint(packet, key);
                    break;
                }
                case 29: {
                    this.processSessionName(packet, key);
                    break;
                }
                case 30: {
                    this.processSessionRecord(packet, key);
                    break;
                }
                case 10: {
                    this.processImageSize(packet, key);
                    break;
                }
                case 11: {
                    this.processSetFeedVisible(packet, key);
                    break;
                }
                case 7: {
                    this.processTextPacket(packet, key);
                    break;
                }
                case 16: {
                    this.processConditionFeed(packet, key);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private void processAddFeed(byte[] packet, SelectionKey key) throws IOException {
        String feedName = ContentCaptureIOPacketUtils.getFeedNameFromAdd((byte[])packet);
        byte feedType = ContentCaptureIOPacketUtils.getFeedTypeFromAdd((byte[])packet);
        short feedIndex = ContentCaptureIOPacketUtils.getFeedIndexFromAdd((byte[])packet);
        byte panelMode = ContentCaptureIOPacketUtils.getFeedPanelModeFromAdd((byte[])packet);
        byte[] iconBytes = ContentCaptureIOPacketUtils.getFeedIconFromAdd((byte[])packet);
        short moduleIndex = ContentCaptureIOPacketUtils.getModuleIndexFromFeedAdd((byte[])packet);
        this.addFeed(feedName, feedType, feedIndex, iconBytes, panelMode, moduleIndex, key);
    }

    private void processAddModule(byte[] packet, SelectionKey key) throws IOException {
        String moduleName = ContentCaptureIOPacketUtils.getModuleNameFromAdd((byte[])packet);
        short moduleIndex = ContentCaptureIOPacketUtils.getModuleIndexFromAdd((byte[])packet);
        this.addModule(moduleName, moduleIndex, key);
    }

    private void processAddParticipant(byte[] packet, SelectionKey key) throws IOException {
        String clientName = ContentCaptureIOPacketUtils.getParticipantName((byte[])packet);
        short clientAddress = ContentCaptureIOPacketUtils.getParticipantAddress((byte[])packet);
        String displayName = ContentCaptureIOPacketUtils.getParticipantDisplayName((byte[])packet);
        short clientGroup = ContentCaptureIOPacketUtils.getParticipantGroup((byte[])packet);
        long time = ContentCaptureIOPacketUtils.getParticipantTime((byte[])packet);
        MRFClient mrfClient = new MRFClient(clientName, clientAddress, displayName, clientGroup, true, time);
        if (this.mrFile != null) {
            this.mrFile.writePacket((MRFPacket)mrfClient);
        }
    }

    private void processAudioDataPacket(byte[] packet, SelectionKey key) throws IOException {
        short feedIndex = ContentCaptureIOPacketUtils.getAudioFeedIndex((byte[])packet);
        this.setFrameAudio(feedIndex, packet);
    }

    private void processAudioGrantPacket(byte[] packet, SelectionKey key) throws IOException {
        short feedIndex = ContentCaptureIOPacketUtils.getAudioFeedIndex((byte[])packet);
        this.setAudioGrant(feedIndex, packet);
    }

    private void processAudioRevokePacket(byte[] packet, SelectionKey key) throws IOException {
        short feedIndex = ContentCaptureIOPacketUtils.getAudioFeedIndex((byte[])packet);
        this.setAudioRevoke(feedIndex, packet);
    }

    private void processConditionFeed(byte[] packet, SelectionKey key) throws IOException {
        short feedIndex = ContentCaptureIOPacketUtils.getFeedIndexFromConditionFeed((byte[])packet);
        byte[] data = ContentCaptureIOPacketUtils.getConditionFeed((byte[])packet);
        MRFConditionFeed mrfCond = new MRFConditionFeed(feedIndex, data);
        if (this.mrFile != null) {
            this.mrFile.writePacket((MRFPacket)mrfCond);
        }
    }

    private void processCreateGroupPacket(byte[] packet, SelectionKey key) throws IOException {
        String groupName = ContentCaptureIOPacketUtils.getGroupName((byte[])packet);
        short groupId = ContentCaptureIOPacketUtils.getGroupId((byte[])packet);
        long time = ContentCaptureIOPacketUtils.getGroupTime((byte[])packet);
        MRFGroup mrfGroup = new MRFGroup(groupName, groupId, "", 0, 1, time);
        if (this.mrFile != null) {
            this.mrFile.writePacket((MRFPacket)mrfGroup);
        }
    }

    private void processDeleteGroupPacket(byte[] packet, SelectionKey key) throws IOException {
        short groupId = ContentCaptureIOPacketUtils.getGroupId((byte[])packet);
        long time = ContentCaptureIOPacketUtils.getGroupTime((byte[])packet);
        MRFGroup mrfGroup = new MRFGroup("", groupId, "", 0, 2, time);
        if (this.mrFile != null) {
            this.mrFile.writePacket((MRFPacket)mrfGroup);
        }
    }

    private void processDuplicateTiles(byte[] packet, SelectionKey key) throws IOException {
        short feedIndex = ContentCaptureIOPacketUtils.getDuplicateTilesFeedIndex((byte[])packet);
        short[] tileList = ContentCaptureIOPacketUtils.getDuplicateTiles((byte[])packet);
        long time = ContentCaptureIOPacketUtils.getDuplicateTilesTime((byte[])packet);
        this.setDuplicateImage(feedIndex, tileList, time);
    }

    private void processImageDataPacket(byte[] packet, SelectionKey key) throws IOException {
        short feedIndex = ContentCaptureIOPacketUtils.getImageFeedIndex((byte[])packet);
        short tileNumber = ContentCaptureIOPacketUtils.getImageTileNumber((byte[])packet);
        byte[] compressed = ContentCaptureIOPacketUtils.getImageData((byte[])packet);
        long time = ContentCaptureIOPacketUtils.getImageTime((byte[])packet);
        this.setFrameImage(feedIndex, tileNumber, compressed, time, key);
    }

    private void processImageSize(byte[] packet, SelectionKey key) throws IOException {
        short feedIndex = ContentCaptureIOPacketUtils.getImageFeedIndex((byte[])packet);
        short width = ContentCaptureIOPacketUtils.getImageWidth((byte[])packet);
        short height = ContentCaptureIOPacketUtils.getImageHeight((byte[])packet);
        long time = ContentCaptureIOPacketUtils.getImageSizeTime((byte[])packet);
        this.setImageSize(feedIndex, width, height, time);
    }

    private void processIndexMark(byte[] packet, SelectionKey key) throws IOException {
        String modName = ContentCaptureIOPacketUtils.getIndexModName((byte[])packet);
        String kind = ContentCaptureIOPacketUtils.getIndexKind((byte[])packet);
        String detail = ContentCaptureIOPacketUtils.getIndexDetail((byte[])packet);
        long time = ContentCaptureIOPacketUtils.getIndexTime((byte[])packet);
        MRFIndexMark mim = new MRFIndexMark(modName, kind, detail, time);
        if (this.mrFile != null) {
            this.mrFile.writePacket((MRFPacket)mim);
        }
    }

    private void processRemoveFeed(byte[] packet, SelectionKey key) throws IOException {
        String feedName = ContentCaptureIOPacketUtils.getFeedNameFromAdd((byte[])packet);
        byte feedType = ContentCaptureIOPacketUtils.getFeedTypeFromAdd((byte[])packet);
        this.removeFeed(feedName, key);
    }

    private void processRemoveParticipantPacket(byte[] packet, SelectionKey key) throws IOException {
        short clientAddress = ContentCaptureIOPacketUtils.getParticipantAddress((byte[])packet);
        long time = ContentCaptureIOPacketUtils.getParticipantTime((byte[])packet);
        MRFClient mrfClient = new MRFClient("", clientAddress, "", 0, false, time);
        if (this.mrFile != null) {
            this.mrFile.writePacket((MRFPacket)mrfClient);
        }
    }

    private void processRenameGroupPacket(byte[] packet, SelectionKey key) throws IOException {
        String groupName = ContentCaptureIOPacketUtils.getGroupName((byte[])packet);
        short groupId = ContentCaptureIOPacketUtils.getGroupId((byte[])packet);
        String prevGroupName = ContentCaptureIOPacketUtils.getPrevGroupName((byte[])packet);
        short prevGroupId = ContentCaptureIOPacketUtils.getPrevGroupId((byte[])packet);
        long time = ContentCaptureIOPacketUtils.getGroupTime((byte[])packet);
        MRFGroup mrfGroup = new MRFGroup(groupName, groupId, prevGroupName, prevGroupId, 3, time);
        if (this.mrFile != null) {
            this.mrFile.writePacket((MRFPacket)mrfGroup);
        }
    }

    private void processRequestRepaint(byte[] packet, SelectionKey key) throws IOException {
        long time = ContentCaptureIOPacketUtils.getRepaintTime((byte[])packet);
        short feedIndex = ContentCaptureIOPacketUtils.getRepaintFeedIndex((byte[])packet);
        MRFImageControl mrfc = new MRFImageControl(feedIndex, 0, 0, 2, time);
        if (this.mrFile != null) {
            this.mrFile.writePacket((MRFPacket)mrfc);
        }
    }

    private void processSessionName(byte[] packet, SelectionKey key) throws IOException {
        long time = ContentCaptureIOPacketUtils.getTimeFromSessionName((byte[])packet);
        String name = ContentCaptureIOPacketUtils.getNameFromSessionName((byte[])packet);
        this.setSessionName(name, time);
    }

    private void processSessionRecord(byte[] packet, SelectionKey key) throws IOException {
        long time = ContentCaptureIOPacketUtils.getTimeFromSessionRecord((byte[])packet);
        short recordType = ContentCaptureIOPacketUtils.getSessionRecordType((byte[])packet);
        MRFRecordingControl mfcrc = new MRFRecordingControl(recordType == 0, time);
        if (this.mrFile != null) {
            this.mrFile.writePacket((MRFPacket)mfcrc);
        }
    }

    private void processSetFeedVisible(byte[] packet, SelectionKey key) throws IOException {
        short feedIndex = ContentCaptureIOPacketUtils.getVisibleFeedIndex((byte[])packet);
        boolean visible = ContentCaptureIOPacketUtils.getVisibleState((byte[])packet);
        long time = ContentCaptureIOPacketUtils.getVisibleTime((byte[])packet);
        this.setFeedVisible(feedIndex, visible, time);
    }

    private void processTextPacket(byte[] packet, SelectionKey key) throws IOException {
        short author;
        short feedIndex = ContentCaptureIOPacketUtils.getTextFeedIndex((byte[])packet);
        String text = ContentCaptureIOPacketUtils.getText((byte[])packet);
        long time = ContentCaptureIOPacketUtils.getTextTime((byte[])packet);
        short auth = author = ContentCaptureIOPacketUtils.getAuthor((byte[])packet);
        if (author == -1) {
            auth = -1;
        } else if (author == -2) {
            auth = -2;
        }
        MRFTextData mrft = new MRFTextData(feedIndex, auth, time, text);
        if (this.mrFile != null) {
            this.mrFile.writePacket((MRFPacket)mrft);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueOp(Runnable runnable) {
        MRFTranscriber mRFTranscriber = this;
        synchronized (mRFTranscriber) {
            this.deferQueue.add(runnable);
            this.selector.wakeup();
        }
    }

    private void readChannel(SelectionKey key) throws IOException {
        SocketChannel channel = (SocketChannel)key.channel();
        int read = channel.read(this.readBuffer);
        if (read > 0) {
            this.readBuffer.limit(this.readBuffer.position());
            this.readBuffer.position(0);
            this.fireBufferListener(this.readBuffer, key);
            this.readBuffer.compact();
            this.readBuffer.limit(this.readBuffer.capacity());
        }
    }

    public void removeBufferListener() {
        this.bufferListener = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFeed(String feedName, SelectionKey key) throws IOException {
        Feed feed;
        HashMap hashMap = this.feedNameMap;
        synchronized (hashMap) {
            feed = (Feed)this.feedNameMap.get(feedName);
        }
        if (feed != null) {
            this.subscribeToFeed(false, feed, feed.getFeedIndex(), (short)0, (byte)0, key);
        }
    }

    private void sendAudioEvent(short feedIndex, byte[] packet, boolean grant) throws IOException {
        short talkerAddress = ContentCaptureIOPacketUtils.getAudioTalker((byte[])packet);
        long time = ContentCaptureIOPacketUtils.getAudioTime((byte[])packet);
        MRFAudioControl control = new MRFAudioControl(feedIndex, grant, talkerAddress, time);
        if (this.mrFile != null) {
            this.mrFile.writePacket((MRFPacket)control);
        }
    }

    private void setAudioGrant(short feedIndex, byte[] packet) throws IOException {
        this.sendAudioEvent(feedIndex, packet, true);
    }

    private void setAudioRevoke(short feedIndex, byte[] packet) throws IOException {
        this.sendAudioEvent(feedIndex, packet, false);
    }

    private void setDuplicateImage(short feedIndex, short[] tileIndicies, long time) throws IOException {
        MRFDuplicateTiles mrfTD = new MRFDuplicateTiles(feedIndex, tileIndicies, time);
        if (this.mrFile != null) {
            this.mrFile.writePacket((MRFPacket)mrfTD);
        }
    }

    private void setFeedVisible(short feedIndex, boolean visible, long time) throws IOException {
        MRFShow mrfs = new MRFShow(feedIndex, visible, time);
        if (this.mrFile != null) {
            this.mrFile.writePacket((MRFPacket)mrfs);
        }
    }

    private void setFrameAudio(short feedIndex, byte[] packet) throws IOException {
        byte[] ecelpPacket = ContentCaptureIOPacketUtils.getAudioData((byte[])packet);
        short talkerAddress = ContentCaptureIOPacketUtils.getAudioTalker((byte[])packet);
        long time = ContentCaptureIOPacketUtils.getAudioTime((byte[])packet);
        MRFAudioData audio = new MRFAudioData(feedIndex, ecelpPacket, talkerAddress, time);
        if (this.mrFile != null) {
            this.mrFile.writePacket((MRFPacket)audio);
        }
    }

    private void setFrameImage(short feedIndex, short tileNumber, byte[] compressedData, long time, SelectionKey key) throws IOException {
        MRFImageData mrfID = new MRFImageData(feedIndex, tileNumber, compressedData, time);
        if (this.mrFile != null) {
            this.mrFile.writePacket((MRFPacket)mrfID);
        }
    }

    private void setImageSize(short feedIndex, short width, short height, long time) throws IOException {
        MRFImageControl mrfc = new MRFImageControl(feedIndex, width, height, 1, time);
        if (this.mrFile != null) {
            this.mrFile.writePacket((MRFPacket)mrfc);
        }
    }

    private void setSessionName(String name, long time) throws IOException {
        MRFSessionName sessionName = new MRFSessionName(time, name);
        if (this.mrFile != null) {
            this.mrFile.writePacket((MRFPacket)sessionName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        int keyCount = 0;
        this.addBufferListener(this);
        try {
            InetSocketAddress address = new InetSocketAddress(this.host, this.port);
            do {
                try {
                    this.socketChannel = SocketChannel.open(address);
                }
                catch (IOException ex2) {
                    MRFTranscriber mRFTranscriber = this;
                    synchronized (mRFTranscriber) {
                        try {
                            this.wait(1000L);
                        }
                        catch (InterruptedException ie) {
                            return;
                        }
                    }
                }
            } while (this.socketChannel == null || !this.socketChannel.isConnected());
            LinkedList<ByteBuffer> bufferList = new LinkedList<ByteBuffer>();
            byte[] bytes = ContentCaptureIOPacketUtils.encodeBandwidthSetting((int)56000);
            ByteBuffer buf = ByteBuffer.allocate(bytes.length);
            buf.put(bytes);
            buf.flip();
            bufferList.addLast(buf);
            try {
                this.socketChannel.configureBlocking(false);
                this.socketChannel.register(this.selector, 5, bufferList);
            }
            catch (ClosedChannelException ex) {
                ex.printStackTrace();
                try {
                    this.selector.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                return;
            }
        }
        catch (ClosedChannelException ex) {
            try {
                this.selector.close();
                return;
            }
            catch (IOException e) {
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            try {
                this.selector.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            return;
        }
        this.mrOutStr = this.mrFile.getOutputStream();
        do {
            LinkedList queue;
            MRFTranscriber ioe = this;
            synchronized (ioe) {
                queue = this.deferQueue;
                this.deferQueue = new LinkedList();
            }
            Iterator queueIter = queue.iterator();
            while (queueIter.hasNext()) {
                try {
                    ((Runnable)queueIter.next()).run();
                }
                catch (Exception ex1) {
                    ex1.printStackTrace();
                }
            }
            try {
                keyCount = this.selector.select();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                break;
            }
            if (keyCount <= 0 || !this.selector.isOpen() || !this.socketChannel.isConnected()) continue;
            Set<SelectionKey> keys = this.selector.selectedKeys();
            Iterator<SelectionKey> keyIter = keys.iterator();
            while (keyIter.hasNext() && this.selector.isOpen() && this.socketChannel.isConnected()) {
                SelectionKey key = keyIter.next();
                if (key.isReadable()) {
                    this.readChannel(key);
                }
                if (key.isWritable()) {
                    this.writeChannel(key);
                }
                keyIter.remove();
            }
        } while (this.selector.isOpen() && this.socketChannel.isConnected());
        this.stop();
    }

    public void stop() {
        try {
            this.selector.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.mrFile != null) {
            this.mrFile.close();
            this.mrFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void subscribeToFeed(boolean subscribe, Feed feed, short feedIdx, short moduleIndex, byte feedType, SelectionKey key) throws IOException {
        if (subscribe) {
            if (feed.isInitialized()) {
                byte[] packet = ContentCaptureIOPacketUtils.encodeReSubscribeFeed((String)feed.getFeedName());
                this.writeKey(packet, key);
            } else {
                HashMap hashMap = this.feedNameMap;
                synchronized (hashMap) {
                    this.feedNameMap.put(feed.getFeedName(), feed);
                    this.feedIndexMap.put(feed.getShortFeedIndex(), feed);
                }
                byte[] packet = ContentCaptureIOPacketUtils.encodeSubscribeFeed((String)feed.getFeedName());
                this.writeKey(packet, key);
                MRFFeed mrfFeed = new MRFFeed(feed.getFeedName(), feedIdx, moduleIndex, feedType);
                if (this.mrFile != null) {
                    this.mrFile.writePacket((MRFPacket)mrfFeed);
                }
                packet = ContentCaptureIOPacketUtils.encodeRequestRepaint((short)feedIdx, (long)1L);
                this.writeKey(packet, key);
            }
        } else {
            byte[] packet = ContentCaptureIOPacketUtils.encodeUnsubscribeFeed((String)feed.getFeedName());
            this.writeKey(packet, key);
            HashMap hashMap = this.feedNameMap;
            synchronized (hashMap) {
                this.feedNameMap.remove(feed);
            }
        }
    }

    private void writeChannel(SelectionKey key) {
        LinkedList bufferList = (LinkedList)key.attachment();
        key.attach(new LinkedList());
        SocketChannel channel = (SocketChannel)key.channel();
        if (bufferList != null) {
            while (bufferList.size() > 0) {
                ByteBuffer buffer = (ByteBuffer)bufferList.getFirst();
                if (buffer.hasRemaining()) {
                    try {
                        channel.write(buffer);
                        if (!channel.isBlocking()) continue;
                        key.interestOps(5);
                        return;
                    }
                    catch (IOException ex) {
                        if (key.channel().isOpen()) continue;
                        try {
                            this.selector.close();
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                        return;
                    }
                }
                bufferList.removeFirst();
            }
        }
        key.interestOps(1);
    }

    public void writeKey(byte[] bytes, SelectionKey key) {
        if (key.isValid()) {
            ByteBuffer buf = ByteBuffer.allocate(bytes.length);
            buf.put(bytes);
            buf.flip();
            ((LinkedList)key.attachment()).addLast(buf);
            if ((key.interestOps() & 4) == 0) {
                key.interestOps(5);
            }
        }
    }
}

