/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.module.contentcapture;

import java.util.HashMap;

public class ListMap {
    private HashMap map;
    private ListElement listHead = new ListElement(null, null);
    private ListElement listTail = new ListElement(null, null);

    public ListMap() {
        this.map = new HashMap();
        this.listHead.setNext(this.listTail);
        this.listHead.setPrevious(null);
        this.listTail.setNext(null);
        this.listTail.setPrevious(this.listHead);
    }

    public synchronized void add(Object key, Object value) {
        ListElement element = (ListElement)this.map.get(key);
        if (element == null) {
            element = new ListElement(key, value);
            this.map.put(key, element);
        } else {
            this.listRemove(element);
        }
        this.listAdd(element);
    }

    public synchronized boolean contains(Object object) {
        return this.map.containsKey(object);
    }

    public synchronized boolean isEmpty() {
        return this.map.isEmpty();
    }

    private void listAdd(ListElement element) {
        element.setPrevious(this.listTail.getPrevious());
        element.setNext(this.listTail);
        this.listTail.getPrevious().setNext(element);
        this.listTail.setPrevious(element);
    }

    private void listRemove(ListElement element) {
        if (element != null) {
            element.getPrevious().setNext(element.getNext());
            element.getNext().setPrevious(element.getPrevious());
            element.setPrevious(null);
            element.setNext(null);
        }
    }

    public synchronized Object remove(Object key) {
        return this.removeElement(key).getValue();
    }

    public synchronized ListElement removeElement(Object key) {
        ListElement element = (ListElement)this.map.remove(key);
        if (element != null) {
            this.listRemove(element);
        }
        return element;
    }

    public synchronized ListElement removeFirst() {
        if (this.isEmpty()) {
            return null;
        }
        ListElement element = this.listHead.getNext();
        this.map.remove(element.getKey());
        this.listRemove(element);
        return element;
    }

    public class ListElement {
        private Object key;
        private ListElement next = null;
        private ListElement previous = null;
        private Object value;

        public ListElement(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public ListElement getNext() {
            return this.next;
        }

        private void setNext(ListElement element) {
            this.next = element;
        }

        public ListElement getPrevious() {
            return this.previous;
        }

        private void setPrevious(ListElement element) {
            this.previous = element;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

