/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.module.contentcapture;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;

public class CompressedImageUtil {
    public static final byte[] IMAGE = new byte[]{0};
    public static final boolean STATISTICS = System.getProperty("tilestatistics", null) != null;

    public static void sendCompressedImage(int x, int y, int w, int h, int[] data, OutputStream dataOut, boolean reset) throws IOException {
        if (data.length > 0) {
            ByteArrayOutputStream deflated = new ByteArrayOutputStream();
            BufferedOutputStream dOut = new BufferedOutputStream(new DeflaterOutputStream(deflated));
            CompressedImageUtil.sendInt(dOut, x);
            CompressedImageUtil.sendInt(dOut, y);
            CompressedImageUtil.sendInt(dOut, reset ? -w : w);
            CompressedImageUtil.sendInt(dOut, h);
            CompressedImageUtil.sendInts(dOut, data);
            ((OutputStream)dOut).close();
            byte[] bytes = deflated.toByteArray();
            dataOut.write(IMAGE);
            CompressedImageUtil.sendInt(dataOut, bytes.length);
            dataOut.write(bytes);
            dataOut.flush();
            if (STATISTICS) {
                System.out.println(", Compressed to pixel equivalents: " + bytes.length + ", Compression: " + data.length * 400 / bytes.length + " %");
            }
        }
    }

    private static void sendInt(OutputStream dOut, int value) throws IOException {
        byte[] bytes = new byte[]{(byte)(0xFF & value >> 24), (byte)(0xFF & value >> 16), (byte)(0xFF & value >> 8), (byte)(0xFF & value >> 0)};
        dOut.write(bytes);
    }

    private static void sendInts(OutputStream dOut, int[] values) throws IOException {
        byte[] bytes = new byte[values.length * 4];
        int index = 0;
        for (int i = 0; i < values.length; ++i) {
            int value = values[i];
            bytes[index++] = (byte)(0xFF & value >> 24);
            bytes[index++] = (byte)(0xFF & value >> 16);
            bytes[index++] = (byte)(0xFF & value >> 8);
            bytes[index++] = (byte)(0xFF & value >> 0);
        }
        dOut.write(bytes);
    }
}

