/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.module.contentcapture;

import com.elluminate.contentcapture.CaptureFeedSubscription;
import com.elluminate.contentcapture.CaptureLogicalImageRoot;
import com.elluminate.contentcapture.CaptureTile;
import com.elluminate.contentcapture.ContentCapture;
import com.elluminate.groupware.imps.ScalableComponent;
import com.elluminate.groupware.module.contentcapture.CaptureTileCache;
import com.elluminate.groupware.module.contentcapture.ComponentRepaintManager;
import com.elluminate.mediastream.imageprocessing.ImageUtilities;
import com.elluminate.util.SwingRunnerSupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class CaptureLogicalImageRootImpl
implements CaptureLogicalImageRoot {
    private static final boolean SHOW_REPAINT = System.getProperty("showrepaint", null) != null;
    private static final boolean DEBUG_DISPLAY = System.getProperty("debugdisplay", null) != null;
    private static final Dimension MIN_DIMENSION = new Dimension(1, 1);
    private static final Color CLEAR = Color.white;
    private Container commonRoot;
    private Dimension componentSize = new Dimension();
    private BufferedImage captureImage = null;
    private int[] capturePixels = null;
    public Rectangle dirtyArea = null;
    public Container dirtyContainer;
    public int dirtyLevel = Integer.MIN_VALUE;
    private byte encoding = 1;
    private ContentCapture capture;
    private BufferedImage componentBuffer = null;
    private Dimension lastSize = new Dimension();
    private Object lock = new Object(){};
    private Container logicalRoot;
    private Dimension logicalRootSize = new Dimension();
    private CaptureTileCache tileCache = new CaptureTileCache();
    private BufferedImage outputImage = null;
    private int[] updatePixels = null;
    private ImageDialog currentDialog;
    private ImageDialog componentImageDialog;
    private ImageDialog outputImageDialog;
    private ComponentAdapter componentListener = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent e) {
            CaptureLogicalImageRootImpl.this.resized(e);
        }
    };

    public CaptureLogicalImageRootImpl(Container logicalRoot, ContentCapture capture) {
        this.logicalRoot = logicalRoot;
        logicalRoot.addComponentListener(this.componentListener);
        this.commonRoot = null;
        this.capture = capture;
        if (DEBUG_DISPLAY) {
            this.currentDialog = new ImageDialog(logicalRoot, "Current - " + capture.getFeedName());
            this.currentDialog.setVisible(true);
            this.outputImageDialog = new ImageDialog(logicalRoot, "Output - " + capture.getFeedName());
            this.outputImageDialog.setVisible(true);
            this.componentImageDialog = new ImageDialog(logicalRoot, "Component - " + capture.getFeedName());
            this.componentImageDialog.setVisible(true);
        }
    }

    public void dispose() {
    }

    public Container getCommonRoot() {
        if (this.commonRoot == null) {
            this.commonRoot = ComponentRepaintManager.returnRoot(this.logicalRoot);
        }
        return this.commonRoot;
    }

    public Object getLock() {
        return this.lock;
    }

    public Dimension getComponentSize() {
        Dimension componentSize;
        boolean componentIsScalable = this.logicalRoot instanceof ScalableComponent;
        if (componentIsScalable) {
            ScalableComponent scalableComponent = (ScalableComponent)this.logicalRoot;
            componentSize = scalableComponent.getUnscaledSize();
        } else {
            componentSize = this.logicalRootSize;
        }
        return componentSize;
    }

    public Dimension getOutputSize() {
        double scaleY;
        Dimension outputSize = new Dimension(this.capture.getImageSize());
        if (this.capture.isImageSizeSet()) {
            if (this.capture.getImageSize().width < outputSize.width) {
                double scaleWidth = (double)this.capture.getImageSize().width / (double)outputSize.width;
                outputSize.width = this.capture.getImageSize().width;
                outputSize.height = (int)((double)outputSize.height * scaleWidth);
            }
            if (this.capture.getImageSize().height < outputSize.height) {
                double scaleHeight = (double)this.capture.getImageSize().height / (double)outputSize.height;
                outputSize.height = this.capture.getImageSize().height;
                outputSize.width = (int)((double)outputSize.width * scaleHeight);
            }
        }
        Dimension componentSize = this.getComponentSize();
        if (componentSize.width <= 0 || componentSize.height <= 0) {
            return outputSize;
        }
        double scaleX = outputSize.getWidth() / componentSize.getWidth();
        double scale = scaleX > (scaleY = outputSize.getHeight() / componentSize.getHeight()) ? scaleY : scaleX;
        Dimension restrictedOutputSize = new Dimension((int)(componentSize.getWidth() * scale), (int)(componentSize.getHeight() * scale));
        return scale == 0.0 ? outputSize : restrictedOutputSize;
    }

    public Container getLogicalRoot() {
        return this.logicalRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDirtyUnion(int x, int y, int w, int h, Container container, int level) {
        Object object = this.lock;
        synchronized (object) {
            Rectangle rect = new Rectangle(x, y, w, h);
            SwingUtilities.convertRectangle(container, rect, this.logicalRoot);
            SwingUtilities.computeIntersection(0, 0, this.logicalRoot.getWidth(), this.logicalRoot.getHeight(), rect);
            if (this.dirtyArea == null) {
                this.dirtyArea = rect;
            } else {
                SwingUtilities.computeUnion(rect.x, rect.y, rect.width, rect.height, this.dirtyArea);
            }
            if (level > this.dirtyLevel) {
                this.dirtyContainer = container;
                this.dirtyLevel = level;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintDirtyComponents() {
        boolean fullImage = false;
        ScalableComponent scalableComponent = null;
        double scaleGraphics = 1.0;
        double scaleGraphicsX = 1.0;
        double scaleGraphicsY = 1.0;
        Rectangle updateArea = new Rectangle();
        Object object = this.lock;
        synchronized (object) {
            Rectangle outputClipRect;
            double scaleDirtyRect;
            Dimension imageSize;
            Rectangle unscaledDirty;
            double scaleDirtyRectY;
            double scaleDirtyRectX;
            Graphics2D paneGraphics;
            long frameTime = this.capture.sessionTime();
            if (this.dirtyArea == null || this.dirtyArea.width <= 0 || this.dirtyArea.height <= 0) {
                return;
            }
            this.logicalRootSize = this.logicalRoot.getSize();
            Dimension frameSize = this.getOutputSize();
            this.componentSize = this.getComponentSize();
            if (this.componentSize.width == 0 || this.componentSize.height == 0 || frameSize.width <= 0 || frameSize.height <= 0) {
                this.dirtyArea = null;
                return;
            }
            boolean componentIsScalable = this.logicalRoot instanceof ScalableComponent;
            if (this.componentBuffer == null || this.componentBuffer.getWidth() != this.componentSize.width || this.componentBuffer.getHeight() != this.componentSize.height) {
                this.componentBuffer = new BufferedImage(this.componentSize.width, this.componentSize.height, 1);
                paneGraphics = this.componentBuffer.createGraphics();
                paneGraphics.setColor(CLEAR);
                paneGraphics.fillRect(0, 0, this.componentSize.width, this.componentSize.height);
                fullImage = true;
            } else {
                paneGraphics = this.componentBuffer.createGraphics();
            }
            if (componentIsScalable) {
                scalableComponent = (ScalableComponent)this.logicalRoot;
                scaleDirtyRectX = 1.0 / scalableComponent.getScaleFactorX();
                scaleDirtyRectY = 1.0 / scalableComponent.getScaleFactorY();
                unscaledDirty = ImageUtilities.getScaledRect((Rectangle)this.dirtyArea, (double)scaleDirtyRectX, (double)scaleDirtyRectY);
                if (!fullImage) {
                    paneGraphics.setClip(unscaledDirty);
                    unscaledDirty.setBounds(0, 0, this.componentSize.width, this.componentSize.height);
                } else {
                    paneGraphics.setClip(new Rectangle(0, 0, this.componentSize.width, this.componentSize.height));
                }
                paneGraphics.setFont(this.logicalRoot.getFont());
                paneGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                paneGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                paneGraphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                scalableComponent.paintUnscaled((Graphics)paneGraphics);
                imageSize = this.componentSize;
                if (DEBUG_DISPLAY) {
                    this.componentImageDialog.setImg(this.componentBuffer);
                    this.componentImageDialog.repaintImg(unscaledDirty);
                }
            } else {
                unscaledDirty = this.dirtyArea;
                imageSize = this.logicalRootSize;
                if (fullImage) {
                    unscaledDirty.setBounds(0, 0, imageSize.width, imageSize.height);
                } else {
                    paneGraphics.setClip(unscaledDirty);
                }
                paneGraphics.setFont(this.logicalRoot.getFont());
                this.logicalRoot.paint(paneGraphics);
                if (DEBUG_DISPLAY) {
                    this.componentImageDialog.setImg(this.componentBuffer);
                    this.componentImageDialog.repaintImg(this.dirtyArea);
                }
            }
            paneGraphics.dispose();
            scaleDirtyRectX = frameSize.getWidth() / imageSize.getWidth();
            scaleDirtyRectY = frameSize.getHeight() / imageSize.getHeight();
            Dimension outputSize = frameSize;
            scaleGraphicsX = frameSize.getWidth() * this.componentSize.getWidth() / (imageSize.getWidth() * imageSize.getWidth());
            scaleGraphicsY = frameSize.getHeight() * this.componentSize.getHeight() / (imageSize.getHeight() * imageSize.getHeight());
            if (scaleGraphicsX != 1.0 || scaleGraphicsY != 1.0) {
                if (scaleGraphicsX > scaleGraphicsY) {
                    scaleGraphics = scaleGraphicsY;
                    scaleDirtyRect = scaleDirtyRectY;
                } else {
                    scaleGraphics = scaleGraphicsX;
                    scaleDirtyRect = scaleDirtyRectX;
                }
                if (componentIsScalable) {
                    double dirtyScaleX = scalableComponent.getScaleFactorX();
                    double dirtyScaleY = scalableComponent.getScaleFactorY();
                    scaleDirtyRectX = scaleGraphics / dirtyScaleX;
                    scaleDirtyRectY = scaleGraphics / dirtyScaleY;
                }
            } else {
                scaleDirtyRect = 1.0;
            }
            if (scaleGraphics > 1.0 && !this.capture.allowUpscale()) {
                scaleGraphics = 1.0;
                scaleDirtyRect = 1.0;
                outputClipRect = unscaledDirty;
            } else {
                outputClipRect = ImageUtilities.getScaledRect((Rectangle)unscaledDirty, (double)scaleGraphics, (double)scaleGraphics);
            }
            if (this.outputImage == null || fullImage || outputSize.width > this.outputImage.getWidth() || outputSize.height > this.outputImage.getHeight()) {
                this.outputImage = new BufferedImage(outputSize.width, outputSize.height, 1);
                paneGraphics = this.outputImage.createGraphics();
                paneGraphics.setColor(CLEAR);
                paneGraphics.fillRect(0, 0, outputSize.width, outputSize.height);
                paneGraphics.dispose();
                this.updatePixels = null;
                outputClipRect.setBounds(0, 0, outputSize.width, outputSize.height);
            }
            if (outputClipRect.x < 0) {
                outputClipRect.x = 0;
            }
            if (outputClipRect.y < 0) {
                outputClipRect.y = 0;
            }
            if (outputClipRect.height > this.outputImage.getHeight()) {
                outputClipRect.height = this.outputImage.getHeight();
            }
            if (outputClipRect.width > this.outputImage.getWidth()) {
                outputClipRect.width = this.outputImage.getWidth();
            }
            paneGraphics = this.outputImage.createGraphics();
            paneGraphics.setClip(outputClipRect);
            if (scaleGraphics != 1.0) {
                paneGraphics.scale(scaleGraphics, scaleGraphics);
            }
            paneGraphics.setFont(this.logicalRoot.getFont());
            paneGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            paneGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            paneGraphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            paneGraphics.drawImage((Image)this.componentBuffer, 0, 0, null);
            if (DEBUG_DISPLAY) {
                this.outputImageDialog.setImg(this.outputImage);
            }
            Object object2 = this.lock;
            synchronized (object2) {
                this.manageCurrentImage(this.outputImage, outputClipRect, frameTime, outputSize, fullImage);
            }
            this.dirtyArea = null;
            this.dirtyLevel = Integer.MIN_VALUE;
        }
    }

    private void manageCurrentImage(BufferedImage updateImage, Rectangle rect, long frameTime, Dimension outputSize, boolean flushCache) {
        int outputSizeHeight = outputSize.height;
        int outputSizeWidth = outputSize.width;
        int captureImageHeight = outputSize.height;
        int captureImageWidth = outputSize.width;
        if (this.captureImage == null || flushCache || this.captureImage.getWidth() != outputSizeWidth || this.captureImage.getHeight() != outputSizeHeight) {
            Graphics2D paneGraphics;
            this.capturePixels = null;
            if (this.captureImage == null) {
                this.captureImage = new BufferedImage(outputSizeWidth, outputSizeHeight, 1);
                paneGraphics = this.captureImage.createGraphics();
                paneGraphics.setColor(CLEAR);
                paneGraphics.fillRect(0, 0, outputSizeWidth, outputSizeHeight);
                paneGraphics.setClip(0, 0, outputSizeWidth, outputSizeHeight);
                paneGraphics.drawImage(this.captureImage, 0, 0, captureImageWidth, captureImageHeight, null);
            } else {
                BufferedImage newImage = new BufferedImage(outputSizeWidth, outputSizeHeight, 1);
                paneGraphics = newImage.createGraphics();
                paneGraphics.setColor(CLEAR);
                paneGraphics.fillRect(0, 0, outputSizeWidth, outputSizeHeight);
                paneGraphics.setClip(0, 0, outputSizeWidth, outputSizeHeight);
                paneGraphics.drawImage(updateImage, rect.x, rect.y, rect.width, rect.height, null);
                this.captureImage = newImage;
            }
            paneGraphics.dispose();
            this.setNewSize(true);
            if (DEBUG_DISPLAY) {
                this.currentDialog.setImg(this.captureImage);
            }
            switch (this.encoding) {
                case 1: {
                    this.regenerateAllTilesLossless(this.captureImage, frameTime);
                    break;
                }
                case 0: {
                    break;
                }
            }
            return;
        }
        this.setNewSize(false);
        switch (this.encoding) {
            case 1: {
                this.generateChangedTilesLossless(this.captureImage, updateImage, rect, frameTime);
                break;
            }
            case 0: {
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateChangedTilesLossless(BufferedImage current, BufferedImage update, Rectangle rect, long frameTime) {
        CaptureTile[] tileArray;
        int currentHeight = current.getHeight();
        int currentWidth = current.getWidth();
        int currentPixelCount = currentHeight * currentWidth;
        int updateHeight = update.getHeight();
        int updateWidth = update.getWidth();
        int updatePixelCount = updateHeight * updateWidth;
        HashSet<Integer> tileNumberMap = new HashSet<Integer>();
        LinkedList<CaptureTile> changedTiles = new LinkedList<CaptureTile>();
        if (this.capturePixels == null || this.capturePixels.length < currentPixelCount) {
            this.capturePixels = new int[currentPixelCount];
            current.getRGB(0, 0, currentWidth, currentHeight, this.capturePixels, 0, currentWidth);
            this.updatePixels = null;
        }
        if (this.updatePixels == null || this.updatePixels.length < updatePixelCount) {
            this.updatePixels = new int[update.getWidth() * update.getHeight()];
        }
        rect = rect.intersection(new Rectangle(0, 0, updateWidth, updateHeight));
        update.getRGB(rect.x, rect.y, rect.width, rect.height, this.updatePixels, 0, update.getWidth());
        Object object = this.lock;
        synchronized (object) {
            for (int x = 0; x < rect.width && x < currentWidth; ++x) {
                for (int y = 0; y < rect.height && y < currentHeight; ++y) {
                    int currentIndex = rect.x + x + (rect.y + y) * currentWidth;
                    int updateIndex = x + y * update.getWidth();
                    if (currentIndex >= this.capturePixels.length || updateIndex >= this.updatePixels.length) {
                        System.err.println("index range: cur: " + currentIndex + ", len: " + this.capturePixels.length + ", update: " + updateIndex + ", len: " + this.updatePixels.length);
                    }
                    if (y >= rect.height || x >= rect.width || this.capturePixels[currentIndex] == this.updatePixels[updateIndex]) continue;
                    this.capturePixels[currentIndex] = this.updatePixels[updateIndex];
                    Integer tileNumber = new Integer(ImageUtilities.getTileNumberFromPixel((int)(x + rect.x), (int)(y + rect.y)));
                    if (tileNumberMap.contains(tileNumber)) continue;
                    tileNumberMap.add(tileNumber);
                    CaptureTile newTile = new CaptureTile(x + rect.x, y + rect.y, frameTime);
                    changedTiles.add(newTile);
                }
            }
            tileArray = new CaptureTile[changedTiles.size()];
            tileArray = changedTiles.toArray(tileArray);
        }
        if (DEBUG_DISPLAY) {
            this.currentDialog.setImg(currentWidth, currentHeight, this.capturePixels);
        }
        this.fillTilePixels(tileArray, this.capturePixels, currentWidth, currentHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void regenerateAllTilesLossless(BufferedImage current, long time) {
        this.tileCache.clear();
        int width = current.getWidth();
        int height = current.getHeight();
        if (this.capturePixels == null) {
            this.capturePixels = new int[width * height];
            current.getRGB(0, 0, width, height, this.capturePixels, 0, width);
            this.updatePixels = null;
            if (DEBUG_DISPLAY) {
                this.currentDialog.setImg(current);
            }
        }
        CaptureTile[] tileArray = new CaptureTile[(15 + width) / 16 * ((15 + height) / 16)];
        int tileIndex = 0;
        Object object = this.lock;
        synchronized (object) {
            for (int x = 0; x < width; x += 16) {
                for (int y = 0; y < height; y += 16) {
                    tileArray[tileIndex++] = new CaptureTile(x, y, time);
                }
            }
            this.fillTilePixels(tileArray, this.capturePixels, width, height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillTilePixels(CaptureTile[] changedTiles, int[] pixels, int width, int height) {
        try {
            Object object = this.lock;
            synchronized (object) {
                for (int i = 0; i < changedTiles.length; ++i) {
                    changedTiles[i].setTileData(pixels, width, height);
                    CaptureTileCache captureTileCache = this.tileCache;
                    synchronized (captureTileCache) {
                        this.tileCache.addCaptureTile(changedTiles[i]);
                        continue;
                    }
                }
            }
            this.capture.sendImageTiles(changedTiles);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayTiles(CaptureFeedSubscription subscription) {
        Object object = this.lock;
        synchronized (object) {
            Dimension outputSize = this.getOutputSize();
            subscription.setSizeChanged(outputSize);
            for (int x = 0; x <= outputSize.width; x += 16) {
                boolean emitted = false;
                for (int y = 0; y <= outputSize.height; y += 16) {
                    Integer tileNumber = new Integer(ImageUtilities.getTileNumberFromPixel((int)x, (int)y));
                    CaptureTileCache captureTileCache = this.tileCache;
                    synchronized (captureTileCache) {
                        if (!this.tileCache.contains(tileNumber)) {
                            break;
                        }
                        subscription.setTile(this.tileCache.getCaptureTile(tileNumber));
                        emitted = true;
                        continue;
                    }
                }
                if (!emitted) break;
            }
        }
        subscription.requestRepaint(true);
        subscription.startOutput();
    }

    private void resized(ComponentEvent e) {
        this.paintDirtyComponents();
    }

    public byte getEncoding() {
        return this.encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CaptureTile getCaptureTile(Integer tileNumber) {
        CaptureTileCache captureTileCache = this.tileCache;
        synchronized (captureTileCache) {
            return this.tileCache.getCaptureTile(tileNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getCaptureTileSet(Integer crc) {
        CaptureTileCache captureTileCache = this.tileCache;
        synchronized (captureTileCache) {
            return this.tileCache.getCaptureTileSet(crc);
        }
    }

    public Dimension getSize() {
        Dimension outputSize = this.getOutputSize();
        if (outputSize.width <= 0 || outputSize.height <= 0) {
            return MIN_DIMENSION;
        }
        return new Dimension(outputSize);
    }

    public void setEncoding(byte encoding) {
        if (this.componentBuffer != null) {
            throw new RuntimeException("Cannot set image encoding after LogicalImageRoot has started.");
        }
        this.encoding = encoding;
    }

    private void setNewSize(boolean force) {
        Dimension outputSize = this.getOutputSize();
        if (force || this.captureImage == null || outputSize.getWidth() != (double)this.lastSize.width || outputSize.getHeight() != (double)this.lastSize.height) {
            this.lastSize = new Dimension(outputSize);
            this.capture.setSizeChanged(this.lastSize);
        }
    }

    private static Frame getFrame(Container container) {
        if (container instanceof Frame) {
            return (Frame)container;
        }
        if (container != null) {
            return CaptureLogicalImageRootImpl.getFrame(container.getParent());
        }
        return null;
    }

    class ImageDialog
    extends JDialog {
        private static final long serialVersionUID = 4519139519717332987L;
        Image img;
        JPanel displayPanel;
        JLabel label;

        public ImageDialog(Frame c, String title) {
            super(c, title);
            this.img = null;
            this.displayPanel = new JPanel(){
                private static final long serialVersionUID = -3133356348121157909L;

                @Override
                public void paint(Graphics g) {
                    if (ImageDialog.this.img != null) {
                        g.drawImage(ImageDialog.this.img, 0, 0, null);
                        if (SHOW_REPAINT) {
                            Rectangle clip = g.getClipBounds();
                            g.setClip(0, 0, this.getWidth(), this.getHeight());
                            g.drawRect(clip.x - 1, clip.y - 1, clip.width + 2, clip.height + 2);
                        }
                    }
                }
            };
            this.label = new JLabel();
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.displayPanel, "South");
            this.getContentPane().add((Component)this.label, "North");
        }

        public ImageDialog(Container container, String title) {
            this(CaptureLogicalImageRootImpl.getFrame(container), title);
        }

        public void repaintImg(int x, int y, int w, int h) {
            this.displayPanel.repaint(x, y, w, h);
        }

        public void repaintImg(Rectangle rect) {
            this.displayPanel.repaint(rect.x, rect.y, rect.width, rect.height);
        }

        public Container getDisplay() {
            return this.displayPanel;
        }

        public void setImg(int width, int height, int[] pixels) {
            BufferedImage debugImage = new BufferedImage(width, height, 1);
            debugImage.setRGB(0, 0, width, height, pixels, 0, width);
            this.setImg(debugImage);
        }

        public void setImg(Image img) {
            this.img = img;
            if (img != null) {
                SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Dimension newSize = new Dimension(ImageDialog.this.img.getWidth(null), ImageDialog.this.img.getHeight(null));
                        if (ImageDialog.this.img != null) {
                            ImageDialog.this.label.setText("Image: (" + ImageDialog.this.img.getWidth(null) + ", " + ImageDialog.this.img.getHeight(null) + ")");
                        } else {
                            ImageDialog.this.label.setText("Null Image");
                        }
                        ImageDialog.this.displayPanel.setPreferredSize(newSize);
                        ImageDialog.this.pack();
                        ImageDialog.this.repaint();
                    }
                });
            }
        }
    }
}

