/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.client.messaging;

import com.elluminate.classroom.client.messaging.ListenerMap;
import com.elluminate.classroom.client.messaging.Message;
import com.elluminate.classroom.client.messaging.MessageListener;
import com.elluminate.classroom.client.messaging.MessagePublisher;
import com.elluminate.classroom.client.messaging.MessagePublisherMetadata;
import com.elluminate.classroom.client.messaging.MessageRouter;
import com.elluminate.classroom.client.messaging.MessageType;
import com.elluminate.util.event.FiringFunctor;
import com.elluminate.util.event.ListenerRegistry;
import com.elluminate.util.event.ThrowableListener;
import com.elluminate.util.log.Logger;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;

@Singleton
public class MessageRouterImpl
implements MessageRouter {
    private volatile long messagesSent = 0L;
    private long messagesReceived = 0L;
    private Logger logger;
    private ListenerRegistry<MessagePublisherMetadata> publishers;
    private ListenerMap listenerTypeMap = new ListenerMap();
    private ListenerRegistry<MessageListener> masterListenerList;

    @Inject
    public MessageRouterImpl(Logger logger, ThrowableListener errorHandler) {
        this.logger = logger;
        this.masterListenerList = new ListenerRegistry(errorHandler);
        this.publishers = new ListenerRegistry(errorHandler);
    }

    @Override
    public void registerPublisher(MessagePublisher publisher) {
        if (publisher == null) {
            return;
        }
        final MessagePublisherMetadata publisherInfo = publisher.getMessagePublisherMetadata();
        this.publishers.add((Object)publisherInfo);
        this.masterListenerList.fire((FiringFunctor)new FiringFunctor<MessageListener>(){

            public void fire(MessageListener listener) {
                listener.newPublisherAvailable(publisherInfo);
            }
        });
    }

    @Override
    public void registerListener(MessageListener listener) {
        if (listener == null) {
            return;
        }
        this.addListenerToMaster(listener);
        for (MessagePublisherMetadata publisherInfo : this.publishers) {
            listener.newPublisherAvailable(publisherInfo);
        }
    }

    @Override
    public void addListener(MessageListener listener, List<MessageType> types) {
        if (listener != null) {
            this.addListenerToMaster(listener);
            this.listenerTypeMap.addListener(listener, types);
        }
    }

    @Override
    public void addListener(MessageListener listener) {
        if (listener == null) {
            return;
        }
        this.addListenerToMaster(listener);
        for (MessagePublisherMetadata publisherInfo : this.publishers) {
            this.listenerTypeMap.addListener(listener, publisherInfo.getMessageTypes());
        }
    }

    @Override
    public void removeListener(MessageListener listener) {
        this.listenerTypeMap.removeListener(listener);
    }

    @Override
    public void removeListener(MessageListener listener, List<MessageType> types) {
        this.listenerTypeMap.removeListenerFromType(listener, types);
    }

    @Override
    public void permanentlyRemoveListener(MessageListener listener) {
        if (listener == null) {
            return;
        }
        this.listenerTypeMap.removeListener(listener);
        this.masterListenerList.remove((Object)listener);
    }

    @Override
    public void send(Message msg) {
        if (msg == null) {
            return;
        }
        ++this.messagesReceived;
        int count = this.listenerTypeMap.fireReceiveMessage(msg);
        this.messagesSent += (long)count;
    }

    private void addListenerToMaster(MessageListener listener) {
        if (listener == null) {
            return;
        }
        this.masterListenerList.add((Object)listener);
    }

    public String toString() {
        String reply = "";
        reply = reply + "messages sent[" + this.messagesSent + "]\n";
        reply = reply + "messages received[" + this.messagesReceived + "]\n";
        reply = reply + "registered publishers[" + this.publishers.size() + "]\n";
        for (MessagePublisherMetadata metadata : this.publishers) {
            reply = reply + "   -[" + metadata.getPublisherDisplayName() + "]\n";
        }
        reply = reply + "registered listeners[" + this.masterListenerList.size() + "]\n";
        final StringBuilder listenerDump = new StringBuilder();
        this.masterListenerList.fire((FiringFunctor)new FiringFunctor<MessageListener>(){

            public void fire(MessageListener listener) {
                listenerDump.append("   -[").append(listener.getClass().getName()).append("]\n");
            }
        });
        return reply + listenerDump;
    }

    protected long getListenerCount() {
        return this.masterListenerList.size();
    }

    protected long getPublisherCount() {
        return this.publishers.size();
    }

    protected long getMessageSentCount() {
        return this.messagesSent;
    }

    protected long getMessageReceivedCount() {
        return this.messagesReceived;
    }
}

