/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.client.app;

import com.elluminate.classroom.client.app.Application;
import com.elluminate.classroom.client.app.StringsProperties;
import com.elluminate.gui.component.EasyDialog;
import com.elluminate.gui.component.MultilineLabel;
import com.elluminate.util.Debug;
import com.elluminate.util.DebugFlag;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.browser.BrowserUtil;
import com.elluminate.util.log.ExTRASupport;
import com.elluminate.util.log.LogSupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class BadCacheExceptionFilter
extends ExTRASupport.ExceptionFilter {
    private static final String[] SECURITY_MSGS = new String[]{"SHA1 digest error", "signer information does not match signer information of other classes in the same package", "no manifiest section for signature file entry", "cannot verify signature block file"};
    private static final String[] CACHED_PACKAGES = new String[]{"com/elluminate/", "com/sun/jimi/", "com/google/inject/", "org/jdom/", "com/lowagie/"};
    private static final I18n i18n = I18n.create(BadCacheExceptionFilter.class);
    private Application vclass = null;
    private String appName = null;
    private String infoURL = null;

    public BadCacheExceptionFilter(Application app, String name) {
        this.vclass = app;
        this.appName = name;
    }

    public void setInfoURL(String url) {
        this.infoURL = url;
    }

    public String getInfoURL() {
        return this.infoURL;
    }

    public boolean checkException(Throwable t) {
        String msg = t.getMessage();
        if (t instanceof NoClassDefFoundError) {
            if (this.checkCachedPackage(msg)) {
                return true;
            }
        } else if (t instanceof ClassNotFoundException) {
            if (this.checkCachedPackage(msg)) {
                return true;
            }
        } else if (t instanceof ClassFormatError) {
            if (this.checkCachedPackage(msg)) {
                return true;
            }
        } else if (t instanceof SecurityException) {
            for (String secMsg : SECURITY_MSGS) {
                if (msg.indexOf(secMsg) < 0) continue;
                return true;
            }
        } else if (t instanceof TestException) {
            return true;
        }
        return false;
    }

    private boolean checkCachedPackage(String s) {
        for (String pkg : CACHED_PACKAGES) {
            if (s.indexOf(pkg) > 0) {
                return true;
            }
            if (s.indexOf(pkg = pkg.replace('/', '.')) <= 0) continue;
            return true;
        }
        return false;
    }

    public void processException(String where, Throwable t, String msg) {
        super.reportException(where, t, msg);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Component win = null;
                ReportDialog dlg = new ReportDialog(win, BadCacheExceptionFilter.this.infoURL);
                dlg.pack();
                dlg.show();
            }
        };
        SwingRunnerSupport.invokeLater((Runnable)r);
    }

    static {
        DebugFlag cacheFlag = DebugFlag.get((String)"ExTRA.JWSCacheTest");
        class DebugChangeListener
        implements PropertyChangeListener {
            final /* synthetic */ DebugFlag val$cacheFlag;

            DebugChangeListener(DebugFlag debugFlag) {
                this.val$cacheFlag = debugFlag;
            }

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (!this.val$cacheFlag.isEnabled()) {
                    return;
                }
                final TestException t = new TestException();
                Thread reporter = new Thread("JWSCacheException Test Thread"){

                    @Override
                    public void run() {
                        LogSupport.exception((Object)this, (String)"propertyChange", (Throwable)t, (boolean)false);
                        val$cacheFlag.setEnabled(false);
                    }
                };
                reporter.start();
            }
        }
        cacheFlag.addPropertyChangeListener("debugEnabled", (PropertyChangeListener)new DebugChangeListener(cacheFlag));
    }

    private class ReportDialog
    extends EasyDialog {
        private JButton quitBtn;
        private JButton ignoreBtn;
        private JButton infoBtn;
        private JPanel content;
        private JLabel icon;
        private MultilineLabel contentText;

        ReportDialog(Component parent, String url) {
            super(parent, i18n.getString((PropertiesEnum)StringsProperties.BADCACHE_DIALOGTITLE));
            this.quitBtn = this.makeButton(i18n.getString((PropertiesEnum)StringsProperties.BADCACHE_QUITBTN));
            this.ignoreBtn = this.makeButton(i18n.getString((PropertiesEnum)StringsProperties.BADCACHE_IGNOREBTN));
            this.infoBtn = new JButton();
            this.content = new JPanel(new BorderLayout(16, 16));
            this.icon = new JLabel();
            this.contentText = new MultilineLabel();
            final String infoURL = url != null && url.length() > 0 ? url : i18n.getString((PropertiesEnum)StringsProperties.BADCACHE_MOREINFOURL);
            String name = BadCacheExceptionFilter.this.appName;
            if (name == null) {
                name = i18n.getString((PropertiesEnum)StringsProperties.BADCACHE_DFTAPPNAME);
            }
            String msgText = i18n.getString((PropertiesEnum)StringsProperties.BADCACHE_CONTENTMSG, new Object[]{name});
            this.contentText.setText(msgText);
            this.icon.setIcon(UIManager.getIcon("OptionPane.errorIcon"));
            this.icon.setVerticalAlignment(1);
            this.content.add((Component)this.contentText, "Center");
            this.content.add((Component)this.icon, "West");
            ActionListener infoHandler = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    try {
                        BrowserUtil.gotoURL((String)infoURL);
                    }
                    catch (Throwable t) {
                        LogSupport.message((Object)this, (String)"actionPerformed", (String)("Failed to open URL " + infoURL + ": " + Debug.getStackTrace((Throwable)t)));
                    }
                }
            };
            this.infoBtn.addActionListener(infoHandler);
            this.infoBtn.setText(i18n.getString((PropertiesEnum)StringsProperties.BADCACHE_MOREINFOBTN));
            this.infoBtn.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.BADCACHE_MOREINFOTIP));
            ActionListener quitHandler = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    try {
                        BadCacheExceptionFilter.this.vclass.doShutdown();
                    }
                    catch (Throwable t) {
                        LogSupport.message((Object)this, (String)"actionPerformed", (String)("Failed to open URL " + infoURL + ": " + Debug.getStackTrace((Throwable)t)));
                    }
                }
            };
            this.quitBtn.addActionListener(quitHandler);
            this.quitBtn.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.BADCACHE_QUITTIP, new Object[]{name}));
            this.ignoreBtn.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.BADCACHE_IGNORETIP, new Object[]{name}));
            this.setContent(this.content);
            this.addActionButton(this.ignoreBtn, true);
            this.addAlternateActionButton(this.quitBtn);
            this.addPassiveComponent(this.infoBtn);
        }
    }

    private static class TestException
    extends RuntimeException {
        private TestException() {
        }
    }
}

