/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.client.app;

import com.elluminate.classroom.client.ApplicationUIProxy;
import com.elluminate.classroom.client.BrandingI18nProvider;
import com.elluminate.classroom.client.BrandingI18nProviderImpl;
import com.elluminate.classroom.client.app.AllowConnectionWhenStartExitsListener;
import com.elluminate.classroom.client.app.AppDebug;
import com.elluminate.classroom.client.app.BadCacheExceptionFilter;
import com.elluminate.classroom.client.app.ExtraPrefsPanel;
import com.elluminate.classroom.client.app.StringsProperties;
import com.elluminate.classroom.moduleloading.LoadingStatus;
import com.elluminate.classroom.moduleloading.LoadingStatusListener;
import com.elluminate.classroom.swing.SwingApplicationUI;
import com.elluminate.contentcapture.ContentCaptureProvider;
import com.elluminate.extra.ExTRA;
import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.ActionFeatureEvent;
import com.elluminate.framework.feature.ActionFeatureListener;
import com.elluminate.framework.feature.ComponentFeature;
import com.elluminate.framework.feature.ComponentProvider;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.framework.imps.Imps;
import com.elluminate.framework.moduleloading.ModuleContainer;
import com.elluminate.framework.moduleloading.ModuleFunctor;
import com.elluminate.framework.moduleloading.ProgressEvent;
import com.elluminate.framework.moduleloading.ProgressListener;
import com.elluminate.framework.moduleloading.locator.ClassPathModuleLocator;
import com.elluminate.framework.moduleloading.states.ModulesState;
import com.elluminate.framework.moduleloading.states.ModulesStateListener;
import com.elluminate.groupware.ChairProtocol;
import com.elluminate.groupware.imps.QuitQueryAPI;
import com.elluminate.groupware.module.ClientModule;
import com.elluminate.gui.FontUtils;
import com.elluminate.gui.GuiUtils;
import com.elluminate.jinx.provider.ConnectionProvider;
import com.elluminate.platform.Platform;
import com.elluminate.util.ApplicationProperties;
import com.elluminate.util.DebugFlag;
import com.elluminate.util.ExceptionHandler;
import com.elluminate.util.I18n;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.TimerResolution;
import com.elluminate.util.TuningParamReader;
import com.elluminate.util.UnknownTuningParamException;
import com.elluminate.util.VersionManager;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.log.ExTRASupport;
import com.elluminate.util.log.LogSupport;
import com.elluminate.util.log.Logger;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.swing.ImageIcon;

@Singleton
public class Application
extends WorkerThread {
    public static final String PREF_DIR_NAME = "Blackboard";
    public static final String DFT_PREF_NAME = "Collaborate.preferences";
    public static final String TRACE_ARG = "trace";
    public static final String LOG_ARG = "log";
    public static final String MULTIMEDIA_ARG = "multimedia";
    public static final String TUNING_ARG = "tuning";
    public static final String SESSION_ARG = "session";
    public static final String ONLINE_SESSION = "online";
    public static final String PLAYER_SESSION = "player";
    private static final String UNLOAD_ARG = "unload";
    private ClassPathModuleLocator<ClientModule> locator;
    private ModuleContainer<ClientModule> modules;
    private Logger logger;
    private Preferences prefs;
    private BrandingI18nProviderImpl brandingProvider;
    private Imps imps;
    private VersionManager versionMgr;
    private ComponentFeature extraPrefsFeature;
    private ApplicationProperties appProps;
    private ContentCaptureProvider contentCaptureProvider;
    private LoadingStatus loadingStatus;
    private Provider<ApplicationUIProxy> uiProv;
    private Provider<FeatureBroker> brokerProv;
    private Provider<ExtraPrefsPanel> extraPrefsProv;
    private AllowConnectionWhenStartExitsListener startExitListener;
    private boolean shuttingDown = false;
    private Object wsfix;
    LoadingStatusListener readyStateListener = new AppLoadingStatusListener();

    @Inject
    public Application(Logger logger, VersionManager vmgr) {
        this.logger = logger;
        this.versionMgr = vmgr;
    }

    @Inject
    void initImps(Imps imps) {
        this.imps = imps;
    }

    @Inject
    void initBrandingProvider(BrandingI18nProviderImpl prov) {
        this.brandingProvider = prov;
    }

    @Inject
    void initLoadingStatus(LoadingStatus status) {
        this.loadingStatus = status;
    }

    @Inject
    void initContentCapture(ContentCaptureProvider prov) {
        this.contentCaptureProvider = prov;
    }

    @Inject
    void initConnectionProvider(ConnectionProvider prov) {
        this.versionMgr.registerComponent((Object)prov);
    }

    @Inject
    void initAppProps(ApplicationProperties props) {
        this.appProps = props;
    }

    @Inject
    void initUIProvider(Provider<ApplicationUIProxy> prov) {
        this.uiProv = prov;
    }

    @Inject
    void initLocator(ClassPathModuleLocator<ClientModule> locator) {
        this.locator = locator;
    }

    @Inject
    void initModules(ModuleContainer<ClientModule> modules) {
        this.modules = modules;
    }

    @Inject
    void initPrefs(Preferences prefs) {
        this.prefs = prefs;
    }

    @Inject
    void initBroker(Provider<FeatureBroker> prov) {
        this.brokerProv = prov;
    }

    @Inject
    void initExtraPrefs(Provider<ExtraPrefsPanel> prov) {
        this.extraPrefsProv = prov;
    }

    @Inject
    void initStartExitListener(AllowConnectionWhenStartExitsListener lst) {
        this.startExitListener = lst;
    }

    public void init(String[] args, I18n brandedI18n) {
        block6: {
            this.brandingProvider.init(brandedI18n);
            Application.checkLocale(args);
            try {
                System.setSecurityManager(null);
            }
            catch (Throwable t) {
                // empty catch block
            }
            new WorkerThread(){

                public void run() {
                    TimerResolution.compute();
                }
            }.start();
            Date now = new Date();
            String zoneid = System.getProperty("user.timezone");
            TimeZone dftZone = TimeZone.getDefault();
            boolean dftDST = dftZone.inDaylightTime(now);
            if (zoneid != null && !zoneid.trim().equals("")) {
                TimeZone propZone = TimeZone.getTimeZone(zoneid);
                boolean propDST = propZone.inDaylightTime(now);
                if (!TimeZone.getDefault().equals(TimeZone.getTimeZone(zoneid))) {
                    this.logger.error((Object)this, "<init>", "Wrong time zone! Changing from " + dftZone.getDisplayName(dftDST, 0) + " to " + propZone.getDisplayName(propDST, 0));
                    TimeZone.setDefault(propZone);
                    dftZone = propZone;
                    dftDST = propDST;
                }
            }
            this.logger.message("TimeZone = " + dftZone.getDisplayName(dftDST, 0));
            this.versionMgr.registerComponent((Object)this.logger);
            this.initExtraSystem(brandedI18n, args);
            this.populateArguments(args);
            try {
                Class<?> wsfixCls = Class.forName("com.elluminate.wsfix.WSFix");
                Constructor<?> wsfixInit = wsfixCls.getConstructor(Boolean.TYPE);
                this.wsfix = wsfixInit.newInstance(AppDebug.WSFIX_VERBOSE.show());
            }
            catch (Throwable t) {
                if (!AppDebug.WSFIX_VERBOSE.show()) break block6;
                this.logger.message((Object)this, "init", "Failed to instantiate wsfix - " + t);
            }
        }
        this.versionMgr.registerComponent(ChairProtocol.class);
    }

    private void populateArguments(String[] args) {
        String currentKey = null;
        for (String arg : args) {
            if (arg.equals("placeholder")) continue;
            if (arg.startsWith("-")) {
                if (arg.length() <= 1) continue;
                currentKey = arg.substring(arg.indexOf("-") + 1);
                this.appProps.put(currentKey, new ArrayList());
                continue;
            }
            if (currentKey == null || currentKey.equals("")) continue;
            this.appProps.addValue(currentKey, arg);
        }
        if (this.appProps.containsKey(LOG_ARG)) {
            List logfile = this.appProps.get(LOG_ARG);
            if (logfile.size() > 1) {
                LogSupport.error((String)"Too many log files specified.");
                ExTRA.exit((int)1);
            } else {
                try {
                    LogSupport.setLogFile((File)new File((String)logfile.get(0)));
                }
                catch (IOException iox) {
                    LogSupport.error((String)("Unable to set log file '" + (String)logfile.get(0) + "' - " + iox.getMessage()));
                }
            }
        }
        if (this.appProps.containsKey(TRACE_ARG)) {
            List flags = this.appProps.get(TRACE_ARG);
            for (String flag : flags) {
                DebugFlag.get((String)flag).setEnabled(true);
            }
        }
        this.contentCaptureProvider.init();
    }

    public void run() {
        this.loadPrefs();
        this.setTuningParams();
        ApplicationUIProxy ui = (ApplicationUIProxy)this.uiProv.get();
        this.versionMgr.registerComponent((Object)ui);
        ui.applicationStarting();
        this.loadingStatus.increment();
        this.loadModules();
        this.registerFeatures();
        ui.applicationRunning();
        this.logUnreadApplicationProperties();
        this.loadingStatus.decrement();
    }

    private void logUnreadApplicationProperties() {
        Iterator it = this.appProps.getUnreadKeys().iterator();
        while (it.hasNext()) {
            this.logger.error((String)it.next() + " application property was not read by any module");
        }
    }

    private void loadModules() {
        I18n branding = this.brandingProvider.get();
        this.locator.appendPropertiesLocation(branding.getString((PropertiesEnum)BrandingI18nProvider.Values.MODULE_LOADING_PROPS_FILE));
        List session = this.appProps.get(SESSION_ARG);
        if (session == null || session.isEmpty()) {
            this.locator.appendPropertiesLocation(branding.getString((PropertiesEnum)BrandingI18nProvider.Values.ONLINE_MODULE_PROPS_FILE));
        } else if (((String)session.get(0)).equalsIgnoreCase(PLAYER_SESSION)) {
            this.locator.appendPropertiesLocation(branding.getString((PropertiesEnum)BrandingI18nProvider.Values.PLAYER_MODULE_PROPS_FILE));
        } else if (((String)session.get(0)).equalsIgnoreCase(ONLINE_SESSION)) {
            this.locator.appendPropertiesLocation(branding.getString((PropertiesEnum)BrandingI18nProvider.Values.ONLINE_MODULE_PROPS_FILE));
        } else {
            throw new IllegalArgumentException("Argument for session [" + (String)session.get(0) + "] was not recognized");
        }
        if (this.appProps.containsKey(UNLOAD_ARG)) {
            List unloads = this.appProps.get(UNLOAD_ARG);
            if (unloads.size() > 1) {
                LogSupport.error((String)"Too many unload specifications.");
                ExTRA.exit((int)1);
            } else {
                String[] notloadedModules = ((String)unloads.get(0)).split(",");
                this.locator.noteNotloadedModules(notloadedModules);
            }
        }
        this.modules.addLoadFunctor("setupUI", (ModuleFunctor)new ClientModule.SetupUIFunctor());
        this.modules.addUnloadFunctor("cleanupUI", (ModuleFunctor)new ClientModule.CleanupUIFunctor());
        this.modules.addLoadFunctor("sessionStart", (ModuleFunctor)new ClientModule.SessionStartFunctor());
        this.modules.addUnloadFunctor("sessionStop", (ModuleFunctor)new ClientModule.SessionStopFunctor());
        this.modules.addStateListener((ModulesStateListener)this.startExitListener);
        this.modules.addProgressListener(new ProgressListener(){
            ApplicationUIProxy ui;
            {
                this.ui = (ApplicationUIProxy)Application.this.uiProv.get();
            }

            public void progressUpdated(ProgressEvent e) {
                int step = e.getProgress();
                int max = e.getProgressSrc().getMax();
                String desc = e.getProgressDescription();
                this.ui.applicationLoading(step, max, desc);
            }
        });
        ModulesStateListener stateListener = new ModulesStateListener(){
            private final ModulesState STATE_START = this.getState("start");
            private final ModulesState STATE_ATTACH = this.getState("attach");
            private final ModulesState STATE_DETACH = this.getState("detach");
            private final ModulesState STATE_STOP = this.getState("stop");
            private ApplicationUIProxy ui = (ApplicationUIProxy)Application.access$000(Application.this).get();

            private ModulesState getState(String name) {
                ModulesState result = Application.this.modules.getState(name, ModulesState.Status.ENTERING);
                if (result == null) {
                    throw new RuntimeException("Failed to get " + name + " state constant");
                }
                return result;
            }

            public void moduleStateChanged(ModulesState state) {
                if (this.STATE_START.equals((Object)state)) {
                    this.ui.start();
                } else if (this.STATE_ATTACH.equals((Object)state)) {
                    this.ui.attach();
                } else if (this.STATE_DETACH.equals((Object)state)) {
                    this.ui.detach();
                } else if (this.STATE_STOP.equals((Object)state)) {
                    this.ui.stop();
                }
            }
        };
        this.modules.addStateListener(stateListener);
        this.modules.loadModules(this.locator);
        ExTRA.setApplication((String)this.versionMgr.getProductName(), (String)this.versionMgr.getVersions());
    }

    private void registerFeatures() {
        FeatureBroker broker = (FeatureBroker)this.brokerProv.get();
        I18n i18n = I18n.create((Object)((Object)this));
        ActionFeature exitFeature = broker.createActionFeature((Object)this, "/classroom/exit", i18n.getString((PropertiesEnum)StringsProperties.MENUS_FILE_EXIT), i18n.getString((PropertiesEnum)StringsProperties.MENUS_FILE_EXIT_DESC));
        exitFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                Application.this.doShutdownQuery();
            }
        });
        exitFeature.setEnabled(true);
        broker.addFeature((Feature)exitFeature);
        if (ExTRA.isInitialized()) {
            this.extraPrefsFeature = broker.createComponentFeature((Object)this, "/classroom/extraPrefs", new ComponentProvider(){

                public Component get(ComponentFeature feature) {
                    ExtraPrefsPanel panel = (ExtraPrefsPanel)((Object)Application.this.extraPrefsProv.get());
                    return panel;
                }
            }, "", "");
            broker.addFeature((Feature)this.extraPrefsFeature);
        }
    }

    private void doShutdownQuery() {
        List quitQueryAPIs = this.imps.findAll(QuitQueryAPI.class);
        for (QuitQueryAPI query : quitQueryAPIs) {
            if (query.canQuit()) continue;
            return;
        }
        ApplicationUIProxy ui = (ApplicationUIProxy)this.uiProv.get();
        if (!ui.quitApplicationRequested()) {
            return;
        }
        this.doShutdown();
    }

    public void doShutdown() {
        if (this.shuttingDown) {
            return;
        }
        this.shuttingDown = true;
        ApplicationUIProxy ui = (ApplicationUIProxy)this.uiProv.get();
        ui.applicationQuitting();
        new Thread("Shutdown thread"){

            @Override
            public void run() {
                Application.this.loadingStatus.increment();
                if (!AppDebug.EXIT_EXTRA_ENABLED.show()) {
                    ExTRA.shuttingDown();
                }
                Application.this.modules.unloadModules();
                Application.this.loadingStatus.decrement();
                if (Application.this.loadingStatus.isReady()) {
                    Application.this.readyStateListener.onStatusChange(null, null);
                } else {
                    Application.this.loadingStatus.addListener(Application.this.readyStateListener);
                }
            }
        }.start();
    }

    private void setTuningParams() {
        try {
            this.prefs.updateTuningParameters();
        }
        catch (Throwable t) {
            this.logger.exception((Object)this, "loadPrefs", t, true);
        }
        if (this.appProps.containsKey(TUNING_ARG)) {
            for (String param : this.appProps.get(TUNING_ARG)) {
                try {
                    TuningParamReader.read((String)param);
                }
                catch (UnknownTuningParamException e) {
                    this.logger.error((Object)this, "run", e.getMessage());
                }
            }
        }
    }

    private void loadPrefs() {
        this.prefs.setFile(this.getPreferencesFile(false));
        try {
            if (this.contentCaptureProvider.get().isEchoingData()) {
                this.prefs.load();
            }
        }
        catch (IOException iox) {
            this.logger.exception((Object)this, "loadPrefs", (Throwable)iox, false, "Error while loading preferences.");
        }
    }

    private void savePrefs() {
        try {
            if (this.contentCaptureProvider.get().isEchoingData()) {
                File preferencesFile = this.getPreferencesFile();
                if (!preferencesFile.getParentFile().exists()) {
                    preferencesFile.getParentFile().mkdirs();
                }
                this.prefs.setFile(preferencesFile);
                this.prefs.save();
            }
        }
        catch (IOException iox) {
            this.logger.exception((Object)this, "savePrefs", (Throwable)iox, false, "Error while saving preferences.");
        }
    }

    public File getPreferencesDir() {
        return this.getPreferencesDir(true);
    }

    public File getPreferencesDir(boolean allowCreateDir) {
        File dir = new File(Platform.getPreferencesDir(), Platform.cleanFilename((String)PREF_DIR_NAME, (boolean)false));
        if (!dir.exists() && allowCreateDir) {
            dir.mkdirs();
        }
        return dir;
    }

    private File getPreferencesFile() {
        return this.getPreferencesFile(true);
    }

    private File getPreferencesFile(boolean allowCreateDir) {
        String filename;
        File dir = this.getPreferencesDir(allowCreateDir);
        try {
            filename = this.brandingProvider.get().getStringLegacy("Collaborate.settings");
        }
        catch (Throwable t) {
            filename = DFT_PREF_NAME;
        }
        filename = Platform.cleanFilename((String)filename, (boolean)true);
        return new File(dir, filename);
    }

    private void initExtraSystem(I18n brandedI18n, String[] args) {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ExceptionHandler());
        URL extraURL = null;
        try {
            extraURL = new URL(brandedI18n.getStringLegacy("Collaborate.ExTRA_URL"));
        }
        catch (Exception ex) {
            this.logger.exception(null, "launch", (Throwable)ex, false);
        }
        String appName = brandedI18n.getString((PropertiesEnum)BrandingI18nProvider.Values.APP_NAME);
        try {
            ExTRA.setPropertyFilePath((String)(Platform.getPreferencesDir().getCanonicalPath() + File.separator + PREF_DIR_NAME));
            ExTRA.setPropertyFileName((String)Platform.cleanFilename((String)"ExTRA.properties", (boolean)true));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ExTRA.init((Object)((Object)this), (URL)extraURL, (String)appName);
        ExTRA.addHeirarchy((String)"com.elluminate");
        ExTRA.addIgnored((String)"com.elluminate.groupware.module.contentcapture.SwingCaptureFrame.paint");
        ExTRA.setMessageResource((String)brandedI18n.getStringLegacy("Collaborate.ExTRAmessage"));
        ExTRA.setIcon((ImageIcon)brandedI18n.getIcon((PropertiesEnum)BrandingI18nProvider.Values.COLLABORATE_SYS_ICON));
        String appVer = this.versionMgr.getProductName() + " " + this.versionMgr.getProductVer();
        ExTRA.setApplication((String)appVer, (String)appVer);
        ExTRA.setField((String)"edition", (String)brandedI18n.getString((PropertiesEnum)BrandingI18nProvider.Values.EDITION_NAME));
        StringBuffer cmdLine = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            cmdLine.append(args[i]);
            cmdLine.append("\n");
        }
        ExTRA.setField((String)"args", (String)cmdLine.toString());
        ExTRA.setField((String)"jre", (String)Platform.getJavaInfo());
        ExTRA.setField((String)"os", (String)(Platform.getOSName() + " " + Platform.getVersionString() + " " + Platform.getArchName()));
        BadCacheExceptionFilter badCacheFilter = new BadCacheExceptionFilter(this, appName);
        try {
            String infoURL = brandedI18n.getStringLegacy("Collaborate.clearJavaCacheInfoURL");
            if (infoURL != null && infoURL.trim().length() > 0) {
                badCacheFilter.setInfoURL(infoURL);
            }
        }
        catch (Throwable ignored) {
            // empty catch block
        }
        ExTRASupport.addExceptionFilter((ExTRASupport.ExceptionFilter)badCacheFilter);
    }

    protected static void checkLocale(String[] args) {
        LinkedList<String> arglist = new LinkedList<String>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-locale")) {
                String value;
                String lang = "";
                String country = "";
                String variant = "";
                try {
                    value = args[++i];
                }
                catch (IndexOutOfBoundsException oobx) {
                    arglist.add(arg);
                    continue;
                }
                StringTokenizer parser = new StringTokenizer(value, "_");
                try {
                    lang = parser.nextToken();
                    country = parser.nextToken();
                    variant = parser.nextToken();
                }
                catch (NoSuchElementException nsx) {
                    // empty catch block
                }
                if (lang == null) continue;
                Locale.setDefault(new Locale(lang, country, variant));
                continue;
            }
            arglist.add(arg);
        }
    }

    static {
        WorkerThread.setDefaultThreadGroup((ThreadGroup)Thread.currentThread().getThreadGroup());
        Runnable swingInitializer = new Runnable(){

            @Override
            public void run() {
                SwingApplicationUI.preInitialize();
                GuiUtils.initialize();
                FontUtils.initialize();
            }
        };
        try {
            SwingRunnerSupport.invokeAndWait((Runnable)swingInitializer);
        }
        catch (InterruptedException intx) {
            throw new RuntimeException("Initialization interrupted", intx);
        }
    }

    private class AppLoadingStatusListener
    implements LoadingStatusListener {
        private AppLoadingStatusListener() {
        }

        public void onStatusChange(LoadingStatus statusSource, String entityName) {
            Application.this.loadingStatus.removeListener(Application.this.readyStateListener);
            Application.this.savePrefs();
            ExTRA.exit((int)0);
        }
    }
}

