/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx.client;

import com.elluminate.jinx.client.DirectCaller;
import com.elluminate.jinx.client.StringsProperties;
import com.elluminate.net.Endpoint;
import com.elluminate.net.EndpointCaller;
import com.elluminate.net.EndpointSecurity;
import com.elluminate.net.SSLTargetQuery;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.net.ProxyUtils;
import java.io.IOException;

public class ProxyCaller
extends DirectCaller {
    public static final int RESPONSE_TIMEOUT = 10000;
    private String proxyHost = null;
    private int proxyPort = -1;
    private String proxyOptions = null;

    public ProxyCaller(String method) {
        this(method, null);
    }

    public ProxyCaller(String method, String options) {
        this.method = method;
        this.proxyHost = ProxyUtils.getHostForProxyType((String)method);
        this.proxyPort = ProxyUtils.getPortForProxyType((String)method);
        this.proxyOptions = options != null ? options : ProxyUtils.getOptionsForProxyType((String)method);
    }

    public ProxyCaller(String method, String host, int port, String opts) {
        this.method = method;
        this.proxyHost = host;
        this.proxyOptions = opts;
        this.proxyPort = port;
    }

    @Override
    public void run() {
        Endpoint ep = null;
        try {
            ep = EndpointCaller.tunnel((String)this.host, (int)this.port, (String)this.proxyHost, (int)this.proxyPort, (String)this.method, (String)this.proxyOptions);
            ep.setSoTimeout(10000);
            if (this.url.getProtocol().equals("ssljinx")) {
                ep = EndpointSecurity.secureClient((Endpoint)ep, (String)this.url.getHost(), (int)this.url.getPort());
                EndpointSecurity.verifyDestination((Endpoint)ep, (String)this.url.getHost(), (SSLTargetQuery)this.targetQuery);
            }
            this.sayHello(ep);
            this.finish(ep, null);
        }
        catch (IOException ex) {
            if (ep != null) {
                ep.closeForce();
            }
            this.finish(ex);
            return;
        }
    }

    @Override
    public String getTarget() {
        if (this.host == null) {
            return "none";
        }
        if (this.proxyHost == null) {
            return super.getTarget();
        }
        Integer iPort = new Integer(this.port);
        Integer pPort = new Integer(this.proxyPort);
        return this.i18n.getString((PropertiesEnum)StringsProperties.PROXYCALLER_TARGET, new Object[]{this.method, this.host, iPort, this.proxyHost, pPort});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        String desc;
        Object object = this.getLock();
        synchronized (object) {
            desc = this.isDone() ? (this.getEndpoint() != null ? this.i18n.getString((PropertiesEnum)StringsProperties.PROXYCALLER_SUCCESSDESC, new Object[]{this.getTarget()}) : this.i18n.getString((PropertiesEnum)StringsProperties.PROXYCALLER_FAILEDDESC, new Object[]{this.getTarget(), this.getReason()})) : this.i18n.getString((PropertiesEnum)StringsProperties.PROXYCALLER_WORKINGDESC, new Object[]{this.getTarget()});
        }
        return desc;
    }
}

