/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.imps.whiteboard;

public class WBModelEvent {
    public static final int NONE = -1;
    private Action action;
    private int uid;
    private int from = -1;
    private int to = -1;
    private int after = -1;
    private String attribute = null;
    private boolean more = false;

    public WBModelEvent(int uid, boolean more) {
        this.action = Action.ObjectContentChanged;
        this.uid = uid;
        this.more = more;
    }

    public WBModelEvent(int uid, String nm, boolean more) {
        this.action = Action.ObjectAttributeChanged;
        this.uid = uid;
        this.attribute = nm;
        this.more = more;
    }

    public WBModelEvent(int uid, int to, int after) {
        this.action = Action.ObjectAdded;
        this.uid = uid;
        this.to = to;
        this.after = after;
    }

    public WBModelEvent(int uid, int from) {
        this.action = Action.ObjectRemoved;
        this.uid = uid;
        this.from = from;
    }

    public WBModelEvent(int uid, int from, int to, int after) {
        this.action = Action.ObjectMoved;
        this.uid = uid;
        this.from = from;
        this.to = to;
        this.after = after;
    }

    public Action getAction() {
        return this.action;
    }

    public int getUID() {
        return this.uid;
    }

    public String getAttributeName() {
        return this.attribute;
    }

    public int getSourceUID() {
        return this.from;
    }

    public int getDestinationUID() {
        return this.to;
    }

    public int getAfter() {
        return this.after;
    }

    public boolean hasMore() {
        return this.more;
    }

    public void setMore(boolean hasMore) {
        this.more = hasMore;
    }

    public String toString() {
        String desc = null;
        switch (this.action) {
            case ObjectAdded: {
                desc = "Added object " + this.uid + " to " + this.to + " after " + this.after;
                break;
            }
            case ObjectRemoved: {
                desc = "Removed object " + this.uid + " from " + this.from;
                break;
            }
            case ObjectMoved: {
                desc = "Moved object " + this.uid + " from " + this.from + " to " + this.to + " after " + this.after;
                break;
            }
            case ObjectAttributeChanged: {
                desc = "Changed attribute " + this.attribute + " of object " + this.uid;
                break;
            }
            case ObjectContentChanged: {
                desc = "Changed content of object " + this.uid;
            }
        }
        if (this.more) {
            return desc + " (more)";
        }
        return desc + " (done)";
    }

    public static enum Action {
        ObjectAdded,
        ObjectRemoved,
        ObjectMoved,
        ObjectAttributeChanged,
        ObjectContentChanged;

    }
}

