/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.breakout;

import com.elluminate.groupware.LabelProps;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.JinxProtocolAdapter;
import com.elluminate.jinx.PropertyAccessAPI;
import com.elluminate.util.DebugFlag;
import com.elluminate.util.I18n;
import java.io.DataInputStream;
import java.io.IOException;

public class BreakoutProtocol
extends JinxProtocolAdapter {
    public static I18n i18n = I18n.create(BreakoutProtocol.class);
    public static final String CHANNEL = "breakout";
    public static final byte PRIORITY = 2;
    public static final DebugFlag DEBUG = DebugFlag.get((String)"breakout");
    public static final String LAST_PROP = "breakout.last";
    public static final String AUTO_MOBILE_PROP = "breakout.autoMobile";
    public static final byte CREATE_ROOM = 1;
    public static final byte DELETE_ROOM = 2;
    public static final byte JOIN_ROOM = 3;
    public static final byte RENAME_ROOM = 4;
    public static final byte REJOIN = 16;
    public static final byte REDISTRIBUTE = 17;
    public static final byte ERROR = -1;

    public BreakoutProtocol() {
        this.defineProperty(AUTO_MOBILE_PROP, (byte)1, Boolean.FALSE);
        this.defineChannel(CHANNEL, (byte)2);
    }

    public String commandToString(byte cmd) {
        switch (cmd) {
            case 1: {
                return "CreateRoom";
            }
            case 2: {
                return "DeleteRoom";
            }
            case 3: {
                return "JoinRoom";
            }
            case 4: {
                return "RenameRoom";
            }
            case 16: {
                return "Rejoin";
            }
            case 17: {
                return "Redistribute";
            }
            case -1: {
                return "Error";
            }
        }
        return "***** UNKNOWN BREAKOUT COMMAND CODE " + cmd + " *****";
    }

    public String messageToString(byte cmd, DataInputStream str) {
        StringBuffer desc = new StringBuffer(this.commandToString(cmd));
        try {
            switch (cmd) {
                case 1: {
                    desc.append(" - ");
                    desc.append(str.readUTF());
                    desc.append(str.readBoolean() ? " (transient" : " (permanent");
                    int count = str.readShort();
                    for (int i = 0; i < count; ++i) {
                        desc.append(",");
                        desc.append(str.readShort());
                    }
                    desc.append(")");
                    break;
                }
                case 2: {
                    desc.append(" - ");
                    desc.append(str.readShort());
                    break;
                }
                case 3: {
                    desc.append(" - ");
                    desc.append(str.readShort());
                    String separator = ": ";
                    int count = str.readShort();
                    for (int i = 0; i < count; ++i) {
                        desc.append(separator);
                        desc.append(str.readShort());
                        separator = ",";
                    }
                    break;
                }
                case 4: {
                    desc.append(" - ");
                    desc.append(str.readShort());
                    desc.append(" -> '");
                    desc.append(str.readUTF());
                    desc.append("'");
                    break;
                }
                case 16: {
                    break;
                }
                case 17: {
                    if (str.readBoolean()) {
                        desc.append(" - include moderators");
                        break;
                    }
                    desc.append(" - except moderators");
                    break;
                }
                case -1: {
                    desc.append(" - ");
                    desc.append(BreakoutProtocol.getErrorMsg(str, null));
                }
            }
        }
        catch (IOException ex) {
            desc.append(" - *** EXCEPTION '");
            desc.append(ex);
            desc.append("' ***");
        }
        return desc.toString();
    }

    public static String getErrorMsg(DataInputStream istr, ClientList clients) {
        String label = LabelProps.get((PropertyAccessAPI)clients, (String)"Label.group");
        try {
            String msg = istr.readUTF();
            String arg = istr.readUTF();
            return i18n.getStringLegacy(msg, new Object[]{label, arg});
        }
        catch (IOException iox) {
            return "Unknown " + label + " error:" + iox;
        }
    }

    public static String getErrorMsg(ChannelDataEvent cde, ClientList clients) {
        try {
            DataInputStream istr = cde.read();
            String msg = BreakoutProtocol.getErrorMsg(istr, clients);
            istr.close();
            return msg;
        }
        catch (IOException iox) {
            return null;
        }
    }
}

