/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.moduleloading;

import com.elluminate.framework.moduleloading.ExecutionMonitor;
import com.elluminate.framework.moduleloading.MLFDebug;
import com.elluminate.framework.moduleloading.Module;
import com.elluminate.framework.moduleloading.ModuleFunctor;
import com.elluminate.framework.moduleloading.ModuleLocator;
import com.elluminate.framework.moduleloading.ProgressListener;
import com.elluminate.framework.moduleloading.ProgressSrcImpl;
import com.elluminate.framework.moduleloading.StateFunctorPair;
import com.elluminate.framework.moduleloading.states.ModulesState;
import com.elluminate.framework.moduleloading.states.ModulesStateClerk;
import com.elluminate.framework.moduleloading.states.ModulesStateListener;
import com.elluminate.framework.moduleloading.states.ModulesStateSrc;
import com.elluminate.framework.moduleloading.threadingengine.ThreadingEngine;
import com.elluminate.util.DebugFlag;
import com.elluminate.util.event.FiringFunctor;
import com.elluminate.util.event.ListenerRegistry;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class ModuleContainer<T extends Module>
implements ModulesStateSrc,
Iterable<T> {
    public static final DebugFlag LOG_APP_STATES = DebugFlag.get((String)"mlf.logstates");
    private String bindingSuffix = "GuiceBindings";
    private String moduleSuffix = "Module";
    private ModulesState modulesState;
    private ModulesStateClerk stateClerk;
    private List<StateFunctorPair<T>> loadFunctors = new CopyOnWriteArrayList<StateFunctorPair<T>>();
    private List<StateFunctorPair<T>> unloadFunctors = new CopyOnWriteArrayList<StateFunctorPair<T>>();
    private List<FunctorRunnable<T>> performanceLog = new LinkedList<FunctorRunnable<T>>();
    private Injector injector;
    private List<T> modules = new CopyOnWriteArrayList<T>();
    private ListenerRegistry<ModulesStateListener> stateListeners;
    private ThreadingEngine threadingEngine;
    private ExecutionMonitor executionMonitor;

    @Inject
    public ModuleContainer(ModulesStateClerk clerk) {
        this.stateClerk = clerk;
        this.modulesState = clerk.getState("init", ModulesState.Status.ENTERING);
        this.addStartFunctor();
        this.addStopFunctor();
        this.addAttachFunctor();
        this.addDetachFunctor();
    }

    @Inject
    public void initInjector(Injector injector) {
        this.injector = injector;
    }

    @Inject
    public void initExecutionMonitor(ExecutionMonitor executionMonitor) {
        this.executionMonitor = executionMonitor;
    }

    @Inject
    public void initRegistryListener(ListenerRegistry<ModulesStateListener> registry) {
        this.stateListeners = registry;
    }

    @Inject
    public void initThreadingEngine(ThreadingEngine threadingEngine) {
        this.threadingEngine = threadingEngine;
    }

    public void addLoadFunctor(String stateName, ModuleFunctor<T> functor) {
        this.stateClerk.addLoadState(stateName);
        this.loadFunctors.add(new StateFunctorPair<T>(stateName, functor));
    }

    public void addUnloadFunctor(String stateName, ModuleFunctor<T> functor) {
        this.stateClerk.addUnloadState(stateName);
        this.unloadFunctors.add(0, new StateFunctorPair<T>(stateName, functor));
    }

    @Override
    public void addStateListener(ModulesStateListener listener) {
        listener.moduleStateChanged(this.modulesState);
        this.stateListeners.add((Object)listener);
    }

    public void setModuleBindingMapping(String moduleSuffix, String bindingSuffix) {
        this.moduleSuffix = moduleSuffix;
        this.bindingSuffix = bindingSuffix;
    }

    public void loadModules(ModuleLocator<T> locator) {
        long elapsed = System.currentTimeMillis();
        List<Class<T>> moduleClasses = locator.locateModuleClasses();
        this.setProgressSrc("MLF Loading", this.calcLoadingSteps(moduleClasses.size()));
        this.createModules(moduleClasses);
        this.execute(this.loadFunctors);
        this.threadingEngine.cleanUpThreads();
        if (MLFDebug.STATS.show()) {
            elapsed = System.currentTimeMillis() - elapsed;
            LogSupport.message((Object)this, (String)"loadModules", (String)("Loading statistics:\n" + this.performanceSummary(this.loadFunctors, elapsed)));
        }
    }

    private void setProgressSrc(String name, int max) {
        this.executionMonitor.setProgressSrc(new ProgressSrcImpl(name, 0, max));
    }

    private int calcLoadingSteps(int modulesToLoad) {
        return modulesToLoad * (this.loadFunctors.size() + 1);
    }

    private void execute(List<StateFunctorPair<T>> pairs) {
        for (StateFunctorPair<T> p : pairs) {
            this.executeFunctor(p.functor, p.stateName);
        }
    }

    public void unloadModules() {
        long elapsed = System.currentTimeMillis();
        this.setProgressSrc("MLF unloading", this.unloadFunctors.size() * this.modules.size());
        this.execute(this.unloadFunctors);
        this.threadingEngine.cleanUpThreads();
        if (MLFDebug.STATS.show()) {
            elapsed = System.currentTimeMillis() - elapsed;
            LogSupport.message((Object)this, (String)"loadModules", (String)("unloading statistics:\n" + this.performanceSummary(this.unloadFunctors, elapsed)));
        }
    }

    public void executeFunctor(ModuleFunctor<T> functor) {
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        for (Module m : this.modules) {
            FunctorRunnable<Module> runner = new FunctorRunnable<Module>(m, functor);
            tasks.add(runner);
            this.performanceLog.add(runner);
        }
        this.executeTasks(tasks);
    }

    public void executeFunctor(ModuleFunctor<T> functor, String stateName) {
        this.updateState(this.stateClerk.getState(stateName, ModulesState.Status.ENTERING));
        this.executeFunctor(functor);
        this.updateState(this.stateClerk.getState(stateName, ModulesState.Status.EXITING));
    }

    private ModuleFunctor<T> makeDetachFunctor() {
        return new ModuleFunctor<T>(){

            @Override
            public void execute(T instance) {
                if (LOG_APP_STATES.show()) {
                    LogSupport.message((String)("Detaching " + instance.getClass().getSimpleName()));
                }
                instance.detach();
            }
        };
    }

    private ModuleFunctor<T> makeStopFunctor() {
        return new ModuleFunctor<T>(){

            @Override
            public void execute(T instance) {
                if (LOG_APP_STATES.show()) {
                    LogSupport.message((String)("Stopping " + instance.getClass().getSimpleName()));
                }
                instance.stop();
            }
        };
    }

    private void createModules(List<Class<T>> moduleClasses) {
        this.execute(this.makeCreateModuleTasks(moduleClasses), "create");
    }

    private void execute(List<Runnable> tasks, String stateName) {
        this.updateState(this.stateClerk.getState(stateName, ModulesState.Status.ENTERING));
        this.executeTasks(tasks);
        this.updateState(this.stateClerk.getState(stateName, ModulesState.Status.EXITING));
    }

    private void executeTasks(List<Runnable> tasks) {
        this.threadingEngine.execute(this.executionMonitor.instrument(tasks));
    }

    private List<Runnable> makeCreateModuleTasks(List<Class<T>> moduleClasses) {
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        for (Class<T> c : moduleClasses) {
            tasks.add(this.makeCreateModuleTask(c));
        }
        return tasks;
    }

    private Runnable makeCreateModuleTask(final Class<T> moduleClass) {
        return new Runnable(){

            @Override
            public void run() {
                ModuleContainer.this.createModule(moduleClass);
            }
        };
    }

    private void createModule(Class<T> moduleClass) {
        Injector moduleInjector = this.createModuleInjector(moduleClass);
        this.modules.add(moduleInjector.getInstance(moduleClass));
    }

    private Injector createModuleInjector(Class<T> c) {
        String bName = c.getName();
        if (bName.endsWith(this.moduleSuffix)) {
            bName = bName.substring(0, bName.length() - this.moduleSuffix.length());
        }
        bName = bName + this.bindingSuffix;
        try {
            Class<?> bindingClass = Class.forName(bName);
            com.google.inject.Module bindings = (com.google.inject.Module)bindingClass.newInstance();
            return this.injector.createChildInjector(new com.google.inject.Module[]{bindings});
        }
        catch (Exception noBindings) {
            return this.injector;
        }
    }

    private void addStartFunctor() {
        this.addLoadFunctor("start", this.makeStartFunctor());
    }

    private void addAttachFunctor() {
        this.addLoadFunctor("attach", this.makeAttachFunctor());
    }

    private void addDetachFunctor() {
        this.addUnloadFunctor("detach", this.makeDetachFunctor());
    }

    private void addStopFunctor() {
        this.addUnloadFunctor("stop", this.makeStopFunctor());
    }

    private ModuleFunctor<T> makeStartFunctor() {
        return new ModuleFunctor<T>(){

            @Override
            public void execute(T instance) {
                if (LOG_APP_STATES.show()) {
                    LogSupport.message((String)("Starting " + instance.getClass().getSimpleName()));
                }
                instance.start();
            }
        };
    }

    private ModuleFunctor<T> makeAttachFunctor() {
        return new ModuleFunctor<T>(){

            @Override
            public void execute(T instance) {
                if (LOG_APP_STATES.show()) {
                    LogSupport.message((String)("Attaching " + instance.getClass().getSimpleName()));
                }
                instance.attach();
            }
        };
    }

    private void updateState(final ModulesState state) {
        this.modulesState = state;
        this.stateListeners.fire((FiringFunctor)new FiringFunctor<ModulesStateListener>(){

            public void fire(ModulesStateListener listener) {
                listener.moduleStateChanged(state);
            }
        });
    }

    @Override
    public Iterator<T> iterator() {
        return Collections.unmodifiableList(this.modules).iterator();
    }

    public void addProgressListener(ProgressListener listener) {
        this.executionMonitor.addProgressListener(listener);
    }

    @Override
    public ModulesState getState(String name, ModulesState.Status status) {
        return this.stateClerk.getState(name, status);
    }

    public String performanceSummary(List<StateFunctorPair<T>> states, long elapsed) {
        StringBuilder summary = new StringBuilder();
        TreeMap<String, HashMap<ModuleFunctor, Long>> matrix = new TreeMap<String, HashMap<ModuleFunctor, Long>>();
        int steps = 0;
        long grandTotal = 0L;
        summary.append("\t\t\t");
        for (StateFunctorPair<T> stateFunctorPair : states) {
            int len = stateFunctorPair.stateName.length();
            if (len > 7) {
                summary.append("\t\u2026" + stateFunctorPair.stateName.substring(len - 6));
                continue;
            }
            summary.append("\t" + stateFunctorPair.stateName);
        }
        summary.append("\ttotal\n");
        for (FunctorRunnable functorRunnable : this.performanceLog) {
            ModuleFunctor f = functorRunnable.functor;
            Module i = functorRunnable.instance;
            long ms = functorRunnable.elapsed;
            String module = i.getClass().getName();
            int dot = module.lastIndexOf(46);
            HashMap<ModuleFunctor, Long> times = (HashMap<ModuleFunctor, Long>)matrix.get(module = module.substring(dot + 1));
            if (times == null) {
                times = new HashMap<ModuleFunctor, Long>();
                matrix.put(module, times);
            }
            times.put(f, ms);
        }
        for (String string : matrix.keySet()) {
            long total = 0L;
            summary.append(string);
            for (int i = 8; i < 32; i += 8) {
                if (string.length() + i >= 32) continue;
                summary.append('\t');
            }
            Map times = (Map)matrix.get(string);
            for (StateFunctorPair<T> pair : states) {
                long ms = (Long)times.get(pair.functor);
                total += ms;
                summary.append("\t" + ms);
                ++steps;
            }
            summary.append("\t" + total + "\n");
            grandTotal += total;
        }
        summary.append("Summary: elapsed: " + elapsed + "ms, CPU: " + grandTotal + "ms, " + steps + " steps");
        return summary.toString();
    }

    private static class FunctorRunnable<T extends Module>
    implements Runnable {
        private T instance;
        private ModuleFunctor<T> functor;
        private long elapsed;

        public FunctorRunnable(T inst, ModuleFunctor<T> func) {
            this.instance = inst;
            this.functor = func;
        }

        @Override
        public void run() {
            this.elapsed = System.currentTimeMillis();
            this.functor.execute(this.instance);
            this.elapsed = System.currentTimeMillis() - this.elapsed;
        }
    }
}

