/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.imps;

import com.elluminate.framework.imps.Imps;
import com.elluminate.framework.imps.ImpsAPI;
import com.elluminate.framework.imps.ImpsAvailableListener;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

@Singleton
public class ImpsImpl
implements Imps {
    private Map<Class<? extends ImpsAPI>, LinkedList<? extends ImpsAPI>> apis = new HashMap<Class<? extends ImpsAPI>, LinkedList<? extends ImpsAPI>>();
    private Map<Class<? extends ImpsAPI>, List<ImpsAvailableListener>> listeners = new HashMap<Class<? extends ImpsAPI>, List<ImpsAvailableListener>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends ImpsAPI> void addImpsAvailableListener(ImpsAvailableListener listener, Class<T> type) {
        if (listener == null || type == null) {
            return;
        }
        Map<Class<? extends ImpsAPI>, List<ImpsAvailableListener>> map = this.listeners;
        synchronized (map) {
            if (!this.listeners.containsKey(type)) {
                this.listeners.put(type, new LinkedList());
            }
            this.addListener(this.listeners.get(type), listener);
        }
    }

    private void addListener(List<ImpsAvailableListener> list, ImpsAvailableListener listener) {
        if (!list.contains(listener)) {
            list.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends ImpsAPI> List<T> findAll(Class<T> type) {
        Map<Class<? extends ImpsAPI>, LinkedList<? extends ImpsAPI>> map = this.apis;
        synchronized (map) {
            List reply = this.apis.get(type);
            return reply;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends ImpsAPI> T findBest(Class<T> type) {
        Map<Class<? extends ImpsAPI>, LinkedList<? extends ImpsAPI>> map = this.apis;
        synchronized (map) {
            if (this.apis.containsKey(type)) {
                LinkedList<? extends ImpsAPI> apiContainer = this.apis.get(type);
                if (apiContainer == null || apiContainer.isEmpty()) {
                    return null;
                }
                return (T)((ImpsAPI)type.cast(apiContainer.getFirst()));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends ImpsAPI> void provideAPI(Class<T> type, T instance) {
        if (type == null || instance == null) {
            return;
        }
        Map<Class<? extends ImpsAPI>, LinkedList<? extends ImpsAPI>> map = this.apis;
        synchronized (map) {
            LinkedList<? extends ImpsAPI> list;
            if (!this.apis.containsKey(type)) {
                this.apis.put(type, new LinkedList());
            }
            if ((list = this.apis.get(type)).isEmpty()) {
                list.add(instance);
            } else {
                byte tier = instance.getTier();
                boolean done = false;
                ListIterator<T> i = list.listIterator();
                while (i.hasNext()) {
                    ImpsAPI test = (ImpsAPI)type.cast(i.next());
                    if (tier <= test.getTier()) continue;
                    i.previous();
                    i.add(instance);
                    done = true;
                    break;
                }
                if (!done) {
                    list.addLast(instance);
                }
            }
        }
        this.notifyListeners(type, instance, API.ADD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends ImpsAPI> void revokeAPI(Class<T> api, T instance) {
        if (api == null || instance == null) {
            return;
        }
        Map<Class<? extends ImpsAPI>, LinkedList<? extends ImpsAPI>> map = this.apis;
        synchronized (map) {
            LinkedList<? extends ImpsAPI> apiList = this.apis.get(api);
            if (apiList.contains(instance)) {
                apiList.remove(instance);
            }
        }
        this.notifyListeners(api, instance, API.REMOVE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends ImpsAPI> void notifyListeners(Class<T> type, T instance, API notify) {
        Map<Class<? extends ImpsAPI>, List<ImpsAvailableListener>> map = this.listeners;
        synchronized (map) {
            List<ImpsAvailableListener> availListeners = this.listeners.get(type);
            if (availListeners == null || availListeners.isEmpty()) {
                return;
            }
            for (ImpsAvailableListener listener : this.listeners.get(type)) {
                if (notify.equals((Object)API.ADD)) {
                    listener.available(instance);
                    continue;
                }
                listener.removed(instance);
            }
        }
    }

    private static enum API {
        ADD,
        REMOVE;

    }
}

