/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.chat.module;

import com.elluminate.groupware.chat.module.StringsProperties;
import com.elluminate.gui.FixedLengthDocument;
import com.elluminate.gui.component.EasyDialog;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;

public class SendAnnouncementDialog
extends EasyDialog {
    private static final Dimension MessageFieldSize = new Dimension(300, 200);
    private static final int MessageMaxLength = 2000;
    private JEditorPane messageField;
    private JCheckBox sendToAllRooms;

    public SendAnnouncementDialog(Component owner, String body) {
        super(owner, null, true);
        I18n i18n = I18n.create(SendAnnouncementDialog.class);
        this.setTitle(i18n.getString((PropertiesEnum)StringsProperties.ROOM_ANNOUNCE_DIALOG_TITLE));
        final JButton sendButton = this.makeButton(i18n.getString((PropertiesEnum)StringsProperties.ROOM_ANNOUNCE_SEND_BUTTON));
        sendButton.setEnabled(false);
        this.addActionButton(sendButton, true);
        JButton cancelButton = this.makeButton(0);
        this.addCancelButton(cancelButton, false);
        this.sendToAllRooms = new JCheckBox(i18n.getString((PropertiesEnum)StringsProperties.ROOM_ANNOUNCE_ALL_ROOMS_CHECKBOX));
        this.addPassiveComponent(this.sendToAllRooms);
        final FixedLengthDocument doc = new FixedLengthDocument(2000);
        doc.addDocumentListener(new DocumentListener(){

            private void determineSendEnabled() {
                int trimmedLength = 0;
                try {
                    trimmedLength = doc.getText(0, doc.getLength()).trim().length();
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                sendButton.setEnabled(trimmedLength > 0);
            }

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                this.determineSendEnabled();
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                this.determineSendEnabled();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
            }
        });
        this.messageField = new JEditorPane();
        this.messageField.setEditable(true);
        this.messageField.setDocument((Document)doc);
        this.messageField.setMargin(new Insets(2, 4, 2, 4));
        this.messageField.setPreferredSize(MessageFieldSize);
        this.messageField.setText(body != null ? body : "");
        this.messageField.setFocusTraversalKeys(0, null);
        this.messageField.setFocusTraversalKeys(1, null);
        Keymap kmap = JTextComponent.addKeymap(null, this.messageField.getKeymap());
        kmap.addActionForKeyStroke(KeyStroke.getKeyStroke(10, 0), new TextAction("send-announcement-action"){

            @Override
            public void actionPerformed(ActionEvent e) {
                sendButton.doClick();
            }
        });
        this.messageField.setKeymap(kmap);
        JScrollPane messagePane = new JScrollPane(this.messageField);
        messagePane.setHorizontalScrollBarPolicy(31);
        JLabel label = new JLabel(i18n.getString((PropertiesEnum)StringsProperties.ROOM_ANNOUNCE_MESSAGE_LABEL), 10);
        label.setLabelFor(this.messageField);
        JPanel messagePanel = new JPanel();
        messagePanel.setLayout(new BorderLayout(0, 6));
        messagePanel.add((Component)label, "North");
        messagePanel.add((Component)messagePane, "South");
        this.setContent(messagePanel);
        this.setInitialFocus(this.messageField);
    }

    public String getMessageText() {
        return this.messageField.getText();
    }

    public boolean getToAllRooms() {
        return this.sendToAllRooms.isSelected();
    }
}

