/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.chat.module;

import com.elluminate.classroom.client.messaging.ModulePublisherInfo;
import com.elluminate.contentcapture.CaptureBacklogCallback;
import com.elluminate.contentcapture.CaptureFeedSubscription;
import com.elluminate.contentcapture.CaptureTextInput;
import com.elluminate.contentcapture.ContentCapture;
import com.elluminate.contentcapture.ContentCaptureProvider;
import com.elluminate.engine.ConferencingEngine;
import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.ActionFeatureEvent;
import com.elluminate.framework.feature.ActionFeatureListener;
import com.elluminate.framework.feature.ActionParameterDescriptor;
import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.framework.feature.FeaturePathSupport;
import com.elluminate.framework.feature.ListFeature;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.imps.Imps;
import com.elluminate.framework.imps.ImpsAPI;
import com.elluminate.framework.session.CRParticipant;
import com.elluminate.framework.session.CRPermissionDelegate;
import com.elluminate.framework.session.CRPermissionFactory;
import com.elluminate.framework.session.CRPermissionScope;
import com.elluminate.framework.session.CRSession;
import com.elluminate.framework.session.listener.CRParticipantAdapter;
import com.elluminate.framework.session.listener.CRParticipantListener;
import com.elluminate.framework.session.listener.CRPermissionChangeListener;
import com.elluminate.framework.session.listener.event.CRParticipantEvent;
import com.elluminate.framework.session.listener.event.CRPermissionChangeEvent;
import com.elluminate.framework.session.listener.event.CRPermissionChangeEventType;
import com.elluminate.groupware.Chair;
import com.elluminate.groupware.ChairProtocol;
import com.elluminate.groupware.chat.Address;
import com.elluminate.groupware.chat.Chat;
import com.elluminate.groupware.chat.ChatProtocol;
import com.elluminate.groupware.chat.module.AnnouncementDisplayDialog;
import com.elluminate.groupware.chat.module.ChatPermissionDelegate;
import com.elluminate.groupware.chat.module.ChatPublisher;
import com.elluminate.groupware.chat.module.ChatTerminal;
import com.elluminate.groupware.chat.module.ChatTerminalListener;
import com.elluminate.groupware.chat.module.ErrorHandler;
import com.elluminate.groupware.chat.module.SendAnnouncementDialog;
import com.elluminate.groupware.chat.module.SendChatMessageCmd;
import com.elluminate.groupware.chat.module.StringsProperties;
import com.elluminate.groupware.chat.module.ToAll;
import com.elluminate.groupware.chat.module.ToAllRooms;
import com.elluminate.groupware.chat.module.ToChairs;
import com.elluminate.groupware.chat.module.ToParticipants;
import com.elluminate.groupware.chat.module.ToSelection;
import com.elluminate.groupware.feature.chat.SimpleChatMessage;
import com.elluminate.groupware.imps.PlaybackTimeAPI;
import com.elluminate.groupware.imps.PlaybackTimeListener;
import com.elluminate.groupware.imps.PublishUrlAPI;
import com.elluminate.groupware.imps.module.PresentationModeAPI;
import com.elluminate.groupware.module.AbstractClientModule;
import com.elluminate.groupware.module.ClientModule;
import com.elluminate.groupware.module.PermissionFeatureFactory;
import com.elluminate.gui.swing.DialogParentProvider;
import com.elluminate.jinx.ClientEvent;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.ClientListener;
import com.elluminate.jinx.JinxProtocol;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.util.ComponentRegistrar;
import com.elluminate.util.I18n;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

@Singleton
public class ChatModule
extends AbstractClientModule
implements ModulePublisherInfo,
PropertyChangeListener,
ClientModule,
ChatTerminalListener,
CRPermissionChangeListener,
CaptureTextInput,
CaptureBacklogCallback {
    private static final String MODULE_NAME = "Chat";
    private static final String FEATURE_BASE_PATH = "/chat";
    private static final String MSG_RECV_NOTICE = "/chat/notice/messageReceived";
    private static final String PRIV_MSG_RECV_NOTICE = "/chat/notice/privateMessageReceived";
    private static final String RESET_NOTICE = "/chat/notice/reset";
    private static final String ROOM_ANNOUNCEMENT_RECV_NOTICE = "/chat/notice/roomAnnouncement";
    public static final int MAX_MESSAGE_LENGTH = 1500;
    private final I18n i18n = I18n.create((Object)this);
    private Imps imps;
    private ErrorHandler errorHandler;
    private ChatTerminal terminal;
    private PresentationModeAPI presentAPI = null;
    private PlaybackTimeListener playbackTimeListener;
    private Provider<SendChatMessageCmd> sendCmdProvider;
    private DialogParentProvider parentProvider;
    private ClientList clients;
    private ChairProtocol chairProtocol;
    private ClientProvider clientProvider;
    private ConferencingEngine confEngine;
    private FeaturePathSupport pathSupport;
    private FeatureBroker broker;
    private BooleanFeature supervisedFeature;
    private ListFeature<SimpleChatMessage> messagesFeature;
    private ListFeature<CRParticipant> forbiddenParticipantsFeature;
    private BooleanFeature chatActiveFeature;
    private BooleanFeature enableEmoticonsControlFeature;
    private BooleanFeature showEmoticonsFeature;
    private ActionFeature sendMessageToRoomFeature;
    private ActionFeature sendMessageToParticipantsFeature;
    private ActionFeature sendRoomAnnouncementFeature;
    private ActionFeature sendMessageToModeratorsFeature;
    private ChatPublisher msgPublisher;
    private ContentCapture contentCapture = null;
    private ContentCaptureProvider contentCaptureProvider;
    private CRSession session;
    private PermissionFeatureFactory permissionFeatureFactory;
    private ChatPermissionDelegate chatPermissionDelegate;
    private CRPermissionFactory chatPermissionFactory;
    private PublishAPI publishAPI = new PublishAPI();
    private ChangeListener presentListener = new PresentationStateListener();

    @Inject
    public void initContentCaptureProvider(ContentCaptureProvider contentCaptureProvider) {
        this.contentCaptureProvider = contentCaptureProvider;
    }

    @Inject
    public ChatModule() {
        this.playbackTimeListener = new PlaybackTimeListener(){

            public void setLinearity(PlaybackTimeListener.Linearity spd) {
            }

            public void resetSession() {
                if (ChatModule.this.messagesFeature != null) {
                    ChatModule.this.messagesFeature.clear();
                }
                ChatModule.this.broker.sendNotification((Object)ChatModule.this, ChatModule.RESET_NOTICE, "", 0L);
            }
        };
    }

    @Inject
    protected void initSession(CRSession session) {
        this.session = session;
    }

    @Inject
    protected void initChairProtocol(ChairProtocol chairProtocol) {
        this.chairProtocol = chairProtocol;
    }

    @Inject
    protected void initParentProvider(DialogParentProvider dpp) {
        this.parentProvider = dpp;
    }

    @Inject
    public void initChatPublisher(ChatPublisher pub) {
        this.msgPublisher = pub;
    }

    @Inject
    public void initSendCmdProvider(Provider<SendChatMessageCmd> sendCmd) {
        this.sendCmdProvider = sendCmd;
    }

    @Inject
    public void initClientProvider(ClientProvider cp) {
        this.clientProvider = cp;
    }

    @Inject
    public void initConferencingEngine(ConferencingEngine ce) {
        this.confEngine = ce;
    }

    @Inject
    public void initImps(Imps imps) {
        this.imps = imps;
    }

    @Inject
    public void initComponentRegistrar(ComponentRegistrar registrar) {
        registrar.registerComponent((Object)this);
    }

    @Inject
    public void initPathSupport(FeaturePathSupport pathSupport) {
        this.pathSupport = pathSupport;
    }

    @Inject
    public void initFeatureBroker(FeatureBroker broker) {
        this.broker = broker;
    }

    @Inject
    public void initTerminal(ChatTerminal terminal) {
        this.terminal = terminal;
        this.terminal.setMaxMsgLength(1500);
        this.terminal.setProtocol((JinxProtocol)new ChatProtocol());
    }

    @Inject
    public void initErrorHandler(ErrorHandler errHandler) {
        this.errorHandler = errHandler;
    }

    @Inject
    protected void initPermissionFeatureFactory(PermissionFeatureFactory permissionFeatureFactory) {
        this.permissionFeatureFactory = permissionFeatureFactory;
    }

    @Inject
    public void initChatPermissionDelegate(ChatPermissionDelegate chatPermissionDelegate) {
        this.chatPermissionDelegate = chatPermissionDelegate;
    }

    public String getNameOfModule() {
        return MODULE_NAME;
    }

    public String getDisplayNameOfModule() {
        return this.i18n.getString((PropertiesEnum)StringsProperties.CHATMODULE_TITLE);
    }

    public Icon getModuleIcon() {
        return this.i18n.getIcon((PropertiesEnum)StringsProperties.CHATMODULE_TOOLICON);
    }

    protected void sendChatEnabledStatusUpdateMessage(Boolean oldValue, Boolean newValue) {
        if (oldValue != newValue && newValue != null) {
            this.msgPublisher.sendEnabledStatusChangeMessage(newValue);
        }
    }

    private boolean isRestricted() {
        if (this.session.getMe() == null) {
            return false;
        }
        boolean chatPermission = this.session.getPermissionValue("ChatPermission", this.session.getMe().getID());
        return !chatPermission;
    }

    protected void updateForbiddenParticipants() {
        if (this.isRestricted()) {
            ArrayList<CRParticipant> nonchairs = new ArrayList<CRParticipant>();
            Iterator it = this.session.getParticipantIterator();
            while (it.hasNext()) {
                CRParticipant p = (CRParticipant)it.next();
                if (p.isChair()) continue;
                nonchairs.add(p);
            }
            this.forbiddenParticipantsFeature.assign(nonchairs);
        } else {
            this.forbiddenParticipantsFeature.clear();
        }
    }

    public boolean isConfigured() {
        return this.publishAPI != null;
    }

    void updateState() {
        this.updateFeatures();
    }

    void postAnnouncement(String message) {
    }

    public void sessionStart() {
        this.session.addPermissionChangeListener("ChatPermission", (CRPermissionChangeListener)this);
        this.session.addPermissionChangeListener("ChairPermission", (CRPermissionChangeListener)this);
    }

    public void start() {
        this.imps.provideAPI(PublishUrlAPI.class, (ImpsAPI)this.publishAPI);
        SendChatMessageCmd sendCmd = (SendChatMessageCmd)((Object)this.sendCmdProvider.get());
        sendCmd.setChatModule(this);
        sendCmd.setSession(this.session);
        this.confEngine.registerCommand(this.sendCmdProvider);
    }

    public void attach() {
        PlaybackTimeAPI playbackTimeApi;
        this.clients = this.clientProvider.get().getClientList();
        this.clients.addPropertyChangeListener("chair", (PropertyChangeListener)this);
        this.clients.setProperty("directMessagingChatActive", true);
        this.clients.addClientListener(new ClientListener(){

            public void onRemoveClient(ClientEvent e) {
            }

            public void onAddClient(ClientEvent e) {
                if (e.isMe()) {
                    ChatModule.this.clients.getMyClient().addPropertyChangeListener("directMessagingFloor", new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            ChatModule.this.sendChatEnabledStatusUpdateMessage((Boolean)evt.getOldValue(), (Boolean)evt.getNewValue());
                        }
                    });
                }
            }
        });
        this.clients.addPropertyChangeListener("directMessagingMonitored", (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener("directMessagingEmoticonsEnabled", (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener((byte)0, (PropertyChangeListener)new ChatAnnotationProvider());
        this.session.registerAnnotation("ChatActivityAnnotation", (Object)0);
        this.terminal.createChannels();
        this.presentAPI = (PresentationModeAPI)this.imps.findBest(PresentationModeAPI.class);
        if (this.presentAPI != null) {
            this.presentAPI.addPresentationStateListener(this.presentListener);
        }
        if ((playbackTimeApi = (PlaybackTimeAPI)this.imps.findBest(PlaybackTimeAPI.class)) != null) {
            playbackTimeApi.addPlaybackTimeListener(this.playbackTimeListener);
        }
        this.chatPermissionDelegate.setClientProvider(this.clientProvider);
        this.chatPermissionDelegate.setSession(this.session);
        this.chatPermissionDelegate.addListener(new CRPermissionChangeListener(){

            public void onPermissionValueChange(CRPermissionChangeEvent event) {
                ChatModule.this.updateFeatures();
                ChatModule.this.updateForbiddenParticipants();
            }

            public void onPermissionDefaultChange(CRPermissionChangeEvent event) {
            }
        });
        this.clients.addPropertyChangeListener(this.chatPermissionDelegate.getPropertyName(), (byte)0, (PropertyChangeListener)((Object)this.chatPermissionDelegate));
        this.clients.addDefaultPropertyChangeListener(this.chatPermissionDelegate.getPropertyName(), (byte)0, (PropertyChangeListener)((Object)this.chatPermissionDelegate));
        this.chatPermissionFactory = new CRPermissionFactory("ChatPermission", "ChatPermission", CRPermissionScope.PARTICIPANT, (CRPermissionDelegate)this.chatPermissionDelegate);
        this.session.registerPermission(this.chatPermissionFactory);
        this.session.addParticipantListener((CRParticipantListener)new CRParticipantAdapter(){

            public void onParticipantJoinedRoom(CRParticipantEvent event) {
                ChatModule.this.updateForbiddenParticipants();
            }
        });
        this.session.addPermissionChangeListener("ChatPermission", new CRPermissionChangeListener(){

            public void onPermissionDefaultChange(CRPermissionChangeEvent event) {
            }

            public void onPermissionValueChange(CRPermissionChangeEvent event) {
                if (event.getValueChange() == CRPermissionChangeEventType.TRUE_TO_FALSE) {
                    ClientInfo ci = ChatModule.this.clients.getMyClient();
                    if (ci != null) {
                        ci.setProperty("directMessagingActive", false);
                    }
                } else if (event.getValueChange() == CRPermissionChangeEventType.FALSE_TO_TRUE) {
                    if (ChatModule.this.terminal == null || !ChatModule.this.terminal.isConnected()) {
                        return;
                    }
                    if (((Boolean)ChatModule.this.chatActiveFeature.getValue()).booleanValue()) {
                        ClientInfo ci = ChatModule.this.clients.getMyClient();
                        ci.setProperty("directMessagingActive", true);
                    }
                }
            }
        });
    }

    public void setupUI() {
        this.createFeatures();
        this.updateFeatures();
    }

    public void cleanupUI() {
        this.revokeFeatures();
    }

    public void detach() {
        if (this.clients == null) {
            return;
        }
        PlaybackTimeAPI playbackTimeApi = (PlaybackTimeAPI)this.imps.findBest(PlaybackTimeAPI.class);
        if (playbackTimeApi != null) {
            playbackTimeApi.removePlaybackTimeListener(this.playbackTimeListener);
        }
        this.session.deRegisterAnnotation("ChatActivityAnnotation");
        this.clients.removePropertyChangeListener("directMessagingFloor", (PropertyChangeListener)this);
        this.clients.removePropertyChangeListener("chair", (PropertyChangeListener)this);
        this.clients = null;
    }

    public void stop() {
        this.imps.revokeAPI(PublishUrlAPI.class, (ImpsAPI)this.publishAPI);
        this.publishAPI = null;
    }

    private void createFeatures() {
        this.supervisedFeature = this.broker.createBooleanFeature((Object)this, this.pathSupport.composePath(FEATURE_BASE_PATH, "supervised"), false, false, "supervised", "whether chat is supervised");
        this.chatActiveFeature = this.broker.createBooleanFeature((Object)this, this.pathSupport.composePath(FEATURE_BASE_PATH, "chatActive"), true, false, "chatActive", "whether the user has pending chat input");
        this.chatActiveFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent ev) {
                if (ChatModule.this.terminal == null || !ChatModule.this.terminal.isConnected()) {
                    return;
                }
                ClientList clients = ChatModule.this.clientProvider.get().getClientList();
                ClientInfo ci = clients.getMyClient();
                if (ci == null) {
                    return;
                }
                boolean nowActive = (Boolean)ev.getNewValue();
                boolean wasActive = ci.getProperty("directMessagingActive", false);
                if (wasActive != nowActive) {
                    ci.setProperty("directMessagingActive", nowActive);
                }
            }
        });
        this.enableEmoticonsControlFeature = this.broker.createBooleanFeature((Object)this, this.pathSupport.composePath(FEATURE_BASE_PATH, "enableEmoticonsControl"), true, true, this.i18n.getString((PropertiesEnum)StringsProperties.CHAT_ENABLE_EMOTICONS), null);
        this.enableEmoticonsControlFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent event) {
                ChatModule.this.clients.setProperty("directMessagingEmoticonsEnabled", ((Boolean)event.getNewValue()).booleanValue());
            }
        });
        this.showEmoticonsFeature = this.broker.createBooleanFeature((Object)this, this.pathSupport.composePath(FEATURE_BASE_PATH, "showEmoticons"), true, true, null, null);
        this.broker.setFeaturePublished((Feature)this.showEmoticonsFeature, true);
        this.forbiddenParticipantsFeature = this.broker.createListFeature((Object)this, this.pathSupport.composePath(FEATURE_BASE_PATH, "forbiddenParticipants"), CRParticipant.class, null, "forbiddenParticipants", null);
        this.messagesFeature = this.broker.createListFeature((Object)this, this.pathSupport.composePath(FEATURE_BASE_PATH, "messages"), SimpleChatMessage.class, null, "messages", null);
        ActionParameterDescriptor sendMsgBodyDesc = new ActionParameterDescriptor("body", ActionParameterDescriptor.Type.STRING);
        ActionParameterDescriptor toRoomDesc = new ActionParameterDescriptor("toRoom", ActionParameterDescriptor.Type.STRING);
        String path = this.pathSupport.composePath(FEATURE_BASE_PATH, "sendMessageToRoom");
        String name = this.i18n.getString((PropertiesEnum)StringsProperties.CHATBEAN_SEND);
        String desc = this.i18n.getString((PropertiesEnum)StringsProperties.CHATBEAN_SENDTIP);
        ActionParameterDescriptor[] params = new ActionParameterDescriptor[]{sendMsgBodyDesc, toRoomDesc};
        this.sendMessageToRoomFeature = this.broker.createActionFeature((Object)this, path, params, name, desc);
        this.sendMessageToRoomFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent ev) {
                String text = (String)ev.getParameterAs(String.class, "body");
                String toRoom = (String)ev.getParameterAs(String.class, "toRoom");
                if (toRoom == null) {
                    toRoom = "this_room";
                }
                ToSelection to = new ToAll();
                if (ChatModule.this.isRestricted()) {
                    Chair chair = ChatModule.this.chairProtocol.fetchChair(ChatModule.this.session.getConnection());
                    ArrayList<CRParticipant> chairListCollection = new ArrayList<CRParticipant>();
                    for (ClientInfo clientInfo : chair.getClients()) {
                        chairListCollection.add(new CRParticipant(ChatModule.this.session, clientInfo));
                    }
                    ToChairs toChairs = new ToChairs(chair, ChatModule.this.errorHandler, "sendMessageToModeratorsFeature", ChatModule.this.i18n);
                    ChatModule.this.terminal.send(toChairs, text, false, ChatModule.this.errorHandler);
                } else {
                    if (toRoom.equalsIgnoreCase("all_rooms")) {
                        to = new ToAllRooms();
                    }
                    ChatModule.this.terminal.send(to, text, false, ChatModule.this.errorHandler);
                }
            }
        });
        path = this.pathSupport.composePath(FEATURE_BASE_PATH, "sendMessageToModerators");
        name = this.i18n.getString((PropertiesEnum)StringsProperties.CHATBEAN_SEND);
        desc = this.i18n.getString((PropertiesEnum)StringsProperties.CHATBEAN_SENDTIP);
        params = new ActionParameterDescriptor[]{sendMsgBodyDesc};
        this.sendMessageToModeratorsFeature = this.broker.createActionFeature((Object)this, path, params, name, desc);
        this.sendMessageToModeratorsFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent ev) {
                String text = (String)ev.getParameterAs(String.class, "body");
                Chair chair = ChatModule.this.chairProtocol.fetchChair(ChatModule.this.session.getConnection());
                ToChairs to = new ToChairs(chair, ChatModule.this.errorHandler, "sendMessageToModeratorsFeature", ChatModule.this.i18n);
                ChatModule.this.terminal.send(to, text, false, ChatModule.this.errorHandler);
            }
        });
        path = this.pathSupport.composePath(FEATURE_BASE_PATH, "sendRoomAnnouncement");
        name = this.i18n.getString((PropertiesEnum)StringsProperties.ROOM_ANNOUNCE_ACTION);
        desc = this.i18n.getString((PropertiesEnum)StringsProperties.CHATBEAN_SENDTIP);
        this.sendRoomAnnouncementFeature = this.broker.createActionFeature((Object)this, path, name, desc);
        this.sendRoomAnnouncementFeature.setInteractive(true);
        this.sendRoomAnnouncementFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent ev) {
                Map params = ev.getUserData() instanceof Map ? (Map)ev.getUserData() : null;
                final String body = params != null ? (String)params.get("body") : null;
                final String toRoom = params != null ? (String)params.get("toRoom") : null;
                SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        SendAnnouncementDialog rad = new SendAnnouncementDialog(ChatModule.this.parentProvider.getDialogParent(), body);
                        if (toRoom == null) {
                            rad.show();
                        }
                        if (!ChatModule.this.sendRoomAnnouncementFeature.isPublished()) {
                            return;
                        }
                        if (!rad.wasCanceled()) {
                            ToSelection to;
                            String message = rad.getMessageText();
                            ToSelection toSelection = to = rad.getToAllRooms() ? new ToAllRooms() : new ToAll();
                            if (toRoom != null && toRoom.equalsIgnoreCase("all_rooms")) {
                                to = new ToAllRooms();
                            } else if (toRoom != null && toRoom.equalsIgnoreCase("moderators")) {
                                Chair chair = ChatModule.this.chairProtocol.fetchChair(ChatModule.this.session.getConnection());
                                to = new ToChairs(chair, ChatModule.this.errorHandler, "sendRoomAnnouncementFeature", ChatModule.this.i18n);
                            }
                            ChatModule.this.terminal.send(to, message, true, ChatModule.this.errorHandler);
                        }
                    }
                });
            }
        });
        path = this.pathSupport.composePath(FEATURE_BASE_PATH, "sendMessageToParticipants");
        name = this.i18n.getString((PropertiesEnum)StringsProperties.CHATBEAN_SEND);
        desc = this.i18n.getString((PropertiesEnum)StringsProperties.CHATBEAN_SENDTIP);
        ActionParameterDescriptor.Validator toValidator = new ActionParameterDescriptor.Validator(){

            public boolean isValid(Object val) {
                if (val == null) {
                    return false;
                }
                if (val instanceof CRParticipant) {
                    CRParticipant part = (CRParticipant)val;
                    if (part.isMe()) {
                        return false;
                    }
                    return part.isVisible();
                }
                return false;
            }
        };
        ActionParameterDescriptor sendMsgToDesc = new ActionParameterDescriptor("recipients", ActionParameterDescriptor.Type.PARTICIPANT, 1, Integer.MAX_VALUE, this.i18n.getString((PropertiesEnum)StringsProperties.CHATBEAN_TOTIP), toValidator);
        ActionParameterDescriptor[] params2 = new ActionParameterDescriptor[]{sendMsgToDesc, sendMsgBodyDesc};
        this.sendMessageToParticipantsFeature = this.broker.createActionFeature((Object)this, path, params2, name, desc);
        this.sendMessageToParticipantsFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent ev) {
                Collection recipients = ev.getParameterAsCollectionOf(CRParticipant.class, "recipients");
                for (int i = 0; i < ChatModule.this.forbiddenParticipantsFeature.size(); ++i) {
                    if (!recipients.contains(ChatModule.this.forbiddenParticipantsFeature.get(i))) continue;
                    LogSupport.error((String)("Attempted to send a message to a forbidden participant: " + ((CRParticipant)ChatModule.this.forbiddenParticipantsFeature.get(i)).toString()));
                    return;
                }
                String text = (String)ev.getParameterAs(String.class, "body");
                ToParticipants to = new ToParticipants(recipients);
                to.initErrorHandler(ChatModule.this.errorHandler);
                to.initI18n(ChatModule.this.i18n);
                ChatModule.this.terminal.send(to, text, false, ChatModule.this.errorHandler);
            }
        });
        if (this.permissionFeatureFactory != null) {
            BooleanFeature bf = this.permissionFeatureFactory.createPermissionFeature((Object)this, "ChatPermission", "/chat/chatPermission", this.i18n.getString((PropertiesEnum)StringsProperties.CHATMODULE_COLUMNTITLE), MODULE_NAME, this.i18n);
            bf.setAccessibleName(this.i18n.getString((PropertiesEnum)StringsProperties.CHATMODULE_COLUMNTITLE_ACCESSIBLENAME));
        }
        this.broker.announceNotification((Object)this, MSG_RECV_NOTICE);
        this.broker.announceNotification((Object)this, PRIV_MSG_RECV_NOTICE);
        this.broker.announceNotification((Object)this, ROOM_ANNOUNCEMENT_RECV_NOTICE);
    }

    public void sendChat(String messageType, ToSelection to, String text, boolean announce) throws Exception {
        if (messageType == null) {
            throw new IllegalArgumentException("Chat Message Type was not provided.");
        }
        if (announce || messageType.equalsIgnoreCase("announcement")) {
            if (this.sendRoomAnnouncementFeature == null || !this.sendRoomAnnouncementFeature.isPublished()) {
                throw new Exception("sendChat: sendRoomAnnouncementFeature is not published.");
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("body", text);
            params.put("toRoom", messageType);
            this.sendRoomAnnouncementFeature.fireActionFeatureListeners(params);
        } else if (messageType.equalsIgnoreCase("this_room")) {
            if (this.sendMessageToRoomFeature == null || !this.sendMessageToRoomFeature.isPublished()) {
                throw new Exception("sendChat: sendMessageToRoomFeature is not published.");
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("body", text);
            params.put("toRoom", messageType);
            this.sendMessageToRoomFeature.fireActionFeatureListeners(params);
        } else if (messageType.equalsIgnoreCase("all_rooms")) {
            if (this.sendMessageToRoomFeature == null || !this.sendMessageToRoomFeature.isPublished()) {
                throw new Exception("sendChat: sendMessageToRoomFeature is not published.");
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("body", text);
            params.put("toRoom", messageType);
            this.sendMessageToRoomFeature.fireActionFeatureListeners(params);
        } else if (messageType.equalsIgnoreCase("moderators")) {
            if (this.sendMessageToModeratorsFeature == null || !this.sendMessageToModeratorsFeature.isPublished()) {
                throw new Exception("sendChat: sendMessageToModeratorsFeature is not published.");
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("body", text);
            this.sendMessageToModeratorsFeature.fireActionFeatureListeners(params);
        } else if (messageType.equalsIgnoreCase("selected_participants")) {
            if (this.sendMessageToParticipantsFeature == null || !this.sendMessageToParticipantsFeature.isPublished()) {
                throw new Exception("sendChat: sendMessageToParticipantsFeature is not published.");
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("body", text);
            params.put("recipients", ((ToParticipants)to).getToList());
            this.sendMessageToParticipantsFeature.fireActionFeatureListeners(params);
        } else {
            throw new Exception("sendChat: Unknown Chat Message Type - " + messageType);
        }
    }

    private void updateFeatures() {
        if (this.sendMessageToParticipantsFeature == null) {
            return;
        }
        boolean chaired = this.session.getMe() == null ? false : this.session.getMe().isChair();
        boolean connected = this.terminal == null ? false : this.terminal.isConnected();
        boolean supervised = this.clients.getProperty("directMessagingMonitored", false);
        boolean emoticonStateLocked = this.clients.getProperty("directMessagingEmoticonsLockState", false);
        this.supervisedFeature.setValue((Object)supervised);
        this.broker.setFeaturePublished((Feature)this.supervisedFeature, true);
        this.broker.setFeaturePublished((Feature)this.chatActiveFeature, true);
        this.broker.setFeaturePublished(this.messagesFeature, true);
        this.broker.setFeaturePublished(this.forbiddenParticipantsFeature, true);
        this.broker.setFeaturePublished((Feature)this.sendMessageToRoomFeature, connected);
        this.broker.setFeaturePublished((Feature)this.sendMessageToParticipantsFeature, connected);
        this.broker.setFeaturePublished((Feature)this.sendRoomAnnouncementFeature, connected && chaired);
        this.broker.setFeaturePublished((Feature)this.sendMessageToModeratorsFeature, connected && chaired);
        if (!emoticonStateLocked) {
            this.broker.setFeaturePublished((Feature)this.enableEmoticonsControlFeature, chaired);
        }
    }

    private void revokeFeatures() {
        this.broker.setFeaturePublished((Feature)this.supervisedFeature, false);
        this.broker.setFeaturePublished((Feature)this.chatActiveFeature, false);
        this.broker.setFeaturePublished(this.messagesFeature, false);
        this.broker.setFeaturePublished(this.forbiddenParticipantsFeature, false);
        this.broker.setFeaturePublished((Feature)this.sendMessageToRoomFeature, false);
        this.broker.setFeaturePublished((Feature)this.sendMessageToParticipantsFeature, false);
        this.broker.setFeaturePublished((Feature)this.sendRoomAnnouncementFeature, false);
        this.broker.setFeaturePublished((Feature)this.sendMessageToModeratorsFeature, false);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String pn = propertyChangeEvent.getPropertyName();
        if (pn.equals("directMessagingMonitored")) {
            this.updateFeatures();
        } else if (pn.equals("directMessagingEmoticonsEnabled")) {
            Boolean newvalue = (Boolean)propertyChangeEvent.getNewValue();
            newvalue = newvalue == null ? false : newvalue;
            this.enableEmoticonsControlFeature.setValue((Object)newvalue);
            this.showEmoticonsFeature.setValue((Object)newvalue);
        } else if (pn.equals("chair")) {
            this.updateForbiddenParticipants();
        }
    }

    private ContentCapture getContentCapture() {
        if (this.contentCapture == null && this.contentCaptureProvider.get().isCapturingData()) {
            this.contentCapture = this.contentCaptureProvider.get().registerTextModule(MODULE_NAME, MODULE_NAME, (CaptureBacklogCallback)this, (CaptureTextInput)this, this.i18n.getIcon("ChatBean.thinClientIcon"), (byte)4, (byte)60);
        }
        return this.contentCapture;
    }

    public void captureBacklogCallback(CaptureFeedSubscription subscription) {
    }

    public void textInput(String text) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessageToContentCapture(Chat msg) {
        if (!this.contentCaptureProvider.get().isCapturingData()) {
            return;
        }
        String body = msg.getText();
        Address from = msg.getOriginator();
        StringBuffer hdr = new StringBuffer();
        if (msg.isPrivate()) {
            return;
        }
        if (from.isMe()) {
            hdr.append(this.i18n.getString((PropertiesEnum)StringsProperties.CHATBEAN_ME));
        } else {
            hdr.append(from.getName());
        }
        hdr.append(" - " + body);
        if (this.contentCaptureProvider.get().isCapturingData()) {
            ClientList cl = this.clientProvider.get().getClientList();
            ClientInfo fromClient2 = cl.getVisible(from.getName());
            short addr = -1;
            if (fromClient2 != null) {
                addr = fromClient2.getAddress();
            } else {
                ClientList clientList = cl;
                synchronized (clientList) {
                    for (ClientInfo fromClient2 : cl) {
                        if (!fromClient2.getDisplayName().equals(from.getName())) continue;
                        addr = fromClient2.getAddress();
                    }
                }
            }
            this.getContentCapture().setText(addr, body);
        }
    }

    private static SimpleChatMessage simpleChatMessageFromChat(Chat c) {
        ArrayList<String> recipientNames = new ArrayList<String>();
        for (Address addr : c.getRecipients()) {
            if (addr.getName().length() <= 0 || addr.getType() == 6) continue;
            recipientNames.add(addr.getName());
        }
        return new SimpleChatMessage(c.getOriginator().getName(), c.getOriginator().getJinxAddress(), recipientNames, c.getText(), c.getTimestamp(), c.isAnnouncement(), c.isModeratorsMessage());
    }

    @Override
    public void welcome(Date time) {
    }

    @Override
    public void goodbye(Date time) {
    }

    @Override
    public void messageRecieved(Chat msg) {
        String notificationPath = null;
        if (this.getContentCapture() == null || this.getContentCapture().isEchoingData()) {
            if (msg.isAnnouncement()) {
                final AnnouncementDisplayDialog ancdd = new AnnouncementDisplayDialog(this.parentProvider.getDialogParent(), msg);
                ancdd.show();
                notificationPath = ROOM_ANNOUNCEMENT_RECV_NOTICE;
                if (this.clientProvider.get().isPlayback()) {
                    LightweightTimer closeTimer = new LightweightTimer(2, new Runnable(){

                        @Override
                        public void run() {
                            ancdd.dispose();
                        }
                    });
                    closeTimer.scheduleIn(3000L);
                }
            } else if (!msg.isFromMe()) {
                notificationPath = msg.isPrivate() ? PRIV_MSG_RECV_NOTICE : MSG_RECV_NOTICE;
            }
            SimpleChatMessage scm = ChatModule.simpleChatMessageFromChat(msg);
            this.messagesFeature.add((Object)scm);
            if (notificationPath != null) {
                this.broker.sendNotification((Object)this, notificationPath, msg.getText(), msg.getTimestamp().getTime());
            }
            this.msgPublisher.sendRouterMessage(msg);
        }
        this.sendMessageToContentCapture(msg);
    }

    @Override
    public void connectionChanged(boolean connected) {
        this.updateFeatures();
    }

    public void onPermissionValueChange(CRPermissionChangeEvent event) {
        this.updateFeatures();
    }

    public void onPermissionDefaultChange(CRPermissionChangeEvent event) {
    }

    protected boolean isPrivateChatRestricted() {
        if (this.clientProvider == null) {
            return true;
        }
        this.clients = this.clientProvider.get().getClientList();
        if (this.clients == null) {
            return true;
        }
        return this.clients.getProperty("directMessagingPrivateChatRestricted", true);
    }

    private class ChatAnnotationProvider
    implements PropertyChangeListener {
        private ChatAnnotationProvider() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (ChatModule.this.clients == null) {
                return;
            }
            String propertyName = evt.getPropertyName();
            short ownerId = ChatModule.this.clients.getPropertyOwner(evt.getSource());
            ClientInfo ci = ChatModule.this.clients.get(ownerId);
            if (ci == null) {
                return;
            }
            if (propertyName.equals("directMessagingActive")) {
                boolean active = ci.getProperty("directMessagingActive", false);
                if (active) {
                    ChatModule.this.session.setAnnotationValue(ownerId, "ChatActivityAnnotation", (Object)1);
                } else {
                    ChatModule.this.session.setAnnotationValue(ownerId, "ChatActivityAnnotation", (Object)0);
                }
            }
        }
    }

    private class PresentationStateListener
    implements ChangeListener {
        private PresentationStateListener() {
        }

        @Override
        public void stateChanged(ChangeEvent ev) {
            ChatModule.this.updateState();
        }
    }

    class PublishAPI
    implements PublishUrlAPI {
        PublishAPI() {
        }

        public String getProvider() {
            return ChatModule.this.i18n.getString((PropertiesEnum)StringsProperties.CHATMODULE_PUBLISHAPI_WEBPROVIDERNAME);
        }

        public byte getTier() {
            return 32;
        }

        public void publishURL(String url) {
            if (ChatModule.this.sendMessageToRoomFeature == null || !ChatModule.this.sendMessageToRoomFeature.isPublished()) {
                return;
            }
            TreeMap<String, String> params = new TreeMap<String, String>();
            params.put("body", url);
            params.put("toRoom", "this_room");
            ChatModule.this.sendMessageToRoomFeature.fireActionFeatureListeners(params);
        }
    }
}

