/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.appshare.module.x11;

import com.elluminate.groupware.appshare.AppShareDebug;
import com.elluminate.groupware.appshare.module.ApplicationInformation;
import com.elluminate.groupware.appshare.module.x11.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class X11AppInfo
implements ApplicationInformation {
    private static I18n i18n = I18n.create(X11AppInfo.class);
    private static final Icon DFT_ICON = i18n.getIcon("X11AppInfo.defaultAppIcon");
    private static final String JAVA_APP_FLAG = "_JAVA_";
    private static final String JAVA_APP = i18n.getString((PropertiesEnum)StringsProperties.X11APPINFO_WEBSTARTAPPNAME);
    private int clientID;
    private Integer key = null;
    private boolean me = false;
    private String xName = null;
    private String resName = null;
    private String execName = null;
    private ArrayList winList = new ArrayList();
    private Icon icon = DFT_ICON;

    public X11AppInfo(int id, boolean isme, String name, String res, String exe) {
        this.clientID = id;
        this.key = new Integer(id);
        this.me = isme;
        this.xName = name;
        this.resName = res;
        this.execName = exe;
        if (this.resName != null && this.resName.equals(JAVA_APP_FLAG)) {
            this.resName = JAVA_APP;
        }
    }

    X11AppInfo(int id, String name, String res, String app, String win) {
        this.clientID = id;
        this.key = new Integer(id);
        this.me = false;
        this.xName = name;
        this.resName = res;
        this.execName = app;
        this.winList.add(win);
        LogSupport.message((Object)this, (String)"<init>", (String)"Warning: old JNI library in use.");
    }

    void addWindow(String title) {
        this.winList.add(title);
    }

    void setAppIcon(int w, int h, int[] pixels) {
        BufferedImage bufimg;
        if (w == 0 || h == 0 || pixels == null) {
            this.icon = null;
            return;
        }
        Image img = bufimg = new BufferedImage(w, h, 2);
        bufimg.setRGB(0, 0, w, h, pixels, 0, w);
        if (w > 16 || h > 16) {
            double scale = 16.0 / (double)Math.max(w, h);
            w = (int)((double)w * scale + 0.5);
            h = (int)((double)h * scale + 0.5);
            img = bufimg.getScaledInstance(w, h, 4);
        }
        this.icon = new ImageIcon(img);
    }

    @Override
    public String getAppName() {
        if (this.resName != null && this.resName.length() > 0) {
            return this.resName;
        }
        if (this.execName != null && this.execName.length() > 0) {
            return X11AppInfo.parseAfterLast(this.execName, '/');
        }
        return null;
    }

    @Override
    public String getAppPath() {
        return this.execName;
    }

    @Override
    public int getWindowCount() {
        return this.winList.size();
    }

    @Override
    public String getWindowTitle(int which) {
        return (String)this.winList.get(which);
    }

    @Override
    public Icon getWindowIcon(int which) {
        return null;
    }

    @Override
    public String[] getWindowTitles() {
        String[] result = new String[this.winList.size()];
        return this.winList.toArray(result);
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    @Override
    public Icon getAppIcon() {
        return this.icon;
    }

    public int getClientID() {
        return this.clientID;
    }

    public boolean isMe() {
        return this.me;
    }

    public String getXName() {
        return this.xName;
    }

    public String getResName() {
        return this.resName;
    }

    public String getExecName() {
        return this.execName;
    }

    public String toString() {
        String title;
        String result = this.getAppName();
        if (result == null) {
            result = super.toString();
        }
        if (this.winList.size() == 1 && result.indexOf(title = this.getWindowTitle(0)) < 0) {
            result = result + " '" + title + "'";
        }
        if (AppShareDebug.HOST.show()) {
            result = result + " 0x" + Integer.toHexString(this.clientID) + " " + this.execName;
        }
        return result;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof X11AppInfo)) {
            return false;
        }
        X11AppInfo otherApp = (X11AppInfo)other;
        if (this.clientID != 0) {
            if (this.clientID != otherApp.clientID) {
                return false;
            }
        } else {
            if (otherApp.clientID != 0) {
                return false;
            }
            if (this.resName != null ? !this.resName.equals(otherApp.resName) : otherApp.resName != null) {
                return false;
            }
        }
        if (this.winList != null) {
            if (otherApp.winList == null) {
                return false;
            }
            if (!this.winList.equals(otherApp.winList)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return this.clientID;
    }

    private static String parseAfterLast(String s, char c) {
        int pos = s.lastIndexOf(c);
        if (pos >= 0 && pos < s.length() - 1) {
            return s.substring(pos + 1);
        }
        return s;
    }
}

