/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.appshare.module;

import com.elluminate.util.Debug;

public class WindowStats {
    private Period head = null;
    private Period free = null;
    private long mSec = 0L;
    private long mSecOpen = 0L;
    private long mSecClosed = 0L;

    public WindowStats(long mSec) {
        this.mSec = mSec;
        this.head = new Period(System.currentTimeMillis(), mSec, true);
        this.mSecOpen = mSec;
    }

    public void open() {
        this.setOpen(true);
    }

    public void close() {
        this.setOpen(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOpen(boolean open) {
        Debug.lockEnter((Object)this, (String)"setOpen", null, (Object)this);
        WindowStats windowStats = this;
        synchronized (windowStats) {
            long now = System.currentTimeMillis();
            long len = now - this.head.time;
            if (len > this.mSec) {
                len = this.mSec;
            }
            if (len > 0L) {
                this.trim(now);
                Period next = this.getPeriod(now, len, open);
                next.insertBefore(this.head);
                this.head = next;
                if (open) {
                    this.mSecOpen += len;
                } else {
                    this.mSecClosed += len;
                }
            }
        }
        Debug.lockLeave((Object)this, (String)"setOpen", null, (Object)this);
    }

    public float getOpenFraction() {
        return (float)this.mSecOpen / (float)this.mSec;
    }

    public float getClosedFraction() {
        return (float)this.mSecClosed / (float)this.mSec;
    }

    private Period getPeriod(long now, long len, boolean open) {
        Period period;
        if (len > this.mSec) {
            len = this.mSec;
        }
        if (this.free != null) {
            period = this.free;
            this.free = period.remove();
            period.time = now;
            period.duration = len;
            period.open = open;
        } else {
            period = new Period(now, len, open);
        }
        return period;
    }

    private void trim(long now) {
        long start = now - this.mSec;
        Period tail = this.head.prev;
        long delta = start - (tail.time - tail.duration);
        while (delta > 0L) {
            if (delta < tail.duration) {
                tail.duration -= delta;
                if (tail.open) {
                    this.mSecOpen -= delta;
                } else {
                    this.mSecClosed -= delta;
                }
                return;
            }
            this.head = tail.remove();
            if (tail.open) {
                this.mSecOpen -= tail.duration;
            } else {
                this.mSecClosed -= tail.duration;
            }
            tail.insertBefore(this.free);
            this.free = tail;
            if (this.head == null) {
                return;
            }
            tail = this.head.prev;
            delta = start - (tail.time - tail.duration);
        }
    }

    private static final class Period {
        public long time;
        public long duration;
        public boolean open;
        public Period next;
        public Period prev;

        public Period(long t, long l, boolean o) {
            this.time = t;
            this.duration = l;
            this.open = o;
            this.next = this;
            this.prev = this;
        }

        public void insertBefore(Period p) {
            if (p == null) {
                return;
            }
            this.next = p;
            this.prev = p.prev;
            this.prev.next = this;
            this.next.prev = this;
        }

        public Period remove() {
            if (this.next == this) {
                return null;
            }
            Period tmp = this.next;
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.next = this;
            this.prev = this;
            return tmp;
        }
    }
}

