/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.appshare.module;

import com.elluminate.groupware.appshare.AppShareDebug;
import com.elluminate.groupware.appshare.AppShareTile;
import com.elluminate.util.Debug;
import com.elluminate.util.log.LogSupport;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Arrays;

public final class TileImageSource
implements ImageProducer {
    private static final int TILE_SIZE = 16;
    private static final int N_PIXELS = 256;
    private Rectangle region = null;
    private ColorModel model = ColorModel.getRGBdefault();
    private AppShareTile blank = null;
    private int background = 0;
    private int row0 = 0;
    private int col0 = 0;
    private int nRows = 0;
    private int nCols = 0;
    private int pLeft = 0;
    private int pRight = 0;
    private int pTop = 0;
    private int pBottom = 0;
    private ImageConsumer ic = null;
    private Object[] pending = null;

    public TileImageSource(Rectangle rect, Color bg) {
        this.region = new Rectangle(rect);
        this.background = bg.getRGB();
        int[] pixels = new int[256];
        Arrays.fill(pixels, this.background);
        this.blank = new AppShareTile(0, 0, pixels);
        this.col0 = rect.x / 16;
        this.row0 = rect.y / 16;
        this.pLeft = rect.x % 16;
        this.pTop = rect.y % 16;
        this.pRight = (rect.x + rect.width) % 16;
        this.pBottom = (rect.y + rect.height) % 16;
        if (this.pRight != 0) {
            this.pRight = 16 - this.pRight;
        }
        if (this.pBottom != 0) {
            this.pBottom = 16 - this.pBottom;
        }
        this.nCols = (rect.width + this.pLeft + 16 - 1) / 16;
        this.nRows = (rect.height + this.pTop + 16 - 1) / 16;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void erase() {
        Debug.lockEnter((Object)this, (String)"erase", null, (Object)this);
        try {
            TileImageSource tileImageSource = this;
            synchronized (tileImageSource) {
                if (this.pending != null) {
                    for (int ix = 0; ix < this.pending.length; ++ix) {
                        this.pending[ix] = null;
                    }
                    this.pending = null;
                }
                for (int r = 0; r < this.nRows; ++r) {
                    for (int c = 0; c < this.nCols; ++c) {
                        this.sendTilePixels(r, c, this.blank.pixels, false);
                    }
                }
            }
        }
        finally {
            Debug.lockLeave((Object)this, (String)"erase", null, (Object)this);
        }
        this.frameComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConsumer(ImageConsumer consumer) {
        try {
            Debug.lockEnter((Object)this, (String)"addConsumer", null, (Object)this);
            TileImageSource tileImageSource = this;
            synchronized (tileImageSource) {
                if (this.ic == null) {
                    this.ic = consumer;
                    this.ic.setColorModel(this.model);
                    this.ic.setDimensions(this.region.width, this.region.height);
                    this.ic.setHints(1);
                    for (int r = 0; r < this.nRows; ++r) {
                        for (int c = 0; c < this.nCols; ++c) {
                            this.sendTilePixels(r, c, this.blank.pixels, false);
                        }
                    }
                    if (this.pending != null) {
                        for (int ix = 0; ix < this.pending.length; ++ix) {
                            if (this.pending[ix] == null) continue;
                            this.sendTilePixels(ix / this.nCols, ix % this.nCols, (int[])this.pending[ix], false);
                            this.pending[ix] = null;
                        }
                        this.pending = null;
                    }
                    this.frameComplete();
                } else if (this.ic != consumer) {
                    throw new IllegalStateException("Only one consumer allowed for TileImageSource");
                }
            }
        }
        finally {
            Debug.lockLeave((Object)this, (String)"addConsumer", null, (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConsumer(ImageConsumer consumer) {
        Debug.lockEnter((Object)this, (String)"removeConsumer", null, (Object)this);
        TileImageSource tileImageSource = this;
        synchronized (tileImageSource) {
            if (this.ic == consumer) {
                this.ic = null;
            }
        }
        Debug.lockLeave((Object)this, (String)"removeConsumer", null, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConsumer(ImageConsumer consumer) {
        boolean isIC = false;
        Debug.lockEnter((Object)this, (String)"isConsumer", null, (Object)this);
        TileImageSource tileImageSource = this;
        synchronized (tileImageSource) {
            isIC = this.ic == consumer;
        }
        Debug.lockEnter((Object)this, (String)"isConsumer", null, (Object)this);
        return isIC;
    }

    @Override
    public void startProduction(ImageConsumer consumer) {
        this.addConsumer(consumer);
    }

    @Override
    public void requestTopDownLeftRightResend(ImageConsumer consumer) {
    }

    public void setTile(AppShareTile t) {
        this.setTile(t, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTile(AppShareTile t, boolean complete) {
        int r = t.row - this.row0;
        int c = t.col - this.col0;
        int[] pixels = t.pixels;
        if (r < 0 || r >= this.nRows) {
            return;
        }
        if (c < 0 || c >= this.nCols) {
            return;
        }
        if (AppShareDebug.SHOW_GRID.show()) {
            LogSupport.message((Object)this, (String)"setTile", (String)("(" + t.row + "," + t.col + ") -> (" + r + "," + c + ")"));
            pixels = (int[])pixels.clone();
            for (int offset = 0; offset < 16; ++offset) {
                int n = offset * 16 + 15;
                pixels[n] = pixels[n] ^ 0xFFFFFF;
                int n2 = 240 + offset;
                pixels[n2] = pixels[n2] ^ 0xFFFFFF;
            }
        }
        Debug.lockEnter((Object)this, (String)"setTile", null, (Object)this);
        TileImageSource tileImageSource = this;
        synchronized (tileImageSource) {
            if (this.ic != null) {
                this.sendTilePixels(r, c, pixels, complete);
            } else {
                if (this.pending == null) {
                    this.pending = new Object[this.nCols * this.nRows];
                }
                if (pixels == t.pixels) {
                    pixels = (int[])pixels.clone();
                }
                this.pending[(t.row - this.row0) * this.nCols + t.col - this.col0] = pixels;
            }
        }
        Debug.lockLeave((Object)this, (String)"setTile", null, (Object)this);
    }

    public void setPixels(Rectangle bounds, int[] data) {
        this.setPixels(bounds, data, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPixels(Rectangle bounds, int[] data, boolean complete) {
        if (bounds == null) {
            return;
        }
        if (bounds.isEmpty()) {
            return;
        }
        if (!this.region.intersects(bounds)) {
            return;
        }
        Debug.lockEnter((Object)this, (String)"setPixels", null, (Object)this);
        TileImageSource tileImageSource = this;
        synchronized (tileImageSource) {
            if (this.ic != null) {
                this.sendRawPixels(bounds.x - this.region.x, bounds.y - this.region.y, bounds.width, bounds.height, data, complete);
            } else {
                if (this.pending == null) {
                    this.pending = new Object[this.nCols * this.nRows];
                }
                int r = bounds.y / 16;
                while (r * 16 < bounds.y + bounds.height) {
                    int c = bounds.x / 16;
                    while (c * 16 < bounds.x + bounds.width) {
                        int x0 = c * 16;
                        int y0 = r * 16;
                        int x = x0;
                        int y = y0;
                        int w = 16;
                        int h = 16;
                        if (x < bounds.x) {
                            w -= bounds.x - x;
                            x = bounds.x;
                        }
                        if (y < bounds.y) {
                            h -= bounds.y - y;
                            y = bounds.y;
                        }
                        if (x < bounds.x + bounds.width && y < bounds.y + bounds.height) {
                            w -= Math.max(0, x + w - (bounds.x + bounds.width));
                            h -= Math.max(0, y + h - (bounds.y + bounds.height));
                            if (w > 0 && h > 0) {
                                int[] pixels = new int[256];
                                Arrays.fill(pixels, this.background);
                                for (int y1 = y; y1 < y + h; ++y1) {
                                    int dataIdx = (y1 - bounds.y) * bounds.width + x - bounds.x;
                                    int pixIdx = (y1 - y0) * 16 + x - x0;
                                    System.arraycopy(data, dataIdx, pixels, pixIdx, w);
                                }
                                this.pending[(r - this.row0) * this.nCols + c - this.col0] = pixels;
                            }
                        }
                        ++c;
                    }
                    ++r;
                }
            }
        }
        Debug.lockLeave((Object)this, (String)"setPixels", null, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void frameComplete() {
        Debug.lockEnter((Object)this, (String)"frameComplete", null, (Object)this);
        TileImageSource tileImageSource = this;
        synchronized (tileImageSource) {
            if (this.ic != null) {
                this.ic.imageComplete(2);
            }
        }
        Debug.lockLeave((Object)this, (String)"frameComplete", null, (Object)this);
    }

    private void sendTilePixels(int r, int c, int[] pixels, boolean complete) {
        int x = c * 16;
        int y = r * 16;
        int w = 16;
        int h = 16;
        int off = 0;
        int len = 256;
        if (r == 0) {
            y += this.pTop;
            h -= this.pTop;
            off += this.pTop * 16;
        }
        if (c == 0) {
            x += this.pLeft;
            w -= this.pLeft;
            off += this.pLeft;
        }
        if (r == this.nRows - 1) {
            h -= this.pBottom;
        }
        if (c == this.nCols - 1) {
            w -= this.pRight;
        }
        x -= this.pLeft;
        y -= this.pTop;
        if (w > 0 && h > 0 && this.ic != null) {
            this.ic.setPixels(x, y, w, h, this.model, pixels, off, 16);
        }
        if (complete) {
            this.frameComplete();
        }
    }

    private void sendRawPixels(int x, int y, int w, int h, int[] pixels, boolean complete) {
        int off = 0;
        int rowLen = w;
        if (y < 0) {
            off -= y * rowLen;
            h += y;
            y = 0;
        }
        if (x < 0) {
            off -= x;
            w += x;
            x = 0;
        }
        if (y + h > this.region.height) {
            h = this.region.height - y;
        }
        if (x + w > this.region.width) {
            w = this.region.width - x;
        }
        if (w > 0 && h > 0) {
            this.ic.setPixels(x, y, w, h, this.model, pixels, off, rowLen);
        }
        if (complete) {
            this.frameComplete();
        }
    }
}

