/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.appshare.module;

import com.elluminate.engine.CommandContextException;
import com.elluminate.engine.CommandExecutionException;
import com.elluminate.engine.CommandParameterException;
import com.elluminate.engine.command.AbstractCommand;
import com.elluminate.engine.command.ShareScreenCommand;
import com.elluminate.framework.imps.Imps;
import com.elluminate.groupware.appshare.AppShareDebug;
import com.elluminate.groupware.appshare.module.AppShareBean;
import com.elluminate.groupware.appshare.module.AppShareController;
import com.elluminate.groupware.appshare.module.AppShareModule;
import com.elluminate.groupware.appshare.module.StringsProperties;
import com.elluminate.groupware.imps.module.PresentationModeAPI;
import com.elluminate.groupware.imps.view.ViewAPI;
import com.elluminate.groupware.imps.view.ViewMode;
import com.elluminate.util.Debug;
import com.elluminate.util.I18n;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Toolkit;

public class ShareScreenCmd
extends AbstractCommand
implements ShareScreenCommand {
    private boolean presentationMode = false;
    @Inject
    private I18n i18n;
    @Inject
    private AppShareModule module;
    private Imps imps;

    @Inject
    void initImps(Imps imps) {
        this.imps = imps;
    }

    public void setPresenting(boolean presenting) {
        this.presentationMode = presenting;
    }

    public void doexecute() throws CommandExecutionException {
        this.validateIsOnline();
        AppShareBean bean = this.module.getAppBean();
        if (bean.isViewing()) {
            throw new CommandContextException("Already sharing", this.i18n.getString((PropertiesEnum)StringsProperties.SHARECMD_BADCONTEXTALREADYSHARING));
        }
        if (bean.getState() != 1) {
            throw new CommandContextException("Already hosting", this.i18n.getString((PropertiesEnum)StringsProperties.SHARECMD_BADCONTEXTALREADYHOSTING));
        }
        Rectangle rgn = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
        if (rgn.isEmpty()) {
            throw new CommandParameterException("Empty screen region", this.i18n.getString((PropertiesEnum)StringsProperties.SHARECMD_BADPARAMEMPTYREGION));
        }
        AppShareController ctl = new AppShareController(){
            Rectangle initAOI = null;
            Object[] appList = null;
            AppShareModule appMod = ShareScreenCmd.access$000(ShareScreenCmd.this);
            AppShareBean appShareBean = ShareScreenCmd.access$000(ShareScreenCmd.this).getAppBean();

            @Override
            public void selectRegion(Rectangle rgn) {
                if (rgn.isEmpty()) {
                    throw new RuntimeException("Empty shared region.");
                }
                this.appShareBean.changeState(4);
                this.appList = null;
                this.initAOI = rgn;
                if (!this.startSharing()) {
                    throw new RuntimeException("Can't share screen.");
                }
            }

            @Override
            public void selectApps(Object[] appsToShare) {
                throw new UnsupportedOperationException("Invalid method. ShareScreenCmd shares the entire desktop, not applications.");
            }

            @Override
            public void cancel() {
                this.appShareBean.changeState(1);
            }

            @Override
            public void showOptions(Component parent) {
                throw new UnsupportedOperationException("Invalid method. Cannot show options.");
            }

            private boolean startSharing() {
                if (this.appShareBean.startHosting(this.appList, this.initAOI)) {
                    if (ShareScreenCmd.this.presentationMode) {
                        Runnable presentAction = new Runnable(){

                            @Override
                            public void run() {
                                if (appShareBean.getState() == 5) {
                                    LightweightTimer timer = new LightweightTimer(2, (Runnable)this);
                                    timer.scheduleIn(100L);
                                    return;
                                }
                                if (appShareBean.getState() != 6) {
                                    return;
                                }
                                PresentationModeAPI presentationAPI = null;
                                if (appMod != null) {
                                    presentationAPI = appMod.getPresentationAPI();
                                }
                                if (presentationAPI == null) {
                                    return;
                                }
                                presentationAPI.setPresentable((Object)appMod, true);
                                if (presentationAPI.isPresentationPermitted()) {
                                    presentationAPI.present((Object)appMod, false);
                                }
                            }
                        };
                        LightweightTimer timer = new LightweightTimer(2, presentAction);
                        timer.scheduleIn(250L);
                    }
                    return true;
                }
                this.cancel();
                return false;
            }
        };
        ViewAPI viewApi = (ViewAPI)this.imps.findBest(ViewAPI.class);
        if (viewApi != null) {
            viewApi.requestMode(ViewMode.APPSHARE);
        }
        try {
            ctl.selectRegion(rgn);
        }
        catch (RuntimeException re) {
            if (AppShareDebug.VERBOSE.show()) {
                LogSupport.message((String)re.getMessage());
                LogSupport.message((String)Debug.getStackTrace((Throwable)re));
            }
            throw new CommandContextException(re.getMessage(), this.i18n.getString((PropertiesEnum)StringsProperties.SHARECMD_BADRESULTERROROCCURRED));
        }
    }

    static /* synthetic */ AppShareModule access$000(ShareScreenCmd x0) {
        return x0.module;
    }
}

