/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.appshare.module;

import com.elluminate.groupware.appshare.module.RemoteControl;
import com.elluminate.groupware.appshare.module.StringsProperties;
import com.elluminate.gui.component.AbstractPreferencesPanel;
import com.elluminate.gui.component.InvalidPreferenceSettingException;
import com.elluminate.gui.component.MultilineLabel;
import com.elluminate.gui.component.PreferencesPanelOwner;
import com.elluminate.gui.swing.CPasswordField;
import com.elluminate.util.I18n;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

@Singleton
public class RemoteControlPrefsPanel
extends AbstractPreferencesPanel {
    private I18n i18n;
    private JRadioButton promptMeRadio;
    private JRadioButton withPasswordRadio;
    private CPasswordField passwordField;
    private JRadioButton alwaysRadio;
    private MultilineLabel messageField;
    private boolean valid = false;

    @Inject
    public RemoteControlPrefsPanel(PreferencesPanelOwner owner, I18n i18n) {
        super(owner, i18n.getString((PropertiesEnum)StringsProperties.REMOTECONTROL_TITLE));
        this.i18n = i18n;
    }

    protected void createContent() {
        this.setLayout(new BorderLayout(0, 6));
        JPanel p = new JPanel(new GridBagLayout());
        this.add(p, "North");
        int kIndent = 20;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.insets.bottom = 6;
        JLabel l = new JLabel(this.i18n.getString((PropertiesEnum)StringsProperties.REMOTECONTROL_PERMITREMOTECONTROLLABEL));
        p.add((Component)l, gbc);
        gbc.insets.left = 20;
        this.promptMeRadio = new JRadioButton(this.i18n.getString((PropertiesEnum)StringsProperties.REMOTECONTROL_PERMITPROMPTME));
        this.promptMeRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemoteControlPrefsPanel.this.doPromptMeRadio();
            }
        });
        p.add((Component)this.promptMeRadio, gbc);
        gbc.insets.left = 20;
        JPanel passwordPanel = new JPanel(new GridBagLayout());
        p.add((Component)passwordPanel, gbc);
        GridBagConstraints gbc2 = new GridBagConstraints();
        this.withPasswordRadio = new JRadioButton(this.i18n.getString((PropertiesEnum)StringsProperties.REMOTECONTROL_PERMITWITHPASSWORD));
        this.withPasswordRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemoteControlPrefsPanel.this.doWithPasswordRadio();
            }
        });
        passwordPanel.add((Component)this.withPasswordRadio, gbc2);
        gbc2.insets.left = 6;
        this.passwordField = new CPasswordField(15);
        this.passwordField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                RemoteControlPrefsPanel.this.doPasswordField();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                RemoteControlPrefsPanel.this.doPasswordField();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                RemoteControlPrefsPanel.this.doPasswordField();
            }
        });
        passwordPanel.add((Component)this.passwordField, gbc2);
        gbc.insets.left = 20;
        this.alwaysRadio = new JRadioButton(this.i18n.getString((PropertiesEnum)StringsProperties.REMOTECONTROL_PERMITALWAYS));
        this.alwaysRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemoteControlPrefsPanel.this.doAlwaysRadio();
            }
        });
        p.add((Component)this.alwaysRadio, gbc);
        gbc.gridx = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        p.add(Box.createHorizontalGlue(), gbc);
        ButtonGroup grp = new ButtonGroup();
        grp.add(this.alwaysRadio);
        grp.add(this.withPasswordRadio);
        grp.add(this.promptMeRadio);
        this.messageField = new MultilineLabel();
        this.messageField.setForeground(new Color(192, 0, 0));
        this.add((Component)this.messageField, "Center");
        this.enablePasswordField();
    }

    private void enablePasswordField() {
        this.passwordField.setEnabled(this.withPasswordRadio.isSelected());
    }

    private void doAlwaysRadio() {
        this.enablePasswordField();
        this.checkSettings();
        this.setModified(true);
    }

    private void doWithPasswordRadio() {
        this.enablePasswordField();
        this.checkSettings();
        this.setModified(true);
    }

    private void doPasswordField() {
        this.checkSettings();
        this.setModified(true);
    }

    private void doPromptMeRadio() {
        this.enablePasswordField();
        this.checkSettings();
        this.setModified(true);
    }

    protected void populate(Preferences preferences) {
        String prefix = this.getOwnerPrefix();
        String opt = RemoteControl.getOption(prefix, preferences);
        if (opt == "always") {
            this.alwaysRadio.setSelected(true);
        } else if (opt == "password") {
            this.withPasswordRadio.setSelected(true);
        } else {
            this.promptMeRadio.setSelected(true);
        }
        char[] pw = RemoteControl.getPassword(prefix, preferences);
        if (pw != null && pw.length != 0) {
            this.passwordField.setText(new String(pw));
        } else {
            this.passwordField.setText("");
        }
        RemoteControl.zeroArray(pw);
        this.valid = true;
        this.enablePasswordField();
        this.checkSettings();
    }

    protected void apply(Preferences preferences) throws InvalidPreferenceSettingException {
        if (!this.valid) {
            throw new InvalidPreferenceSettingException((AbstractPreferencesPanel)this);
        }
        String prefix = this.getOwnerPrefix();
        String opt = "prompt";
        if (this.alwaysRadio.isSelected()) {
            opt = "always";
        } else if (this.withPasswordRadio.isSelected()) {
            opt = "password";
        }
        char[] pw = null;
        if (opt == "password") {
            pw = this.passwordField.getPassword();
        }
        RemoteControl.setOption(prefix, preferences, opt);
        RemoteControl.setPassword(prefix, preferences, pw);
        RemoteControl.zeroArray(pw);
    }

    protected void reset(Preferences preferences) {
        String prefix = this.getOwnerPrefix();
        RemoteControl.setOption(prefix, preferences, "prompt");
        RemoteControl.setPassword(prefix, preferences, RemoteControl.REMOTE_CONTROL_PASSWORD_DEFAULT);
    }

    private void checkSettings() {
        if (this.alwaysRadio.isSelected()) {
            this.messageField.setText(this.i18n.getString((PropertiesEnum)StringsProperties.REMOTECONTROL_PERMITALWAYSWARNING));
            this.valid = true;
        } else if (this.withPasswordRadio.isSelected()) {
            char[] pw = this.passwordField.getPassword();
            if (pw == null || pw.length == 0) {
                this.messageField.setText(this.i18n.getString((PropertiesEnum)StringsProperties.REMOTECONTROL_BLANKPASSWORDERROR));
                this.valid = false;
            } else {
                this.messageField.setText(null);
                this.valid = true;
            }
            RemoteControl.zeroArray(pw);
        } else if (this.promptMeRadio.isSelected()) {
            this.messageField.setText(null);
            this.valid = true;
        }
    }
}

