/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.appshare.module;

import com.elluminate.classroom.client.messaging.MessagePublisher;
import com.elluminate.classroom.client.messaging.MessagePublisherMetadata;
import com.elluminate.classroom.client.messaging.MessageRouter;
import com.elluminate.classroom.client.messaging.MessageType;
import com.elluminate.classroom.client.messaging.ModulePublisherInfo;
import com.elluminate.groupware.appshare.module.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

@Singleton
public class AppSharePublisher {
    private final String UNIQUE_NAME = "AppSharePublisher";
    private final String DISPLAY_NAME;
    private final Icon icon;
    public static final String APP_SHARE_STARTED = "app-share-started";
    public static final String APP_SHARE_STOPPED = "app-share-stopped";
    public static final String APP_SHARE_ENABLED = "app-share-enabled";
    public static final String APP_SHARE_DISABLED = "app-share-disabled";
    private final MessagePublisher publisher;
    private final MessagePublisherMetadata metadata;
    private final I18n i18n;
    private final MessageRouter router;
    private String modName;
    private String modDisplayName;
    private Map<String, MessageType> msgTypes = new HashMap<String, MessageType>();

    @Inject
    public AppSharePublisher(MessagePublisher pub, MessagePublisherMetadata meta, MessageRouter rtr, I18n localization, ModulePublisherInfo mod) {
        this.publisher = pub;
        this.metadata = meta;
        this.router = rtr;
        this.i18n = localization;
        this.DISPLAY_NAME = this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREPUBLISHER_DISPLAYNAME);
        this.icon = mod.getModuleIcon();
        this.modName = mod.getNameOfModule();
        this.modDisplayName = mod.getDisplayNameOfModule();
        this.initializePublisher();
    }

    public void sendAppShareStartedMessage(boolean isMe) {
        String message = this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREPUBLISHER_STARTED_MESSAGE);
        this.sendRouterMsg(message, this.msgTypes.get(APP_SHARE_STARTED), isMe);
    }

    public void sendAppShareStoppedMessage(boolean isMe) {
        String message = this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREPUBLISHER_STOPPED_MESSAGE);
        this.sendRouterMsg(message, this.msgTypes.get(APP_SHARE_STOPPED), isMe);
    }

    public void sendAppShareEnabledMessage() {
        String message = this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREPUBLISHER_ENABLED_MESSAGE);
        this.publisher.sendTextMessage(message, this.msgTypes.get(APP_SHARE_ENABLED));
    }

    public void sendAppShareDisabledMessage() {
        String message = this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREPUBLISHER_DISABLED_MESSAGE);
        this.publisher.sendTextMessage(message, this.msgTypes.get(APP_SHARE_DISABLED));
    }

    private void sendRouterMsg(String message, MessageType type, boolean isMe) {
        this.publisher.sendTextMessage(message, type, isMe);
    }

    private void initializePublisher() {
        this.initMessageTypes();
        this.setMetadata();
        this.publisher.setPublisherMetadata(this.metadata);
        this.router.registerPublisher(this.publisher);
    }

    private void setMetadata() {
        this.metadata.setPublisherDisplayName(this.DISPLAY_NAME);
        this.metadata.setPublisherUniqueName("AppSharePublisher");
        this.metadata.setPublisherIcon(this.icon);
        this.metadata.setModuleName(this.modName);
        this.metadata.setModuleDisplayName(this.modDisplayName);
        this.metadata.setPublisherSupportedMessageTypes(new ArrayList<MessageType>(this.msgTypes.values()));
    }

    private void initMessageTypes() {
        this.msgTypes.put(APP_SHARE_STARTED, new MessageType(APP_SHARE_STARTED, this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREPUBLISHER_TYPE_STARTED), 5));
        this.msgTypes.put(APP_SHARE_STOPPED, new MessageType(APP_SHARE_STOPPED, this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREPUBLISHER_TYPE_STOPPED), 5));
        this.msgTypes.put(APP_SHARE_ENABLED, new MessageType(APP_SHARE_ENABLED, this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREPUBLISHER_TYPE_ENABLED), 4));
        this.msgTypes.put(APP_SHARE_DISABLED, new MessageType(APP_SHARE_DISABLED, this.i18n.getString((PropertiesEnum)StringsProperties.APPSHAREPUBLISHER_TYPE_DISABLED), 4));
    }
}

