/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.appshare.module;

import com.elluminate.groupware.appshare.AppShareDebug;
import com.elluminate.groupware.appshare.module.AppSharingHost;
import com.elluminate.groupware.appshare.module.StringsProperties;
import com.elluminate.groupware.appshare.module.TranslucencyHelper;
import com.elluminate.groupware.imps.ImageAcceptAPI;
import com.elluminate.groupware.imps.ImageAcceptAccessibleListener;
import com.elluminate.gui.GuiUtils;
import com.elluminate.gui.component.AlphaIcon;
import com.elluminate.gui.component.DisabledIcon;
import com.elluminate.platform.Platform;
import com.elluminate.util.Debug;
import com.elluminate.util.I18n;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.log.LogSupport;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;

class ApertureFrame
extends JFrame
implements ActionListener {
    public static final Color TRANSPARENT = new Color(0, 0, 0, 0);
    private static final int BORDER_WIDTH = 3;
    private static final int HANDLE_WIDTH = 7;
    private static final boolean IS_MAC = Platform.getPlatform() == 2;
    private static final boolean IS_WIN = Platform.getPlatform() == 1;
    private static final boolean IS_VISTA = IS_WIN && Platform.getOS() >= 406;
    private static final boolean IS_X11 = Platform.getPlatform() == 3;
    private static final boolean IS_LINUX = Platform.getOS() == 300;
    private static final boolean MAC_LEOPARD = Platform.checkOSVersion((int)202, (String)"10.5+");
    private static final boolean JAVA_6U10 = Platform.checkJavaVersion((String)"1.6.0_10+");
    private static final boolean JAVA_7 = Platform.checkJavaVersion((String)"1.7+");
    private static final boolean WIN_TRANS_BUG = IS_VISTA;
    private static final boolean LINUX_TRANS_BUG = IS_LINUX && Platform.is64BitAddressable();
    private static final boolean TRANS_OVERRIDE = Boolean.getBoolean("com.elluminate.live.allowTranslucency");
    private static final boolean X11_ALPHA_ISSUE = IS_X11 && !Platform.checkJavaVersion((String)"1.6.0_24+");
    private static final boolean X11_ALPHA_PERFORMANCE = IS_X11;
    private static final float DASH_TOTAL = 18.0f;
    private static final float[] DASH_DATA = new float[]{12.0f, 6.0f};
    private static final float ACTIVE_BUTTON_ALPHA = 1.0f;
    private static final float INACTIVE_BUTTON_ALPHA = 0.5f;
    private static final float DEFAULT_BUTTON_ALPHA = X11_ALPHA_ISSUE ? 1.0f : 0.5f;
    private static final float ACTIVE_BACKGROUND_ALPHA = 0.75f;
    private static final float INACTIVE_BACKGROUND_ALPHA = 0.35f;
    private static final TranslucencyHelper translucency = TranslucencyHelper.create();
    private static final boolean available = translucency != null && translucency.isAvailable();
    private static final boolean hasWindowTranslucency;
    private static final String TITLE_BASE_STRING = "AppShare Hosting Markup";
    private static int instanceCount;
    private I18n i18n = I18n.create((Object)this);
    private final Rectangle display = new Rectangle();
    private boolean allowLiveResize = false;
    private AppSharingHost host = null;
    private AperturePane mainPane = null;
    private AlphaIcon stopIcon;
    private JButton stopBtn = new JButton();
    private AlphaIcon pauseIcon;
    private AlphaIcon pauseSelectedIcon = null;
    private JToggleButton pauseBtn = new JToggleButton();
    private AlphaIcon snapIcon;
    private JButton snapBtn = new JButton();
    private ImageAcceptAPI imageAcceptor = null;
    private Runnable openHandler = new OpenHandler();
    private Runnable validator = new LayoutRevalidator();
    private ArrayList<ResizeHandle> resizeHandles = new ArrayList();
    private Rectangle dragOutline = null;
    private long dragStartTime = 0L;
    private MouseHandler mouseHandler = new MouseHandler();

    public static boolean isAvailable() {
        return available;
    }

    static GraphicsConfiguration getCompatibleGC(GraphicsDevice gDev) {
        if (available && translucency != null) {
            return translucency.getCompatibleGC(gDev);
        }
        return null;
    }

    private static synchronized String getNextTitle() {
        return "AppShare Hosting Markup #" + ++instanceCount;
    }

    public ApertureFrame(AppSharingHost host, Color outline, Rectangle dispBounds) {
        super(ApertureFrame.getNextTitle(), ApertureFrame.getCompatibleGC(null));
        this.host = host;
        this.display.setBounds(dispBounds);
        this.allowLiveResize = hasWindowTranslucency && host.isLiveRegionResizeAvailable() && host.isShowingRegion();
        this.setBounds(dispBounds);
        this.setFocusableWindowState(false);
        this.setUndecorated(true);
        if (WIN_TRANS_BUG) {
            this.setWindowOpaque(true);
            this.setBackground(Color.WHITE);
        } else {
            this.setBackground(TRANSPARENT);
            this.setWindowOpaque(false);
        }
        if (IS_MAC) {
            this.getRootPane().putClientProperty("apple.awt.draggableWindowBackground", Boolean.FALSE);
        }
        this.setWindowShape(new Rectangle(0, 0, 0, 0));
        this.enableEvents(202L);
        host.setWindowFloating(this, true);
        this.mainPane = new AperturePane();
        this.mainPane.setLineWidth(3);
        this.mainPane.setShowDragHandles(this.allowLiveResize);
        this.mainPane.setBackground(TRANSPARENT);
        if (this.allowLiveResize) {
            this.mainPane.setShowDragHandles(true);
            this.mainPane.addMouseListener(this.mouseHandler);
            this.mainPane.addMouseMotionListener(this.mouseHandler);
        }
        this.resizeHandles.add(new ResizeHandle(ResizeHandlePosition.TopLeft));
        this.resizeHandles.add(new ResizeHandle(ResizeHandlePosition.Top));
        this.resizeHandles.add(new ResizeHandle(ResizeHandlePosition.TopRight));
        this.resizeHandles.add(new ResizeHandle(ResizeHandlePosition.Right));
        this.resizeHandles.add(new ResizeHandle(ResizeHandlePosition.BottomRight));
        this.resizeHandles.add(new ResizeHandle(ResizeHandlePosition.Bottom));
        this.resizeHandles.add(new ResizeHandle(ResizeHandlePosition.BottomLeft));
        this.resizeHandles.add(new ResizeHandle(ResizeHandlePosition.Left));
        this.imageAcceptor = (ImageAcceptAPI)host.getImps().findBest(ImageAcceptAPI.class);
        if (this.imageAcceptor != null) {
            ImageAcceptAccessibleListener ial = new ImageAcceptAccessibleListener(){

                public void onAccessChange() {
                    boolean isAvail = ApertureFrame.this.imageAcceptor != null && ApertureFrame.this.imageAcceptor.isAccessible(1);
                    ApertureFrame.this.snapBtn.setEnabled(isAvail);
                }
            };
            this.imageAcceptor.addAccessibleListener(ial);
        }
        ImageIcon icon = X11_ALPHA_ISSUE && !AppShareDebug.AOI_BUTTONS.show() ? this.i18n.getIcon((PropertiesEnum)StringsProperties.APPSHARINGHOST_APERTUREPANEOPAQUESTOPICON) : this.i18n.getIcon((PropertiesEnum)StringsProperties.APPSHARINGHOST_APERTUREPANESTOPICON);
        this.stopIcon = new AlphaIcon((Icon)icon, DEFAULT_BUTTON_ALPHA);
        this.stopBtn.setIcon((Icon)this.stopIcon);
        this.stopBtn.setMargin(new Insets(0, 0, 0, 0));
        this.stopBtn.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.APPSHARINGHOST_APERTUREPANESTOPTIP));
        this.stopBtn.setFocusable(false);
        this.stopBtn.setOpaque(false);
        this.stopBtn.setBorderPainted(false);
        this.stopBtn.setContentAreaFilled(false);
        this.stopBtn.addActionListener(this);
        if (X11_ALPHA_ISSUE && !AppShareDebug.AOI_BUTTONS.show()) {
            icon = this.i18n.getIcon((PropertiesEnum)StringsProperties.APPSHARINGHOST_APERTUREPANEOPAQUEPAUSEICON);
            this.pauseIcon = new AlphaIcon((Icon)icon, DEFAULT_BUTTON_ALPHA);
            this.pauseBtn.setIcon((Icon)this.pauseIcon);
            icon = this.i18n.getIcon((PropertiesEnum)StringsProperties.APPSHARINGHOST_APERTUREPANEOPAQUESELECTEDPAUSEICON);
            this.pauseSelectedIcon = new AlphaIcon((Icon)icon, DEFAULT_BUTTON_ALPHA);
            this.pauseBtn.setSelectedIcon((Icon)this.pauseSelectedIcon);
        } else {
            icon = this.i18n.getIcon((PropertiesEnum)StringsProperties.APPSHARINGHOST_APERTUREPANEPAUSEICON);
            this.pauseIcon = new AlphaIcon((Icon)icon, DEFAULT_BUTTON_ALPHA);
            this.pauseBtn.setIcon((Icon)this.pauseIcon);
        }
        this.pauseBtn.setMargin(new Insets(0, 0, 0, 0));
        this.pauseBtn.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.APPSHARINGHOST_APERTUREPANEPAUSETIP));
        this.pauseBtn.setFocusable(false);
        this.pauseBtn.setOpaque(false);
        this.pauseBtn.setBorderPainted(false);
        this.pauseBtn.setContentAreaFilled(false);
        this.pauseBtn.addActionListener(this);
        icon = X11_ALPHA_ISSUE && !AppShareDebug.AOI_BUTTONS.show() ? this.i18n.getIcon((PropertiesEnum)StringsProperties.APPSHARINGHOST_APERTUREPANEOPAQUESNAPSHOTICON) : this.i18n.getIcon((PropertiesEnum)StringsProperties.APPSHARINGHOST_APERTUREPANESNAPSHOTICON);
        this.snapIcon = new AlphaIcon((Icon)icon, DEFAULT_BUTTON_ALPHA);
        this.snapBtn.setIcon((Icon)this.snapIcon);
        this.snapBtn.setDisabledIcon(DisabledIcon.getDisabledIcon((Icon)this.snapIcon, (JComponent)this.mainPane));
        this.snapBtn.setMargin(new Insets(0, 0, 0, 0));
        this.snapBtn.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.APPSHARINGHOST_APERTUREPANESNAPSHOTTIP));
        this.snapBtn.setFocusable(false);
        this.snapBtn.setOpaque(false);
        this.snapBtn.setBorderPainted(false);
        this.snapBtn.setContentAreaFilled(false);
        this.snapBtn.addActionListener(this);
        boolean isAvail = this.imageAcceptor != null && this.imageAcceptor.isAccessible(1);
        this.snapBtn.setEnabled(isAvail);
        ButtonVisibilityListener btnVisListener = new ButtonVisibilityListener();
        this.mainPane.addMouseListener(btnVisListener);
        this.mainPane.addMouseMotionListener(btnVisListener);
        this.stopBtn.addMouseListener(btnVisListener);
        this.stopBtn.addMouseMotionListener(btnVisListener);
        this.pauseBtn.addMouseListener(btnVisListener);
        this.pauseBtn.addMouseMotionListener(btnVisListener);
        this.snapBtn.addMouseListener(btnVisListener);
        this.snapBtn.addMouseMotionListener(btnVisListener);
        this.mainPane.add(this.stopBtn);
        this.mainPane.add(this.pauseBtn);
        this.mainPane.add(Box.createRigidArea(new Dimension(8, 8)));
        this.mainPane.add(this.snapBtn);
        this.setContentPane(this.mainPane);
        this.setOutlineColor(outline);
    }

    public void setAperture(Rectangle aperture) {
        this.mainPane.setAperture(aperture);
        SwingRunnerSupport.invokeLater((Runnable)this.validator);
        if (AppShareDebug.AOI_DISPLAY.show()) {
            LogSupport.message((Object)this, (String)"setAperture", (String)("aperture=" + aperture + " bounds=" + this.getBounds()));
        }
    }

    public Rectangle getAperture() {
        return this.mainPane.getAperture();
    }

    public void setOutlineColor(Color c) {
        Color paintCol = c;
        if (hasWindowTranslucency && !X11_ALPHA_ISSUE && !X11_ALPHA_PERFORMANCE && !WIN_TRANS_BUG) {
            paintCol = new Color(c.getRed(), c.getGreen(), c.getBlue(), 192);
        }
        this.mainPane.setForeground(paintCol);
    }

    public void setPauseState(boolean paused) {
        if (this.pauseBtn.isSelected() != paused) {
            this.pauseBtn.setSelected(paused);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object src = ev.getSource();
        if (src == this.stopBtn) {
            this.host.fireShutDown(0);
        } else if (src == this.pauseBtn) {
            this.host.doPause(this.pauseBtn.isSelected());
        } else if (src == this.snapBtn) {
            this.host.doSnapshot();
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent ev) {
        super.processWindowEvent(ev);
        try {
            switch (ev.getID()) {
                case 200: {
                    SwingRunnerSupport.invokeOnEventThread((Runnable)this.openHandler);
                    break;
                }
                case 202: {
                    this.host.setIgnoredWindow(null);
                }
            }
        }
        catch (Throwable t) {
            LogSupport.message((Object)this, (String)"processWindowEvent", (String)("Error handling window event: " + ev.paramString() + "\n" + Debug.getStackTrace((Throwable)t)));
            this.host.hideAperture();
        }
    }

    private void setWindowOpaque(boolean opaque) {
        if (translucency != null) {
            translucency.setWindowOpaque(this, opaque);
        }
    }

    void setWindowShape(Area a) {
        if (a == null) {
            this.setWindowShape(new Rectangle(0, 0, 0, 0));
            return;
        }
        a = new Area(a);
        Point scrnPos = this.getLocation();
        if (scrnPos.x != 0 || scrnPos.y != 0) {
            double dx = -scrnPos.x;
            double dy = -scrnPos.y;
            AffineTransform transform = AffineTransform.getTranslateInstance(dx, dy);
            a = new Area(a);
            a.transform(transform);
        }
        this.setWindowShapeInternal(a);
    }

    void setWindowShape(Rectangle r) {
        if (r == null) {
            r = new Rectangle(0, 0, 0, 0);
        }
        Point scrnPos = this.getLocation();
        if (scrnPos.x != 0 || scrnPos.y != 0) {
            r = new Rectangle(r);
            r.translate(-scrnPos.x, -scrnPos.y);
        }
        this.setWindowShapeInternal(r);
    }

    private void setWindowShapeInternal(Shape shape) {
        if (IS_WIN) {
            this.setAlwaysOnTop(false);
            this.setAlwaysOnTop(true);
        }
        if (translucency != null) {
            translucency.setWindowShape(this, shape);
        }
    }

    private boolean isOnBorder(Point pt) {
        Rectangle r = new Rectangle(this.mainPane.getAperture());
        int lineW = this.mainPane.getLineWidth();
        r.x -= lineW;
        r.y -= lineW;
        r.width += lineW * 2;
        r.height += lineW * 2;
        if (!(r = r.intersection(this.display)).contains(pt)) {
            return false;
        }
        r.x += lineW + 1;
        r.y += lineW + 1;
        r.width -= lineW * 2 + 2;
        r.height -= lineW * 2 + 2;
        return !r.contains(pt);
    }

    private void recomputeHandles() {
        for (ResizeHandle handle : this.resizeHandles) {
            handle.recompute();
        }
    }

    private void setHandleRolloverCursor(Point pt) {
        Rectangle r = this.mainPane.getAperture();
        Cursor cursor = null;
        if (!this.isOnBorder(pt)) {
            cursor = Cursor.getPredefinedCursor(0);
            this.mainPane.setCursor(cursor);
            return;
        }
        for (ResizeHandle handle : this.resizeHandles) {
            if (!handle.isTrigger(pt)) continue;
            cursor = handle.getCursor();
            break;
        }
        if (cursor == null) {
            cursor = Cursor.getPredefinedCursor(12);
        }
        this.mainPane.setCursor(cursor);
    }

    private void setButtonState(AbstractButton btn, boolean isOpaque) {
        if (btn.isOpaque() == isOpaque) {
            return;
        }
        btn.setOpaque(isOpaque);
        btn.setBorderPainted(isOpaque);
        btn.setContentAreaFilled(isOpaque);
        float alpha = 1.0f;
        if (hasWindowTranslucency && !X11_ALPHA_ISSUE) {
            alpha = isOpaque ? 1.0f : 0.5f;
            this.setIconAlpha(btn.getIcon(), alpha);
            this.setIconAlpha(btn.getSelectedIcon(), alpha);
        }
        btn.repaint();
    }

    private void setIconAlpha(Icon icon, float alpha) {
        if (icon instanceof AlphaIcon) {
            AlphaIcon alphaIcon = (AlphaIcon)icon;
            alphaIcon.setAlpha(alpha);
        }
    }

    private int getLuminance(Color c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int lum = (int)(0.3 * (double)r + 0.59 * (double)g + 0.11 * (double)b + 0.5);
        return lum;
    }

    static {
        boolean bl = hasWindowTranslucency = translucency != null && translucency.isWindowTranslucencySupported();
        if (!available) {
            LogSupport.message(ApertureFrame.class, (String)"<clinit>", (String)"No translucent window support, shared region highlighting disabled");
        } else if (!hasWindowTranslucency) {
            LogSupport.message(ApertureFrame.class, (String)"<clinit>", (String)"Window translucency not supported, drag-to-resize region disabled.");
        }
        instanceCount = 0;
    }

    class AperturePane
    extends JPanel {
        private final Rectangle sharedRegion;
        private final Rectangle childBounds;
        private int lineWidth;
        private Area opaqueArea;
        private float childBackgroundAlpha;
        private boolean showDragHandles;

        public AperturePane() {
            this(null);
        }

        public AperturePane(Rectangle aoi) {
            super(null);
            this.sharedRegion = new Rectangle();
            this.childBounds = new Rectangle();
            this.lineWidth = 1;
            this.opaqueArea = null;
            this.childBackgroundAlpha = 0.35f;
            this.showDragHandles = false;
            this.setDoubleBuffered(false);
            this.setOpaque(false);
            this.setAperture(aoi);
        }

        void setShowDragHandles(boolean b) {
            if (this.showDragHandles != b) {
                this.showDragHandles = b;
                this.repaint();
            }
        }

        public int getLineWidth() {
            return this.lineWidth;
        }

        public void setLineWidth(int w) {
            this.lineWidth = w;
            ApertureFrame.this.recomputeHandles();
            this.invalidate();
            this.repaint();
            SwingRunnerSupport.invokeLater((Runnable)ApertureFrame.this.validator);
        }

        public float getChildBackgroundAlpha() {
            return this.childBackgroundAlpha;
        }

        public void setChildBackgroundAlpha(float alpha) {
            if (alpha < 0.0f || alpha > 1.0f) {
                throw new IllegalArgumentException("Invalid alpha: " + alpha);
            }
            this.childBackgroundAlpha = alpha;
            this.repaint();
        }

        public Rectangle getChildBounds() {
            return new Rectangle(this.childBounds);
        }

        public Area getOpaqueArea() {
            if (this.opaqueArea == null) {
                Area result = new Area();
                if (!this.sharedRegion.isEmpty()) {
                    Rectangle r = new Rectangle(this.sharedRegion);
                    r.x -= this.lineWidth;
                    r.y -= this.lineWidth;
                    r.width += 2 * this.lineWidth + 1;
                    r.height += 2 * this.lineWidth + 1;
                    r = r.intersection(ApertureFrame.this.display);
                    result.add(new Area(r));
                    r.x += this.lineWidth;
                    r.y += this.lineWidth;
                    r.width = Math.max(0, r.width - 2 * this.lineWidth - 1);
                    r.height = Math.max(0, r.height - 2 * this.lineWidth - 1);
                    if (!r.isEmpty()) {
                        result.subtract(new Area(r));
                    }
                    if (this.showDragHandles) {
                        for (ResizeHandle handle : ApertureFrame.this.resizeHandles) {
                            result.add(new Area(handle.getPaintBounds()));
                        }
                    }
                }
                if (!this.childBounds.isEmpty()) {
                    result.add(new Area(this.childBounds));
                }
                this.opaqueArea = result;
            }
            return this.opaqueArea;
        }

        public Rectangle getAperture() {
            return this.sharedRegion;
        }

        public void setAperture(Rectangle aoi) {
            if (aoi != null && this.sharedRegion.equals(aoi)) {
                return;
            }
            if (aoi == null) {
                this.sharedRegion.setBounds(0, 0, 0, 0);
            } else {
                this.sharedRegion.setBounds(aoi);
            }
            this.opaqueArea = null;
            this.invalidate();
            ApertureFrame.this.recomputeHandles();
        }

        @Override
        public void doLayout() {
            int pad;
            this.opaqueArea = null;
            if (this.getComponentCount() == 0) {
                this.childBounds.setBounds(this.sharedRegion.x, this.sharedRegion.y, 0, 0);
                if (AppShareDebug.AOI_DISPLAY.show()) {
                    LogSupport.message((Object)this, (String)"doLayout", (String)("No children: aperture=" + this.sharedRegion + " children=" + this.childBounds + " display=" + ApertureFrame.this.display));
                }
                return;
            }
            Insets insets = this.getDisplayInsets();
            int layoutX = ((ApertureFrame)ApertureFrame.this).display.x + insets.left;
            int layoutY = ((ApertureFrame)ApertureFrame.this).display.y + insets.top;
            int layoutW = ((ApertureFrame)ApertureFrame.this).display.width - insets.left - insets.right;
            int layoutH = ((ApertureFrame)ApertureFrame.this).display.height - insets.top - insets.bottom;
            int totalWidth = pad = 3;
            int totalHeight = pad;
            int maxWidth = 0;
            int maxHeight = 0;
            Component[] cmp = this.getComponents();
            for (int ix = 0; ix < cmp.length; ++ix) {
                Dimension size = cmp[ix].getPreferredSize();
                totalWidth += size.width + pad;
                totalHeight += size.height + pad;
                if (size.width > maxWidth) {
                    maxWidth = size.width;
                }
                if (size.height <= maxHeight) continue;
                maxHeight = size.height;
            }
            Point pos = new Point(32768, 32768);
            boolean vertical = false;
            boolean placed = false;
            if (!this.sharedRegion.isEmpty()) {
                if (this.sharedRegion.y - layoutY - this.lineWidth > maxHeight) {
                    placed = true;
                    vertical = false;
                    pos.x = Math.min(this.sharedRegion.x, layoutX + layoutW - totalWidth);
                    pos.y = this.sharedRegion.y - this.lineWidth - maxHeight - 1;
                    this.childBounds.setBounds(pos.x - this.lineWidth, pos.y - this.lineWidth, totalWidth + this.lineWidth + 1, maxHeight + this.lineWidth + 1);
                } else if (layoutH - (this.sharedRegion.y + this.sharedRegion.height - layoutY) - this.lineWidth > maxHeight) {
                    placed = true;
                    vertical = false;
                    pos.x = Math.min(this.sharedRegion.x, layoutX + layoutW - totalWidth);
                    pos.y = this.sharedRegion.y + this.sharedRegion.height + this.lineWidth;
                    this.childBounds.setBounds(pos.x - this.lineWidth, pos.y + 1, totalWidth + this.lineWidth + 1, maxHeight + this.lineWidth - 1);
                } else if (this.sharedRegion.x - layoutX - this.lineWidth > maxWidth) {
                    placed = true;
                    vertical = true;
                    pos.x = this.sharedRegion.x - this.lineWidth - maxWidth - 1;
                    pos.y = Math.min(this.sharedRegion.y, layoutY + layoutH - totalHeight);
                    this.childBounds.setBounds(pos.x - this.lineWidth, pos.y - this.lineWidth, maxWidth + this.lineWidth + 1, totalHeight + this.lineWidth + 1);
                } else if (layoutW - (this.sharedRegion.x + this.sharedRegion.width - layoutX) - this.lineWidth > maxWidth) {
                    placed = true;
                    vertical = true;
                    pos.x = this.sharedRegion.x + this.sharedRegion.width + this.lineWidth;
                    pos.y = Math.min(this.sharedRegion.y, layoutY + layoutH - totalHeight);
                    this.childBounds.setBounds(pos.x + 1, pos.y - this.lineWidth, maxWidth + this.lineWidth - 1, totalHeight + this.lineWidth + 1);
                }
            }
            if (!placed) {
                placed = true;
                vertical = false;
                if (this.sharedRegion.isEmpty()) {
                    this.sharedRegion.setLocation(pos.x + totalWidth, this.childBounds.y);
                    pos.x = layoutX + layoutW - totalWidth;
                } else {
                    pos.x = Math.min(this.sharedRegion.x + this.sharedRegion.width - totalWidth, layoutX + layoutW - totalWidth);
                }
                pos.y = layoutY + this.lineWidth + 1;
                this.childBounds.setBounds(pos.x - this.lineWidth, layoutY + this.lineWidth - 1, totalWidth + this.lineWidth, maxHeight + this.lineWidth);
            }
            SwingUtilities.convertPointFromScreen(pos, this);
            if (vertical) {
                pos.y += pad;
            } else {
                pos.x += pad;
            }
            for (int ix = 0; ix < cmp.length; ++ix) {
                Dimension size = cmp[ix].getPreferredSize();
                cmp[ix].setBounds(pos.x, pos.y, size.width, size.height);
                if (vertical) {
                    pos.y += size.height + pad;
                    continue;
                }
                pos.x += size.width + pad;
            }
            if (AppShareDebug.AOI_DISPLAY.show()) {
                LogSupport.message((Object)this, (String)"doLayout", (String)("aperture=" + this.sharedRegion + " children=" + this.childBounds + " display=" + ApertureFrame.this.display + " insets=" + insets + " opaqueBounds=" + this.getOpaqueArea().getBounds()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g.create();
            try {
                Rectangle r;
                Composite origComposite = g2.getComposite();
                try {
                    g2.setComposite(AlphaComposite.Src);
                    g2.setColor(this.getBackground());
                    g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
                finally {
                    g2.setComposite(origComposite);
                }
                Color col = this.getForeground();
                Point origin = this.getLocationOnScreen();
                g2.translate(-origin.x, -origin.y);
                int x1 = Math.max(((ApertureFrame)ApertureFrame.this).display.x, this.sharedRegion.x - this.lineWidth + 1);
                int y1 = Math.max(((ApertureFrame)ApertureFrame.this).display.y, this.sharedRegion.y - this.lineWidth + 1);
                int w1 = Math.min(((ApertureFrame)ApertureFrame.this).display.width, this.sharedRegion.width + this.lineWidth * 2 - 2);
                int h1 = Math.min(((ApertureFrame)ApertureFrame.this).display.height, this.sharedRegion.height + this.lineWidth * 2 - 2);
                g2.setColor(col);
                g2.fill(this.getOpaqueArea());
                if (this.showDragHandles && ApertureFrame.this.dragOutline == null) {
                    Color c2 = ApertureFrame.this.getLuminance(col) > 128 ? Color.BLACK : Color.WHITE;
                    for (ResizeHandle handle : ApertureFrame.this.resizeHandles) {
                        Rectangle hb = handle.getPaintBounds();
                        g2.setColor(col);
                        g2.drawRect(hb.x - 1, hb.y - 1, hb.width + 1, hb.height + 1);
                        g2.setColor(c2);
                        g2.fillRect(hb.x, hb.y, hb.width, hb.height);
                    }
                }
                if ((r = ApertureFrame.this.dragOutline) != null) {
                    r = ApertureFrame.this.display.intersection(r);
                    if (r.width > 21 && r.height > 21) {
                        Stroke origStroke = g2.getStroke();
                        long elapsed = System.currentTimeMillis() - ApertureFrame.this.dragStartTime;
                        double cycles = (double)elapsed / 350.0;
                        float phase = (float)((cycles - Math.floor(cycles)) * 18.0);
                        BasicStroke stroke = new BasicStroke(this.lineWidth, 0, 0, 1.0f, DASH_DATA, phase);
                        g2.setStroke(stroke);
                        g2.setColor(Color.gray);
                        g2.drawRect(r.x - this.lineWidth + 1, r.y - this.lineWidth + 1, r.width + this.lineWidth * 2 - 2, r.height + this.lineWidth * 2 - 2);
                        g2.setStroke(origStroke);
                    }
                }
            }
            finally {
                g2.dispose();
            }
        }

        private Insets getDisplayInsets() {
            Insets result = null;
            GraphicsConfiguration gc = this.getGraphicsConfiguration();
            if (gc != null) {
                result = GuiUtils.getScreenInsets((GraphicsConfiguration)gc);
            }
            if (result == null) {
                result = new Insets(0, 0, 0, 0);
            }
            return result;
        }
    }

    class ButtonVisibilityListener
    extends MouseAdapter
    implements MouseMotionListener {
        ButtonVisibilityListener() {
        }

        @Override
        public void mousePressed(MouseEvent ev) {
            this.updateOpacity(ev);
        }

        @Override
        public void mouseReleased(MouseEvent ev) {
            this.updateOpacity(ev);
        }

        @Override
        public void mouseEntered(MouseEvent ev) {
            this.updateOpacity(ev);
        }

        @Override
        public void mouseExited(MouseEvent ev) {
            this.updateOpacity(ev);
        }

        @Override
        public void mouseMoved(MouseEvent ev) {
            this.updateOpacity(ev);
        }

        @Override
        public void mouseDragged(MouseEvent ev) {
            this.updateOpacity(ev);
        }

        private void updateOpacity(MouseEvent ev) {
            Point pt = new Point(ev.getPoint());
            SwingUtilities.convertPointToScreen(pt, ev.getComponent());
            boolean isOpaque = ApertureFrame.this.mainPane.getOpaqueArea().contains(pt);
            ApertureFrame.this.setButtonState(ApertureFrame.this.stopBtn, isOpaque);
            ApertureFrame.this.setButtonState(ApertureFrame.this.pauseBtn, isOpaque);
            ApertureFrame.this.setButtonState(ApertureFrame.this.snapBtn, isOpaque);
            float childAlpha = 1.0f;
            if (!X11_ALPHA_ISSUE && hasWindowTranslucency) {
                float f = childAlpha = isOpaque ? 0.75f : 0.35f;
            }
            if (ApertureFrame.this.mainPane.getChildBackgroundAlpha() != childAlpha) {
                ApertureFrame.this.mainPane.setChildBackgroundAlpha(childAlpha);
                ApertureFrame.this.mainPane.repaint();
            }
        }
    }

    private class LayoutRevalidator
    implements Runnable {
        private Runnable repainter;
        private LightweightTimer repaintTimer;

        private LayoutRevalidator() {
            this.repainter = new Repainter();
            this.repaintTimer = new LightweightTimer(this.repainter);
        }

        @Override
        public void run() {
            ApertureFrame.this.mainPane.validate();
            ApertureFrame.this.setWindowShape(ApertureFrame.this.mainPane.getOpaqueArea());
            ApertureFrame.this.mainPane.repaint();
            this.repaintTimer.scheduleIn(150L);
        }
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private ResizeHandle dragHandle = null;
        private Point dragStartLoc = null;
        private Point dragBase = null;
        private boolean dragging = false;
        private boolean resizing = false;
        private Runnable repainter = new DragRepainter();
        private LightweightTimer animator = new LightweightTimer(2, this.repainter);

        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent ev) {
            Rectangle aoi = ApertureFrame.this.mainPane.getAperture();
            Point pt = new Point(ev.getPoint());
            SwingUtilities.convertPointToScreen(pt, ev.getComponent());
            Cursor cursor = null;
            for (ResizeHandle handle : ApertureFrame.this.resizeHandles) {
                if (!handle.isTrigger(pt)) continue;
                this.startDrag(handle, pt, aoi);
                cursor = handle.getCursor();
                break;
            }
            if (!this.dragging && ApertureFrame.this.isOnBorder(pt)) {
                this.startDrag(null, pt, aoi);
                cursor = Cursor.getPredefinedCursor(12);
            }
            if (this.dragging) {
                ApertureFrame.this.mainPane.setCursor(cursor);
                ApertureFrame.this.setWindowShape(ApertureFrame.this.display);
                if (WIN_TRANS_BUG) {
                    ApertureFrame.this.setWindowOpaque(false);
                }
            }
            ApertureFrame.this.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent ev) {
            Rectangle neoRegion = ApertureFrame.this.dragOutline;
            Point pt = new Point(ev.getPoint());
            SwingUtilities.convertPointToScreen(pt, ev.getComponent());
            ApertureFrame.this.setHandleRolloverCursor(pt);
            if (WIN_TRANS_BUG) {
                ApertureFrame.this.setWindowOpaque(true);
            }
            ApertureFrame.this.setWindowShape(ApertureFrame.this.mainPane.getOpaqueArea());
            ApertureFrame.this.repaint();
            this.clearDrag();
            if (neoRegion == null) {
                return;
            }
            neoRegion = neoRegion.intersection(ApertureFrame.this.display);
            if (neoRegion.width <= 21) {
                return;
            }
            if (neoRegion.height <= 21) {
                return;
            }
            if (!ApertureFrame.this.mainPane.getAperture().equals(neoRegion)) {
                ApertureFrame.this.host.changeRegion(neoRegion);
            }
        }

        @Override
        public void mouseMoved(MouseEvent ev) {
            Point pt = new Point(ev.getPoint());
            SwingUtilities.convertPointToScreen(pt, ev.getComponent());
            ApertureFrame.this.setHandleRolloverCursor(pt);
        }

        @Override
        public void mouseDragged(MouseEvent ev) {
            this.repaintDrag();
            if (!this.dragging) {
                return;
            }
            Point pt = new Point(ev.getPoint());
            SwingUtilities.convertPointToScreen(pt, ev.getComponent());
            this.updateDrag(pt);
            this.repaintDrag();
        }

        private void startDrag(ResizeHandle handle, Point startLoc, Rectangle r) {
            this.dragging = true;
            this.resizing = handle != null;
            this.dragHandle = handle;
            this.dragStartLoc = new Point(startLoc);
            this.dragBase = r.getLocation();
            ApertureFrame.this.dragOutline = new Rectangle(r);
            if (handle != null) {
                handle.updateDragRegion(startLoc);
            }
            ApertureFrame.this.dragStartTime = System.currentTimeMillis();
            this.animator.scheduleEvery(40L);
        }

        private void updateDrag(Point pt) {
            this.repaintDrag();
            if (this.dragHandle != null) {
                this.dragHandle.updateDragRegion(pt);
            } else {
                int dx = pt.x - this.dragStartLoc.x;
                int dy = pt.y - this.dragStartLoc.y;
                int x0 = this.dragBase.x + dx;
                int y0 = this.dragBase.y + dy;
                x0 = Math.max(((ApertureFrame)ApertureFrame.this).display.x, Math.min(((ApertureFrame)ApertureFrame.this).display.x + ((ApertureFrame)ApertureFrame.this).display.width - ((ApertureFrame)ApertureFrame.this).dragOutline.width, x0));
                y0 = Math.max(((ApertureFrame)ApertureFrame.this).display.y, Math.min(((ApertureFrame)ApertureFrame.this).display.y + ((ApertureFrame)ApertureFrame.this).display.height - ((ApertureFrame)ApertureFrame.this).dragOutline.height, y0));
                ((ApertureFrame)ApertureFrame.this).dragOutline.x = x0;
                ((ApertureFrame)ApertureFrame.this).dragOutline.y = y0;
            }
            this.repaintDrag();
        }

        private void clearDrag() {
            this.animator.cancel();
            this.dragging = false;
            this.resizing = false;
            this.dragHandle = null;
            this.dragStartLoc = null;
            ApertureFrame.this.dragOutline = null;
            this.dragBase = null;
            ApertureFrame.this.dragStartTime = 0L;
        }

        private void repaintDrag() {
            if (ApertureFrame.this.dragOutline == null) {
                ApertureFrame.this.repaint();
            } else {
                int w = Math.max(7, ApertureFrame.this.mainPane.getLineWidth());
                Point p = ApertureFrame.this.getLocation();
                ApertureFrame.this.repaint(((ApertureFrame)ApertureFrame.this).dragOutline.x - p.x - w - 3, ((ApertureFrame)ApertureFrame.this).dragOutline.y - p.y - w - 3, ((ApertureFrame)ApertureFrame.this).dragOutline.width + 2 * w + 6, ((ApertureFrame)ApertureFrame.this).dragOutline.height + 2 * w + 6);
            }
        }

        private class DragRepainter
        implements Runnable {
            private DragRepainter() {
            }

            @Override
            public void run() {
                MouseHandler.this.repaintDrag();
                if (!MouseHandler.this.dragging) {
                    MouseHandler.this.clearDrag();
                }
            }
        }
    }

    private class OpenHandler
    implements Runnable {
        private OpenHandler() {
        }

        @Override
        public void run() {
            if (ApertureFrame.this.host == null) {
                return;
            }
            if (!ApertureFrame.this.host.setIgnoredWindow(ApertureFrame.this)) {
                SwingRunnerSupport.invokeLater((Runnable)this);
                return;
            }
            Runnable updater = new Runnable(){

                @Override
                public void run() {
                    ApertureFrame.this.mainPane.repaint();
                }
            };
            byte context = 2;
            LightweightTimer forcedUpdate = new LightweightTimer(context, updater);
            forcedUpdate.scheduleIn(500L);
        }
    }

    private class Repainter
    implements Runnable {
        private Repainter() {
        }

        @Override
        public void run() {
            ApertureFrame.this.mainPane.repaint();
        }
    }

    private class ResizeHandle {
        private final ResizeHandlePosition pos;
        private final Point location = new Point();
        private final Point centreLoc = new Point();
        private final Rectangle paintBounds = new Rectangle();

        ResizeHandle(ResizeHandlePosition pos) {
            this.pos = pos;
            this.recompute();
        }

        public String toString() {
            return "ResizeHandle " + (Object)((Object)this.pos) + " @ " + this.getLocation();
        }

        public boolean isTrigger(Point pt) {
            Rectangle b = this.getPaintBounds();
            return b.contains(pt);
        }

        public Point getLocation() {
            return this.location;
        }

        public Point getCentreLocation() {
            return this.centreLoc;
        }

        public Rectangle getPaintBounds() {
            return this.paintBounds;
        }

        void recompute() {
            this.location.setLocation(this.computeLocation(this.pos));
            this.centreLoc.setLocation(this.computeCentreLocation(this.pos));
            this.paintBounds.setBounds(this.computePaintBounds(this.centreLoc));
        }

        private Point computeLocation(ResizeHandlePosition pos) {
            Rectangle aoi;
            Point result = new Point();
            Rectangle rectangle = aoi = ApertureFrame.this.mainPane == null ? null : ApertureFrame.this.mainPane.getAperture();
            if (aoi != null) {
                switch (pos) {
                    case TopLeft: {
                        result.x = aoi.x;
                        result.y = aoi.y;
                        break;
                    }
                    case Top: {
                        result.x = aoi.x + aoi.width / 2;
                        result.y = aoi.y;
                        break;
                    }
                    case TopRight: {
                        result.x = aoi.x + aoi.width;
                        result.y = aoi.y;
                        break;
                    }
                    case Right: {
                        result.x = aoi.x + aoi.width;
                        result.y = aoi.y + aoi.height / 2;
                        break;
                    }
                    case BottomRight: {
                        result.x = aoi.x + aoi.width;
                        result.y = aoi.y + aoi.height;
                        break;
                    }
                    case Bottom: {
                        result.x = aoi.x + aoi.width / 2;
                        result.y = aoi.y + aoi.height;
                        break;
                    }
                    case BottomLeft: {
                        result.x = aoi.x;
                        result.y = aoi.y + aoi.height;
                        break;
                    }
                    case Left: {
                        result.x = aoi.x;
                        result.y = aoi.y + aoi.height / 2;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid ResizeHandle position: " + (Object)((Object)pos));
                    }
                }
            }
            return result;
        }

        private Point computeCentreLocation(ResizeHandlePosition pos) {
            Point loc = this.computeLocation(pos);
            int w = ApertureFrame.this.mainPane == null ? 1 : ApertureFrame.this.mainPane.getLineWidth();
            switch (pos) {
                case TopLeft: {
                    loc.x = Math.max(((ApertureFrame)ApertureFrame.this).display.x + w / 2, loc.x - w / 2);
                    loc.y = Math.max(((ApertureFrame)ApertureFrame.this).display.y + w / 2, loc.y - w / 2);
                    break;
                }
                case Top: {
                    loc.y = Math.max(((ApertureFrame)ApertureFrame.this).display.y + w / 2, loc.y - w / 2);
                    break;
                }
                case TopRight: {
                    loc.x = Math.min(((ApertureFrame)ApertureFrame.this).display.x + ((ApertureFrame)ApertureFrame.this).display.width - w / 2, loc.x + (w + 1) / 2 + 1);
                    loc.y = Math.max(((ApertureFrame)ApertureFrame.this).display.y + w / 2, loc.y - w / 2);
                    break;
                }
                case Right: {
                    loc.x = Math.min(((ApertureFrame)ApertureFrame.this).display.x + ((ApertureFrame)ApertureFrame.this).display.width - w / 2, loc.x + (w + 1) / 2 + 1);
                    break;
                }
                case BottomRight: {
                    loc.x = Math.min(((ApertureFrame)ApertureFrame.this).display.x + ((ApertureFrame)ApertureFrame.this).display.width - w / 2, loc.x + (w + 1) / 2 + 1);
                    loc.y = Math.min(((ApertureFrame)ApertureFrame.this).display.y + ((ApertureFrame)ApertureFrame.this).display.height - w / 2, loc.y + (w + 1) / 2 + 1);
                    break;
                }
                case Bottom: {
                    loc.y = Math.min(((ApertureFrame)ApertureFrame.this).display.y + ((ApertureFrame)ApertureFrame.this).display.height - w / 2, loc.y + (w + 1) / 2 + 1);
                    break;
                }
                case BottomLeft: {
                    loc.x = Math.max(((ApertureFrame)ApertureFrame.this).display.x + w / 2, loc.x - w / 2);
                    loc.y = Math.min(((ApertureFrame)ApertureFrame.this).display.y + ((ApertureFrame)ApertureFrame.this).display.height - w / 2, loc.y + (w + 1) / 2 + 1);
                    break;
                }
                case Left: {
                    loc.x = Math.max(((ApertureFrame)ApertureFrame.this).display.x + w / 2, loc.x - w / 2);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid ResizeHandle position: " + (Object)((Object)pos));
                }
            }
            return loc;
        }

        private Rectangle computePaintBounds(Point loc) {
            int dW = 4;
            return new Rectangle(loc.x - dW, loc.y - dW, 7, 7);
        }

        public Cursor getCursor() {
            switch (this.pos) {
                case TopLeft: {
                    return Cursor.getPredefinedCursor(6);
                }
                case Top: {
                    return Cursor.getPredefinedCursor(8);
                }
                case TopRight: {
                    return Cursor.getPredefinedCursor(7);
                }
                case Right: {
                    return Cursor.getPredefinedCursor(11);
                }
                case BottomRight: {
                    return Cursor.getPredefinedCursor(5);
                }
                case Bottom: {
                    return Cursor.getPredefinedCursor(9);
                }
                case BottomLeft: {
                    return Cursor.getPredefinedCursor(4);
                }
                case Left: {
                    return Cursor.getPredefinedCursor(10);
                }
            }
            throw new IllegalStateException("Invalid ResizeHandle position: " + (Object)((Object)this.pos));
        }

        public ResizeHandlePosition getOppositePosition() {
            switch (this.pos) {
                case TopLeft: {
                    return ResizeHandlePosition.BottomRight;
                }
                case Top: {
                    return ResizeHandlePosition.Bottom;
                }
                case TopRight: {
                    return ResizeHandlePosition.BottomLeft;
                }
                case Right: {
                    return ResizeHandlePosition.Left;
                }
                case BottomRight: {
                    return ResizeHandlePosition.TopLeft;
                }
                case Bottom: {
                    return ResizeHandlePosition.Top;
                }
                case BottomLeft: {
                    return ResizeHandlePosition.TopRight;
                }
                case Left: {
                    return ResizeHandlePosition.Right;
                }
            }
            throw new IllegalStateException("Invalid ResizeHandle position: " + (Object)((Object)this.pos));
        }

        void updateDragRegion(Point pt) {
            switch (this.pos) {
                case TopLeft: 
                case TopRight: 
                case BottomRight: 
                case BottomLeft: {
                    this.updateDragCorner(pt);
                    break;
                }
                case Top: {
                    ((ApertureFrame)ApertureFrame.this).dragOutline.y = pt.y;
                    break;
                }
                case Bottom: {
                    ((ApertureFrame)ApertureFrame.this).dragOutline.height = pt.y - ((ApertureFrame)ApertureFrame.this).dragOutline.y - 1;
                    break;
                }
                case Left: {
                    ((ApertureFrame)ApertureFrame.this).dragOutline.x = pt.x;
                    break;
                }
                case Right: {
                    ((ApertureFrame)ApertureFrame.this).dragOutline.width = pt.x - ((ApertureFrame)ApertureFrame.this).dragOutline.x - 1;
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid ResizeHandle position: " + (Object)((Object)this.pos));
                }
            }
        }

        private void updateDragCorner(Point pt) {
            Point opposite = this.computeLocation(this.getOppositePosition());
            int dx = pt.x - opposite.x;
            int dy = pt.y - opposite.y;
            if (dx < 0) {
                ((ApertureFrame)ApertureFrame.this).dragOutline.x = pt.x;
                ((ApertureFrame)ApertureFrame.this).dragOutline.width = -dx;
            } else {
                ((ApertureFrame)ApertureFrame.this).dragOutline.x = opposite.x;
                ((ApertureFrame)ApertureFrame.this).dragOutline.width = dx;
            }
            if (dy < 0) {
                ((ApertureFrame)ApertureFrame.this).dragOutline.y = pt.y;
                ((ApertureFrame)ApertureFrame.this).dragOutline.height = -dy;
            } else {
                ((ApertureFrame)ApertureFrame.this).dragOutline.y = opposite.y;
                ((ApertureFrame)ApertureFrame.this).dragOutline.height = dy;
            }
        }
    }

    static enum ResizeHandlePosition {
        TopLeft,
        Top,
        TopRight,
        Right,
        BottomRight,
        Bottom,
        BottomLeft,
        Left;

    }
}

