/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.GlyphList;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class Type1
extends BaseFont {
    private String FontName;
    private String FullName;
    private String FamilyName;
    private String Weight;
    private float ItalicAngle;
    private boolean IsFixedPitch;
    private String CharacterSet;
    private int llx;
    private int lly;
    private int urx;
    private int ury;
    private int UnderlinePosition;
    private int UnderlineThickness;
    private String EncodingScheme;
    private int CapHeight;
    private int XHeight;
    private int Ascender;
    private int Descender;
    private int StdHW;
    private int StdVW;
    private ArrayList CharMetrics;
    private HashMap KernPairs;
    private String fileName;
    private boolean builtinFont;
    private static final int[] pfbTypes = new int[]{1, 2, 1};

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Type1(String string, String string2, boolean bl) throws DocumentException, IOException {
        block17: {
            this.Weight = "";
            this.ItalicAngle = 0.0f;
            this.IsFixedPitch = false;
            this.llx = -50;
            this.lly = -200;
            this.urx = 1000;
            this.ury = 900;
            this.UnderlinePosition = -100;
            this.UnderlineThickness = 50;
            this.EncodingScheme = "FontSpecific";
            this.CapHeight = 700;
            this.Ascender = 800;
            this.Descender = -200;
            this.StdVW = 80;
            this.CharMetrics = new ArrayList();
            this.KernPairs = new HashMap();
            this.builtinFont = false;
            this.normalizeEncoding(string2);
            this.embedded = bl;
            this.fileName = string;
            InputStream inputStream = null;
            if (BaseFont.BuiltinFonts14.containsKey(string)) {
                this.embedded = false;
                this.builtinFont = true;
                try {
                    inputStream = this.getClass().getResourceAsStream("afm/" + string + ".afm");
                    if (inputStream == null) {
                        throw new DocumentException(string + " not found as resource.");
                    }
                    this.process(inputStream);
                    Object var6_5 = null;
                    if (inputStream == null) break block17;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    if (inputStream == null) throw throwable;
                    try {
                        inputStream.close();
                        throw throwable;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (Exception exception) {}
                inputStream.close();
            } else {
                if (!string.toLowerCase().endsWith(".afm")) throw new DocumentException(string + " is not an AFM font file.");
                try {
                    inputStream = new FileInputStream(string);
                    if (inputStream == null) {
                        throw new DocumentException(string + " not found as file.");
                    }
                    this.process(inputStream);
                    Object var9_10 = null;
                    if (inputStream == null) break block17;
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    if (inputStream == null) throw throwable;
                    try {
                        inputStream.close();
                        throw throwable;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (Exception exception) {}
                inputStream.close();
            }
        }
        try {
            this.EncodingScheme = this.EncodingScheme.trim();
            if (this.EncodingScheme.equals("AdobeStandardEncoding") || this.EncodingScheme.equals("StandardEncoding")) {
                this.fontSpecific = false;
            }
            this.createEncoding();
            return;
        }
        catch (Exception exception) {
            throw new DocumentException(exception.getMessage());
        }
    }

    protected int getRawWidth(int n, String string) {
        try {
            if (string == null) {
                int n2 = 0;
                while (n2 < this.CharMetrics.size()) {
                    Object[] objectArray = (Object[])this.CharMetrics.get(n2);
                    if ((Integer)objectArray[0] == n) {
                        return (Integer)objectArray[1];
                    }
                    ++n2;
                }
            } else {
                if (string.equals(".notdef")) {
                    return 0;
                }
                int n3 = 0;
                while (n3 < this.CharMetrics.size()) {
                    Object[] objectArray = (Object[])this.CharMetrics.get(n3);
                    if (string.equals(objectArray[2])) {
                        return (Integer)objectArray[1];
                    }
                    ++n3;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public int getKerning(char c, char c2) {
        String string = GlyphList.unicodeToName(c);
        if (string == null) {
            return 0;
        }
        String string2 = GlyphList.unicodeToName(c2);
        if (string2 == null) {
            return 0;
        }
        Object[] objectArray = (Object[])this.KernPairs.get(string);
        if (objectArray == null) {
            return 0;
        }
        int n = 0;
        while (n < objectArray.length) {
            if (string2.equals(objectArray[n])) {
                return (Integer)objectArray[n + 1];
            }
            n += 2;
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    public void process(InputStream var1_1) throws DocumentException, IOException {
        var2_2 = new BufferedReader(new InputStreamReader(var1_1));
        var4_3 = false;
        while ((var3_4 = var2_2.readLine()) != null) {
            var5_5 = new StringTokenizer(var3_4);
            if (!var5_5.hasMoreTokens()) continue;
            var6_6 = var5_5.nextToken();
            if (var6_6.equals("FontName")) {
                this.FontName = var5_5.nextToken("\u00ff").substring(1);
                continue;
            }
            if (var6_6.equals("FullName")) {
                this.FullName = var5_5.nextToken("\u00ff").substring(1);
                continue;
            }
            if (var6_6.equals("FamilyName")) {
                this.FamilyName = var5_5.nextToken("\u00ff").substring(1);
                continue;
            }
            if (var6_6.equals("Weight")) {
                this.Weight = var5_5.nextToken("\u00ff").substring(1);
                continue;
            }
            if (var6_6.equals("ItalicAngle")) {
                this.ItalicAngle = Float.parseFloat(var5_5.nextToken());
                continue;
            }
            if (var6_6.equals("IsFixedPitch")) {
                this.IsFixedPitch = var5_5.nextToken().equals("true");
                continue;
            }
            if (var6_6.equals("CharacterSet")) {
                this.CharacterSet = var5_5.nextToken("\u00ff").substring(1);
                continue;
            }
            if (var6_6.equals("FontBBox")) {
                this.llx = (int)Float.parseFloat(var5_5.nextToken());
                this.lly = (int)Float.parseFloat(var5_5.nextToken());
                this.urx = (int)Float.parseFloat(var5_5.nextToken());
                this.ury = (int)Float.parseFloat(var5_5.nextToken());
                continue;
            }
            if (var6_6.equals("UnderlinePosition")) {
                this.UnderlinePosition = (int)Float.parseFloat(var5_5.nextToken());
                continue;
            }
            if (var6_6.equals("UnderlineThickness")) {
                this.UnderlineThickness = (int)Float.parseFloat(var5_5.nextToken());
                continue;
            }
            if (var6_6.equals("EncodingScheme")) {
                this.EncodingScheme = var5_5.nextToken("\u00ff").substring(1);
                continue;
            }
            if (var6_6.equals("CapHeight")) {
                this.CapHeight = (int)Float.parseFloat(var5_5.nextToken());
                continue;
            }
            if (var6_6.equals("XHeight")) {
                this.XHeight = (int)Float.parseFloat(var5_5.nextToken());
                continue;
            }
            if (var6_6.equals("Ascender")) {
                this.Ascender = (int)Float.parseFloat(var5_5.nextToken());
                continue;
            }
            if (var6_6.equals("Descender")) {
                this.Descender = (int)Float.parseFloat(var5_5.nextToken());
                continue;
            }
            if (var6_6.equals("StdHW")) {
                this.StdHW = (int)Float.parseFloat(var5_5.nextToken());
                continue;
            }
            if (var6_6.equals("StdVW")) {
                this.StdVW = (int)Float.parseFloat(var5_5.nextToken());
                continue;
            }
            if (!var6_6.equals("StartCharMetrics")) continue;
            var4_3 = true;
            break;
        }
        if (var4_3) ** GOTO lbl91
        throw new DocumentException("Missing StartCharMetrics in " + this.fileName);
lbl-1000:
        // 1 sources

        {
            var5_5 = new StringTokenizer(var3_4);
            if (!var5_5.hasMoreTokens()) continue;
            var6_6 = var5_5.nextToken();
            if (var6_6.equals("EndCharMetrics")) {
                var4_3 = false;
                break;
            }
            var7_7 = new Integer(-1);
            var8_8 = new Integer(250);
            var9_9 = "";
            var5_5 = new StringTokenizer(var3_4, ";");
            while (var5_5.hasMoreTokens()) {
                var10_10 = new StringTokenizer(var5_5.nextToken());
                if (!var10_10.hasMoreTokens()) continue;
                var6_6 = var10_10.nextToken();
                if (var6_6.equals("C")) {
                    var7_7 = Integer.valueOf(var10_10.nextToken());
                    continue;
                }
                if (var6_6.equals("WX")) {
                    var8_8 = Integer.valueOf(var10_10.nextToken());
                    continue;
                }
                if (!var6_6.equals("N")) continue;
                var9_9 = var10_10.nextToken();
            }
            this.CharMetrics.add(new Object[]{var7_7, var8_8, var9_9});
lbl91:
            // 3 sources

            ** while ((var3_4 = var2_2.readLine()) != null)
        }
lbl92:
        // 2 sources

        if (!var4_3) ** GOTO lbl102
        throw new DocumentException("Missing EndCharMetrics in " + this.fileName);
lbl-1000:
        // 1 sources

        {
            var5_5 = new StringTokenizer(var3_4);
            if (!var5_5.hasMoreTokens()) continue;
            var6_6 = var5_5.nextToken();
            if (var6_6.equals("EndFontMetrics")) {
                return;
            }
            if (!var6_6.equals("StartKernPairs")) continue;
            var4_3 = true;
            break;
lbl102:
            // 3 sources

            ** while ((var3_4 = var2_2.readLine()) != null)
        }
lbl103:
        // 2 sources

        if (var4_3) ** GOTO lbl128
        throw new DocumentException("Missing EndFontMetrics in " + this.fileName);
lbl-1000:
        // 1 sources

        {
            var5_5 = new StringTokenizer(var3_4);
            if (!var5_5.hasMoreTokens()) continue;
            var6_6 = var5_5.nextToken();
            if (var6_6.equals("KPX")) {
                var7_7 = var5_5.nextToken();
                var8_8 = var5_5.nextToken();
                var9_9 = new Integer((int)Float.parseFloat(var5_5.nextToken()));
                var10_10 = (Object[])this.KernPairs.get(var7_7);
                if (var10_10 == null) {
                    this.KernPairs.put(var7_7, new Object[]{var8_8, var9_9});
                    continue;
                }
                var11_11 = var10_10.length;
                var12_12 = new Object[var11_11 + 2];
                System.arraycopy(var10_10, 0, var12_12, 0, var11_11);
                var12_12[var11_11] = var8_8;
                var12_12[var11_11 + 1] = var9_9;
                this.KernPairs.put(var7_7, var12_12);
                continue;
            }
            if (!var6_6.equals("EndKernPairs")) continue;
            var4_3 = false;
            break;
lbl128:
            // 5 sources

            ** while ((var3_4 = var2_2.readLine()) != null)
        }
lbl129:
        // 2 sources

        if (var4_3) {
            throw new DocumentException("Missing EndKernPairs in " + this.fileName);
        }
        var2_2.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PdfStream getFontStream() throws DocumentException {
        if (this.builtinFont) return null;
        if (!this.embedded) {
            return null;
        }
        InputStream inputStream = null;
        try {
            try {
                File file = new File(this.fileName.substring(0, this.fileName.length() - 3) + "pfb");
                int n = (int)file.length();
                byte[] byArray = new byte[n - 18];
                inputStream = new FileInputStream(file);
                int[] nArray = new int[3];
                int n2 = 0;
                int n3 = 0;
                block7: while (true) {
                    if (n3 >= 3) break;
                    if (inputStream.read() != 128) {
                        throw new DocumentException("Start marker missing in " + file.getName());
                    }
                    if (inputStream.read() != pfbTypes[n3]) {
                        throw new DocumentException("Incorrect segment type in " + file.getName());
                    }
                    int n4 = inputStream.read();
                    n4 += inputStream.read() << 8;
                    n4 += inputStream.read() << 16;
                    nArray[n3] = n4 += inputStream.read() << 24;
                    while (true) {
                        if (n4 == 0) {
                            ++n3;
                            continue block7;
                        }
                        int n5 = inputStream.read(byArray, n2, n4);
                        if (n5 < 0) {
                            throw new DocumentException("Premature end in " + file.getName());
                        }
                        n2 += n5;
                        n4 -= n5;
                    }
                    break;
                }
                BaseFont.StreamFont streamFont = new BaseFont.StreamFont(byArray, nArray);
                Object var11_12 = null;
                if (inputStream == null) return streamFont;
                try {
                    inputStream.close();
                    return streamFont;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return streamFont;
            }
            catch (Exception exception) {
                throw new DocumentException(exception.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (inputStream == null) throw throwable;
            try {}
            catch (Exception exception) {
                throw throwable;
            }
            inputStream.close();
            throw throwable;
        }
    }

    private PdfDictionary getFontDescriptor(PdfIndirectReference pdfIndirectReference) throws DocumentException {
        if (this.builtinFont) {
            return null;
        }
        PdfDictionary pdfDictionary = new PdfDictionary(new PdfName("FontDescriptor"));
        pdfDictionary.put(new PdfName("Ascent"), new PdfNumber(this.Ascender));
        pdfDictionary.put(new PdfName("CapHeight"), new PdfNumber(this.CapHeight));
        pdfDictionary.put(new PdfName("Descent"), new PdfNumber(this.Descender));
        pdfDictionary.put(new PdfName("FontBBox"), new PdfRectangle(this.llx, this.lly, this.urx, this.ury));
        pdfDictionary.put(new PdfName("FontName"), new PdfName(this.FontName));
        pdfDictionary.put(new PdfName("ItalicAngle"), new PdfNumber(this.ItalicAngle));
        pdfDictionary.put(new PdfName("StemV"), new PdfNumber(this.StdVW));
        if (pdfIndirectReference != null) {
            pdfDictionary.put(new PdfName("FontFile"), pdfIndirectReference);
        }
        int n = 0;
        if (this.IsFixedPitch) {
            n |= 1;
        }
        n |= this.fontSpecific ? 4 : 32;
        if (this.ItalicAngle < 0.0f) {
            n |= 0x40;
        }
        if (this.FontName.indexOf("Caps") >= 0 || this.FontName.endsWith("SC")) {
            n |= 0x20000;
        }
        if (this.Weight.equals("Bold")) {
            n |= 0x40000;
        }
        pdfDictionary.put(new PdfName("Flags"), new PdfNumber(n));
        return pdfDictionary;
    }

    private PdfDictionary getFontType(PdfIndirectReference pdfIndirectReference) throws DocumentException {
        PdfObject pdfObject;
        PdfDictionary pdfDictionary = new PdfDictionary(PdfName.FONT);
        pdfDictionary.put(PdfName.SUBTYPE, PdfName.TYPE1);
        pdfDictionary.put(PdfName.BASEFONT, new PdfName(this.FontName));
        int n = 0;
        int n2 = 0;
        while (n2 < 256) {
            if (!this.differences[n2].equals(BaseFont.notdef)) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (!this.fontSpecific) {
            if (this.encoding.equals("Cp1252") || this.encoding.equals("MacRoman")) {
                pdfDictionary.put(PdfName.ENCODING, this.encoding.equals("Cp1252") ? PdfName.WIN_ANSI_ENCODING : PdfName.MAC_ROMAN_ENCODING);
            } else {
                pdfObject = new PdfDictionary(new PdfName("Encoding"));
                PdfArray pdfArray = new PdfArray();
                pdfArray.add(new PdfNumber(n));
                int n3 = n;
                while (n3 < 256) {
                    pdfArray.add(new PdfName(this.differences[n3]));
                    ++n3;
                }
                ((PdfDictionary)pdfObject).put(new PdfName("Differences"), pdfArray);
                pdfDictionary.put(PdfName.ENCODING, pdfObject);
            }
        }
        if (!this.builtinFont || !this.fontSpecific && !this.encoding.equals("Cp1252") && !this.encoding.equals("MacRoman")) {
            pdfDictionary.put(new PdfName("FirstChar"), new PdfNumber(n));
            pdfDictionary.put(new PdfName("LastChar"), new PdfNumber(255));
            pdfObject = new PdfArray();
            int n4 = n;
            while (n4 < 256) {
                ((PdfArray)pdfObject).add(new PdfNumber(this.widths[n4]));
                ++n4;
            }
            pdfDictionary.put(new PdfName("Widths"), pdfObject);
        }
        if (!this.builtinFont && pdfIndirectReference != null) {
            pdfDictionary.put(new PdfName("FontDescriptor"), pdfIndirectReference);
        }
        return pdfDictionary;
    }

    PdfObject getFontInfo(PdfIndirectReference pdfIndirectReference, int n) throws DocumentException {
        switch (n) {
            case 0: {
                return this.getFontStream();
            }
            case 1: {
                return this.getFontDescriptor(pdfIndirectReference);
            }
            case 2: {
                return this.getFontType(pdfIndirectReference);
            }
        }
        return null;
    }
}

