/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfPrintable;
import java.io.UnsupportedEncodingException;

class PdfString
extends PdfObject
implements PdfPrintable {
    protected String value = "";

    PdfString() {
        super(3, "");
    }

    PdfString(String string) {
        super(3, string);
        this.value = string;
    }

    PdfString(byte[] byArray) {
        super(3, byArray);
        try {
            this.value = new String(byArray, "latin1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.value = new String(byArray);
        }
    }

    PdfString(PdfPrintable pdfPrintable) {
        super(3, pdfPrintable.toString());
        this.value = pdfPrintable.toString();
    }

    final byte[] toPdf() {
        try {
            return this.get().getBytes("latin1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return this.get().getBytes();
        }
    }

    public String toString() {
        return this.value;
    }

    String get() {
        StringBuffer stringBuffer = new StringBuffer("(");
        int n = this.value.length();
        int n2 = -1;
        int n3 = -1;
        while (++n2 < n) {
            char c = this.value.charAt(n2);
            if (++n3 > 150 && c == ' ') {
                n3 = -1;
                stringBuffer.append(" \\\n");
                continue;
            }
            if (n3 > 250) {
                n3 = -1;
                stringBuffer.append("\\\n");
            }
            if (c > '\u00ff' && c < '\u0200') {
                stringBuffer.append('\\');
                stringBuffer.append(Integer.toString(c, 8));
                continue;
            }
            if (c > '\u01ff') {
                stringBuffer.append("?");
            }
            switch (c) {
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    break;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    break;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    break;
                }
                case '(': {
                    stringBuffer.append("\\(");
                    break;
                }
                case ')': {
                    stringBuffer.append("\\)");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

