/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfException;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.DeflaterOutputStream;

class PdfStream
extends PdfObject {
    protected PdfDictionary dictionary;
    private boolean compressed = false;

    PdfStream(PdfDictionary pdfDictionary, String string) {
        super(7);
        this.dictionary = pdfDictionary;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            int n3 = string.indexOf(10, n) + 1;
            int n4 = n3 - n;
            if (n4 < 250 && n4 > 0) {
                stringBuffer.append(string.substring(n, n3));
                n = n3;
                continue;
            }
            try {
                stringBuffer.append(string.substring(n, n + 250) + "\n");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                stringBuffer.append(string.substring(n) + "\n");
            }
            n += 250;
        }
        this.setContent(stringBuffer.toString());
        pdfDictionary.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
    }

    PdfStream(String string) {
        this(new PdfDictionary(), string);
    }

    protected PdfStream() {
        super(7);
        this.dictionary = new PdfDictionary();
    }

    final byte[] toPdf() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(this.dictionary.toPdf());
            byteArrayOutputStream.write("\nstream\n".getBytes());
            byteArrayOutputStream.write(this.bytes);
            byteArrayOutputStream.write("\nendstream".getBytes());
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }

    final synchronized void flateCompress() throws PdfException {
        if (this.compressed) {
            return;
        }
        PdfObject pdfObject = this.dictionary.get(PdfName.FILTER);
        if (pdfObject != null) {
            if (pdfObject.isName() && ((PdfName)pdfObject).compareTo(PdfName.FLATEDECODE) == 0) {
                return;
            }
            if (pdfObject.isArray() && ((PdfArray)pdfObject).contains(PdfName.FLATEDECODE)) {
                return;
            }
            throw new PdfException("Stream could not be compressed: filter is not a name or array.");
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
            deflaterOutputStream.write(this.bytes);
            deflaterOutputStream.close();
            this.bytes = byteArrayOutputStream.toByteArray();
            this.dictionary.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
            if (pdfObject == null) {
                this.dictionary.put(PdfName.FILTER, PdfName.FLATEDECODE);
            } else {
                PdfArray pdfArray = new PdfArray(pdfObject);
                pdfArray.add(PdfName.FLATEDECODE);
                this.dictionary.put(PdfName.FILTER, pdfArray);
            }
            this.compressed = true;
        }
        catch (IOException iOException) {
            System.err.println("The stream was not compressed: " + iOException.getMessage());
        }
    }
}

