/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Image;
import com.lowagie.text.Png;
import com.lowagie.text.pdf.BadPdfFormatException;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfException;
import com.lowagie.text.pdf.PdfGifColorTable;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

class PdfImage
extends PdfStream {
    protected PdfName name;

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PdfImage(Image var1_1, String var2_2) throws BadPdfFormatException {
        block64: {
            super();
            this.name = null;
            this.name = new PdfName(var2_2);
            this.dictionary.put(PdfName.TYPE, PdfName.XOBJECT);
            this.dictionary.put(PdfName.SUBTYPE, PdfName.IMAGE);
            this.dictionary.put(PdfName.NAME, this.name);
            this.dictionary.put(PdfName.WIDTH, new PdfNumber(var1_1.width()));
            this.dictionary.put(PdfName.HEIGHT, new PdfNumber(var1_1.height()));
            var3_3 = null;
            try {
                try {
                    if (var1_1.isImgRaw()) {
                        switch (var1_1.colorspace()) {
                            case 1: {
                                this.dictionary.put(PdfName.COLORSPACE, PdfName.DEVICEGRAY);
                                break;
                            }
                            case 3: {
                                this.dictionary.put(PdfName.COLORSPACE, PdfName.DEVICERGB);
                                break;
                            }
                            default: {
                                this.dictionary.put(PdfName.COLORSPACE, PdfName.DEVICECMYK);
                            }
                        }
                        this.dictionary.put(PdfName.BITSPERCOMPONENT, new PdfNumber(var1_1.bpc()));
                        this.bytes = var1_1.rawData();
                        this.dictionary.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
                        try {
                            this.flateCompress();
                        }
                        catch (PdfException var4_4) {
                        }
                        var28_7 = null;
                        if (var3_3 == null) return;
                        break block64;
                    }
                    if (var1_1.rawData() == null) {
                        var3_3 = var1_1.url().openStream();
                        var4_5 = var1_1.url().toString();
                    } else {
                        var3_3 = new ByteArrayInputStream(var1_1.rawData());
                        var4_5 = "Byte array";
                    }
                    var5_13 = new ByteArrayOutputStream();
                    var6_14 = 0;
                    block8 : switch (var1_1.type()) {
                        case 33: {
                            this.dictionary.put(PdfName.FILTER, PdfName.FLATEDECODE);
                            var7_15 = 0;
                            while (true) {
                                if (var7_15 >= Png.PNGID.length) break;
                                if (Png.PNGID[var7_15] != var3_3.read()) {
                                    throw new BadPdfFormatException(var4_5 + " is not a PNG file.");
                                }
                                ++var7_15;
                            }
                            var8_16 = 0;
                            block24: while (true) {
                                var9_17 = Png.getInt(var3_3);
                                var10_19 = Png.getString(var3_3);
                                if ("IDAT".equals(var10_19)) {
                                    var11_21 = 0;
                                    while (true) {
                                        if (var11_21 >= var9_17) {
                                            Png.getInt(var3_3);
                                            continue block24;
                                        }
                                        var5_13.write(var3_3.read());
                                        ++var11_21;
                                    }
                                }
                                if ("IHDR".equals(var10_19)) {
                                    var11_22 = Png.getInt(var3_3);
                                    var12_27 = Png.getInt(var3_3);
                                    var13_30 = var3_3.read();
                                    if (var13_30 == 16) {
                                        throw new BadPdfFormatException(var4_5 + " Bit depth 16 is not suported.");
                                    }
                                    this.dictionary.put(PdfName.BITSPERCOMPONENT, new PdfNumber(var13_30));
                                    var8_16 = var3_3.read();
                                    if (var8_16 != 0 && var8_16 != 2 && var8_16 != 3) {
                                        throw new BadPdfFormatException(var4_5 + " Colortype " + var8_16 + " is not suported.");
                                    }
                                    if (var8_16 == 0) {
                                        this.dictionary.put(PdfName.COLORSPACE, PdfName.DEVICEGRAY);
                                    } else if (var8_16 == 2) {
                                        this.dictionary.put(PdfName.COLORSPACE, PdfName.DEVICERGB);
                                    }
                                    var14_32 = var3_3.read();
                                    var15_34 = var3_3.read();
                                    var16_36 = var3_3.read();
                                    if (var16_36 != 0) {
                                        throw new BadPdfFormatException(var4_5 + " Interlace method " + var16_36 + " is not suported.");
                                    }
                                    var17_38 = new PdfDictionary();
                                    var17_38.put(PdfName.BITSPERCOMPONENT, new PdfNumber(var13_30));
                                    var17_38.put(PdfName.PREDICTOR, new PdfNumber(15));
                                    var17_38.put(PdfName.COLUMNS, new PdfNumber(var11_22));
                                    var17_38.put(PdfName.COLORS, new PdfNumber(var8_16 == 2 ? 3 : 1));
                                    this.dictionary.put(PdfName.DECODEPARMS, var17_38);
                                    Png.getInt(var3_3);
                                    continue;
                                }
                                if ("PLTE".equals(var10_19)) {
                                    if (var8_16 == 3) {
                                        var11_23 = new PdfArray();
                                        var11_23.add(PdfName.INDEXED);
                                        var11_23.add(PdfName.DEVICERGB);
                                        var11_23.add(new PdfNumber(var9_17 / 3 - 1));
                                        var12_28 = new ByteArrayOutputStream();
                                        while (true) {
                                            if (var9_17-- <= 0) {
                                                var11_23.add(new PdfGifColorTable(var12_28.toByteArray()));
                                                this.dictionary.put(PdfName.COLORSPACE, var11_23);
                                                Png.getInt(var3_3);
                                                continue block24;
                                            }
                                            var12_28.write(var3_3.read());
                                        }
                                    }
                                    var11_24 = -4;
                                    while (true) {
                                        if (var11_24 >= var9_17) continue block24;
                                        var3_3.read();
                                        ++var11_24;
                                    }
                                }
                                if ("IEND".equals(var10_19)) break block8;
                                var11_25 = -4;
                                while (true) {
                                    if (var11_25 >= var9_17) ** break;
                                    var3_3.read();
                                    ++var11_25;
                                }
                                break;
                            }
                        }
                        case 32: {
                            this.dictionary.put(PdfName.FILTER, PdfName.DCTDECODE);
                            switch (var1_1.colorspace()) {
                                case 1: {
                                    this.dictionary.put(PdfName.COLORSPACE, PdfName.DEVICEGRAY);
                                    break;
                                }
                                case 3: {
                                    this.dictionary.put(PdfName.COLORSPACE, PdfName.DEVICERGB);
                                    break;
                                }
                                default: {
                                    this.dictionary.put(PdfName.COLORSPACE, PdfName.DEVICECMYK);
                                }
                            }
                            this.dictionary.put(PdfName.BITSPERCOMPONENT, new PdfNumber(8));
                            while ((var6_14 = var3_3.read()) >= 0) {
                                var5_13.write(var6_14);
                            }
                            break;
                        }
                        case 31: {
                            if (var3_3.read() != 71) throw new BadPdfFormatException(var4_5 + " is not a GIF-file (GIF header not found).");
                            if (var3_3.read() != 73) throw new BadPdfFormatException(var4_5 + " is not a GIF-file (GIF header not found).");
                            if (var3_3.read() != 70) {
                                throw new BadPdfFormatException(var4_5 + " is not a GIF-file (GIF header not found).");
                            }
                            this.dictionary.put(PdfName.FILTER, PdfName.LZWDECODE);
                            var9_18 = new PdfDictionary();
                            var9_18.put(PdfName.EARLYCHANGE, new PdfNumber(0));
                            this.dictionary.put(PdfName.DECODEPARMS, var9_18);
                            var10_20 = new PdfArray();
                            var10_20.add(PdfName.INDEXED);
                            var10_20.add(PdfName.DEVICERGB);
                            var11_26 = 0;
                            while (true) {
                                if (var11_26 >= 8) {
                                    if ((var6_14 & 128) != 0) break;
                                    throw new BadPdfFormatException(var4_5 + " is not a supported GIF-file (there is no global color table present).");
                                }
                                var6_14 = var3_3.read();
                                ++var11_26;
                            }
                            var12_29 = 1 << (var6_14 & 7) + 1;
                            var10_20.add(new PdfNumber(var12_29 - 1));
                            var3_3.read();
                            var3_3.read();
                            var13_31 = new ByteArrayOutputStream();
                            var14_33 = 0;
                            while (true) {
                                if (var14_33 >= var12_29) {
                                    var10_20.add(new PdfGifColorTable(var13_31.toByteArray()));
                                    this.dictionary.put(PdfName.COLORSPACE, var10_20);
                                    this.dictionary.put(PdfName.BITSPERCOMPONENT, new PdfNumber(8));
                                    if (var3_3.read() == 44) break;
                                    throw new BadPdfFormatException(var4_5 + " is not a supported GIF-file (the image separator '0x2c' is not found after reading the color table).");
                                }
                                var13_31.write(var3_3.read());
                                var13_31.write(var3_3.read());
                                var13_31.write(var3_3.read());
                                ++var14_33;
                            }
                            var15_35 = 0;
                            while (true) {
                                if (var15_35 >= 8) {
                                    if ((var3_3.read() & 192) <= 0) break;
                                    throw new BadPdfFormatException(var4_5 + " is not a supported GIF-file (interlaced gifs or gifs using local color table can't be inserted).");
                                }
                                var3_3.read();
                                ++var15_35;
                            }
                            if (var3_3.read() != 8) {
                                throw new BadPdfFormatException(var4_5 + " is not a supported GIF-file (initial LZW code not supported).");
                            }
                            var16_37 = 0;
                            var17_39 = 9;
                            var18_40 = 257;
                            var19_41 = 0;
                            var20_42 = 0;
                            var21_43 = 0;
                            var22_44 = 23;
                            var23_45 = 0;
                            var24_46 = 0;
                            var25_47 = 0;
                            var26_48 = var3_3.read();
                            if (var26_48 < 1) {
                                throw new BadPdfFormatException(var4_5 + " is not a supported GIF-file. (no image data found).");
                            }
                            ++var24_46;
                            var19_41 = var3_3.read();
                            if (--var26_48 > 0) {
                                ++var24_46;
                                var19_41 += var3_3.read() << 8;
                                if (--var26_48 > 0) {
                                    --var26_48;
                                    ++var24_46;
                                    var19_41 += var3_3.read() << 16;
                                }
                            }
                            block33: while (var24_46 > var25_47) {
                                ++var18_40;
                                var16_37 = var19_41 >> var21_43 & (1 << var17_39) - 1;
                                var23_45 = (var21_43 + var17_39) / 8;
                                var21_43 = (var21_43 + var17_39) % 8;
                                while (true) {
                                    if (var23_45 <= 0) {
                                        var20_42 += var16_37 << var22_44 - var17_39 + 1;
                                        var22_44 -= var17_39;
                                        break;
                                    }
                                    --var23_45;
                                    var19_41 >>= 8;
                                    if (var26_48 > 0) {
                                        --var26_48;
                                        ++var24_46;
                                        var19_41 += var3_3.read() << 16;
                                        continue;
                                    }
                                    var26_48 = var3_3.read();
                                    if (var26_48 <= 0) continue;
                                    --var26_48;
                                    ++var24_46;
                                    var19_41 += var3_3.read() << 16;
                                }
                                while (true) {
                                    if (var22_44 >= 16) {
                                        if (var16_37 == 256) {
                                            var17_39 = 9;
                                            var18_40 = 257;
                                        }
                                        if (var16_37 != 257) break;
                                        break block33;
                                    }
                                    var5_13.write(var20_42 >> 16);
                                    ++var25_47;
                                    var20_42 = (var20_42 & 65535) << 8;
                                    var22_44 += 8;
                                }
                                if (var18_40 != 1 << var17_39) continue;
                                ++var17_39;
                            }
                            if (var24_46 - var25_47 <= 2) break;
                            throw new BadPdfFormatException(var4_5 + " is not a supported GIF-file (unexpected end of data block).");
                        }
                        default: {
                            throw new BadPdfFormatException(var4_5 + " is an unknown Image format.");
                        }
                    }
                    this.bytes = var5_13.toByteArray();
                    this.dictionary.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
                }
                catch (IOException var4_6) {
                    throw new BadPdfFormatException(var4_6.getMessage());
                }
                var28_8 = null;
                if (var3_3 == null) return;
                try {
                    var3_3.close();
                    return;
                }
                catch (Exception var29_11) {
                    return;
                }
            }
            catch (Throwable var27_49) {
                var28_9 = null;
                if (var3_3 == null) throw var27_49;
                ** try [egrp 3[TRYBLOCK] [3 : 2126->2133)] { 
lbl312:
                // 1 sources

                var3_3.close();
                throw var27_49;
lbl314:
                // 1 sources

                catch (Exception var29_12) {
                    // empty catch block
                }
                throw var27_49;
            }
        }
        ** try [egrp 3[TRYBLOCK] [3 : 2126->2133)] { 
lbl319:
        // 1 sources

        var3_3.close();
        return;
lbl321:
        // 1 sources

        catch (Exception var29_10) {
            // empty catch block
        }
    }

    public final PdfName name() {
        return this.name;
    }
}

