/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;

class PdfDestination
extends PdfArray {
    public static final int XYZ = 0;
    public static final int FIT = 1;
    public static final int FITH = 2;
    public static final int FITV = 3;
    public static final int FITR = 4;
    public static final int FITB = 5;
    public static final int FITBH = 6;
    public static final int FITBV = 7;
    private boolean status = false;

    PdfDestination(int n) {
        if (n == 5) {
            this.add(PdfName.FITB);
        } else {
            this.add(PdfName.FIT);
        }
    }

    PdfDestination(int n, int n2) {
        super(new PdfNumber(n2));
        switch (n) {
            default: {
                this.addFirst(PdfName.FITH);
                break;
            }
            case 3: {
                this.addFirst(PdfName.FITV);
                break;
            }
            case 6: {
                this.addFirst(PdfName.FITBH);
                break;
            }
            case 7: {
                this.addFirst(PdfName.FITBV);
            }
        }
    }

    PdfDestination(int n, int n2, int n3, int n4) {
        super(PdfName.XYZ);
        this.add(new PdfNumber(n2));
        this.add(new PdfNumber(n3));
        this.add(new PdfNumber(n4));
    }

    PdfDestination(int n, int n2, int n3, int n4, int n5) {
        super(PdfName.FITR);
        this.add(new PdfNumber(n2));
        this.add(new PdfNumber(n3));
        this.add(new PdfNumber(n4));
        this.add(new PdfNumber(n5));
    }

    public boolean hasPage() {
        return this.status;
    }

    public boolean addPage(PdfIndirectReference pdfIndirectReference) {
        if (!this.status) {
            this.addFirst(pdfIndirectReference);
            this.status = true;
            return true;
        }
        return false;
    }
}

