/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.Font;
import com.lowagie.text.pdf.PdfFont;
import com.lowagie.text.pdf.PdfFontMetrics;
import com.lowagie.text.pdf.PdfString;
import java.awt.Color;

class PdfChunk
extends PdfString {
    protected PdfFont font;
    protected Color color;
    protected boolean underlined = false;
    protected boolean strikethru = false;

    private PdfChunk(String string, PdfFont pdfFont, Color color) {
        super(string);
        this.font = pdfFont;
        this.color = color;
    }

    PdfChunk(Chunk chunk) {
        super(chunk.content());
        int n;
        Font font = chunk.font();
        int n2 = font.style();
        if (n2 == -1) {
            n2 = 0;
        }
        block0 : switch (font.family()) {
            case 0: {
                switch (n2 & 3) {
                    case 1: {
                        n = 1;
                        break block0;
                    }
                    case 2: {
                        n = 2;
                        break block0;
                    }
                    case 3: {
                        n = 3;
                        break block0;
                    }
                }
                n = 0;
                break;
            }
            case 2: {
                switch (n2 & 3) {
                    case 1: {
                        n = 10;
                        break block0;
                    }
                    case 2: {
                        n = 11;
                        break block0;
                    }
                    case 3: {
                        n = 12;
                        break block0;
                    }
                }
                n = 9;
                break;
            }
            case 3: {
                n = 8;
                break;
            }
            case 4: {
                n = 13;
                break;
            }
            default: {
                switch (n2 & 3) {
                    case 1: {
                        n = 5;
                        break block0;
                    }
                    case 2: {
                        n = 6;
                        break block0;
                    }
                    case 3: {
                        n = 7;
                        break block0;
                    }
                }
                n = 4;
            }
        }
        int n3 = font.size();
        this.font = n3 == -1 ? new PdfFont(n, 12) : new PdfFont(n, n3);
        this.underlined = font.isUnderlined();
        this.strikethru = font.isStrikethru();
        this.color = font.color();
    }

    PdfChunk split(double d) {
        int n = 0;
        int n2 = -1;
        double d2 = this.font.width();
        int n3 = this.value.length();
        while (n < n3 && d2 < d) {
            char c = this.value.charAt(n);
            d2 += this.font.width(c);
            if (c == '\r' || c == '\n') {
                String string = this.value.substring(n + 1);
                this.value = this.value.substring(0, n);
                if (this.value.length() < 1) {
                    this.value = " ";
                }
                this.setContent(this.value);
                return new PdfChunk(string, this.font, this.color);
            }
            if (PdfFontMetrics.isSplitCharacter(c)) {
                n2 = n + 1;
            }
            ++n;
        }
        if (n == n3) {
            return null;
        }
        if (n2 < 0) {
            String string = this.value;
            this.value = "";
            this.setContent(this.value);
            return new PdfChunk(string, this.font, this.color);
        }
        String string = this.value.substring(n2);
        this.value = PdfFontMetrics.trim(this.value.substring(0, n2));
        this.setContent(this.value);
        return new PdfChunk(string, this.font, this.color);
    }

    PdfChunk truncate(double d) {
        int n = 0;
        double d2 = this.font.width();
        if (d < d2) {
            String string = this.value.substring(1);
            this.value = this.value.substring(0, 1);
            this.setContent(this.value);
            return new PdfChunk(string, this.font, this.color);
        }
        int n2 = this.value.length();
        while (n < n2 && d2 < d) {
            char c = this.value.charAt(n);
            d2 += this.font.width(c);
            ++n;
        }
        if (n == n2) {
            return null;
        }
        if ((n -= 2) < 0) {
            n = 1;
        }
        String string = this.value.substring(n);
        this.value = this.value.substring(0, n);
        this.setContent(this.value);
        return new PdfChunk(string, this.font, this.color);
    }

    PdfFont font() {
        return this.font;
    }

    Color color() {
        return this.color;
    }

    double width() {
        double d = 0.0;
        int n = this.value.length();
        int n2 = 0;
        while (n2 < n) {
            d += this.font.width(this.value.charAt(n2));
            ++n2;
        }
        return d;
    }

    public boolean isUnderlined() {
        return this.underlined;
    }

    public boolean isStrikethru() {
        return this.strikethru;
    }
}

