/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.participant.module;

import com.elluminate.groupware.participant.module.DocumentPageableFactory;
import com.elluminate.gui.print.DocumentPageable;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.PrinterJob;
import javax.swing.text.PlainDocument;
import javax.swing.text.SimpleAttributeSet;

@Singleton
public class PrintClerk {
    private DocumentPageableFactory documentPageableFactory;

    @Inject
    public PrintClerk(DocumentPageableFactory dpf) {
        this.documentPageableFactory = dpf;
    }

    public void print(String sessionName, String[] participantInfo) {
        if (participantInfo == null || participantInfo.length < 1) {
            return;
        }
        PlainDocument doc = new PlainDocument();
        if (sessionName != null) {
            try {
                doc.insertString(0, sessionName + "\n\n", SimpleAttributeSet.EMPTY);
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"doPrint", (Throwable)t, (boolean)true);
            }
        }
        for (int ix = 0; ix < participantInfo.length; ++ix) {
            try {
                doc.insertString(doc.getLength(), participantInfo[ix] + "\n", SimpleAttributeSet.EMPTY);
                continue;
            }
            catch (Throwable t) {
                LogSupport.exception((Object)this, (String)"doPrint", (Throwable)t, (boolean)true);
            }
        }
        PrinterJob job = PrinterJob.getPrinterJob();
        PageFormat format = job.defaultPage();
        DocumentPageable printable = this.documentPageableFactory.create(doc, "text/plain", format);
        job.setPageable((Pageable)printable);
        if (!job.printDialog()) {
            return;
        }
        try {
            job.print();
        }
        catch (Throwable t) {
            LogSupport.exception((Object)this, (String)"doPrint", (Throwable)t, (boolean)true);
        }
    }
}

