/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.participant.module;

import com.elluminate.classroom.client.messaging.ExtraInfo;
import com.elluminate.classroom.client.messaging.MessagePublisher;
import com.elluminate.classroom.client.messaging.MessagePublisherMetadata;
import com.elluminate.classroom.client.messaging.MessageRouter;
import com.elluminate.classroom.client.messaging.MessageType;
import com.elluminate.classroom.client.messaging.ModulePublisherInfo;
import com.elluminate.groupware.participant.module.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

@Singleton
public class ParticipantPublisher {
    private final String UNIQUE_NAME = "ParticipantPublisher";
    private final String DISPLAY_NAME;
    private final Icon icon;
    public static final String USER_JOINED = "user-joined";
    public static final String USER_LEFT = "user-left";
    public static final String USER_AWAY = "user-away";
    public static final String USER_RETURNED = "user-returned";
    private final MessagePublisher publisher;
    private final MessagePublisherMetadata metadata;
    private final I18n i18n;
    private final MessageRouter router;
    private String modName;
    private String modDisplayName;
    private Map<String, MessageType> msgTypes = new HashMap<String, MessageType>();

    @Inject
    public ParticipantPublisher(MessagePublisher pub, MessagePublisherMetadata meta, MessageRouter rtr, I18n localization, ModulePublisherInfo mod) {
        this.publisher = pub;
        this.metadata = meta;
        this.router = rtr;
        this.i18n = localization;
        this.DISPLAY_NAME = this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANTPUBLISHER_DISPLAYNAME);
        this.icon = mod.getModuleIcon();
        this.modName = mod.getNameOfModule();
        this.modDisplayName = mod.getDisplayNameOfModule();
        this.initializePublisher();
    }

    public void sendUserJoinedMessage(String message, boolean isMe) {
        this.sendRouterMsg(message, this.msgTypes.get(USER_JOINED), isMe);
    }

    public void sendUserLeftMessage(String message, boolean isMe) {
        this.sendRouterMsg(message, this.msgTypes.get(USER_LEFT), isMe);
    }

    public void sendUserAwayMessage(String user, String sessionLabel, boolean isMe) {
        String message = isMe ? this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANTMODULE_AWAYMSG_SELF, new Object[]{sessionLabel}) : this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANTMODULE_AWAYMSG, new Object[]{user, sessionLabel});
        this.sendRouterMsg(message, this.msgTypes.get(USER_AWAY), isMe);
    }

    public void sendUserReturnedMessage(String user, String sessionLabel, boolean isMe) {
        String message = isMe ? this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANTMODULE_RETURNMSG_SELF, new Object[]{sessionLabel}) : this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANTMODULE_RETURNMSG, new Object[]{user, sessionLabel});
        this.sendRouterMsg(message, this.msgTypes.get(USER_RETURNED), isMe);
    }

    private void sendRouterMsg(String message, MessageType type, String who, boolean isMe) {
        ExtraInfo info = new ExtraInfo();
        info.setHeader(who);
        this.publisher.sendMessageWithExtraInfo(message, info, type, isMe);
    }

    private void sendRouterMsg(String message, MessageType type, boolean isMe) {
        this.publisher.sendTextMessage(message, type, isMe);
    }

    private void initializePublisher() {
        this.initMessageTypes();
        this.setMetadata();
        this.publisher.setPublisherMetadata(this.metadata);
        this.router.registerPublisher(this.publisher);
    }

    private void setMetadata() {
        this.metadata.setPublisherDisplayName(this.DISPLAY_NAME);
        this.metadata.setPublisherUniqueName("ParticipantPublisher");
        this.metadata.setPublisherIcon(this.icon);
        this.metadata.setModuleName(this.modName);
        this.metadata.setModuleDisplayName(this.modDisplayName);
        this.metadata.setPublisherSupportedMessageTypes(new ArrayList<MessageType>(this.msgTypes.values()));
    }

    private void initMessageTypes() {
        this.msgTypes.put(USER_JOINED, new MessageType(USER_JOINED, this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANTPUBLISHER_TYPE_USER_JOINED), 11));
        this.msgTypes.put(USER_LEFT, new MessageType(USER_LEFT, this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANTPUBLISHER_TYPE_USER_LEFT), 11));
        this.msgTypes.put(USER_AWAY, new MessageType(USER_AWAY, this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANTPUBLISHER_TYPE_USER_AWAY), 5));
        this.msgTypes.put(USER_RETURNED, new MessageType(USER_RETURNED, this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANTPUBLISHER_TYPE_USER_RETURNED), 5));
    }
}

