/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.cluster;

import com.elluminate.cluster.ClusterMsg;

public class TelephonyAllocatorReq
extends ClusterMsg {
    private static final long serialVersionUID = 1L;
    public static final short F_REQUEST = 1;
    public static final short F_SESSIONID = 2;
    public static final short F_MODERATOR_PIN = 3;
    public static final short F_PARTICIPANT_PIN = 4;
    public static final short F_SUCCESS = 5;
    public static final short F_PHONE_NUMBER = 6;
    public static final byte REQ_ALLOC = 1;
    public static final byte REQ_GET = 2;
    public static final byte REQ_DELETE = 3;
    public static final short VERSION = 2;

    public TelephonyAllocatorReq() {
    }

    public TelephonyAllocatorReq(byte req, String sid) {
        super((short)2, (short)1, req, (short)2, sid);
    }

    public byte getRequestType() {
        return (byte)this.getFieldAsLong((short)1);
    }

    public String getSessionID() {
        return this.getFieldAsString((short)2);
    }

    public long getModeratorPIN() {
        return this.getFieldAsLong((short)3);
    }

    public long getParticipantPIN() {
        return this.getFieldAsLong((short)4);
    }

    public String getPhoneNumber() {
        try {
            return this.getFieldAsString((short)6);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public void setPhoneNumber(String phoneNo) {
        this.setField((short)6, phoneNo);
    }

    public boolean succeeded() {
        return this.getFieldAsBoolean((short)5);
    }

    public void setResults(long moderatorPIN, long participantPIN) {
        this.setField((short)3, moderatorPIN);
        this.setField((short)4, participantPIN);
        this.setField((short)5, true);
    }

    public void setFail() {
        this.setField((short)5, false);
    }

    public void setSuccess() {
        this.setField((short)5, true);
    }

    @Override
    public String toString() {
        StringBuilder bld = new StringBuilder();
        byte req = (byte)this.getFieldAsLong((short)1);
        String sid = this.getFieldAsString((short)2);
        switch (req) {
            case 1: {
                bld.append("TARequestAlloc(v");
                break;
            }
            case 3: {
                bld.append("TARequestDelete(v");
                break;
            }
            case 2: {
                bld.append("TARequestGet(v");
                break;
            }
            default: {
                return super.toString();
            }
        }
        bld.append(this.getVersion());
        bld.append(",sessionID=");
        bld.append(sid);
        if (this.hasField((short)6)) {
            bld.append(",phoneNo=");
            bld.append(this.getFieldAsString((short)6));
        }
        bld.append(")");
        if (this.hasField((short)5)) {
            bld.append("=[");
            boolean success = this.getFieldAsBoolean((short)5);
            bld.append(success ? "succeeded" : "failed");
            if (this.hasField((short)3)) {
                bld.append(",moderator PIN=");
                bld.append(this.getFieldAsLong((short)3));
            }
            if (this.hasField((short)4)) {
                bld.append(",participant PIN=");
                bld.append(this.getFieldAsLong((short)4));
            }
            bld.append("]");
        }
        return bld.toString();
    }
}

