/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.cluster;

import com.elluminate.cluster.ClusterTuning;
import com.elluminate.util.DebugFlag;
import com.elluminate.util.log.LogSupport;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LogEvent;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class GeminiLogger
implements ILogger {
    private static final String PREFIX = "cluster.";
    private static DebugFlag CLUSTERING_DEBUG = DebugFlag.get((String)"cluster.debug");
    private static DebugFlag CLUSTERING_TRACE = DebugFlag.get((String)"cluster.trace");
    Level defaultLevel = Level.parse(ClusterTuning.DefaultLogLevel.getValue());
    DebugFlag flag;

    public GeminiLogger(String name) {
        this.flag = DebugFlag.get((String)(PREFIX + name));
    }

    public void log(Level level, String message) {
        if (this.isLoggable(level)) {
            if (level.intValue() >= Level.WARNING.intValue()) {
                LogSupport.error((String)("[" + level.getName() + "]: " + message));
            } else {
                LogSupport.message((String)("[" + level.getName() + "]: " + message));
            }
        }
    }

    public void log(Level level, String message, Throwable thrown) {
        if (this.isLoggable(level)) {
            LogSupport.exception((Object)this, (String)"log", (Throwable)thrown, (boolean)true, (String)("[" + level.getName() + "]: " + message));
        }
    }

    public void log(LogEvent logEvent) {
        LogRecord record = logEvent.getLogRecord();
        Level level = record.getLevel();
        if (this.isLoggable(level)) {
            String msg = "[" + level.getName() + "]: " + record.getMessage();
            Throwable thrown = record.getThrown();
            String cls = record.getSourceClassName();
            String method = record.getSourceMethodName();
            if (thrown != null) {
                LogSupport.exception((Object)cls, (String)method, (Throwable)thrown, (boolean)true, (String)msg);
            } else if (level.intValue() >= Level.WARNING.intValue()) {
                LogSupport.error((Object)cls, (String)method, (String)msg);
            } else {
                LogSupport.message((Object)cls, (String)method, (String)msg);
            }
        }
    }

    public Level getLevel() {
        if (this.flag.show()) {
            return Level.ALL;
        }
        if (CLUSTERING_TRACE.show()) {
            return Level.ALL;
        }
        if (CLUSTERING_DEBUG.show()) {
            return Level.FINE;
        }
        return ClusterTuning.DefaultLogLevel.getLevel();
    }

    public boolean isLoggable(Level level) {
        return level.intValue() >= this.getLevel().intValue();
    }
}

