/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.cluster;

import com.elluminate.cluster.CQueue;
import com.hazelcast.nio.DataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ClusterMsg
implements DataSerializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final byte CLUSTER_MSG_V1 = 1;
    public static final byte CLUSTER_MSG_V2 = 2;
    public static final byte CLUSTER_MSG_VERSION = 2;
    public static final byte CLUSTER_FIELD_STRING = 1;
    public static final byte CLUSTER_FIELD_BOOL = 2;
    public static final byte CLUSTER_FIELD_LONG = 3;
    public static final byte CLUSTER_FIELD_INT = 4;
    public static final byte CLUSTER_FIELD_SHORT = 5;
    public static final byte CLUSTER_FIELD_BYTE = 6;
    public static final byte CLUSTER_FIELD_MSG = 7;
    public static final byte CLUSTER_FIELD_ARRAY = 8;
    private static final short RETURN_QUEUE = -1;
    private static final short REQUEST_ID = -2;
    private Map<Short, Field> fields = new TreeMap<Short, Field>();
    private short amVer = (short)-1;
    private short cmVer = 1;
    private String returnQueue = null;

    public ClusterMsg() {
        this.amVer = (short)-1;
    }

    protected ClusterMsg(short ver, Object ... args) {
        this.amVer = ver;
        this.setArgPairs(args);
    }

    protected void setArgPairs(Object ... args) {
        Short key = null;
        for (Object arg : args) {
            if (key == null) {
                try {
                    key = (Short)arg;
                    if (key > 0) continue;
                    throw new IllegalArgumentException("Negative field IDs are not allowed - " + key);
                }
                catch (ClassCastException ccx) {
                    throw new IllegalArgumentException("Expected field id, got " + key.getClass().getName(), ccx);
                }
            }
            Field f = Field.getField(arg);
            this.fields.put(key, f);
            key = null;
            byte ver = f.getVersion();
            if (ver <= this.cmVer) continue;
            this.cmVer = ver;
        }
    }

    public boolean isValid() {
        return this.amVer > 0;
    }

    protected void setVersion(short ver) {
        if (this.amVer < 0) {
            throw new IllegalStateException("Cannot set the version on an invalid message.");
        }
        this.amVer = ver;
    }

    protected short getVersion() {
        return this.amVer;
    }

    public void setReturnQueue(CQueue<?> queue) {
        this.fields.put((short)-1, new StringField(queue.getName()));
    }

    public void setReturnQueue(String queueName) {
        this.fields.put((short)-1, new StringField(queueName));
    }

    public String getReturnQueue() {
        if (this.returnQueue != null) {
            return this.returnQueue;
        }
        ScalarField rqf = (ScalarField)this.fields.get((short)-1);
        if (rqf != null) {
            return rqf.stringValue();
        }
        return null;
    }

    public boolean isResponseRequested() {
        return this.returnQueue != null;
    }

    public void setRequestID(long id) {
        this.fields.put((short)-2, new LongField(id));
    }

    public long getRequestID() {
        return this.getFieldAsLong((short)-2);
    }

    public boolean hasRequestID() {
        return this.hasField((short)-2);
    }

    public boolean hasField(short fieldID) {
        return this.fields.containsKey(fieldID);
    }

    protected String getFieldAsString(short fieldID) {
        return this.getScalarField(fieldID).stringValue();
    }

    protected String getFieldAsString(short fieldID, String dft) {
        try {
            return this.getFieldAsString(fieldID);
        }
        catch (IllegalArgumentException iax) {
            return dft;
        }
    }

    public String getElementAsString(short fieldID, int idx) {
        return this.getVectorField(fieldID).stringValueAt(idx);
    }

    protected String[] getFieldAsStringArray(short fieldID) {
        return this.getVectorField(fieldID).stringValues();
    }

    protected long getFieldAsLong(short fieldID) {
        return this.getScalarField(fieldID).longValue();
    }

    public long getFieldAsLong(short fieldID, long dft) {
        try {
            return this.getFieldAsLong(fieldID);
        }
        catch (IllegalArgumentException iax) {
            return dft;
        }
    }

    protected long getElementAsLong(short fieldID, int idx) {
        return this.getVectorField(fieldID).longValueAt(idx);
    }

    protected long[] getFieldAsLongArray(short fieldID) {
        return this.getVectorField(fieldID).longValues();
    }

    public boolean getFieldAsBoolean(short fieldID) {
        return this.getScalarField(fieldID).booleanValue();
    }

    protected boolean getFieldAsBoolean(short fieldID, boolean dft) {
        try {
            return this.getFieldAsBoolean(fieldID);
        }
        catch (IllegalArgumentException iax) {
            return dft;
        }
    }

    protected boolean getElementAsBoolean(short fieldID, int idx) {
        return this.getVectorField(fieldID).booleanValueAt(idx);
    }

    protected boolean[] getFieldAsBooleanArray(short fieldID) {
        return this.getVectorField(fieldID).booleanValues();
    }

    protected <T extends ClusterMsg> T getFieldAsMsg(short fieldID, Class<T> cls) {
        return this.getScalarField(fieldID).msgValue(cls);
    }

    protected <T extends ClusterMsg> T getFieldAsMsg(short fieldID, Class<T> cls, T dft) {
        try {
            return this.getFieldAsMsg(fieldID, cls);
        }
        catch (IllegalArgumentException iax) {
            return dft;
        }
    }

    public <T extends ClusterMsg> T getElementAsMsg(short fieldID, Class<T> cls, int idx) {
        return this.getVectorField(fieldID).msgValueAt(cls, idx);
    }

    protected <T extends ClusterMsg> List<T> getFieldAsMsgArray(short fieldID, Class<T> cls) {
        return this.getVectorField(fieldID).msgValues(cls);
    }

    protected void setField(short fieldID, String value) {
        if (fieldID <= 0) {
            throw new IllegalArgumentException("Invalid field ID " + fieldID);
        }
        this.fields.put(fieldID, new StringField(value));
    }

    protected void setField(short fieldID, String[] value) {
        if (fieldID <= 0) {
            throw new IllegalArgumentException("Invalid field ID " + fieldID);
        }
        this.fields.put(fieldID, new StringArrayField(value));
        this.cmVer = (short)2;
    }

    protected void setField(short fieldID, long value) {
        if (fieldID <= 0) {
            throw new IllegalArgumentException("Invalid field ID " + fieldID);
        }
        this.fields.put(fieldID, new LongField(value));
    }

    protected void setField(short fieldID, long[] value) {
        if (fieldID <= 0) {
            throw new IllegalArgumentException("Invalid field ID " + fieldID);
        }
        this.fields.put(fieldID, new LongArrayField(value));
        this.cmVer = (short)2;
    }

    protected void setField(short fieldID, boolean value) {
        if (fieldID <= 0) {
            throw new IllegalArgumentException("Invalid field ID " + fieldID);
        }
        this.fields.put(fieldID, new BooleanField(value));
    }

    protected void setField(short fieldID, boolean[] value) {
        if (fieldID <= 0) {
            throw new IllegalArgumentException("Invalid field ID " + fieldID);
        }
        this.fields.put(fieldID, new BooleanArrayField(value));
        this.cmVer = (short)2;
    }

    protected void setField(short fieldID, ClusterMsg value) {
        if (fieldID <= 0) {
            throw new IllegalArgumentException("Invalid field ID " + fieldID);
        }
        this.fields.put(fieldID, new MsgField(value));
        this.cmVer = (short)2;
    }

    protected void setField(short fieldID, ClusterMsg[] value) {
        if (fieldID <= 0) {
            throw new IllegalArgumentException("Invalid field ID " + fieldID);
        }
        this.fields.put(fieldID, new MsgArrayField(value));
        this.cmVer = (short)2;
    }

    private ScalarField getScalarField(short fieldID) {
        Field f = this.fields.get(fieldID);
        if (f == null) {
            throw new IllegalArgumentException("field " + fieldID + " not found");
        }
        return (ScalarField)f;
    }

    private VectorField getVectorField(short fieldID) {
        Field f = this.fields.get(fieldID);
        if (f == null) {
            throw new IllegalArgumentException("Field " + fieldID + " not found");
        }
        return (VectorField)f;
    }

    public final void writeData(DataOutput out) throws IOException {
        out.writeByte(this.cmVer);
        out.writeShort(this.amVer);
        out.writeShort(this.fields.size());
        for (Map.Entry<Short, Field> entry : this.fields.entrySet()) {
            out.writeShort(entry.getKey().shortValue());
            entry.getValue().writeData(out);
        }
    }

    public final void readData(DataInput in) throws IOException {
        this.cmVer = in.readByte();
        if (this.cmVer > 2) {
            throw new IOException("Mismatched message versions! - got " + this.cmVer + ", expected " + 2);
        }
        this.amVer = in.readShort();
        int count = in.readShort();
        for (int i = 0; i < count; ++i) {
            short key = in.readShort();
            Field val = Field.getField(in);
            if (key == -1) {
                this.returnQueue = ((ScalarField)val).stringValue();
                continue;
            }
            this.fields.put(key, val);
        }
    }

    public Object clone() {
        ClusterMsg copy;
        try {
            copy = (ClusterMsg)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
        copy.fields = new TreeMap<Short, Field>();
        for (Short k : this.fields.keySet()) {
            copy.fields.put(k, this.fields.get(k));
        }
        return copy;
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        bld.append(this.getClass().getSimpleName());
        bld.append("(v");
        bld.append(this.amVer);
        bld.append("):");
        for (Map.Entry<Short, Field> entry : this.fields.entrySet()) {
            bld.append("{");
            bld.append(this.getFieldName(entry.getKey()));
            bld.append("=");
            bld.append(entry.getValue().toString());
            bld.append("}");
        }
        if (this.returnQueue != null) {
            bld.append("{returnQueue=");
            bld.append(this.returnQueue);
            bld.append("}");
        }
        return bld.toString();
    }

    protected String getFieldName(short fid) {
        switch (fid) {
            case -1: {
                return "returnQueue";
            }
            case -2: {
                return "requestID";
            }
        }
        return Short.toString(fid);
    }

    public boolean equals(Object o) {
        try {
            ClusterMsg other = (ClusterMsg)o;
            if (!this.getClass().equals(other.getClass())) {
                return false;
            }
            if (this.amVer != other.amVer) {
                return false;
            }
            if (this.returnQueue == null ? other.returnQueue != null : !this.returnQueue.equals(other.returnQueue)) {
                return false;
            }
            if (this.fields.size() != other.fields.size()) {
                return false;
            }
            for (Short key : this.fields.keySet()) {
                Field foreign;
                Field mine = this.fields.get(key);
                if (mine.equals(foreign = other.fields.get(key))) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException ccx) {
            return false;
        }
        catch (IllegalArgumentException iax) {
            return false;
        }
    }

    public int hashCode() {
        int code = this.getClass().hashCode();
        code ^= this.amVer;
        if (this.returnQueue != null) {
            code ^= this.returnQueue.hashCode();
        }
        for (Short key : this.fields.keySet()) {
            code ^= key.shortValue();
            code ^= this.fields.get(key).hashCode();
        }
        return code;
    }

    private static ClusterMsg read(DataInput in) throws IOException {
        ClusterMsg tmp;
        String cname = in.readUTF();
        Class<?> cls = null;
        try {
            cls = Class.forName(cname);
            tmp = (ClusterMsg)cls.newInstance();
        }
        catch (Exception e) {
            throw new IOException("Invalid class in cluster msg - " + cname);
        }
        tmp.readData(in);
        return tmp;
    }

    private static class BooleanArrayField
    extends VectorField {
        private boolean[] vector;

        public BooleanArrayField(boolean[] v) {
            this.vector = new boolean[v.length];
            System.arraycopy(v, 0, this.vector, 0, v.length);
        }

        public BooleanArrayField(int len, DataInput in) throws IOException {
            this.vector = new boolean[len];
            for (int i = 0; i < len; ++i) {
                this.vector[i] = in.readBoolean();
            }
        }

        @Override
        public int length() {
            return this.vector != null ? this.vector.length : -1;
        }

        @Override
        public String stringValueAt(int idx) {
            return this.vector[idx] ? "true" : "false";
        }

        @Override
        public boolean booleanValueAt(int idx) {
            return this.vector[idx];
        }

        @Override
        public boolean[] booleanValues() {
            boolean[] copy = new boolean[this.vector.length];
            System.arraycopy(this.vector, 0, copy, 0, this.vector.length);
            return copy;
        }

        @Override
        public byte getType() {
            return 2;
        }

        @Override
        public void writeValue(DataOutput out, int idx) throws IOException {
            out.writeBoolean(this.vector[idx]);
        }

        public boolean equals(Object o) {
            try {
                BooleanArrayField other = (BooleanArrayField)o;
                return Arrays.equals(this.vector, other.vector);
            }
            catch (ClassCastException ccx) {
                return false;
            }
        }

        public int hashCode() {
            return Arrays.hashCode(this.vector);
        }
    }

    private static class BooleanField
    extends ScalarField {
        private boolean value;

        public BooleanField(boolean v) {
            this.value = v;
        }

        @Override
        public String stringValue() {
            return this.value ? "true" : "false";
        }

        @Override
        public boolean booleanValue() {
            return this.value;
        }

        @Override
        public byte getType() {
            return 2;
        }

        @Override
        public void writeValue(DataOutput out) throws IOException {
            out.writeBoolean(this.value);
        }

        public boolean equals(Object o) {
            try {
                BooleanField other = (BooleanField)o;
                return this.value == other.value;
            }
            catch (ClassCastException ccx) {
                return false;
            }
        }

        public int hashCode() {
            return Boolean.valueOf(this.value).hashCode();
        }
    }

    private static abstract class Field {
        private Field() {
        }

        static Field getField(Object o) {
            if (o == null) {
                throw new IllegalArgumentException("Null field values are not supported.");
            }
            if (o instanceof String) {
                return new StringField((String)o);
            }
            if (o instanceof String[]) {
                return new StringArrayField((String[])o);
            }
            if (o instanceof ClusterMsg) {
                return new MsgField((ClusterMsg)o);
            }
            if (o instanceof ClusterMsg[]) {
                return new MsgArrayField((ClusterMsg[])o);
            }
            if (o instanceof Boolean) {
                return new BooleanField((Boolean)o);
            }
            if (o instanceof boolean[]) {
                return new BooleanArrayField((boolean[])o);
            }
            if (o instanceof Byte) {
                return new LongField(((Byte)o).byteValue());
            }
            if (o instanceof Short) {
                return new LongField(((Short)o).shortValue());
            }
            if (o instanceof Integer) {
                return new LongField(((Integer)o).intValue());
            }
            if (o instanceof Long) {
                return new LongField((Long)o);
            }
            if (o instanceof long[]) {
                return new LongArrayField((long[])o);
            }
            throw new IllegalArgumentException("Unsupported ClusterMsg field data type " + o.getClass().getName());
        }

        static Field getField(DataInput in) throws IOException {
            byte type = in.readByte();
            if (type == 8) {
                int len = in.readInt();
                type = in.readByte();
                switch (type) {
                    case 1: {
                        return new StringArrayField(len, in);
                    }
                    case 2: {
                        return new BooleanArrayField(len, in);
                    }
                    case 3: {
                        return new LongArrayField(len, type, in);
                    }
                    case 4: {
                        return new LongArrayField(len, type, in);
                    }
                    case 5: {
                        return new LongArrayField(len, type, in);
                    }
                    case 6: {
                        return new LongArrayField(len, type, in);
                    }
                    case 7: {
                        return new MsgArrayField(len, in);
                    }
                }
                throw new IOException("Unknown field type - " + type);
            }
            switch (type) {
                case 1: {
                    return new StringField(in.readUTF());
                }
                case 2: {
                    return new BooleanField(in.readBoolean());
                }
                case 3: {
                    return new LongField(in.readLong());
                }
                case 4: {
                    return new LongField(in.readInt());
                }
                case 5: {
                    return new LongField(in.readShort());
                }
                case 6: {
                    return new LongField(in.readByte());
                }
                case 7: {
                    return new MsgField(in);
                }
            }
            throw new IOException("Unknown field type - " + type);
        }

        public abstract byte getVersion();

        public abstract void writeData(DataOutput var1) throws IOException;

        public abstract byte getType();

        protected byte getOptimalNumericType(byte type, long v) {
            switch (type) {
                case 6: {
                    if (v >= -128L && v <= 127L) break;
                    type = (byte)5;
                }
                case 5: {
                    if (v >= -32768L && v <= 32767L) break;
                    type = (byte)4;
                }
                case 4: {
                    if (v >= Integer.MIN_VALUE && v <= Integer.MAX_VALUE) break;
                    type = (byte)3;
                }
            }
            return type;
        }

        protected void writeNumericValue(DataOutput out, byte type, long value) throws IOException {
            switch (type) {
                case 6: {
                    out.writeByte((byte)value);
                    break;
                }
                case 5: {
                    out.writeShort((short)value);
                    break;
                }
                case 4: {
                    out.writeInt((int)value);
                    break;
                }
                case 3: {
                    out.writeLong(value);
                }
            }
        }
    }

    private static class LongArrayField
    extends VectorField {
        private long[] vector;
        private byte type = (byte)-1;

        public LongArrayField(long[] v) {
            this.vector = new long[v.length];
            System.arraycopy(v, 0, this.vector, 0, v.length);
        }

        public LongArrayField(int len, byte type, DataInput in) throws IOException {
            this.type = type;
            this.vector = new long[len];
            block6: for (int i = 0; i < len; ++i) {
                switch (type) {
                    case 6: {
                        this.vector[i] = in.readByte();
                        continue block6;
                    }
                    case 5: {
                        this.vector[i] = in.readShort();
                        continue block6;
                    }
                    case 4: {
                        this.vector[i] = in.readInt();
                        continue block6;
                    }
                    case 3: {
                        this.vector[i] = in.readLong();
                        continue block6;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid type in LongField constructor: " + type);
                    }
                }
            }
        }

        @Override
        public int length() {
            return this.vector != null ? this.vector.length : -1;
        }

        @Override
        public String stringValueAt(int idx) {
            return Long.toString(this.vector[idx]);
        }

        @Override
        public long longValueAt(int idx) {
            return this.vector[idx];
        }

        @Override
        public long[] longValues() {
            long[] copy = new long[this.vector.length];
            System.arraycopy(this.vector, 0, copy, 0, this.vector.length);
            return copy;
        }

        @Override
        public byte getType() {
            if (this.type < 0) {
                this.type = (byte)6;
                for (long v : this.vector) {
                    this.type = this.getOptimalNumericType(this.type, v);
                    if (this.type == 3) break;
                }
            }
            return this.type;
        }

        @Override
        public void writeValue(DataOutput out, int idx) throws IOException {
            this.writeNumericValue(out, this.type, this.vector[idx]);
        }

        public boolean equals(Object o) {
            try {
                LongArrayField other = (LongArrayField)o;
                return Arrays.equals(this.vector, other.vector);
            }
            catch (ClassCastException ccx) {
                return false;
            }
        }

        public int hashCode() {
            return Arrays.hashCode(this.vector);
        }
    }

    private static class LongField
    extends ScalarField {
        private long value;
        private byte type = (byte)-1;

        public LongField(long v) {
            this.value = v;
        }

        @Override
        public String stringValue() {
            return Long.toString(this.value);
        }

        @Override
        public long longValue() {
            return this.value;
        }

        @Override
        public byte getType() {
            if (this.type < 0) {
                this.type = (byte)6;
                this.type = this.getOptimalNumericType(this.type, this.value);
            }
            return this.type;
        }

        @Override
        public void writeValue(DataOutput out) throws IOException {
            this.writeNumericValue(out, this.type, this.value);
        }

        public boolean equals(Object o) {
            try {
                LongField other = (LongField)o;
                return this.value == other.value;
            }
            catch (ClassCastException ccx) {
                return false;
            }
        }

        public int hashCode() {
            return Long.valueOf(this.value).hashCode();
        }
    }

    private static class MsgArrayField
    extends VectorField {
        private ClusterMsg[] vector;

        public MsgArrayField(ClusterMsg[] v) {
            this.vector = new ClusterMsg[v.length];
            for (int i = 0; i < v.length; ++i) {
                if (v[i] == null) {
                    throw new IllegalArgumentException("Null messages not allowed in message array fields.");
                }
                this.vector[i] = (ClusterMsg)v[i].clone();
            }
        }

        public MsgArrayField(int len, DataInput in) throws IOException {
            this.vector = new ClusterMsg[len];
            for (int i = 0; i < len; ++i) {
                this.vector[i] = ClusterMsg.read(in);
            }
        }

        @Override
        public int length() {
            return this.vector.length;
        }

        @Override
        public String stringValueAt(int idx) {
            return this.vector[idx].toString();
        }

        @Override
        public <T extends ClusterMsg> T msgValueAt(Class<T> cls, int idx) {
            return (T)this.vector[idx];
        }

        @Override
        public <T extends ClusterMsg> List<T> msgValues(Class<T> cls) {
            ArrayList<ClusterMsg> copy = new ArrayList<ClusterMsg>(this.vector.length);
            for (ClusterMsg msg : this.vector) {
                copy.add(msg);
            }
            return copy;
        }

        @Override
        public byte getType() {
            return 7;
        }

        @Override
        public void writeValue(DataOutput out, int idx) throws IOException {
            out.writeUTF(this.vector[idx].getClass().getName());
            this.vector[idx].writeData(out);
        }

        public boolean equals(Object o) {
            try {
                MsgArrayField other = (MsgArrayField)o;
                return Arrays.equals(this.vector, other.vector);
            }
            catch (ClassCastException ccx) {
                return false;
            }
        }

        public int hashCode() {
            return Arrays.hashCode(this.vector);
        }
    }

    private static class MsgField
    extends ScalarField {
        private ClusterMsg value;

        public MsgField(ClusterMsg v) {
            if (v == null) {
                throw new IllegalArgumentException("Null message values not allowed in fields.");
            }
            this.value = (ClusterMsg)v.clone();
        }

        public MsgField(DataInput in) throws IOException {
            this.value = ClusterMsg.read(in);
        }

        @Override
        public String stringValue() {
            return this.value.toString();
        }

        @Override
        public <T extends ClusterMsg> T msgValue(Class<T> cls) {
            return (T)this.value;
        }

        @Override
        public byte getType() {
            return 7;
        }

        @Override
        public void writeValue(DataOutput out) throws IOException {
            out.writeUTF(this.value.getClass().getName());
            this.value.writeData(out);
        }

        public boolean equals(Object o) {
            try {
                MsgField other = (MsgField)o;
                return this.value.equals(other.value);
            }
            catch (ClassCastException ccx) {
                return false;
            }
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    private static abstract class ScalarField
    extends Field {
        private ScalarField() {
        }

        @Override
        public void writeData(DataOutput out) throws IOException {
            out.writeByte(this.getType());
            this.writeValue(out);
        }

        public long longValue() {
            throw new ClassCastException();
        }

        public String stringValue() {
            throw new ClassCastException();
        }

        public boolean booleanValue() {
            throw new ClassCastException();
        }

        public <T extends ClusterMsg> T msgValue(Class<T> cls) {
            throw new ClassCastException();
        }

        @Override
        public byte getVersion() {
            return 1;
        }

        public abstract void writeValue(DataOutput var1) throws IOException;

        public String toString() {
            return this.stringValue();
        }
    }

    private static class StringArrayField
    extends VectorField {
        String[] vector;

        public StringArrayField(String[] s) {
            this.vector = new String[s.length];
            for (int i = 0; i < s.length; ++i) {
                if (s[i] == null) {
                    throw new IllegalArgumentException("Null values not allowed in string array fields.");
                }
                this.vector[i] = s[i];
            }
            System.arraycopy(s, 0, this.vector, 0, s.length);
        }

        public StringArrayField(int len, DataInput in) throws IOException {
            this.vector = new String[len];
            for (int i = 0; i < len; ++i) {
                this.vector[i] = in.readUTF();
            }
        }

        @Override
        public int length() {
            return this.vector.length;
        }

        @Override
        public String stringValueAt(int i) {
            return this.vector[i];
        }

        @Override
        public String[] stringValues() {
            String[] copy = new String[this.vector.length];
            System.arraycopy(this.vector, 0, copy, 0, this.vector.length);
            return copy;
        }

        @Override
        public byte getType() {
            return 1;
        }

        @Override
        public void writeValue(DataOutput out, int idx) throws IOException {
            out.writeUTF(this.vector[idx]);
        }

        public boolean equals(Object o) {
            try {
                StringArrayField other = (StringArrayField)o;
                return Arrays.equals(this.vector, other.vector);
            }
            catch (ClassCastException ccx) {
                return false;
            }
        }

        public int hashCode() {
            return Arrays.hashCode(this.vector);
        }
    }

    private static class StringField
    extends ScalarField {
        String value;

        public StringField(String s) {
            this.value = s;
        }

        @Override
        public String stringValue() {
            return this.value;
        }

        @Override
        public byte getType() {
            return 1;
        }

        @Override
        public void writeValue(DataOutput out) throws IOException {
            out.writeUTF(this.value);
        }

        public boolean equals(Object o) {
            try {
                StringField other = (StringField)o;
                return this.value.equals(other.value);
            }
            catch (ClassCastException ccx) {
                return false;
            }
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    private static abstract class VectorField
    extends Field {
        private VectorField() {
        }

        @Override
        public void writeData(DataOutput out) throws IOException {
            int len = this.length();
            out.writeByte(8);
            out.writeInt(len);
            out.writeByte(this.getType());
            for (int i = 0; i < len; ++i) {
                this.writeValue(out, i);
            }
        }

        public abstract int length();

        public long[] longValues() {
            throw new ClassCastException();
        }

        public long longValueAt(int i) {
            throw new ArrayIndexOutOfBoundsException();
        }

        public String[] stringValues() {
            throw new ClassCastException();
        }

        public String stringValueAt(int i) {
            throw new ArrayIndexOutOfBoundsException();
        }

        public boolean[] booleanValues() {
            throw new ClassCastException();
        }

        public boolean booleanValueAt(int i) {
            throw new ArrayIndexOutOfBoundsException();
        }

        public <T extends ClusterMsg> List<T> msgValues(Class<T> cls) {
            throw new ClassCastException();
        }

        public <T extends ClusterMsg> T msgValueAt(Class<T> cls, int i) {
            throw new ArrayIndexOutOfBoundsException();
        }

        @Override
        public byte getVersion() {
            return 2;
        }

        public abstract void writeValue(DataOutput var1, int var2) throws IOException;

        public String toString() {
            StringBuilder bld = new StringBuilder("[");
            int len = this.length();
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    bld.append(',');
                }
                bld.append(this.stringValueAt(i));
            }
            bld.append(']');
            return bld.toString();
        }
    }
}

