/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.cluster;

import com.elluminate.cluster.HazelcastWrappedObject;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ItemListener;
import java.util.HashSet;
import java.util.Set;

public class CQueue<T>
extends HazelcastWrappedObject<T> {
    private IQueue<T> iqueue;
    private Set<ItemListener<T>> iListeners = new HashSet<ItemListener<T>>();

    public CQueue(String name, HazelcastInstance instance) {
        super(instance);
        this.iqueue = instance.getQueue(name);
    }

    public String getName() {
        return this.iqueue.getName();
    }

    @Override
    protected void refresh() {
        this.iqueue = this.getInstance().getQueue(this.getName());
        for (ItemListener<T> listener : this.iListeners) {
            this.iqueue.addItemListener(listener, false);
        }
    }

    public void addItemListener(ItemListener<T> listener, boolean b) {
        this.getLock();
        this.iqueue.addItemListener(listener, b);
        this.iListeners.add(listener);
        this.releaseLock();
    }

    public void removeItemListener(ItemListener<T> listener) {
        this.getLock();
        this.iqueue.removeItemListener(listener);
        this.iListeners.remove(listener);
        this.releaseLock();
    }

    public boolean add(T msg) throws NullPointerException, IllegalStateException {
        boolean ret;
        this.getLock();
        try {
            ret = this.iqueue.add(msg);
        }
        catch (NullPointerException e) {
            this.releaseLock();
            throw e;
        }
        catch (IllegalStateException e) {
            this.releaseLock();
            throw e;
        }
        this.releaseLock();
        return ret;
    }

    public T poll() {
        Object t = null;
        this.getLock();
        t = this.iqueue.poll();
        this.releaseLock();
        return (T)t;
    }
}

