/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper;

import com.jniwrapper.AbstractFloat;
import com.jniwrapper.FloatParameter;
import com.jniwrapper.PlatformContext;

public class LongDouble
extends AbstractFloat {
    public static final int LONG_DOUBLE_LENGTH = PlatformContext.getLongDoubleLength();

    public LongDouble() {
        this(0.0);
    }

    public LongDouble(FloatParameter floatParameter) {
        this(floatParameter.getValue());
    }

    public LongDouble(double d2) {
        super(d2, LONG_DOUBLE_LENGTH);
    }

    public LongDouble(LongDouble longDouble) {
        this(longDouble.getValue());
    }

    public Object clone() {
        return new LongDouble(this);
    }

    public double convertToDouble(byte[] byArray) {
        return PlatformContext.convertCLongDoubleToDouble(byArray);
    }

    public byte[] convertToBytes(double d2) {
        return PlatformContext.convertDoubleToCLongDouble(d2);
    }
}

