/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.multimedia.module;

import com.elluminate.groupware.multimedia.module.Progress;
import com.elluminate.groupware.multimedia.module.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

class ServerCellRenderer
extends DefaultTableCellRenderer {
    static Color red = new Color(255, 40, 0);
    static Color warn = new Color(255, 102, 0);
    static Color ok = new Color(0, 102, 0);
    private I18n i18n = I18n.create((Object)this);

    ServerCellRenderer() {
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        Progress p = (Progress)value;
        byte pct = p.getServerStatus();
        Integer percent = new Integer(Math.abs(pct));
        if (pct < 0) {
            if (!isSelected) {
                this.setForeground(red);
            }
            this.setText(this.i18n.getString((PropertiesEnum)StringsProperties.LIBRARYDIALOG_PARTIAL, new Object[]{percent}));
        } else if (pct == 100) {
            if (!isSelected) {
                this.setForeground(ok);
            }
            this.setText(this.i18n.getString((PropertiesEnum)StringsProperties.LIBRARYDIALOG_COMPLETE, new Object[]{percent}));
        } else {
            if (!isSelected) {
                this.setForeground(warn);
            }
            this.setText(this.i18n.getString((PropertiesEnum)StringsProperties.LIBRARYDIALOG_LOADING, new Object[]{percent}));
        }
        return this;
    }
}

