/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.multimedia.module;

import com.elluminate.engine.CommandContextException;
import com.elluminate.engine.CommandExecutionException;
import com.elluminate.engine.CommandParameterException;
import com.elluminate.engine.command.AbstractCommand;
import com.elluminate.engine.command.PlayMultimediaCommand;
import com.elluminate.framework.imps.Imps;
import com.elluminate.groupware.imps.module.PresentationModeAPI;
import com.elluminate.groupware.multimedia.module.LibraryPanel;
import com.elluminate.groupware.multimedia.module.MultimediaBean;
import com.elluminate.groupware.multimedia.module.MultimediaModule;
import com.elluminate.groupware.multimedia.module.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;

public class PlayMultimediaCmd
extends AbstractCommand
implements PlayMultimediaCommand {
    private String fileName = null;
    @Inject
    private I18n i18n;
    @Inject
    private MultimediaModule module;
    @Inject
    private Imps imps;

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void doexecute() throws CommandExecutionException {
        this.validateIsOnlineAndIsChair();
        if (this.fileName == null || this.fileName.length() == 0) {
            throw new CommandParameterException("No filename specified", this.i18n.getString((PropertiesEnum)StringsProperties.PLAYMULTIMEDIACMD_BADPARAMFILENAMENOTSET));
        }
        MultimediaBean bean = this.module.getMultimediaBean();
        PresentationModeAPI presentationAPI = (PresentationModeAPI)this.imps.findBest(PresentationModeAPI.class);
        if (presentationAPI != null && presentationAPI.isPresenting()) {
            throw new CommandContextException("Cannot play multimedia when in presentation mode", this.i18n.getString((PropertiesEnum)StringsProperties.MULTIMEDIACMD_BADCONTEXTPRESENTATIONUNDERWAY));
        }
        LibraryPanel ld = bean.getLibraryPanel();
        ld.getDataVector();
        int id = ld.findMultimediaIdByName(this.fileName);
        if (id < 0) {
            throw new CommandContextException("No match for multimedia name " + this.fileName + " or the name was not specified", this.i18n.getString((PropertiesEnum)StringsProperties.PLAYMULTIMEDIACMD_BADCONTEXTMULTIMEDIANOTFOUND, new Object[]{this.fileName}));
        }
        bean.fireEventToPlayMultimediaId(id);
    }
}

