/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.multimedia.module;

import com.elluminate.groupware.multimedia.MediaLibraryEntry;
import com.elluminate.groupware.multimedia.MultimediaDebug;
import com.elluminate.groupware.multimedia.StreamCache;
import com.elluminate.groupware.multimedia.StreamEvent;
import com.elluminate.groupware.multimedia.StreamListener;
import com.elluminate.groupware.multimedia.module.ClientMediaLibrary;
import com.elluminate.jinx.ProtocolBuffer;
import com.elluminate.net.Endpoint;
import com.elluminate.platform.Platform;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.log.LogSupport;
import com.elluminate.util.net.HttpRequest;
import com.elluminate.util.net.HttpResponse;
import java.awt.Component;
import java.awt.Rectangle;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;

class MediaRequestProcessor
implements Runnable,
StreamListener {
    public static final int NO_WRAPPER = 0;
    public static final int WINDOWS_MEDIA_WRAPPER = 1;
    public static final int REAL_WRAPPER = 2;
    public static final int QUICKTIME_WRAPPER = 3;
    public static final int FLASH_WRAPPER = 4;
    private ClientMediaLibrary lib;
    private Endpoint ep;
    private Thread thread;
    private DataInputStream istr;
    private DataOutputStream ostr;
    private long remaining = -1L;
    private Component comp = null;

    public MediaRequestProcessor(ClientMediaLibrary lib, Component comp, Endpoint ep) {
        this.lib = lib;
        this.ep = ep;
        this.comp = comp;
        if (MultimediaDebug.WEB_SERVER.show()) {
            LogSupport.message((Object)this, (String)"MediaRequestProcessor", (String)("New connection " + ep.getInetAddress() + ":" + ep.getPort() + " -> " + ep.getLocalAddress() + ":" + ep.getLocalPort()));
        }
        this.thread = new WorkerThread((Runnable)this, "MediaRequestProcessor(" + ep.getInetAddress() + ":" + ep.getPort() + ")");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        class InvalidRequestException
        extends Exception {
            public InvalidRequestException(String msg) {
                super(msg);
            }
        }
        int httpVer = 10;
        HttpRequest req = null;
        try {
            int wrapper = 0;
            boolean close = false;
            this.ep.setSoTimeout(60000);
            this.istr = new DataInputStream(this.ep.getInputStream());
            this.ostr = new DataOutputStream(new BufferedOutputStream(this.ep.getOutputStream()));
            while (!close) {
                int id;
                wrapper = 0;
                req = new HttpRequest(this.istr, MultimediaDebug.WEB_SERVER_HTTP.show());
                httpVer = req.getHttpVersion();
                if (req.getMethod() != 1) {
                    throw new InvalidRequestException("Invalid request.");
                }
                String path = req.getURI();
                if (!path.startsWith("/")) {
                    throw new InvalidRequestException("Invalid URI.");
                }
                if (path.startsWith("/wmp_wrapper.html?id=")) {
                    wrapper = 1;
                    path = path.substring(21);
                } else if (path.startsWith("/real_wrapper.html?id=")) {
                    wrapper = 2;
                    path = path.substring(22);
                } else if (path.startsWith("/qt_wrapper.html?id=")) {
                    wrapper = 3;
                    path = path.substring(20);
                } else if (path.startsWith("/swf_wrapper.html?id=")) {
                    wrapper = 4;
                    path = path.substring(21);
                } else if (path.startsWith("/id")) {
                    int dot = path.indexOf(46);
                    if (dot < 0) {
                        throw new InvalidRequestException("Invalid media URL.");
                    }
                    path = path.substring(3, dot);
                } else {
                    throw new InvalidRequestException("InvalidMedia URL.");
                }
                try {
                    id = Integer.parseInt(path);
                }
                catch (Exception ex) {
                    throw new InvalidRequestException("Malformed media id.");
                }
                MediaLibraryEntry ent = this.lib.get(id);
                if (ent == null) {
                    throw new InvalidRequestException("Invalid media id.");
                }
                if (wrapper == 0) {
                    HttpResponse resp;
                    ByteRange range = this.getRange(req, ent);
                    close = false;
                    if (range != null) {
                        this.remaining = range.length();
                        resp = new HttpResponse(206, "OK", (int)this.remaining, close, httpVer, MultimediaDebug.WEB_SERVER_HTTP.show());
                        resp.setHeader("Content-Range", range.toString());
                        if (MultimediaDebug.WEB_SERVER.show()) {
                            LogSupport.message((Object)this, (String)"run", (String)("GET " + req.getURI() + " " + range.toString()));
                        }
                    } else {
                        this.remaining = ent.getLength();
                        resp = new HttpResponse(200, "OK", (int)this.remaining, close, httpVer, MultimediaDebug.WEB_SERVER_HTTP.show());
                        if (MultimediaDebug.WEB_SERVER.show()) {
                            LogSupport.message((Object)this, (String)"run", (String)("GET " + req.getURI()));
                        }
                    }
                    resp.setHeader("Content-Type", ent.getMimeType());
                    resp.setHeader("Server", "Elluminate Live! Media Server");
                    Date dt = new Date();
                    SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
                    sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
                    String now = sdf.format(dt);
                    resp.setHeader("Date", now);
                    resp.setHeader("Last-Modified", now);
                    resp.setHeader("Accept-Ranges", "bytes");
                    resp.setHeader("ETag", "\"" + id + "\"");
                    resp.setHeader("Keep-Alive", "timeout=15, max=100");
                    StreamCache cache = ent.getCache();
                    resp.send(this.ostr);
                    if (range != null) {
                        cache.addStreamListener((StreamListener)this, range.first, range.last);
                    } else {
                        cache.addStreamListener((StreamListener)this);
                    }
                    MediaRequestProcessor mediaRequestProcessor = this;
                    synchronized (mediaRequestProcessor) {
                        while (this.remaining > 0L) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException ix) {}
                        }
                    }
                    cache.removeStreamListener((StreamListener)this);
                    this.ostr.flush();
                    close = req.isDone();
                    continue;
                }
                if (MultimediaDebug.WEB_SERVER.show()) {
                    LogSupport.message((Object)this, (String)"run", (String)("GET " + req.getURI()));
                }
                close = this.generateWrapper(this.ostr, req, wrapper, id, ent.getMimeType());
                this.ostr.flush();
            }
        }
        catch (IOException ex) {
        }
        catch (InvalidRequestException uo) {
            if (MultimediaDebug.WEB_SERVER.show()) {
                LogSupport.message((Object)this, (String)"run", (String)("ERROR: " + req));
            }
            HttpResponse resp = new HttpResponse(403, uo.getMessage(), 0, true, httpVer, MultimediaDebug.WEB_SERVER_HTTP.show());
            try {
                resp.send(this.ostr);
                this.ostr.flush();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        if (MultimediaDebug.WEB_SERVER.show()) {
            LogSupport.message((Object)this, (String)"MediaRequestProcessor", (String)("Connection " + this.ep.getInetAddress() + ":" + this.ep.getPort() + " -> " + this.ep.getLocalAddress() + ":" + this.ep.getLocalPort() + " closed"));
        }
        this.ep.closeForce();
    }

    private ByteRange getRange(HttpRequest req, MediaLibraryEntry ent) {
        String hdr = req.getHeader("Range");
        ByteRange range = null;
        if (hdr == null) {
            return null;
        }
        if (!hdr.startsWith("bytes=")) {
            return null;
        }
        hdr = hdr.substring(6);
        StringTokenizer parser = new StringTokenizer(hdr, ",");
        while (parser.hasMoreTokens()) {
            long from;
            long to;
            long num;
            String rg = parser.nextToken();
            int dash = rg.indexOf(45);
            if (dash < 0) continue;
            if (dash == 0) {
                try {
                    num = Long.parseLong(rg.substring(1));
                }
                catch (NumberFormatException nfx) {
                    return null;
                }
                to = ent.getLength();
                from = to - num;
            } else if (dash == rg.length() - 1) {
                try {
                    num = Long.parseLong(rg.substring(0, dash));
                }
                catch (NumberFormatException nfx) {
                    return null;
                }
                from = num;
                to = ent.getLength();
            } else {
                try {
                    from = Long.parseLong(rg.substring(0, dash));
                }
                catch (NumberFormatException nfx) {
                    return null;
                }
                try {
                    to = Long.parseLong(rg.substring(dash + 1)) + 1L;
                }
                catch (NumberFormatException nfx) {
                    return null;
                }
            }
            if (range == null) {
                range = new ByteRange();
                range.first = from;
                range.last = to;
                range.all = ent.getLength();
                continue;
            }
            if (range.first > from) {
                range.first = from;
            }
            if (range.last >= to) continue;
            range.last = to;
        }
        return range;
    }

    private boolean generateWrapper(DataOutputStream ostr, HttpRequest req, int kind, int id, String mime) throws IOException {
        StringBuffer buf = new StringBuffer();
        MediaLibraryEntry ent = this.lib.get(id);
        String suffix = Platform.getSuffix((String)mime);
        String url = "/id" + id + "." + suffix;
        int h = 480;
        if (this.comp != null) {
            Rectangle bounds = this.comp.getBounds();
            h = bounds.height - 50;
        }
        buf.append("<html>\n");
        buf.append("  <head>\n");
        buf.append("    <title>" + ent.getName() + "</title>\n");
        buf.append("  </head>\n");
        buf.append("  <body style=\"margin: 0px\">\n");
        switch (kind) {
            case 1: {
                url = "http://localhost:" + this.ep.getLocalPort() + url;
                buf.append("    <OBJECT CLASSID=clsid:22d6f312-b0f6-11d0-94ab-0080c74c7e95\n");
                buf.append("            CODEBASE=http://activex.microsoft.com/activex/controls/mplayer/en/nsmp2inf.cab#Version=6,4,7,1112\n");
                buf.append("            ID=MediaPlayer height=100% width=100% type=application/x-oleobject\n");
                buf.append("            standby=\"Loading Microsoft Windows Media Player components...\">\n");
                buf.append("      <PARAM NAME=FileName VALUE=\"" + url + "\">\n");
                buf.append("      <PARAM NAME=AutoStart VALUE=\"True\">\n");
                buf.append("      <PARAM NAME=ShowDisplay VALUE=\"False\">\n");
                buf.append("      <PARAM NAME=ShowControls VALUE=\"True\">\n");
                buf.append("      <PARAM NAME=ShowStatusBar VALUE=\"False\">\n");
                buf.append("      <EMBED SRC=\"" + url + "\" TYPE=application/x-mplayer2\n");
                buf.append("             pluginspage=\"http://www.microsoft.com/Windows/MediaPlayer/\"");
                buf.append("             name=MediaPlayer AutoStart=1 ShowControls=1 ShowStatusBar=0 ShowDisplay=0 height=100% width=100%/>\n");
                buf.append("    </OBJECT>\n");
                break;
            }
            case 2: {
                buf.append("  <OBJECT ID=RVOCX CLASSID=clsid:CFCDAA03-8BE4-11CF-B84B-0020AFBBCCFA\n");
                buf.append("            WIDTH=100% HEIGHT=" + (h - 25) * 100 / h + "%>\n");
                buf.append("    <PARAM NAME=SRC VALUE=\"" + url + "\">\n");
                buf.append("    <PARAM NAME=CONTROLS VALUE=ImageWindow>\n");
                buf.append("    <PARAM NAME=CONSOLE VALUE=console1>\n");
                buf.append("    <PARAM NAME=AUTOSTART VALUE=true>\n");
                buf.append("    <PARAM NAME=MAINTAINASPECT VALUE=true>\n");
                buf.append("    <PARAM NAME=NOLABELS VALUE=true>\n");
                buf.append("    <embed SRC='" + url + "' type=audio/x-pn-realaudio-plugin\n");
                buf.append("           CONSOLE=console1 CONTROLS=ImageWindow HEIGHT=" + (h - 25) * 100 / h + "%\n");
                buf.append("           WIDTH=100% MAINTAINASPECT=true AUTOSTART=true NOLABELS=true NOJAVA=true/>\n");
                buf.append("  </OBJECT>\n");
                buf.append("  <OBJECT ID=RVOCX CLASSID=clsid:CFCDAA03-8BE4-11CF-B84B-0020AFBBCCFA\n");
                buf.append("            WIDTH=100% HEIGHT=25>\n");
                buf.append("    <PARAM NAME=SRC VALUE='" + url + "'>\n");
                buf.append("    <PARAM NAME=CONTROLS VALUE=ControlPanel>\n");
                buf.append("    <PARAM NAME=CONSOLE VALUE=console1>\n");
                buf.append("    <embed SRC='" + url + "' type=audio/x-pn-realaudio-plugin\n");
                buf.append("           CONSOLE=console1 CONTROLS=ControlPanel HEIGHT=25\n");
                buf.append("           WIDTH=100% AUTOSTART=true NOJAVA=true/>\n");
                buf.append("  </OBJECT>\n");
                break;
            }
            case 3: {
                buf.append("      <EMBED SRC=\"" + url + "\" TYPE=video/quicktime\n");
                buf.append("             AUTOPLAY=True SCALE=ASPECT HEIGHT=100% WIDTH=100% AUTOHREF=True/>");
                break;
            }
            case 4: {
                buf.append("  <OBJECT CLASSDID=\"clsid:D27CDB6E-AE6D-11CF-96B8-44455354000\"\n");
                buf.append("          CODEBASE=\"http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,29,0\"\n");
                buf.append("          WIDTH=100% HEIGHT=100%>\n");
                buf.append("    <PARAM NAME=movie VALUE=\"" + url + "\">\n");
                buf.append("    <PARAM NAME=quality VALUE=high>\n");
                buf.append("    <EMBED SRC=\"" + url + "\" QUALITY=high WIDTH=100% HEIGHT=100%\n");
                buf.append("           PLUGINSPAGE=\"http://www.macromedia.com/go/getflashplayer\"\n");
                buf.append("           TYPE=application/x-shockwave-flash/>\n");
                buf.append("  </OBJECT>\n");
            }
        }
        buf.append("  </body>\n");
        buf.append("</html>\n");
        String html = buf.toString();
        byte[] bytes = html.getBytes();
        Date dt = new Date();
        if (MultimediaDebug.WEB_SERVER_HTML.show()) {
            LogSupport.message((Object)this, (String)"generateWrapper", (String)html);
        }
        HttpResponse resp = new HttpResponse(200, "OK", bytes.length, req.isDone(), req.getHttpVersion(), MultimediaDebug.WEB_SERVER_HTTP.show());
        resp.setHeader("Content-Type", "text/html");
        resp.setHeader("Server", "Elluminate Live! Media Server");
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        String now = sdf.format(dt);
        resp.setHeader("Date", now);
        resp.setHeader("Last-Modified", now);
        resp.setHeader("Accept-Ranges", "bytes");
        resp.setHeader("ETag", "\"" + kind + "." + id + "\"");
        resp.setHeader("Keep-Alive", "timeout=15, max=100");
        resp.send(ostr);
        ostr.write(bytes);
        return req.isDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamingData(StreamEvent e) {
        ProtocolBuffer buf = e.getBuffer();
        try {
            long size = buf.getSize();
            buf.writeTo((DataOutput)this.ostr);
            MediaRequestProcessor mediaRequestProcessor = this;
            synchronized (mediaRequestProcessor) {
                this.remaining -= size;
                if (MultimediaDebug.WEB_SERVER_DATA.show()) {
                    LogSupport.message((Object)this, (String)"streamingData", (String)("Send " + size + " bytes (" + this.remaining + " remaining)"));
                }
                if (this.remaining == 0L) {
                    this.notifyAll();
                }
            }
        }
        catch (IOException ex) {
            StreamCache cache;
            if (MultimediaDebug.WEB_SERVER.show()) {
                LogSupport.message((Object)this, (String)"streamingData", (String)("Write failed - " + ex));
            }
            if ((cache = e.getCache()) != null) {
                cache.suspendStreamListener((StreamListener)this);
            }
            MediaRequestProcessor mediaRequestProcessor = this;
            synchronized (mediaRequestProcessor) {
                this.remaining = 0L;
                this.notifyAll();
            }
        }
        e.dispose();
    }

    class ByteRange {
        public long first;
        public long last;
        public long all;

        ByteRange() {
        }

        public long length() {
            return this.last - this.first;
        }

        public String toString() {
            return "bytes " + this.first + "-" + (this.last - 1L) + "/" + this.all;
        }
    }
}

